/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.communication.login;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import webetk.javaclient.communication.login.CommonLogin;
import webetk.utils.communication.CertTrustUtils;
import webetk.utils.communication.HtmlUtils;
import webetk.utils.communication.ProxyAuthentication;
import webetk.utils.communication.StringUtils;

public class DcsLogin
extends CommonLogin {
    private static Logger log = Logger.getLogger(DcsLogin.class);
    private String sContext = "DCS";
    private String hostDCS = null;
    private String pathDCS = null;
    private String hostAsap = null;
    private String pathAsap = null;

    public static void main(String[] args) throws Exception {
        DcsLogin login = new DcsLogin();
        login.setNetzUrl("https://www.dealerspeed.net/asapweb/tetis/startTetisAction.do?DOMAIN=Dcs");
        login.setProxyAdress("proxy.msg.de");
        login.setProxyPort(3128);
        login.setUserID("????????");
        login.setPassword("????????");
        login.login();
        log.debug((Object)("Status Code : " + login.getStatusCode()));
        log.debug((Object)("Status Msg  : " + login.getStatusMsg()));
    }

    public DcsLogin() {
    }

    public DcsLogin(String proxyAdress, int proxyPort, String proxyUser, String proxyPassword, String netzUrl, String userID, String password) {
        this.setProxyAdress(proxyAdress);
        this.setProxyPort(proxyPort);
        this.setProxyUser(proxyUser);
        this.setProxyPassword(proxyPassword);
        this.setNetzUrl(netzUrl);
        this.setUserID(userID);
        this.setPassword(password);
    }

    @Override
    public void login() throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, URISyntaxException {
        System.setProperty("jsse.enableSNIExtension", "false");
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        DefaultHttpClient httpclient = CertTrustUtils.httpClientTrustingAllSSLCerts();
        CookieSpecFactory csf = new CookieSpecFactory(){

            public CookieSpec newInstance(HttpParams params) {
                return new BrowserCompatSpec(){

                    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                        log.debug((Object)"custom validate");
                    }
                };
            }
        };
        httpclient.getCookieSpecs().register("easy", csf);
        httpclient.getParams().setParameter("http.protocol.cookie-policy", (Object)"easy");
        ProxyAuthentication proxyAuth = null;
        if (this.getProxyUser() != null && this.getProxyUser().length() > 0) {
            proxyAuth = new ProxyAuthentication(this.getProxyUser(), this.getProxyPassword());
            proxyAuth.initProxyAuthentication();
        }
        if (this.getProxyAdress() != null && this.getProxyAdress().length() > 0) {
            HttpHost proxy = new HttpHost(this.getProxyAdress(), this.getProxyPort());
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        httpclient.getParams().setParameter("http.protocol.handle-redirects", (Object)Boolean.FALSE);
        this.hostAsap = StringUtils.getHostFromUrl(this.getNetzUrl());
        this.pathAsap = StringUtils.getRestFromUrl(this.getNetzUrl());
        log.debug((Object)"===>>> 1. Request - get login page");
        log.debug((Object)("host ASAP : " + this.hostAsap));
        log.debug((Object)("path ASAP : " + this.pathAsap));
        HttpHost target = new HttpHost(this.hostAsap, 443, "https");
        HttpGet req = new HttpGet(this.pathAsap);
        HttpResponse rsp = null;
        try {
            rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        }
        catch (HttpHostConnectException conExc) {
            this.setStatusForConnectionException(this.sContext, conExc);
            return;
        }
        log.debug((Object)"===>>> 1. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.showContentinBrowser(this.getRespCont(), this.sContext + "_resp1");
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 1. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        this.hostDCS = this.hostAsap;
        this.pathDCS = "pkmslogin.form";
        log.debug((Object)"===>>> 2. Request - post common and login informations");
        log.debug((Object)("host " + this.sContext + " : " + this.hostDCS));
        log.debug((Object)("path " + this.sContext + " : " + this.pathDCS));
        target = new HttpHost(this.hostDCS, 443, "https");
        HttpPost post = new HttpPost(this.pathDCS);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("username", this.getUserID()));
        nvps.add(new BasicNameValuePair("password", this.getPassword()));
        nvps.add(new BasicNameValuePair("Login", "+Log+in+"));
        nvps.add(new BasicNameValuePair("login-form-type", "pwd"));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        post.addHeader("Host", this.hostDCS);
        post.addHeader("Referer", this.getNetzUrl());
        rsp = httpclient.execute(target, (HttpRequest)post, (HttpContext)localContext);
        log.debug((Object)"===>>> 2. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.showContentinBrowser(this.getRespCont(), this.sContext + "_resp2");
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)post, rsp, true, null)) {
            log.error((Object)("Fehler im 2. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 3. Request - get location");
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        post.addHeader("Host", this.hostDCS);
        post.addHeader("Referer", this.getNetzUrl());
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 3. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.showContentinBrowser(this.getRespCont(), this.sContext + "_resp3");
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 3. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        String forwardUrl = HtmlUtils.getPostParamFromResp(this.getRespCont(), "CommandForm", "ACTION");
        String psessId = HtmlUtils.getPostParamFromResp(this.getRespCont(), "PSESSID", "value");
        String domain = HtmlUtils.getPostParamFromResp(this.getRespCont(), "DOMAIN", "value");
        this.hostAsap = StringUtils.getHostFromUrl(forwardUrl);
        this.pathAsap = StringUtils.getRestFromUrl(forwardUrl);
        log.debug((Object)"===>>> 4. Request - post ASAP start");
        log.debug((Object)("host ASAP : " + this.hostAsap));
        log.debug((Object)("path ASAP : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        post = new HttpPost(this.pathAsap);
        nvps = new ArrayList();
        nvps.add(new BasicNameValuePair("DOMAIN", domain));
        nvps.add(new BasicNameValuePair("PSESSID", psessId));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        post.addHeader("Host", this.hostAsap);
        post.addHeader("Referer", forwardUrl);
        rsp = httpclient.execute(target, (HttpRequest)post, (HttpContext)localContext);
        log.debug((Object)"===>>> 4. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.showContentinBrowser(this.getRespCont(), this.sContext + "_resp4");
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)post, rsp, false, null)) {
            log.error((Object)("Fehler im 4. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 6. Request - get ASAP login startNode");
        this.pathAsap = "/tetis/startNode.do?APP=WebETK&ENTRY_ID=WebETK_START&NODE=ROOT:Technik:WebETK:WebETK_START";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 6. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 6. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 7. Request - get ASAP login appInWindow");
        this.pathAsap = "/tetis/portal/portaluser/appInWindow.jsp?HM=true&HL=false&WebETK&WebETK_START";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 7. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 7. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 8. Request - get ASAP login starteApplikationAction");
        this.pathAsap = "/tetis/starteApplikationAction.do?ENTRY_ID=WebETK_START";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 8. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 8. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        for (Cookie ck : cookieStore.getCookies()) {
            if (!ck.getName().equals("JSESSIONID")) continue;
            this.setAsapSessionId(ck.getValue());
            this.setAsapUserId(this.getUserID());
            log.debug((Object)("asapSessionId : " + this.getAsapSessionId()));
            break;
        }
        if (this.getAsapSessionId() == null || this.getAsapSessionId().length() == 0) {
            this.setStatusCode(20);
            this.setStatusMsg("login to ASAP portal not successful. Miscellaneous problem during login routine for ASAP login!");
        } else {
            this.setStatusCode(0);
            this.setStatusMsg("Successfully login to ASAP portal.");
        }
        this.resetProxyAuth(proxyAuth);
    }
}

