/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.communication.login;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import webetk.javaclient.communication.login.CommonLogin;
import webetk.utils.communication.CertTrustUtils;
import webetk.utils.communication.ProxyAuthentication;
import webetk.utils.communication.StringUtils;

public class SGateLogin
extends CommonLogin {
    private static Logger log = Logger.getLogger(SGateLogin.class);
    private String sContext = "S-Gate";
    private String hostSgate = null;
    private String pathSgate = null;
    private String pathSgateJsp = "/baansde/jsp/sgate/SGate.jsp";
    private String hostAsap = null;
    private String pathAsap = null;

    public static void main(String[] args) throws Exception {
        SGateLogin login = new SGateLogin();
        login.setNetzUrl("https://asapi-b2d.bmwgroup.com/tetis/index.jsp?DOMAIN=SGate");
        login.setProxyAdress("proxy.msg.de");
        login.setProxyPort(3128);
        login.setUserID("???????");
        login.setPassword("???????");
        login.login();
        log.debug((Object)("Status Code : " + login.getStatusCode()));
        log.debug((Object)("Status Msg  : " + login.getStatusMsg()));
    }

    public SGateLogin() {
    }

    public SGateLogin(String proxyAdress, int proxyPort, String proxyUser, String proxyPassword, String netzUrl, String userID, String password) {
        this.setProxyAdress(proxyAdress);
        this.setProxyPort(proxyPort);
        this.setProxyUser(proxyUser);
        this.setProxyPassword(proxyPassword);
        this.setNetzUrl(netzUrl);
        this.setUserID(userID);
        this.setPassword(password);
    }

    @Override
    public void login() throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, URISyntaxException {
        log.debug((Object)"start of this method ...");
        System.setProperty("jsse.enableSNIExtension", "false");
        log.debug((Object)"after set system property ...");
        BasicCookieStore cookieStore = new BasicCookieStore();
        log.debug((Object)"after create cookie store ...");
        BasicHttpContext localContext = new BasicHttpContext();
        log.debug((Object)"after create local http context ...");
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        log.debug((Object)"after set cookie store in local http context ...");
        DefaultHttpClient httpclient = CertTrustUtils.httpClientTrustingAllSSLCerts();
        log.debug((Object)"after create httpclient ...");
        ProxyAuthentication proxyAuth = null;
        if (this.getProxyUser() != null && this.getProxyUser().length() > 0) {
            proxyAuth = new ProxyAuthentication(this.getProxyUser(), this.getProxyPassword());
            proxyAuth.initProxyAuthentication();
        }
        log.debug((Object)"after create and init proxy authentification ...");
        if (this.getProxyAdress() != null && this.getProxyAdress().length() > 0) {
            HttpHost proxy = new HttpHost(this.getProxyAdress(), this.getProxyPort());
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        log.debug((Object)"after create and set proxy ...");
        httpclient.getParams().setParameter("http.protocol.handle-redirects", (Object)Boolean.FALSE);
        this.hostAsap = StringUtils.getHostFromUrl(this.getNetzUrl());
        this.pathAsap = StringUtils.getRestFromUrl(this.getNetzUrl());
        log.debug((Object)"===>>> 1. Request - get login page");
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        HttpHost target = new HttpHost(this.hostAsap, 443, "https");
        HttpGet req = new HttpGet(this.pathAsap);
        HttpResponse rsp = null;
        try {
            rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        }
        catch (HttpHostConnectException conExc) {
            this.setStatusForConnectionException(this.sContext, conExc);
            return;
        }
        log.debug((Object)"===>>> 1. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 1. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        Header h1 = rsp.getFirstHeader("Location");
        String url = h1.getValue();
        this.hostSgate = StringUtils.getHostFromUrl(url);
        this.pathSgate = StringUtils.getRestFromUrl(url);
        log.debug((Object)"===>>> 2. Request - get login page");
        log.debug((Object)("host : " + this.hostSgate));
        log.debug((Object)("path : " + this.pathSgate));
        target = new HttpHost(this.hostSgate, 443, "https");
        req = new HttpGet(this.pathSgate);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 2. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 2. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)rsp.getEntity());
        this.hostSgate = StringUtils.getHostFromUrl(url);
        this.pathSgate = StringUtils.getRestFromUrl(url);
        log.debug((Object)"===>>> 3. Request - post common and login informations");
        log.debug((Object)("host : " + this.hostSgate));
        log.debug((Object)("path : " + this.pathSgate));
        this.printCookies(false, (CookieStore)cookieStore);
        HttpPost post = new HttpPost(this.pathSgate);
        List nv = URLEncodedUtils.parse((URI)new URI(url), (String)"UTF-8");
        String smagentName = "";
        for (NameValuePair pair : nv) {
            if (pair.getName().equals("SMAGENTNAME")) {
                smagentName = pair.getValue();
            }
            log.debug((Object)("SMAGENTNAME Name: " + pair.getName()));
            log.debug((Object)("SMAGENTNAME Value: " + pair.getValue()));
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("PASSWORD", this.getPassword()));
        nvps.add(new BasicNameValuePair("USER", this.getUserID()));
        nvps.add(new BasicNameValuePair("target", url));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        rsp = httpclient.execute(target, (HttpRequest)post, (HttpContext)localContext);
        log.debug((Object)"===>>> 3. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)post, rsp, true, (CookieStore)cookieStore)) {
            log.error((Object)("Fehler im 3. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            if (this.getStatusCode() == 10) {
                ArrayList<BasicNameValuePair> nvps1 = new ArrayList<BasicNameValuePair>();
                nvps1.add(new BasicNameValuePair("PASSWORD", this.getPassword()));
                nvps1.add(new BasicNameValuePair("USERNAME", this.getUserID()));
                nvps1.add(new BasicNameValuePair("target", url));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps1, "UTF-8"));
                rsp = httpclient.execute(target, (HttpRequest)post, (HttpContext)localContext);
                this.printStatusAndHeaders(false, rsp);
                this.printCookies(false, (CookieStore)cookieStore);
                this.setRespCont(this.getContent(rsp));
                this.printContent(false, this.getRespCont());
                if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)post, rsp, true, (CookieStore)cookieStore)) {
                    this.printStatusAndHeaders(true, rsp);
                    this.printCookies(true, (CookieStore)cookieStore);
                    this.printContent(true, this.getRespCont());
                    this.resetProxyAuth(proxyAuth);
                    return;
                }
            } else {
                this.printStatusAndHeaders(true, rsp);
                this.printCookies(true, (CookieStore)cookieStore);
                this.printContent(true, this.getRespCont());
                this.resetProxyAuth(proxyAuth);
                return;
            }
        }
        h1 = rsp.getFirstHeader("Location");
        url = h1.getValue();
        this.pathSgate = StringUtils.getRestFromUrl(url);
        log.debug((Object)"===>>> 5. Request - get ASAP login");
        this.pathAsap = "/tetis/startTetisAction.do?DOMAIN=SGate";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 5. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 5. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 6. Request - get ASAP login startNode");
        this.pathAsap = "/tetis/startNode.do?APP=WebETK&ENTRY_ID=WebETK_START&NODE=ROOT:Technik:WebETK:WebETK_START";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 6. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 6. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 7. Request - get ASAP login appInWindow");
        this.pathAsap = "/tetis/portal/portaluser/appInWindow.jsp?HM=true&HL=false&WebETK&WebETK_START";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 7. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 7. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        log.debug((Object)"===>>> 8. Request - get ASAP login starteApplikationAction");
        this.pathAsap = "/tetis/starteApplikationAction.do?ENTRY_ID=WebETK_START";
        log.debug((Object)("host : " + this.hostAsap));
        log.debug((Object)("path : " + this.pathAsap));
        target = new HttpHost(this.hostAsap, 443, "https");
        req = new HttpGet(this.pathAsap);
        rsp = httpclient.execute(target, (HttpRequest)req, (HttpContext)localContext);
        log.debug((Object)"===>>> 8. Request - Response : ");
        this.printStatusAndHeaders(false, rsp);
        this.printCookies(false, (CookieStore)cookieStore);
        this.setRespCont(this.getContent(rsp));
        this.printContent(false, this.getRespCont());
        if (!this.checkStatusAndSetStatus(this.sContext, (HttpRequestBase)req, rsp, false, null)) {
            log.error((Object)("Fehler im 8. Request/Response - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last " + this.sContext + " response data : \n"));
            this.printStatusAndHeaders(true, rsp);
            this.printCookies(true, (CookieStore)cookieStore);
            this.printContent(true, this.getRespCont());
            this.resetProxyAuth(proxyAuth);
            return;
        }
        for (Cookie ck : cookieStore.getCookies()) {
            if (!ck.getName().equals("JSESSIONID")) continue;
            this.setAsapSessionId(ck.getValue());
            this.setAsapUserId(this.getUserID());
            log.debug((Object)("asapSessionId : " + this.getAsapSessionId()));
            break;
        }
        if (this.getAsapSessionId() == null || this.getAsapSessionId().length() == 0) {
            this.setStatusCode(20);
            this.setStatusMsg("login to ASAP portal not successful. Miscellaneous problem during login routine for ASAP login!");
        } else {
            this.setStatusCode(0);
            this.setStatusMsg("Successfully login to ASAP portal.");
        }
        this.resetProxyAuth(proxyAuth);
    }
}

