/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.TitledPanel;

public class CheckBoxPanel
extends TitledPanel {
    private static final long serialVersionUID = 5409959892384947972L;
    public static final int ORIENTATION_HORIZONTAL = 1;
    public static final int ORIENTATION_VERTICAL = 2;
    protected Logger log = Logger.getLogger(CheckBoxPanel.class);

    public CheckBoxPanel(String title, AbstractButton[] items, int nRows, int nCols) {
        super(title);
        this.createCheckBoxPanel(title, items, nRows, nCols);
    }

    public CheckBoxPanel(String title, AbstractButton[] items, int orientation) {
        super(title);
        switch (orientation) {
            case 1: {
                this.createCheckBoxPanelHorizontal(title, items);
                break;
            }
            case 2: {
                this.createCheckBoxPanelVertical(title, items);
                break;
            }
            default: {
                throw new IllegalArgumentException("ChoicePanel: Parameter orientation mu\u00df entweder ORIENTATION_HORIZONTAL oder ORIENTATION_VERTICAL sein");
            }
        }
    }

    public CheckBoxPanel(String title, AbstractButton[] items) {
        this(title, items, 2);
    }

    protected void createCheckBoxPanelVertical(String title, AbstractButton[] items) {
        int[] w = new int[]{3, 0};
        int[] h = new int[items.length];
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(layout);
        for (int i = 0; i < items.length; ++i) {
            this.add((Component)items[i], c.rc(i + 1, 2));
        }
    }

    protected void createCheckBoxPanelHorizontal(String title, AbstractButton[] items) {
        int[] w = new int[items.length * 2 + 1];
        int[] h = new int[]{5, 0, 5};
        for (int i = 0; i < items.length + 1; ++i) {
            w[i * 2] = 5;
        }
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(layout);
        for (int i = 0; i < items.length; ++i) {
            this.add((Component)items[i], c.rc(2, i * 2 + 2));
        }
    }

    protected void createCheckBoxPanel(String title, AbstractButton[] items, int nRows, int nCols) {
        int[] h = new int[nRows];
        int[] w = new int[nCols * 2 + 1];
        for (int ii = 0; ii < nCols + 1; ++ii) {
            w[ii * 2] = 5;
        }
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(layout);
        int nAktRow = 0;
        int nAktCol = 1;
        for (int ii = 0; ii < items.length; ++ii) {
            if (++nAktRow > nRows) {
                nAktRow = 1;
                ++nAktCol;
            }
            this.add((Component)items[ii], c.rc(nAktRow, nAktCol * 2));
        }
    }
}

