/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.GrafikDisplayEvent;
import webetk.javaclient.dialog.TextRenderer;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;

public class GrafikDisplay
extends JLabel {
    private static final long serialVersionUID = -6926312215925118569L;
    protected Logger log = Logger.getLogger(GrafikDisplay.class);
    protected Color highlightColorInit = new Color(253, 189, 55, 100);
    protected Color highlightColor = new Color(255, 255, 125, 100);
    private Font titleFont;
    private List<Image> grafiken = new ArrayList<Image>();
    private List<Rectangle> rects = new ArrayList<Rectangle>();
    private List<String> tooltips = new ArrayList<String>();
    private List<String> titles = new ArrayList<String>();
    private List<String> titlesObenRechts = new ArrayList<String>();
    private List<Dimension> titlesHeights = new ArrayList<Dimension>();
    private List<Color> titlesColors = new ArrayList<Color>();
    private int[] textHeightForRow;
    private int grafikH\u00f6he;
    private int grafikBreite;
    private int numberOfColumns;
    private int abstandHorizontal = 10;
    private int abstandVertikal = 10;
    private int lastElement = -1;
    private boolean showMouseOver = false;
    private boolean firstOne = true;
    ActionListener actionListeners;
    private boolean mbAllreadyHighlightedByMouseMove = false;
    private int mnIndexHighlightInit = -1;
    private boolean mbPaintMouseOverInProgress = false;

    public GrafikDisplay(int columns) {
        this.titleFont = UIHelper.getPrintFont();
        this.numberOfColumns = columns;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GrafikDisplay.this.showTooltip(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){
            int indexDown = -1;

            @Override
            public void mouseExited(MouseEvent e) {
                GrafikDisplay.this.setToolTipText(null);
                this.indexDown = -1;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.indexDown = GrafikDisplay.this.findIndexForPosition(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int indexUp = GrafikDisplay.this.findIndexForPosition(e.getPoint());
                if (indexUp == this.indexDown) {
                    GrafikDisplay.this.checkClicked(e);
                }
            }
        });
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    }

    public synchronized void replaceGrafik(Image oldImage, Image newImage) {
        for (int i = 0; i < this.grafiken.size(); ++i) {
            if (this.grafiken.get(i) != oldImage) continue;
            this.grafiken.set(i, newImage);
            this.repaint();
            return;
        }
    }

    public synchronized void addGrafik(Image grafik, String tooltip, String titel, boolean pbMarkRed) {
        if (this.firstOne) {
            if (grafik != null) {
                this.grafikBreite = grafik.getWidth(null);
                this.grafikH\u00f6he = grafik.getHeight(null);
                this.firstOne = false;
            }
        } else if (grafik != null && (this.grafikBreite != grafik.getWidth(null) || this.grafikH\u00f6he != grafik.getHeight(null))) {
            this.log.warn((Object)("Bild hat nicht die gleiche Gr\u00f6\u00dfe wie voriges Bild. Gr\u00f6\u00dfe muss " + this.grafikBreite + " x " + this.grafikH\u00f6he + " sein. Ist aber " + grafik.getWidth(null) + " x " + grafik.getHeight(null)));
        }
        TextRenderer tm = new TextRenderer(titel, this.titleFont, this.grafikBreite);
        Dimension d = tm.measureText((Graphics2D)MainView.getInstance().getGraphics());
        this.titles.add(titel);
        this.titlesHeights.add(d);
        if (pbMarkRed) {
            this.titlesColors.add(Color.red);
        } else {
            this.titlesColors.add(null);
        }
        this.grafiken.add(grafik);
        this.tooltips.add(tooltip);
        this.rects.add(null);
        this.revalidate();
        this.repaint();
    }

    public synchronized void addGrafik(Image grafik, String tooltip, String titel) {
        if (this.firstOne) {
            if (grafik != null) {
                this.grafikBreite = grafik.getWidth(null);
                this.grafikH\u00f6he = grafik.getHeight(null);
                this.firstOne = false;
            }
        } else if (grafik != null && (this.grafikBreite != grafik.getWidth(null) || this.grafikH\u00f6he != grafik.getHeight(null))) {
            this.log.warn((Object)("Bild hat nicht die gleiche Gr\u00f6\u00dfe wie voriges Bild. Gr\u00f6\u00dfe muss " + this.grafikBreite + " x " + this.grafikH\u00f6he + " sein. Ist aber " + grafik.getWidth(null) + " x " + grafik.getHeight(null)));
        }
        TextRenderer tm = new TextRenderer(titel, this.titleFont, this.grafikBreite);
        Dimension d = tm.measureText((Graphics2D)MainView.getInstance().getGraphics());
        this.titles.add(titel);
        this.titlesHeights.add(d);
        this.grafiken.add(grafik);
        this.tooltips.add(tooltip);
        this.rects.add(null);
        this.revalidate();
        this.repaint();
    }

    public synchronized void addGrafik(Image grafik, String tooltip, String titel, String titelObenRechts, boolean pbMarkRed) {
        this.titlesObenRechts.add(titelObenRechts);
        this.addGrafik(grafik, tooltip, titel, pbMarkRed);
    }

    private synchronized int findIndexForPosition(Point p) {
        for (int i = 0; i < this.rects.size(); ++i) {
            Rectangle rect = this.rects.get(i);
            if (rect == null || !rect.contains(p)) continue;
            return i;
        }
        return -1;
    }

    private void checkClicked(MouseEvent e) {
        int idx = this.findIndexForPosition(e.getPoint());
        if (idx == -1) {
            return;
        }
        if (this.actionListeners != null) {
            this.actionListeners.actionPerformed(new GrafikDisplayEvent((Object)this, idx, e));
        }
    }

    private synchronized void showTooltip(MouseEvent e) {
        for (int i = 0; i < this.rects.size(); ++i) {
            Rectangle rect = this.rects.get(i);
            if (rect == null || !rect.contains(e.getPoint())) continue;
            if (this.lastElement != i) {
                if (this.lastElement != -1 && this.isShowMouseOver()) {
                    this.paintMouseOver(this.getGraphics(), this.lastElement, false, true);
                }
                this.lastElement = i;
                if (this.lastElement != -1 && this.isShowMouseOver()) {
                    this.paintMouseOver(this.getGraphics(), this.lastElement, true, true);
                }
                this.setToolTipText(this.tooltips.get(i));
            }
            return;
        }
        if (this.lastElement != -1 && this.isShowMouseOver()) {
            this.paintMouseOver(this.getGraphics(), this.lastElement, false, true);
        }
        this.lastElement = -1;
        this.setToolTipText(null);
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        int w = this.abstandHorizontal + (this.grafikBreite + this.abstandHorizontal) * this.numberOfColumns;
        int numberOfGrafiken = this.grafiken.size();
        int rows = (numberOfGrafiken - 1) / this.numberOfColumns + 1;
        int h = this.abstandVertikal + (this.grafikH\u00f6he + this.abstandVertikal) * rows;
        Iterator<Dimension> itTitelDims = this.titlesHeights.iterator();
        this.textHeightForRow = new int[rows];
        for (int r = 0; r < rows; ++r) {
            int th = 0;
            for (int c = 0; c < this.numberOfColumns && itTitelDims.hasNext(); ++c) {
                Dimension d = itTitelDims.next();
                if (d.height <= th) continue;
                th = d.height;
            }
            h += th;
            this.textHeightForRow[r] = th;
            if (!itTitelDims.hasNext()) break;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public synchronized void paint(Graphics g) {
        super.paint(g);
        int w = this.getWidth();
        int r = 0;
        int c = 0;
        int y = this.abstandVertikal;
        int gap = (w - this.getPreferredSize().width) / 2;
        for (int i = 0; i < this.grafiken.size(); ++i) {
            Image img = this.grafiken.get(i);
            String titel = this.titles.get(i);
            String rechts = null;
            if (this.titlesObenRechts.size() > i) {
                rechts = this.titlesObenRechts.get(i);
            }
            Dimension titelDim = this.titlesHeights.get(i);
            if (img == null) continue;
            int rowTextHeight = this.textHeightForRow[r];
            int x = gap + this.abstandHorizontal + c * (this.grafikBreite + this.abstandHorizontal);
            Color clr = null;
            if (this.titlesColors != null && !this.titlesColors.isEmpty()) {
                clr = this.titlesColors.get(i);
            }
            TextRenderer tr = new TextRenderer(titel, rechts, this.titleFont, this.grafikBreite, clr);
            tr.renderText((Graphics2D)g, x, y + rowTextHeight - titelDim.height);
            g.drawImage(img, x, y + rowTextHeight, null);
            this.rects.set(i, new Rectangle(x, y + rowTextHeight, this.grafikBreite, this.grafikH\u00f6he));
            if (++c < this.numberOfColumns) continue;
            c = 0;
            ++r;
            y += rowTextHeight + this.grafikH\u00f6he + this.abstandVertikal;
        }
        if (this.isShowMouseOver() && this.lastElement >= 0) {
            this.paintMouseOver(g, this.lastElement, true, false);
        }
        if (this.isShowMouseOver() && this.mnIndexHighlightInit >= -1 && this.mnIndexHighlightInit != this.lastElement) {
            this.paintMouseOver(g, this.mnIndexHighlightInit, false, false);
        }
    }

    private void paintMouseOver(Graphics g, int index, boolean highlight, boolean paintImage) {
        if (this.mbPaintMouseOverInProgress) {
            return;
        }
        this.mbPaintMouseOverInProgress = true;
        if (paintImage) {
            this.paintImage(g, index);
        }
        if (highlight) {
            this.highlightImage(g, index, true);
        } else if (index == this.mnIndexHighlightInit) {
            this.highlightImageInit(g);
        }
        this.mbAllreadyHighlightedByMouseMove = true;
        this.mbPaintMouseOverInProgress = false;
    }

    public void paintImage(Graphics g, int index) {
        Rectangle rect = this.rects.get(index);
        int x = rect.x;
        int y = rect.y;
        Image img = this.grafiken.get(index);
        if (img != null) {
            g.drawImage(img, x, y, null);
        }
    }

    private void highlightImage(Graphics g, int index, boolean byMouseMove) {
        if (g == null) {
            return;
        }
        Rectangle rect = this.rects.get(index);
        int x = rect.x;
        int y = rect.y;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.SrcOver);
        if (byMouseMove) {
            g.setColor(this.highlightColor);
        } else {
            g.setColor(this.highlightColorInit);
        }
        g.fillRect(x, y, this.grafikBreite, this.grafikH\u00f6he);
        g2d.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public boolean isShowMouseOver() {
        return this.showMouseOver;
    }

    public void setShowMouseOver(boolean showMouseOver) {
        this.showMouseOver = showMouseOver;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, l);
    }

    public String getTooltip(int index) {
        return this.tooltips.get(index);
    }

    public synchronized void removeAllGraphics() {
        this.grafiken.clear();
        this.tooltips.clear();
        this.titles.clear();
        this.titlesObenRechts.clear();
        this.rects.clear();
        this.lastElement = -1;
        this.firstOne = true;
        this.repaint();
    }

    public Rectangle getRect(int nIndex) {
        Rectangle rect = this.rects.get(nIndex);
        return rect;
    }

    public boolean hasAllreadyHighlightedByMouseMove() {
        return this.mbAllreadyHighlightedByMouseMove;
    }

    public void setIndexHighlightInit(int nIndexHighlightInit) {
        this.mnIndexHighlightInit = nIndexHighlightInit;
    }

    public int getIndexHighlightInit() {
        return this.mnIndexHighlightInit;
    }

    private void highlightImageInit(Graphics g) {
        if (this.mnIndexHighlightInit == -1) {
            return;
        }
        boolean byMouseMove = false;
        this.highlightImage(g, this.mnIndexHighlightInit, byMouseMove);
    }
}

