/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class ResizingTable
extends JTable {
    private static final long serialVersionUID = 3606690809180929070L;
    private static Logger log = Logger.getLogger(ResizingTable.class);
    private JScrollPane enclosingScrollPane = null;
    private int minWidth = -1;

    public void setEnclosingScrollPane(JScrollPane p) {
        this.enclosingScrollPane = p;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.enclosingScrollPane == null) {
            throw new IllegalStateException("ResizingTable: enclosingScrollPane must be set. Consult the documentation of ResizingTable");
        }
        log.debug((Object)("getScrollableTracksViewportWidth: scrollPaneWidth=" + this.enclosingScrollPane.getWidth() + " tableWidth=" + this.minWidth));
        if (this.enclosingScrollPane.getWidth() >= this.minWidth) {
            this.setAutoResizeMode(4);
            log.debug((Object)"set Mode to AUTO_RESIZE_ALL_COLUMNS");
            return true;
        }
        this.setAutoResizeMode(0);
        log.debug((Object)"set Mode to AUTO_RESIZE_OFF");
        return false;
    }

    public void calcMinSizeNow() {
        this.minWidth = this.getColumnModel().getTotalColumnWidth();
        log.debug((Object)("calcMinSizeNow: minWidth=" + this.minWidth));
    }

    public int getMinWidth() {
        return this.minWidth;
    }
}

