/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TextRenderer {
    private String nummer;
    private String bezeichnung;
    private String rechts;
    private int width;
    private AttributedString attrstrNummer;
    private AttributedString attrstrBezeichnung;
    private AttributedString attrstrRechts;

    public TextRenderer(String text, Font f, int width) {
        this.init(text, null, f, width, null);
    }

    public TextRenderer(String text, String textRechts, Font f, int width, Color c) {
        this.init(text, textRechts, f, width, c);
    }

    private void init(String text, String textRechts, Font f, int width, Color c) {
        if (text != null) {
            int idx = text.indexOf(32);
            this.nummer = idx > -1 ? text.substring(0, idx) : null;
            this.bezeichnung = text.substring(idx + 1, text.length());
        }
        this.width = width;
        if (this.nummer != null && this.nummer.length() > 0) {
            this.attrstrNummer = new AttributedString(this.nummer);
            this.attrstrNummer.addAttribute(TextAttribute.FONT, f);
            if (c != null) {
                this.attrstrNummer.addAttribute(TextAttribute.FOREGROUND, c);
            }
        }
        if (this.bezeichnung != null && this.bezeichnung.length() > 0) {
            this.attrstrBezeichnung = new AttributedString(this.bezeichnung);
            this.attrstrBezeichnung.addAttribute(TextAttribute.FONT, f);
            if (c != null) {
                this.attrstrBezeichnung.addAttribute(TextAttribute.FOREGROUND, c);
            }
        }
        this.rechts = textRechts;
        if (this.rechts != null && this.rechts.length() > 0) {
            this.attrstrRechts = new AttributedString(this.rechts);
            this.attrstrRechts.addAttribute(TextAttribute.FONT, f);
            Color backgroundColor = new Color(250, 250, 6);
            this.attrstrRechts.addAttribute(TextAttribute.BACKGROUND, backgroundColor);
            this.attrstrRechts.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
    }

    public Dimension measureText(Graphics2D g) {
        Dimension d1 = null;
        Dimension d2 = null;
        d1 = this.attrstrNummer == null ? new Dimension(0, 0) : this.measure(this.attrstrNummer.getIterator(), this.nummer, g);
        d2 = this.attrstrBezeichnung == null ? new Dimension(0, 0) : this.measure(this.attrstrBezeichnung.getIterator(), this.bezeichnung, g);
        return new Dimension(Math.max(d1.width, d2.width), d2.height + d1.height);
    }

    private Dimension measure(AttributedCharacterIterator it, String text, Graphics2D g) {
        LineBreakMeasurer measurer = new LineBreakMeasurer(it, g.getFontRenderContext());
        float wrappingWidth = this.width;
        Point pen = new Point(0, 0);
        while (measurer.getPosition() < text.length()) {
            TextLayout layout = measurer.nextLayout(wrappingWidth);
            pen.y = (int)((float)pen.y + layout.getAscent());
            pen.y = (int)((float)pen.y + (layout.getDescent() + layout.getLeading()));
            pen.x = (int)((float)pen.x + layout.getAdvance());
        }
        return new Dimension(pen.x, (int)((double)pen.y + 0.6));
    }

    public void renderText(Graphics2D g, int x, int y) {
        Dimension d1 = null;
        d1 = this.attrstrNummer == null ? new Dimension(0, 0) : this.render(this.attrstrNummer.getIterator(), this.nummer, g, x, y);
        if (this.attrstrBezeichnung != null) {
            this.render(this.attrstrBezeichnung.getIterator(), this.bezeichnung, g, x, y + d1.height);
        }
        if (this.attrstrRechts != null) {
            d1 = this.measure(this.attrstrRechts.getIterator(), this.rechts, g);
            this.render(this.attrstrRechts.getIterator(), this.rechts, g, x + this.width - d1.width, y);
        }
    }

    private Dimension render(AttributedCharacterIterator it, String text, Graphics2D g, int x, int y) {
        LineBreakMeasurer measurer = new LineBreakMeasurer(it, g.getFontRenderContext());
        float wrappingWidth = this.width;
        Point pen = new Point(x, y);
        while (measurer.getPosition() < text.length()) {
            TextLayout layout = measurer.nextLayout(wrappingWidth);
            pen.y = (int)((float)pen.y + layout.getAscent());
            float dx = layout.isLeftToRight() ? 0.0f : wrappingWidth - layout.getAdvance();
            layout.draw(g, (float)pen.x + dx, pen.y);
            pen.y = (int)((float)pen.y + (layout.getDescent() + layout.getLeading()));
        }
        Dimension dim = this.measure(it, text, g);
        return new Dimension(dim.width, (int)((double)pen.y + 0.6 - (double)y));
    }
}

