/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.firmeneinstellungen;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Filiale;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgFirmeneinstellungenModel;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgFirmeneinstellungenView;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgNutzer;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgFirmeneinstellungenController
extends AbstractDialogViewController {
    private static Logger log = Logger.getLogger(DlgFirmeneinstellungenController.class);
    DlgFirmeneinstellungenView view = new DlgFirmeneinstellungenView();
    DlgFirmeneinstellungenModel model = new DlgFirmeneinstellungenModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void loadFilialen(String sFirmaId) {
        log.debug((Object)"Performing Load Filialen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFilialen = new TrfHashMap(null);
        trfFilialen.setValue("firmaid", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFilialen, Command.LOAD_FILIALEN_SPRACHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFilialen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFilialen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFilialen.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            this.model.storeFilialen(null);
            return;
        }
        this.model.storeFilialen((List)trfFilialen.getValue("filialen"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static TrfHashMap loadFilialen() {
        log.debug((Object)"Performing Load Filialen");
        TrfHashMap trfFilialen = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getFirmaId();
        trfFilialen.setValue("firmaid", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFilialen, Command.LOAD_FILIALEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException: ", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfFilialen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFilialen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFilialen.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return null;
        }
        return trfFilialen;
    }

    public void loadSprachen(String sIso, String sRegIso) {
        log.debug((Object)"Performing Load Sprachen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSprachen = new TrfHashMap(null);
        trfSprachen.setValue("iso", sIso);
        trfSprachen.setValue("regiso", sRegIso);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSprachen, Command.LOAD_FILIAL_SPRACHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfSprachen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSprachen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSprachen.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return;
        }
        this.model.storeSprachen((List)trfSprachen.getValue("sprachen_list"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadFirma() {
        log.debug((Object)"Performing Load Firma");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFirma = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFirma, Command.LOAD_FIRMA);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFirma.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFirma.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFirma.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            this.model.storeFirma(null);
            return;
        }
        this.model.storeFirma((String)trfFirma.getValue("benennung_string"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean existiertFirmenBenennung(String sFirma) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFirma = new TrfHashMap(null);
        trfFirma.setValue("benennung_string", sFirma);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFirma, Command.EXIST_FIRMA);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFirma.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFirma.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFirma.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (Boolean)trfFirma.getValue("boolean");
    }

    public void updateFirmenBezeichnung(String sBezeichnung) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFirma = new TrfHashMap(null);
        trfFirma.setValue("benennung_string", sBezeichnung);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        trfFirma.setValue("firmaid", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFirma, Command.UPDATE_FIRMA);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFirma.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFirma.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getAendernDerFirmaIstGescheitert(), Resource.getInstance().getFilialverwaltung(), 1);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean existiertFilialId(String sFilialId) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFiliale = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        trfFiliale.setValue("firmaid", sFirmaId);
        trfFiliale.setValue("filialid", sFilialId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFiliale, Command.EXIST_FILIALID);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFiliale.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFiliale.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFiliale.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (Boolean)trfFiliale.getValue("boolean");
    }

    public boolean existiertFilialBezeichnung(String sFilialBezeichnung) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFiliale = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        trfFiliale.setValue("firmaid", sFirmaId);
        trfFiliale.setValue("filiale", sFilialBezeichnung);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFiliale, Command.EXIST_FILIALBEZEICHNUNG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFiliale.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFiliale.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFiliale.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (Boolean)trfFiliale.getValue("boolean");
    }

    public void erzeugeNeueFiliale(String sFiliale, String sId, String sIso, String sRegiso) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFiliale = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        Filiale filiale = new Filiale(sId, sFiliale, sFirmaId, sIso, sRegiso);
        trfFiliale.setValue("filiale", filiale);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFiliale, Command.CREATE_FILIALE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFiliale.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFiliale.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getEintragenDerFilialeIstGescheitert(), Resource.getInstance().getFilialverwaltung(), 1);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteFiliale(String sId) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFiliale = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        Filiale filiale = new Filiale(sId, sFirmaId);
        trfFiliale.setValue("filiale", filiale);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFiliale, Command.DELETE_FILIALE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFiliale.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFiliale.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFilialeKonnteNichtGeloeschtWerden(), Resource.getInstance().getFilialverwaltung(), 1);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void updateFiliale(String sFiliale, String sId, String sIso, String sRegiso) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFiliale = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        Filiale filiale = new Filiale(sId, sFiliale, sFirmaId, sIso, sRegiso);
        trfFiliale.setValue("filiale", filiale);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFiliale, Command.UPDATE_FILIALE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFiliale.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFiliale.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSpeichernDerFilialdatenIstGescheitert(), Resource.getInstance().getFilialverwaltung(), 1);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean existNoUserWithFilialId(String sFilialId, String sFirmaId) {
        log.debug((Object)"Performing Load Nutzer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("filialid", sFilialId);
        trfNutzer.setValue("firmaid", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_USER_BY_FILIALID);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfNutzer.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        List nutzer = (List)trfNutzer.getValue("nutzer_list");
        if (nutzer != null && !nutzer.isEmpty()) {
            DlgNutzer dlg = new DlgNutzer(nutzer);
            dlg.show();
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public boolean existLists(String sFilialId, String sFirmaId) {
        log.debug((Object)"Performing Load Nutzer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFiliale = new TrfHashMap(null);
        trfFiliale.setValue("filialid", sFilialId);
        trfFiliale.setValue("firmaid", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFiliale, Command.EXIST_LISTS_BY_FILIALID);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFirmeneinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFiliale.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFiliale.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFiliale.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfFiliale.getValue("boolean").equals(Boolean.TRUE);
    }
}

