/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.firmeneinstellungen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import webetk.app.konfiguration.Nutzer;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class DlgNutzer {
    private JDialog dlg;
    private GenericTableModel tableModel;
    private GenericTable table;
    protected JPanel panHeader;
    protected JPanel panNutzer;
    private JLabel txtText;
    private JButtonEx buttonOk;
    private Container paneContent;
    List<Nutzer> oNutzer = null;

    public DlgNutzer(List<Nutzer> Nutzer2) {
        this.oNutzer = Nutzer2;
        this.dlg = new JDialog((Frame)MainView.getInstance(), true);
        this.dlg.setTitle(Resource.getInstance().getFilialverwaltung());
        this.dlg.setSize(900, 350);
        this.setPosition();
        this.initComponents();
        this.update();
    }

    private void setPosition() {
        int width = Toolkit.getDefaultToolkit().getScreenSize().width;
        int height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.dlg.setLocation((width - this.dlg.getWidth()) / 2, (height - this.dlg.getHeight()) / 2);
    }

    public void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getFilialverwaltung(), null);
        this.panNutzer = new TitledPanel("");
        TableConfiguration config = new TableConfiguration();
        config.addColumn(Resource.getInstance().getNutzerId(), 2, false, "XXXXXXXXXXXXXX");
        config.addColumn(Resource.getInstance().getNutzername(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tableModel = new GenericTableModel(config);
        this.table = new GenericTable(this.tableModel);
        this.txtText = new JLabel(Resource.getInstance().getFilialeBeiNutzernDefaultFiliale());
        this.buttonOk = new JButtonEx(Resource.getInstance().getOk());
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DlgNutzer.this.dlg.dispose();
            }
        });
        this.layoutAll();
    }

    protected void layoutAll() {
        this.paneContent = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.paneContent.setLayout(l);
        this.paneContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.paneContent.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        p.setLayout(l);
        p.add((Component)this.createNutzerPanel(), c.rc(2, 1));
        return p;
    }

    public JPanel createNutzerPanel() {
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setRowWeight(4, 1);
        this.panNutzer.setLayout(l);
        this.panNutzer.add((Component)this.txtText, c.rc(2, 2));
        this.panNutzer.add((Component)this.table.getScrollPane(), c.rc(4, 2));
        this.panNutzer.add((Component)this.buttonOk, c.rcwh(6, 2, 1, 1, "r"));
        return this.panNutzer;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    private void update() {
        for (Nutzer nutzer : this.oNutzer) {
            this.tableModel.addRow(new AbstractRow(new Object[]{nutzer.getUserId(), nutzer.getUserName()}));
        }
    }
}

