/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.konfiguration;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.administration.konfiguration.DlgKonfigurationView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class AuswahlPanel
extends TitledPanel {
    private static final long serialVersionUID = -3186231005007426012L;
    boolean showAbwicklungBestandFiliale;
    public static final String PROPERTY_HS = "HS";
    public static final String PROPERTY_ABWICKLUNG = "ABWICKLUNG";
    public static final String PROPERTY_BESTAND_FILIALE = "BESTAND_FILIALE";
    public static final String PROPERTY_ABGLEICH = "ABGLEICH";
    public static final String PROPERTY_ANGESCHLOSSEN = "ANGESCHLOSSEN";
    public static final String PROPERTY_NICHT_ANGESCHLOSSEN = "NICHT_ANGESCHLOSSEN";
    public static final String PROPERTY_SATZWEISE = "SATZWEISE";
    public static final String PROPERTY_AUFTRAGSBEZOGEN = "AUFTRAGSBEZOGEN";
    public static final String PROPERTY_JA = "JA";
    public static final String PROPERTY_NEIN = "NEIN";
    public static final String PROPERTY_IMMER = "IMMER";
    public static final String PROPERTY_AUF_ANFRAGE = "AUF_ANFRAGE";
    private String currentHS = "NICHT_ANGESCHLOSSEN";
    private String currentAbwicklung = "AUFTRAGSBEZOGEN";
    private String currentBestandFiliale = "NEIN";
    private String currentAbgleich = "IMMER";
    private static Logger log = Logger.getLogger(AuswahlPanel.class);
    protected JRadioButton rbuttonHSAngeschlossen = new JRadioButton(Resource.getInstance().getJa());
    protected JRadioButton rbuttonHSNichtAngeschlossen = new JRadioButton(Resource.getInstance().getNein());
    protected JRadioButton rbuttonAbwicklungSatzweise = new JRadioButton(Resource.getInstance().getSatzweise());
    protected JRadioButton rbuttonAbwicklungAuftragsbezogen = new JRadioButton(Resource.getInstance().getAuftragsbezogen());
    protected JRadioButton rbuttonBestandFilialeJa = new JRadioButton(Resource.getInstance().getJa());
    protected JRadioButton rbuttonBestandFilialeNein = new JRadioButton(Resource.getInstance().getNein());
    protected JRadioButton rbuttonDMSAbgleichImmer = new JRadioButton(Resource.getInstance().getImmer());
    protected JRadioButton rbuttonDMSAbgleichAufAnfrage = new JRadioButton(Resource.getInstance().getAufAnfrage());
    private ButtonGroup abwicklungGroup;
    private ButtonGroup abgleichGroup;
    private ButtonGroup bestandfilialeGroup;
    private JLabel abwicklungLabel;
    private JLabel bestandfilialeLabel;
    private JLabel abgleichLabel;
    private DlgKonfigurationView parentDlg;
    private JLabel HSLabel;
    protected PropertyChangeSupport propertyDelegate = new PropertyChangeSupport(this);

    public AuswahlPanel(DlgKonfigurationView parent, String ueberschrift, Border border, boolean showAbwicklungBestandFiliale) {
        super(ueberschrift, border);
        this.parentDlg = parent;
        this.showAbwicklungBestandFiliale = showAbwicklungBestandFiliale;
        this.createAuswahlPanel();
    }

    public AuswahlPanel(DlgKonfigurationView parent, String ueberschrift, boolean showAbwicklungBestandFiliale) {
        super(ueberschrift);
        this.parentDlg = parent;
        this.showAbwicklungBestandFiliale = showAbwicklungBestandFiliale;
        this.createAuswahlPanel();
    }

    public boolean getShowAbwicklungBestandFiliale() {
        return this.showAbwicklungBestandFiliale;
    }

    public void setShowAbwicklungBestandFiliale(boolean ashowAbwicklungBestandFiliale) {
        this.showAbwicklungBestandFiliale = ashowAbwicklungBestandFiliale;
    }

    public Logger getLogger() {
        return log;
    }

    public void setLogger(Logger alog) {
        log = alog;
    }

    protected void createAuswahlPanel() {
        int[] w = new int[]{10, 0, 10, 0, 75, 0, 10, 0, 75, 0, 10, 0, 10};
        int[] h = new int[]{5, 0, 3, 0, 10, 0, 3, 0, 5};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(13, 1);
        this.setLayout(l);
        this.HSLabel = new JLabel(Resource.getInstance().getDmsSchnittstelleVerwenden());
        this.HSLabel.setFont(UIHelper.getBoldFont());
        this.add((Component)this.HSLabel, c.rcwh(2, 2, 3, 1, "l"));
        this.abwicklungLabel = new JLabel(Resource.getInstance().getAbwicklung());
        this.abwicklungLabel.setFont(UIHelper.getBoldFont());
        this.add((Component)this.abwicklungLabel, c.rcwh(2, 6, 3, 1, "l"));
        this.bestandfilialeLabel = new JLabel(Resource.getInstance().getBestandFiliale());
        this.bestandfilialeLabel.setFont(UIHelper.getBoldFont());
        this.add((Component)this.bestandfilialeLabel, c.rcwh(2, 10, 3, 1, "l"));
        this.abgleichLabel = new JLabel(Resource.getInstance().getDatenabgleichFuerTeilelisten());
        this.abgleichLabel.setFont(UIHelper.getBoldFont());
        this.add((Component)this.abgleichLabel, c.rcwh(6, 2, 3, 1, "l"));
        ButtonGroup HSGroup = new ButtonGroup();
        HSGroup.add(this.rbuttonHSAngeschlossen);
        HSGroup.add(this.rbuttonHSNichtAngeschlossen);
        this.rbuttonHSNichtAngeschlossen.setSelected(true);
        this.add((Component)this.rbuttonHSAngeschlossen, c.rcwh(4, 2, 1, 1, "lr"));
        this.add((Component)this.rbuttonHSNichtAngeschlossen, c.rcwh(4, 4, 1, 1, "lr"));
        this.abwicklungGroup = new ButtonGroup();
        this.abwicklungGroup.add(this.rbuttonAbwicklungSatzweise);
        this.abwicklungGroup.add(this.rbuttonAbwicklungAuftragsbezogen);
        this.add((Component)this.rbuttonAbwicklungSatzweise, c.rcwh(4, 6, 1, 1, "lr"));
        this.add((Component)this.rbuttonAbwicklungAuftragsbezogen, c.rcwh(4, 8, 1, 1, "lr"));
        this.bestandfilialeGroup = new ButtonGroup();
        this.bestandfilialeGroup.add(this.rbuttonBestandFilialeJa);
        this.bestandfilialeGroup.add(this.rbuttonBestandFilialeNein);
        this.add((Component)this.rbuttonBestandFilialeJa, c.rcwh(4, 10, 1, 1, "lr"));
        this.add((Component)this.rbuttonBestandFilialeNein, c.rcwh(4, 12, 1, 1, "lr"));
        this.abgleichGroup = new ButtonGroup();
        this.abgleichGroup.add(this.rbuttonDMSAbgleichImmer);
        this.abgleichGroup.add(this.rbuttonDMSAbgleichAufAnfrage);
        this.add((Component)this.rbuttonDMSAbgleichImmer, c.rcwh(8, 2, 1, 1, "lr"));
        this.add((Component)this.rbuttonDMSAbgleichAufAnfrage, c.rcwh(8, 4, 1, 1, "lr"));
        this.setupActionlisteners();
        if (!GlobalObjects.getInstance().getSessionInfo().getDMSAngeschlossen()) {
            this.HSLabel.setEnabled(false);
            this.rbuttonHSAngeschlossen.setEnabled(false);
            this.rbuttonHSNichtAngeschlossen.setEnabled(false);
            this.setAbwicklungBestandFilaleDisabled();
        }
    }

    public void update() {
        if (!GlobalObjects.getInstance().getSessionInfo().getDMSAngeschlossen()) {
            this.HSLabel.setEnabled(false);
            this.setAbwicklungBestandFilaleEnabled();
            this.rbuttonHSAngeschlossen.setSelected(false);
            this.rbuttonHSNichtAngeschlossen.setSelected(true);
            this.setAbwicklungBestandFilaleDisabled();
        }
    }

    public void setAbwicklungBestandFilaleEnabled() {
        this.showAbwicklungBestandFiliale = true;
        this.abwicklungLabel.setEnabled(true);
        this.bestandfilialeLabel.setEnabled(true);
        this.abgleichLabel.setEnabled(true);
        this.rbuttonAbwicklungSatzweise.setEnabled(true);
        this.rbuttonAbwicklungAuftragsbezogen.setEnabled(true);
        this.rbuttonBestandFilialeJa.setEnabled(true);
        this.rbuttonBestandFilialeNein.setEnabled(true);
        this.rbuttonDMSAbgleichImmer.setEnabled(true);
        this.rbuttonDMSAbgleichAufAnfrage.setEnabled(true);
        this.parentDlg.getButtonDMSAbgleich().setEnabled(true);
    }

    public void setAbwicklungBestandFilaleDefault() {
        this.rbuttonAbwicklungSatzweise.setSelected(false);
        this.rbuttonAbwicklungAuftragsbezogen.setSelected(true);
        this.rbuttonBestandFilialeJa.setSelected(true);
        this.rbuttonBestandFilialeNein.setSelected(false);
        this.rbuttonDMSAbgleichImmer.setSelected(true);
        this.rbuttonDMSAbgleichAufAnfrage.setSelected(false);
    }

    public void setAbwicklungBestandFilaleDisabled() {
        this.showAbwicklungBestandFiliale = false;
        this.abwicklungLabel.setEnabled(false);
        this.bestandfilialeLabel.setEnabled(false);
        this.abgleichLabel.setEnabled(false);
        this.abwicklungGroup.remove(this.rbuttonAbwicklungSatzweise);
        this.abwicklungGroup.remove(this.rbuttonAbwicklungAuftragsbezogen);
        this.rbuttonAbwicklungSatzweise.setSelected(false);
        this.rbuttonAbwicklungAuftragsbezogen.setSelected(false);
        this.rbuttonAbwicklungSatzweise.setEnabled(false);
        this.rbuttonAbwicklungAuftragsbezogen.setEnabled(false);
        this.abwicklungGroup.add(this.rbuttonAbwicklungSatzweise);
        this.abwicklungGroup.add(this.rbuttonAbwicklungAuftragsbezogen);
        this.bestandfilialeGroup.remove(this.rbuttonBestandFilialeJa);
        this.bestandfilialeGroup.remove(this.rbuttonBestandFilialeNein);
        this.rbuttonBestandFilialeJa.setSelected(false);
        this.rbuttonBestandFilialeNein.setSelected(false);
        this.rbuttonBestandFilialeJa.setEnabled(false);
        this.rbuttonBestandFilialeNein.setEnabled(false);
        this.bestandfilialeGroup.add(this.rbuttonBestandFilialeJa);
        this.bestandfilialeGroup.add(this.rbuttonBestandFilialeNein);
        this.abgleichGroup.remove(this.rbuttonDMSAbgleichImmer);
        this.abgleichGroup.remove(this.rbuttonDMSAbgleichAufAnfrage);
        this.rbuttonDMSAbgleichImmer.setSelected(false);
        this.rbuttonDMSAbgleichAufAnfrage.setSelected(false);
        this.rbuttonDMSAbgleichImmer.setEnabled(false);
        this.rbuttonDMSAbgleichAufAnfrage.setEnabled(false);
        this.abgleichGroup.add(this.rbuttonDMSAbgleichImmer);
        this.abgleichGroup.add(this.rbuttonDMSAbgleichAufAnfrage);
        if (this.parentDlg.getButtonDMSAbgleich() != null) {
            this.parentDlg.getButtonDMSAbgleich().setEnabled(false);
        }
    }

    public boolean isHSAngeschlossen() {
        return this.rbuttonHSAngeschlossen.isSelected();
    }

    public boolean isAbwicklungSatzbezogen() {
        return this.rbuttonAbwicklungSatzweise.isSelected();
    }

    public boolean isBestandFilialeJa() {
        return this.rbuttonBestandFilialeJa.isSelected();
    }

    public boolean isAbgleichImmer() {
        return this.rbuttonDMSAbgleichImmer.isSelected();
    }

    public void setHS(boolean bIsAngeschlossen) {
        this.rbuttonHSAngeschlossen.setSelected(bIsAngeschlossen);
        this.rbuttonHSNichtAngeschlossen.setSelected(!bIsAngeschlossen);
        this.currentHS = bIsAngeschlossen ? PROPERTY_ANGESCHLOSSEN : PROPERTY_NICHT_ANGESCHLOSSEN;
    }

    public void setDatenabgleich(boolean bIsImmer) {
        this.rbuttonDMSAbgleichImmer.setSelected(bIsImmer);
        this.rbuttonDMSAbgleichAufAnfrage.setSelected(!bIsImmer);
        this.currentAbgleich = bIsImmer ? PROPERTY_IMMER : PROPERTY_AUF_ANFRAGE;
    }

    public void setAbwicklung(boolean bIsSatzweise) {
        this.rbuttonAbwicklungSatzweise.setSelected(bIsSatzweise);
        this.rbuttonAbwicklungAuftragsbezogen.setSelected(!bIsSatzweise);
        this.currentAbwicklung = bIsSatzweise ? PROPERTY_SATZWEISE : PROPERTY_AUFTRAGSBEZOGEN;
    }

    public void setBestandFiliale(boolean bIsJa) {
        this.rbuttonBestandFilialeJa.setSelected(bIsJa);
        this.rbuttonBestandFilialeNein.setSelected(!bIsJa);
        this.currentBestandFiliale = bIsJa ? PROPERTY_JA : PROPERTY_NEIN;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyDelegate.addPropertyChangeListener(arg0);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyDelegate.removePropertyChangeListener(arg0);
    }

    @Override
    public synchronized void addPropertyChangeListener(String arg0, PropertyChangeListener arg1) {
        this.propertyDelegate.addPropertyChangeListener(arg0, arg1);
    }

    @Override
    public synchronized void removePropertyChangeListener(String arg0, PropertyChangeListener arg1) {
        this.propertyDelegate.removePropertyChangeListener(arg0, arg1);
    }

    protected void setupActionlisteners() {
        log.debug((Object)"setting up actionlisteners.");
        this.rbuttonHSAngeschlossen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_HS, AuswahlPanel.this.currentHS, AuswahlPanel.PROPERTY_ANGESCHLOSSEN);
                AuswahlPanel.this.currentHS = AuswahlPanel.PROPERTY_ANGESCHLOSSEN;
                if (!AuswahlPanel.this.showAbwicklungBestandFiliale) {
                    AuswahlPanel.this.setAbwicklungBestandFilaleDefault();
                }
                AuswahlPanel.this.setAbwicklungBestandFilaleEnabled();
            }
        });
        this.rbuttonHSNichtAngeschlossen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_HS, AuswahlPanel.this.currentHS, AuswahlPanel.PROPERTY_NICHT_ANGESCHLOSSEN);
                AuswahlPanel.this.currentHS = AuswahlPanel.PROPERTY_NICHT_ANGESCHLOSSEN;
                AuswahlPanel.this.setAbwicklungBestandFilaleDisabled();
            }
        });
        this.rbuttonAbwicklungSatzweise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_ABWICKLUNG, AuswahlPanel.this.currentAbwicklung, AuswahlPanel.PROPERTY_SATZWEISE);
                AuswahlPanel.this.currentAbwicklung = AuswahlPanel.PROPERTY_SATZWEISE;
            }
        });
        this.rbuttonAbwicklungAuftragsbezogen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_ABWICKLUNG, AuswahlPanel.this.currentAbwicklung, AuswahlPanel.PROPERTY_AUFTRAGSBEZOGEN);
                AuswahlPanel.this.currentAbwicklung = AuswahlPanel.PROPERTY_AUFTRAGSBEZOGEN;
            }
        });
        this.rbuttonBestandFilialeJa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_BESTAND_FILIALE, AuswahlPanel.this.currentBestandFiliale, AuswahlPanel.PROPERTY_JA);
                AuswahlPanel.this.currentBestandFiliale = AuswahlPanel.PROPERTY_JA;
            }
        });
        this.rbuttonBestandFilialeNein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_BESTAND_FILIALE, AuswahlPanel.this.currentBestandFiliale, AuswahlPanel.PROPERTY_NEIN);
                AuswahlPanel.this.currentBestandFiliale = AuswahlPanel.PROPERTY_NEIN;
            }
        });
        this.rbuttonDMSAbgleichImmer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_ABGLEICH, AuswahlPanel.this.currentAbgleich, AuswahlPanel.PROPERTY_IMMER);
                AuswahlPanel.this.currentAbgleich = AuswahlPanel.PROPERTY_IMMER;
            }
        });
        this.rbuttonDMSAbgleichAufAnfrage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuswahlPanel.this.propertyDelegate.firePropertyChange(AuswahlPanel.PROPERTY_ABGLEICH, AuswahlPanel.this.currentAbgleich, AuswahlPanel.PROPERTY_AUF_ANFRAGE);
                AuswahlPanel.this.currentAbgleich = AuswahlPanel.PROPERTY_AUF_ANFRAGE;
            }
        });
    }
}

