/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.konfiguration;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Konfiguration;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.administration.konfiguration.AuswahlPanel;
import webetk.javaclient.dialog.administration.konfiguration.DlgKonfigurationController;
import webetk.javaclient.dialog.administration.konfiguration.DlgKonfigurationModel;
import webetk.resources.Resource;

public class DlgKonfigurationView
extends AbstractDialogView {
    private static final long serialVersionUID = 6760657760691937992L;
    Logger log = Logger.getLogger(DlgKonfigurationView.class);
    DlgKonfigurationModel model;
    DlgKonfigurationController controller;
    private JLabel txtMWStSatzNiedrig;
    private JTextField tfMWStSatzNiedrig;
    private JLabel txtMWStSatzHoch;
    private JTextField tfMWStSatzHoch;
    private JLabel txtMWStSatzAltteile;
    private JTextField tfMWStSatzAltteile;
    private JLabel txtMWStSatz3;
    private JTextField tfMWStSatz3;
    private JLabel txtMWStSatz4;
    private JTextField tfMWStSatz4;
    private JLabel txtRechnungsnummer;
    private JTextField tfRechnungsnummer;
    private JLabel txtHaendleranschriftZeile1;
    private JTextField tfHaendleranschriftZeile1;
    private JLabel txtHaendleranschriftZeile2;
    private JTextField tfHaendleranschriftZeile2;
    private JLabel txtHaendleranschriftZeile3;
    private JTextField tfHaendleranschriftZeile3;
    private JLabel txtHaendleranschriftPLZ;
    private JTextField tfHaendleranschriftPLZ;
    private JLabel txtHaendleranschriftOrt;
    private JTextField tfHaendleranschriftOrt;
    private JLabel txtHaendleranschriftTelefon;
    private JTextField tfHaendleranschriftTelefon;
    private JLabel txtHaendlernummerPKW;
    private JTextField tfHaendlernummerPKW;
    private JLabel txtHaendlernummerMotorrad;
    private JTextField tfHaendlernummerMotorrad;
    private JLabel txtStandardBarVerkaufsNummer;
    private JTextField tfStandardBarVerkaufsNummer;
    private JLabel txtStandardAuftragsNummer;
    private JTextField tfStandardAuftragsNummer;
    private JLabel txtStandardKundenNummer;
    private JTextField tfStandardKundenNummer;
    private JLabel txtMailserver;
    private JTextField tfMailserver;
    private JButtonEx buttonSpeichern;
    private JButtonEx buttonAbbrechen;
    private JButtonEx buttonDMSAbgleich;
    private JPanel headerPanel;
    private JPanel anzeigePanel;
    private JPanel rechnungsnummerPanel;
    private JPanel barverkaufsnummerPanel;
    private JPanel haenderanschriftPanel;
    private JPanel mailserverPanel;
    private JPanel MWStPanel;
    private AuswahlPanel auswahlPanel;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        this.headerPanel = new HeaderPanel(Resource.getInstance().getKonfiguration(), ImageCache.getInstance().getHeaderIcon("konfig"));
        this.anzeigePanel = new TitledPanel("");
        this.txtMWStSatzNiedrig = new JLabel(Resource.getInstance().getNiedrigerMehrwertsteuersatz() + ":");
        this.tfMWStSatzNiedrig = new LimitedNumberField(5);
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(5, 4);
        this.tfMWStSatzNiedrig.setDocument(ehDoc);
        this.txtMWStSatzHoch = new JLabel(Resource.getInstance().getHoherMehrwertsteuersatz() + ":");
        this.tfMWStSatzHoch = new LimitedNumberField(5);
        ehDoc = new EnhancedTextDocument(5, 4);
        this.tfMWStSatzHoch.setDocument(ehDoc);
        this.txtMWStSatzAltteile = new JLabel(Resource.getInstance().getMehrwertsteuersatzAufAltteile() + ":");
        this.tfMWStSatzAltteile = new LimitedNumberField(5);
        ehDoc = new EnhancedTextDocument(5, 4);
        this.tfMWStSatzAltteile.setDocument(ehDoc);
        this.txtMWStSatz3 = new JLabel(Resource.getInstance().getMehrwertsteuersatz3() + ":");
        this.tfMWStSatz3 = new LimitedNumberField(5);
        ehDoc = new EnhancedTextDocument(5, 4);
        this.tfMWStSatz3.setDocument(ehDoc);
        this.txtMWStSatz4 = new JLabel(Resource.getInstance().getHoherMehrwertsteuersatz4() + ":");
        this.tfMWStSatz4 = new LimitedNumberField(5);
        ehDoc = new EnhancedTextDocument(5, 4);
        this.tfMWStSatz4.setDocument(ehDoc);
        this.txtRechnungsnummer = new JLabel(Resource.getInstance().getRechnungsnummer() + ":");
        this.tfRechnungsnummer = new LimitedNumberField(6);
        ehDoc = new EnhancedTextDocument(6, 1);
        this.tfRechnungsnummer.setDocument(ehDoc);
        this.txtHaendleranschriftZeile1 = new JLabel(Resource.getInstance().getFirma() + ":");
        this.tfHaendleranschriftZeile1 = new JTextField(30);
        ehDoc = new EnhancedTextDocument(30, 0);
        this.tfHaendleranschriftZeile1.setDocument(ehDoc);
        this.txtHaendleranschriftZeile2 = new JLabel(Resource.getInstance().getZusatz() + ":");
        this.tfHaendleranschriftZeile2 = new JTextField(36);
        ehDoc = new EnhancedTextDocument(36, 0);
        this.tfHaendleranschriftZeile2.setDocument(ehDoc);
        this.txtHaendleranschriftZeile3 = new JLabel(Resource.getInstance().getStrasse() + ":");
        this.tfHaendleranschriftZeile3 = new JTextField(25);
        ehDoc = new EnhancedTextDocument(25, 0);
        this.tfHaendleranschriftZeile3.setDocument(ehDoc);
        this.txtHaendleranschriftPLZ = new JLabel(Resource.getInstance().getPlz() + ":");
        this.tfHaendleranschriftPLZ = new JTextField(8);
        ehDoc = new EnhancedTextDocument(10, 0);
        this.tfHaendleranschriftPLZ.setDocument(ehDoc);
        this.txtHaendleranschriftOrt = new JLabel(Resource.getInstance().getOrt() + ":");
        this.tfHaendleranschriftOrt = new JTextField(20);
        ehDoc = new EnhancedTextDocument(20, 0);
        this.tfHaendleranschriftOrt.setDocument(ehDoc);
        this.txtHaendleranschriftTelefon = new JLabel(Resource.getInstance().getTelefon() + ":");
        this.tfHaendleranschriftTelefon = new JTextField(12);
        ehDoc = new EnhancedTextDocument(12, 0);
        this.tfHaendleranschriftTelefon.setDocument(ehDoc);
        this.txtStandardBarVerkaufsNummer = new JLabel(Resource.getInstance().getStandardBarverkaufsNummer() + ":");
        this.tfStandardBarVerkaufsNummer = new LimitedNumberField(7, 10);
        this.txtStandardAuftragsNummer = new JLabel(Resource.getInstance().getStandardAuftragsNummer() + ":");
        this.tfStandardAuftragsNummer = new LimitedTextField(10);
        this.txtStandardKundenNummer = new JLabel(Resource.getInstance().getStandardKundenNummer() + ":");
        this.tfStandardKundenNummer = new LimitedNumberField(7, 10);
        this.txtMailserver = new JLabel(Resource.getInstance().getServername() + ":");
        this.tfMailserver = new JTextField(29);
        ehDoc = new EnhancedTextDocument(40, 0);
        this.tfMailserver.setDocument(ehDoc);
        this.txtHaendlernummerPKW = new JLabel(Resource.getInstance().getHaendlernrPkw() + ":");
        this.tfHaendlernummerPKW = new LimitedNumberField(5);
        this.txtHaendlernummerMotorrad = new JLabel(Resource.getInstance().getHaendlernrMotorrad() + ":");
        this.tfHaendlernummerMotorrad = new LimitedNumberField(5);
        this.auswahlPanel = new AuswahlPanel(this, Resource.getInstance().getHaendlersystemDms(), false);
        this.auswahlPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
            }
        });
        this.buttonSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getZuruecksetzen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonDMSAbgleich = new JButtonEx(Resource.getInstance().getAbgleichKonfigurationMitDms(), ImageCache.getInstance().getIcon("abgleichdaten.jpg"));
        this.buttonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgKonfigurationView.this.saveKonfiguration();
            }
        });
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgKonfigurationView.this.loadKonfiguration();
            }
        });
        this.buttonDMSAbgleich.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgKonfigurationView.this.controller.doDMSAbgleich();
            }
        });
        this.createLayout();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        this.log.debug((Object)"init");
        this.model = (DlgKonfigurationModel)oDlgModel;
        this.controller = (DlgKonfigurationController)oController;
        this.initComponents();
        this.loadKonfiguration();
    }

    @Override
    public void update() {
        Konfiguration config = this.model.getKonfiguration();
        if (config == null) {
            return;
        }
        if (config.getDMSSchnittstelleVerwenden().equals("")) {
            return;
        }
        this.tfHaendleranschriftZeile1.setText(config.getHaendleranschriftZeile1());
        this.tfHaendleranschriftZeile2.setText(config.getHaendleranschriftZeile2());
        this.tfHaendleranschriftZeile3.setText(config.getHaendleranschriftZeile3());
        this.tfHaendleranschriftPLZ.setText(config.getHaendleranschriftPLZ());
        this.tfHaendleranschriftOrt.setText(config.getHaendleranschriftOrt());
        this.tfHaendleranschriftTelefon.setText(config.getHaendleranschriftTelefon());
        this.tfHaendlernummerPKW.setText(config.getHaendlernummerPKW());
        this.tfHaendlernummerMotorrad.setText(config.getHaendlernummerMotorrad());
        this.tfMailserver.setText(config.getMailserver());
        this.tfMWStSatzNiedrig.setText(config.getMWStSatzNiedrig());
        this.tfMWStSatzHoch.setText(config.getMWStSatzHoch());
        this.tfMWStSatzAltteile.setText(config.getMWStSatzAltteile());
        this.tfMWStSatz3.setText(config.getMWStSatz3());
        this.tfMWStSatz4.setText(config.getMWStSatz4());
        this.tfRechnungsnummer.setText(config.getRechnungsnummer());
        this.tfStandardBarVerkaufsNummer.setText(config.getStandardBarVerkaufsNummer());
        this.tfStandardAuftragsNummer.setText(config.getStandardAuftragsNummer());
        this.tfStandardKundenNummer.setText(config.getStandardKundenNummer());
        this.auswahlPanel.setAbwicklung(config.getAbwicklung().equals("S"));
        this.auswahlPanel.setBestandFiliale(config.getBestandFiliale().equals("J"));
        this.auswahlPanel.setDatenabgleich(config.getDatenabgleich().equals("J"));
        this.headerPanel.repaint();
        this.auswahlPanel.update();
        this.auswahlPanel.repaint();
        this.anzeigePanel.repaint();
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createAnzeigePanel(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createAnzeigePanel() {
        int[] w_anzeige = new int[]{10, 0, 10};
        int[] h_anzeige = new int[]{10, 0, 10, 0, 1};
        HIGLayout layoutAnzeige = new HIGLayout(w_anzeige, h_anzeige);
        this.anzeigePanel.setLayout(layoutAnzeige);
        int[] w_main = new int[]{0, 10, 0};
        int[] h_main = new int[]{0, 10, 0, 10, 0, 10, 0, 15, 0};
        HIGLayout layoutMain = new HIGLayout(w_main, h_main);
        layoutMain.setColumnWeight(1, 1);
        layoutMain.setColumnWeight(3, 1);
        layoutMain.setRowWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(layoutMain);
        mainPanel.add((Component)this.createHaendleranschriftPanel(), c.rcwh(3, 1, 1, 3, "btrl"));
        mainPanel.add((Component)this.createMWStPanel(), c.rc(3, 3, "lr"));
        mainPanel.add((Component)this.createBarverkaufsnummerPanel(), c.rc(5, 3, "lr"));
        mainPanel.add((Component)this.createMailserverPanel(), c.rc(7, 1, "lr"));
        mainPanel.add((Component)this.createRechnungnummerPanel(), c.rc(7, 3, "lr"));
        mainPanel.add((Component)this.createButtonPanel(), c.rcwh(9, 1, 3, 1, "lr"));
        this.anzeigePanel.add((Component)this.auswahlPanel, c.rc(2, 2, "lr"));
        this.anzeigePanel.add((Component)mainPanel, c.rc(4, 2, "lr"));
        return this.anzeigePanel;
    }

    private JPanel createMWStPanel() {
        this.MWStPanel = new TitledPanel(Resource.getInstance().getMehrwertsteuersaetze());
        int[] w_mwst = new int[]{10, 0, 10, 0, 10};
        int[] h_mwst = new int[]{10, 0, 5, 0, 5, 0, 5, 0, 5, 0, 10};
        HIGLayout layoutMWSt = new HIGLayout(w_mwst, h_mwst);
        layoutMWSt.setColumnWeight(5, 1);
        layoutMWSt.setRowWeight(11, 1);
        HIGConstraints c = new HIGConstraints();
        this.MWStPanel.setLayout(layoutMWSt);
        this.MWStPanel.add((Component)this.txtMWStSatzNiedrig, c.rc(2, 2, "l"));
        this.MWStPanel.add((Component)this.tfMWStSatzNiedrig, c.rc(2, 4, "lt"));
        this.MWStPanel.add((Component)this.txtMWStSatzHoch, c.rc(4, 2, "l"));
        this.MWStPanel.add((Component)this.tfMWStSatzHoch, c.rc(4, 4, "lt"));
        this.MWStPanel.add((Component)this.txtMWStSatzAltteile, c.rc(6, 2, "l"));
        this.MWStPanel.add((Component)this.tfMWStSatzAltteile, c.rc(6, 4, "lt"));
        this.MWStPanel.add((Component)this.txtMWStSatz3, c.rc(8, 2, "l"));
        this.MWStPanel.add((Component)this.tfMWStSatz3, c.rc(8, 4, "lt"));
        this.MWStPanel.add((Component)this.txtMWStSatz4, c.rc(10, 2, "l"));
        this.MWStPanel.add((Component)this.tfMWStSatz4, c.rc(10, 4, "lt"));
        return this.MWStPanel;
    }

    private JPanel createHaendleranschriftPanel() {
        this.haenderanschriftPanel = new TitledPanel(Resource.getInstance().getHaendlerschriftRechnungssteller());
        int[] w_haendleranschrift = new int[]{10, 0, 5, 0, 20, 0, 5, 0, 10};
        int[] h_haendleranschrift = new int[]{10, 0, 5, 0, 5, 0, 5, 0, 5, 0, 20, 0, 5, 0, 10};
        HIGLayout layoutHaendleranschrift = new HIGLayout(w_haendleranschrift, h_haendleranschrift);
        layoutHaendleranschrift.setColumnWeight(9, 1);
        layoutHaendleranschrift.setRowWeight(11, 1);
        HIGConstraints c = new HIGConstraints();
        this.haenderanschriftPanel.setLayout(layoutHaendleranschrift);
        this.haenderanschriftPanel.add((Component)this.txtHaendleranschriftZeile1, c.rc(2, 2, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendleranschriftZeile1, c.rcwh(2, 4, 5, 1, "lr"));
        this.haenderanschriftPanel.add((Component)this.txtHaendleranschriftZeile2, c.rc(4, 2, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendleranschriftZeile2, c.rcwh(4, 4, 5, 1, "lr"));
        this.haenderanschriftPanel.add((Component)this.txtHaendleranschriftZeile3, c.rc(6, 2, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendleranschriftZeile3, c.rcwh(6, 4, 5, 1, "lr"));
        this.haenderanschriftPanel.add((Component)this.txtHaendleranschriftPLZ, c.rc(8, 2, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendleranschriftPLZ, c.rc(8, 4, "l"));
        this.haenderanschriftPanel.add((Component)this.txtHaendleranschriftOrt, c.rc(8, 6, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendleranschriftOrt, c.rc(8, 8, "l"));
        this.haenderanschriftPanel.add((Component)this.txtHaendleranschriftTelefon, c.rc(10, 2, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendleranschriftTelefon, c.rcwh(10, 4, 5, 1, "lr"));
        this.haenderanschriftPanel.add((Component)this.txtHaendlernummerPKW, c.rcwh(12, 2, 3, 1, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendlernummerPKW, c.rc(12, 8, "l"));
        this.haenderanschriftPanel.add((Component)this.txtHaendlernummerMotorrad, c.rcwh(14, 2, 3, 1, "l"));
        this.haenderanschriftPanel.add((Component)this.tfHaendlernummerMotorrad, c.rc(14, 8, "l"));
        return this.haenderanschriftPanel;
    }

    private JPanel createRechnungnummerPanel() {
        this.rechnungsnummerPanel = new TitledPanel(Resource.getInstance().getRechnungsnummer());
        int[] w_rechnungsnummer = new int[]{10, 0, 10, 0, 10};
        int[] h_rechnungsnummer = new int[]{10, 0, 10};
        HIGLayout layoutRechnungsnummer = new HIGLayout(w_rechnungsnummer, h_rechnungsnummer);
        layoutRechnungsnummer.setColumnWeight(5, 1);
        layoutRechnungsnummer.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.rechnungsnummerPanel.setLayout(layoutRechnungsnummer);
        this.rechnungsnummerPanel.add((Component)this.txtRechnungsnummer, c.rc(2, 2, "l"));
        this.rechnungsnummerPanel.add((Component)this.tfRechnungsnummer, c.rc(2, 4, "lt"));
        return this.rechnungsnummerPanel;
    }

    private JPanel createBarverkaufsnummerPanel() {
        this.barverkaufsnummerPanel = new TitledPanel(Resource.getInstance().getStandardsDmsAbgleich());
        int[] w_barverkaufsnummer = new int[]{10, 0, 10, 0, 10};
        int[] h_barverkaufsnummer = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(w_barverkaufsnummer, h_barverkaufsnummer);
        layout.setColumnWeight(5, 1);
        layout.setRowWeight(7, 1);
        HIGConstraints c = new HIGConstraints();
        this.barverkaufsnummerPanel.setLayout(layout);
        this.barverkaufsnummerPanel.add((Component)this.txtStandardBarVerkaufsNummer, c.rc(2, 2, "l"));
        this.barverkaufsnummerPanel.add((Component)this.tfStandardBarVerkaufsNummer, c.rc(2, 4, "lt"));
        this.barverkaufsnummerPanel.add((Component)this.txtStandardAuftragsNummer, c.rc(4, 2, "l"));
        this.barverkaufsnummerPanel.add((Component)this.tfStandardAuftragsNummer, c.rc(4, 4, "lt"));
        this.barverkaufsnummerPanel.add((Component)this.txtStandardKundenNummer, c.rc(6, 2, "l"));
        this.barverkaufsnummerPanel.add((Component)this.tfStandardKundenNummer, c.rc(6, 4, "lt"));
        return this.barverkaufsnummerPanel;
    }

    private JPanel createMailserverPanel() {
        this.mailserverPanel = new TitledPanel(Resource.getInstance().getMailserver());
        int[] w_mailserver = new int[]{10, 0, 10, 0, 10};
        int[] h_mailserver = new int[]{10, 0, 10};
        HIGLayout layout = new HIGLayout(w_mailserver, h_mailserver);
        layout.setColumnWeight(5, 1);
        layout.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mailserverPanel.setLayout(layout);
        this.mailserverPanel.add((Component)this.txtMailserver, c.rc(2, 2, "l"));
        this.mailserverPanel.add((Component)this.tfMailserver, c.rc(2, 4, "lt"));
        return this.mailserverPanel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        int[] w_panel = new int[]{0, 10, -5, 10, -3, 10, 0, 0};
        int[] h_panel = new int[]{1, 0, 1};
        HIGLayout layout = new HIGLayout(w_panel, h_panel);
        layout.setColumnWeight(1, 1);
        layout.setColumnWeight(8, 1);
        layout.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(layout);
        if (GlobalObjects.getInstance().getSessionInfo().getDMSAngeschlossen()) {
            panel.add((Component)this.buttonDMSAbgleich, c.rc(2, 7, "r"));
        }
        panel.add((Component)this.buttonSpeichern, c.rc(2, 3, "rl"));
        panel.add((Component)this.buttonAbbrechen, c.rc(2, 5, "rl"));
        return panel;
    }

    void loadKonfiguration() {
        this.model.resetKonfiguration();
        this.controller.loadKonfiguration();
        this.update();
        Konfiguration config = this.model.getKonfiguration();
        this.auswahlPanel.setHS(config.getDMSSchnittstelleVerwenden().equals("J"));
        this.auswahlPanel.setAbwicklung(config.getAbwicklung().equals("S"));
        this.auswahlPanel.setBestandFiliale(config.getBestandFiliale().equals("J"));
        this.auswahlPanel.setDatenabgleich(config.getDatenabgleich().equals("I"));
        if (this.auswahlPanel.isHSAngeschlossen()) {
            this.auswahlPanel.setAbwicklungBestandFilaleEnabled();
        } else {
            this.auswahlPanel.setAbwicklungBestandFilaleDisabled();
        }
        this.auswahlPanel.update();
        this.auswahlPanel.repaint();
    }

    void saveKonfiguration() {
        Konfiguration config = this.model.getKonfiguration();
        config.setHaendleranschriftZeile1(this.tfHaendleranschriftZeile1.getText());
        config.setHaendleranschriftZeile2(this.tfHaendleranschriftZeile2.getText());
        config.setHaendleranschriftZeile3(this.tfHaendleranschriftZeile3.getText());
        config.setHaendleranschriftPLZ(this.tfHaendleranschriftPLZ.getText());
        config.setHaendleranschriftOrt(this.tfHaendleranschriftOrt.getText());
        config.setHaendleranschriftTelefon(this.tfHaendleranschriftTelefon.getText());
        config.setHaendlernummerPKW(this.tfHaendlernummerPKW.getText());
        config.setHaendlernummerMotorrad(this.tfHaendlernummerMotorrad.getText());
        config.setMailserver(this.tfMailserver.getText());
        config.setMWStSatzNiedrig(this.tfMWStSatzNiedrig.getText());
        config.setMWStSatzHoch(this.tfMWStSatzHoch.getText());
        config.setMWStSatzAltteile(this.tfMWStSatzAltteile.getText());
        config.setMWStSatz3(this.tfMWStSatz3.getText());
        config.setMWStSatz4(this.tfMWStSatz4.getText());
        config.setRechnungsnummer(this.tfRechnungsnummer.getText());
        config.setStandardBarVerkaufsNummer(this.tfStandardBarVerkaufsNummer.getText());
        config.setStandardAuftragsNummer(this.tfStandardAuftragsNummer.getText());
        config.setStandardKundenNummer(this.tfStandardKundenNummer.getText());
        config.setDMSSchnittstelleVerwenden(this.auswahlPanel.isHSAngeschlossen() ? "J" : "N");
        config.setAbwicklung(this.auswahlPanel.isAbwicklungSatzbezogen() ? "S" : "A");
        config.setBestandFiliale(this.auswahlPanel.isBestandFilialeJa() ? "J" : "N");
        config.setDatenabgleich(this.auswahlPanel.isAbgleichImmer() ? "I" : "A");
        GlobalObjects.getInstance().setConfig(config);
        this.model.storeKonfiguration(config);
        this.controller.saveKonfiguration();
    }

    public JButtonEx getButtonDMSAbgleich() {
        return this.buttonDMSAbgleich;
    }
}

