/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.nutzereinstellungen;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.nutzereinstellungen.DlgNutzereinstellungenModel;
import webetk.javaclient.dialog.administration.nutzereinstellungen.DlgNutzereinstellungenView;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Firma;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Funktionsrecht;
import webetk.javaclient.dialog.administration.nutzereinstellungen.FunktionsrechtKomparator;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Nutzer;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgNutzereinstellungenController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(DlgNutzereinstellungenController.class);
    DlgNutzereinstellungenView view = new DlgNutzereinstellungenView();
    DlgNutzereinstellungenModel model = new DlgNutzereinstellungenModel();
    public static final int MAX_ANZAHL_USER_COMBOBOX = 30;

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        Firma oFirma = new Firma();
        oFirma.initFirma(sFirmaId);
        this.model.storeFirma(oFirma);
        this.loadAnzahlNutzer(sFirmaId);
        if (this.model.getAnzahlNutzerInit() <= 30) {
            this.loadAllNutzer(sFirmaId);
        } else {
            this.model.setAlleNutzer(null);
        }
        this.loadFunktionsrechte(oFirma);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    private void loadAnzahlNutzer(String sFirmaId) {
        this.log.debug((Object)"Performing Load Nutzer");
        ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
        aUserIdToIgnore.add("score");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("userids_to_ignore", aUserIdToIgnore);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_ANZAHL_NUTZER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            this.model.setAnzahlNutzerInit(0);
            return;
        }
        int anzahl = (Integer)trfNutzer.getValue("anzahlNutzer");
        this.model.setAnzahlNutzerInit(anzahl);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadAllNutzer(String sFirmaId) {
        this.log.debug((Object)"Performing Load Nutzer");
        ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
        aUserIdToIgnore.add("score");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("userids_to_ignore", aUserIdToIgnore);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_BENUTZER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            this.model.setAlleNutzer(null);
            return;
        }
        Collection<Nutzer> cNutzer = this.model.getAlleNutzer();
        if (cNutzer == null) {
            cNutzer = new Vector<Nutzer>();
        } else {
            cNutzer.clear();
        }
        List nutzerList = (List)trfNutzer.getValue("nutzer_list");
        for (webetk.app.konfiguration.Nutzer nutzer : nutzerList) {
            cNutzer.add(new Nutzer(nutzer.getUserName(), nutzer.getUserId(), nutzer.getPassword(), nutzer.getDefaultFiliale(), nutzer.getBearbeiterNummer()));
        }
        this.model.setAlleNutzer(cNutzer);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadFunktionsrechte(Firma oFirma) {
        String sRegIso = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        sRegIso = sRegIso == null ? "  " : sRegIso;
        String sIso = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        this.log.debug((Object)"Performing Load Funktionsrechte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFunktionsrechte = new TrfHashMap(null);
        trfFunktionsrechte.setValue("iso", sIso);
        trfFunktionsrechte.setValue("regiso", sRegIso);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFunktionsrechte, Command.LOAD_FUNKTIONSRECHTE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFunktionsrechte.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFunktionsrechte.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFunktionsrechte.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return;
        }
        int nAnzahlFilialen = 0;
        if (oFirma != null) {
            nAnzahlFilialen = oFirma.getAnzahlFilialen();
        }
        TreeSet<Funktionsrecht> cFunktionsrechteAlle = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        List funktionsrechtList = (List)trfFunktionsrechte.getValue("funktionsrecht_list");
        for (webetk.app.konfiguration.Funktionsrecht funktionsrecht : funktionsrechtList) {
            if (nAnzahlFilialen <= 1 && funktionsrecht.getBezeichnung().equalsIgnoreCase("R_WEBETK_FILIALE_AENDERN")) continue;
            cFunktionsrechteAlle.add(new Funktionsrecht(funktionsrecht.getBezeichnung(), funktionsrecht.getText()));
        }
        this.model.storeAlleFunktionsrechte(cFunktionsrechteAlle);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteNutzer(String sUserId, String sFirmaId) {
        this.log.debug((Object)"Performing Delete Nutzer");
        String sRegIso = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        sRegIso = sRegIso == null ? "  " : sRegIso;
        String sIso = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfDelete = new TrfHashMap(null);
        trfDelete.setValue("user_id", sUserId);
        trfDelete.setValue("firmaid", sFirmaId);
        trfDelete.setValue("iso", sIso);
        trfDelete.setValue("regiso", sRegIso);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfDelete, Command.DELETE_NUTZER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfDelete.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfDelete.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerBeimLoeschenDesNutzers(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean existiertNutzerId(String sNutzerId) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("user_id", sNutzerId.toLowerCase());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.EXIST_USERID);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (Boolean)trfNutzer.getValue("boolean");
    }

    public void storeNutzer() {
        Nutzer oAktNutzer = this.model.getNutzer();
        if (oAktNutzer == null) {
            return;
        }
        oAktNutzer.saveNutzer();
    }

    public void moveTeilelisten(String sFirmaId, String sNutzerId, String sFilialIdNeu, String sFilialIdAlt) {
        this.log.debug((Object)"Performing Move Teilelisten");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("user_id", sNutzerId);
        trfNutzer.setValue("filialid", sFilialIdNeu);
        trfNutzer.setValue("filialid_alt", sFilialIdAlt);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.MOVE_TEILELISTEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            this.model.storeNutzer(null);
            return;
        }
        Nutzer oNutzer = this.model.getNutzer();
        oNutzer.setDefaultFiliale(sFilialIdNeu);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

