/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.nutzereinstellungen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.CheckBoxPanel;
import webetk.javaclient.dialog.ChoicePanel;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledComponent;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.TwoColumnsComboBoxRenderer;
import webetk.javaclient.dialog.administration.nutzereinstellungen.DlgNutzereinstellungenController;
import webetk.javaclient.dialog.administration.nutzereinstellungen.DlgNutzereinstellungenModel;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Filiale;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Firma;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Funktionsrecht;
import webetk.javaclient.dialog.administration.nutzereinstellungen.MarkenSelectionPanel;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Nutzer;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.DlgNutzerSuchenController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Marke;
import webetk.mrkprd.Marken;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkt;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgNutzereinstellungenView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgNutzereinstellungenView.class);
    private DlgNutzereinstellungenModel model;
    private DlgNutzereinstellungenController controller;
    private JLabel txtNutzer;
    private JButtonEx buttonNutzerNeu;
    private JComboBox cbNutzer;
    private JButtonEx buttonNutzer;
    private boolean mbSuppressActionComboNutzer = true;
    private MarkenSelectionPanel mrkSelPanel;
    private Vector<Marke> vMarken;
    private Vector<Produkt> vProdukte;
    private HashMap<Produkt, JCheckBox> hChkbProdukt = new HashMap();
    private JCheckBox chkbKatalogumfangMobileTradition;
    private JCheckBox chkbKatalogumfangHauptkatalog;
    private JRadioButton rbProduktionsdatumJa;
    private JRadioButton rbProduktionsdatumNein;
    private JButtonEx buttonSpeichern;
    private JButtonEx buttonZuruecksetzen;
    private JButtonEx buttonLoeschen;
    private JPanel headerPanel;
    private TitledPanel markePanel;
    private JPanel produktartPanel;
    private JPanel katalogUmfangPanel;
    private JPanel produktionsdatumPanel;
    private JPanel alleFunktionsrechtePanel;
    private JPanel nutzerFunktionsrechtePanel;
    private JList alleFunktionsrechteList;
    private JList nutzerFunktionsrechteList;
    private JButtonEx buttonRechtHinzufuegen;
    private JButtonEx buttonalleRechteHinzufuegen;
    private JButtonEx buttonRechtEntfernen;
    private JButtonEx buttonalleRechteEntfernen;
    private JLabel txtDefaultFiliale;
    private JComboBox cbDefaultFiliale;
    private JLabel txtBearbeiter;
    private LimitedNumberField tfBearbeiter;
    private JLabel txtNutzername;
    private JLabel txtNutzerId;
    private JLabel txtPasswort;
    private JTextField tfNutzername;
    private JTextField tfNutzerId;
    private JTextField tfPasswort;
    private TitledPanel nutzerattributePanel;
    private int modus;
    private static final int NEU = 0;
    private static final int BEARBEITEN = 1;
    private static final int NEU_BEARBEITEN = 2;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        JButtonEx dummyButton;
        this.headerPanel = new HeaderPanel(Resource.getInstance().getBenutzerverwaltung(), ImageCache.getInstance().getHeaderIcon("nutzer"));
        this.txtNutzer = new JLabel(Resource.getInstance().getNutzer() + ":");
        if (this.model.getAlleNutzer() == null) {
            String txt = Resource.getInstance().getZuVieleNutzer();
            txt = StringUtils.substituteStringStraight(txt, "{0}", Integer.toString(30));
            this.txtNutzer.setText(txt);
            this.buttonNutzer = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
            this.buttonNutzer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgNutzerSuchenController dlg = new DlgNutzerSuchenController();
                    WorkflowStateData data = new WorkflowStateData();
                    data.setWert("Nutzer", DlgNutzereinstellungenView.this.model.getNutzer());
                    dlg.init(data);
                    Nutzer nutzer = (Nutzer)data.getWert("Nutzer");
                    if (nutzer != null) {
                        DlgNutzereinstellungenView.this.model.storeNutzer(nutzer);
                        DlgNutzereinstellungenView.this.model.storeNutzerInit(nutzer);
                        DlgNutzereinstellungenView.this.nutzerBearbeiten(true);
                    }
                }
            });
        } else {
            this.txtNutzer.setText(Resource.getInstance().getNutzer() + ":");
            this.cbNutzer = new JComboBox();
            this.cbNutzer.setPreferredSize(new Dimension(330, (int)this.cbNutzer.getPreferredSize().getHeight()));
            this.cbNutzer.setRenderer(new TwoColumnsComboBoxRenderer(200, 100));
            this.cbNutzer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DlgNutzereinstellungenView.this.mbSuppressActionComboNutzer) {
                        return;
                    }
                    if (DlgNutzereinstellungenView.this.cbNutzer.getSelectedIndex() == -1) {
                        return;
                    }
                    DlgNutzereinstellungenView.this.nutzerBearbeiten(true);
                }
            });
        }
        this.buttonNutzerNeu = new JButtonEx(Resource.getInstance().getNeu(), ImageCache.getInstance().getIcon("bi_teilhinzufuegen.jpg"));
        this.buttonNutzerNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.modus = 0;
                DlgNutzereinstellungenView.this.tfNutzername.requestFocus();
                DlgNutzereinstellungenView.this.tfNutzername.setEnabled(true);
                DlgNutzereinstellungenView.this.tfNutzerId.setEnabled(true);
                DlgNutzereinstellungenView.this.tfPasswort.setEnabled(true);
                DlgNutzereinstellungenView.this.tfBearbeiter.setEnabled(true);
                DlgNutzereinstellungenView.this.cbDefaultFiliale.setEnabled(true);
                DlgNutzereinstellungenView.this.buttonZuruecksetzen.setEnabled(false);
                DlgNutzereinstellungenView.this.buttonLoeschen.setEnabled(false);
                DlgNutzereinstellungenView.this.buttonSpeichern.setEnabled(true);
                DlgNutzereinstellungenView.this.nutzerattributePanel.setTitle(Resource.getInstance().getNeuenNutzerAnlegen());
                DlgNutzereinstellungenView.this.tfNutzername.setText("");
                DlgNutzereinstellungenView.this.tfNutzerId.setText("");
                DlgNutzereinstellungenView.this.tfPasswort.setText("");
                DlgNutzereinstellungenView.this.tfBearbeiter.setText("");
                Firma oFirma = DlgNutzereinstellungenView.this.model.getFirma();
                int nAnzahlFilialen = oFirma.getAnzahlFilialen();
                Nutzer oAktNutzer = new Nutzer();
                TreeSet<Funktionsrecht> cFunktionsrechteAkt = oAktNutzer.initFunktionsrechte(DlgNutzereinstellungenView.this.model.getAlleFunktionsrechte(), nAnzahlFilialen);
                DlgNutzereinstellungenView.this.model.storeAktuelleFunktionsrechte(cFunktionsrechteAkt);
                DlgNutzereinstellungenView.this.alleFunktionsrechteList.setListData(DlgNutzereinstellungenView.this.model.getFunktionsrechteBezeichnungen());
                DlgNutzereinstellungenView.this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
                DlgNutzereinstellungenView.this.model.storeNutzer(oAktNutzer);
                DlgNutzereinstellungenView.this.model.storeNutzerInit(null);
                int nAnzFunktionsrechteAkt = DlgNutzereinstellungenView.this.model.getAktuelleFunktionsrechte().size();
                int nAnzNutzerFunktionsrechte = oAktNutzer.getAnzahlFunktionsrechte();
                if (nAnzFunktionsrechteAkt == 0) {
                    DlgNutzereinstellungenView.this.enableEntfernenButtons();
                } else if (nAnzNutzerFunktionsrechte == 0) {
                    DlgNutzereinstellungenView.this.enableHinzufuegenButtons();
                } else {
                    DlgNutzereinstellungenView.this.buttonalleRechteHinzufuegen.setEnabled(true);
                    DlgNutzereinstellungenView.this.buttonRechtHinzufuegen.setEnabled(true);
                    DlgNutzereinstellungenView.this.buttonalleRechteEntfernen.setEnabled(true);
                    DlgNutzereinstellungenView.this.buttonRechtEntfernen.setEnabled(true);
                }
            }
        });
        this.txtNutzername = new JLabel(Resource.getInstance().getNutzername() + ":");
        this.txtNutzerId = new JLabel(Resource.getInstance().getNutzerId() + ":");
        this.txtPasswort = new JLabel(Resource.getInstance().getPasswort() + ":");
        this.tfNutzername = new JTextField();
        EnhancedTextDocument ehDocNeuanlageNutzer = new EnhancedTextDocument(20, 0);
        this.tfNutzername.setDocument(ehDocNeuanlageNutzer);
        this.tfNutzername.setPreferredSize(new Dimension(200, (int)this.tfNutzername.getPreferredSize().getHeight()));
        this.tfNutzerId = new JTextField();
        EnhancedTextDocument ehDocNeuanlageNutzerId = new EnhancedTextDocument(10, 0);
        this.tfNutzerId.setDocument(ehDocNeuanlageNutzerId);
        this.tfNutzerId.setPreferredSize(new Dimension(200, (int)this.tfNutzerId.getPreferredSize().getHeight()));
        this.tfPasswort = new JTextField();
        EnhancedTextDocument ehDocNeuanlageNutzerPasswort = new EnhancedTextDocument(20, 0);
        this.tfPasswort.setDocument(ehDocNeuanlageNutzerPasswort);
        this.tfPasswort.setPreferredSize(new Dimension(200, (int)this.tfPasswort.getPreferredSize().getHeight()));
        this.chkbKatalogumfangHauptkatalog = new JCheckBox(Resource.getInstance().getHauptkatalog());
        this.chkbKatalogumfangHauptkatalog.setEnabled(true);
        this.chkbKatalogumfangMobileTradition = new JCheckBox(Resource.getInstance().getMobileTradition());
        this.chkbKatalogumfangMobileTradition.setEnabled(false);
        Firma oFirma = this.model.getFirma();
        this.vMarken = oFirma.getBerechtigteMarkenObjekte();
        for (Marke oMarke : this.vMarken) {
            oMarke.setName(Resource.getInstance().getNameMarke(oMarke.getBerechtigung()));
        }
        this.mrkSelPanel = new MarkenSelectionPanel();
        this.mrkSelPanel.getList().setListData(this.vMarken);
        if (this.vMarken.size() == 1) {
            this.mrkSelPanel.getList().setSelectedIndex(0);
        }
        this.vProdukte = oFirma.getBerechtigteProdukteObjekte();
        for (Produkt oProdukt : this.vProdukte) {
            oProdukt.setName(Resource.getInstance().getNameProdukt(oProdukt.getBerechtigung()));
            String sProduktName = oProdukt.getName();
            JCheckBox jChkBox = new JCheckBox(sProduktName);
            jChkBox.setSelected(false);
            jChkBox.setEnabled(false);
            this.hChkbProdukt.put(oProdukt, jChkBox);
        }
        this.mrkSelPanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JList list = (JList)evt.getSource();
                    Object[] selected = list.getSelectedValues();
                    ArrayList<String> moeglProdukte = new ArrayList<String>();
                    for (Object obj : selected) {
                        if (!(obj instanceof Marke)) continue;
                        Marke oMarke = (Marke)obj;
                        ArrayList<String> moeglProdukteZurMarke = MarkenProdukte.getInstance(1).getProdukteZurMarke(oMarke.getBerechtigung());
                        for (String sProdukt : moeglProdukteZurMarke) {
                            if (moeglProdukte.contains(sProdukt)) continue;
                            moeglProdukte.add(sProdukt);
                        }
                    }
                    for (Produkt oProdukt : DlgNutzereinstellungenView.this.hChkbProdukt.keySet()) {
                        ((JCheckBox)DlgNutzereinstellungenView.this.hChkbProdukt.get(oProdukt)).setEnabled(false);
                        if (!moeglProdukte.contains(oProdukt.getBerechtigung())) continue;
                        ((JCheckBox)DlgNutzereinstellungenView.this.hChkbProdukt.get(oProdukt)).setEnabled(true);
                    }
                    for (Produkt oProdukt : DlgNutzereinstellungenView.this.hChkbProdukt.keySet()) {
                        if (moeglProdukte.contains(oProdukt.getBerechtigung())) continue;
                        ((JCheckBox)DlgNutzereinstellungenView.this.hChkbProdukt.get(oProdukt)).setSelected(false);
                    }
                    ArrayList<String> selektierteMarken = new ArrayList<String>();
                    for (Object obj : selected) {
                        if (!(obj instanceof Marke)) continue;
                        Marke oMarke = (Marke)obj;
                        selektierteMarken.add(oMarke.getBerechtigung());
                    }
                    if (selektierteMarken.contains(Marken.getInstance().getMarke("BMW").getBerechtigung())) {
                        DlgNutzereinstellungenView.this.chkbKatalogumfangMobileTradition.setEnabled(true);
                    } else {
                        DlgNutzereinstellungenView.this.chkbKatalogumfangMobileTradition.setEnabled(false);
                        DlgNutzereinstellungenView.this.chkbKatalogumfangMobileTradition.setSelected(false);
                    }
                }
            }
        });
        GridBagLayout gbl_markePanel = new GridBagLayout();
        gbl_markePanel.columnWidths = new int[]{0, 0};
        gbl_markePanel.rowHeights = new int[]{0, 0};
        gbl_markePanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_markePanel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.markePanel = new TitledPanel(Resource.getInstance().getMarke(), gbl_markePanel);
        GridBagConstraints gbc_markePanel = new GridBagConstraints();
        gbc_markePanel.fill = 2;
        gbc_markePanel.anchor = 18;
        gbc_markePanel.insets = new Insets(0, 5, 0, 5);
        gbc_markePanel.gridx = 0;
        gbc_markePanel.gridy = 0;
        this.markePanel.add((Component)this.mrkSelPanel, gbc_markePanel);
        AbstractButton[] abProduktart = new AbstractButton[this.hChkbProdukt.size()];
        int index = 0;
        if (this.hChkbProdukt.size() == 1) {
            JButtonEx dummyButton2 = new JButtonEx();
            dummyButton2.setBorder(null);
            dummyButton2.setContentAreaFilled(false);
            for (Produkt oProdukt : this.hChkbProdukt.keySet()) {
                this.hChkbProdukt.get(oProdukt).setSelected(true);
                dummyButton2.setText(this.hChkbProdukt.get(oProdukt).getText());
            }
            abProduktart[index] = dummyButton2;
        } else {
            for (Produkt oProdukt : this.vProdukte) {
                abProduktart[index] = this.hChkbProdukt.get(oProdukt);
                ++index;
            }
        }
        this.produktartPanel = new CheckBoxPanel(Resource.getInstance().getProduktart(), abProduktart);
        AbstractButton[] abKatalogumfang = null;
        if (oFirma.hatBerechtigungKatalogumfangVT() && oFirma.hatBerechtigungKatalogumfangST()) {
            abKatalogumfang = new AbstractButton[]{this.chkbKatalogumfangHauptkatalog, this.chkbKatalogumfangMobileTradition};
        } else if (oFirma.hatBerechtigungKatalogumfangVT()) {
            this.chkbKatalogumfangHauptkatalog.setSelected(true);
            this.chkbKatalogumfangMobileTradition.setSelected(false);
            dummyButton = new JButtonEx();
            dummyButton.setBorder(null);
            dummyButton.setContentAreaFilled(false);
            dummyButton.setText(this.chkbKatalogumfangHauptkatalog.getText());
            abKatalogumfang = new AbstractButton[]{dummyButton};
        } else if (oFirma.hatBerechtigungKatalogumfangST()) {
            this.chkbKatalogumfangHauptkatalog.setSelected(false);
            this.chkbKatalogumfangMobileTradition.setSelected(true);
            dummyButton = new JButtonEx();
            dummyButton.setBorder(null);
            dummyButton.setContentAreaFilled(false);
            dummyButton.setText(this.chkbKatalogumfangMobileTradition.getText());
            abKatalogumfang = new AbstractButton[]{dummyButton};
        } else {
            this.chkbKatalogumfangHauptkatalog.setSelected(false);
            this.chkbKatalogumfangMobileTradition.setSelected(false);
            abKatalogumfang = new AbstractButton[]{};
        }
        this.katalogUmfangPanel = new CheckBoxPanel(Resource.getInstance().getKatalogumfang(), abKatalogumfang);
        this.rbProduktionsdatumJa = new JRadioButton(Resource.getInstance().getAnzeigen());
        this.rbProduktionsdatumJa.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Nutzer oNutzer = DlgNutzereinstellungenView.this.model.getNutzer();
                if (oNutzer == null) {
                    return;
                }
                oNutzer.hatBerechtigungAnzeigeProdDatum(DlgNutzereinstellungenView.this.rbProduktionsdatumJa.isSelected());
            }
        });
        this.rbProduktionsdatumNein = new JRadioButton(Resource.getInstance().getNichtAnzeigen());
        this.rbProduktionsdatumNein.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Nutzer oNutzer = DlgNutzereinstellungenView.this.model.getNutzer();
                if (oNutzer == null) {
                    return;
                }
                oNutzer.hatBerechtigungAnzeigeProdDatum(!DlgNutzereinstellungenView.this.rbProduktionsdatumNein.isSelected());
            }
        });
        this.produktionsdatumPanel = new ChoicePanel(Resource.getInstance().getProduktionsdatum(), new AbstractButton[]{this.rbProduktionsdatumJa, this.rbProduktionsdatumNein}, 0);
        this.alleFunktionsrechteList = new JList();
        this.alleFunktionsrechteList.setSelectionMode(2);
        this.alleFunktionsrechtePanel = new TitledComponent(Resource.getInstance().getAlleFunktionsrechte(), new JScrollPane(this.alleFunktionsrechteList));
        this.nutzerFunktionsrechteList = new JList();
        this.nutzerFunktionsrechteList.setSelectionMode(2);
        this.nutzerFunktionsrechtePanel = new TitledComponent(Resource.getInstance().getBenutzerFunktionsrechte(), new JScrollPane(this.nutzerFunktionsrechteList));
        this.buttonRechtHinzufuegen = new JButtonEx(ImageCache.getInstance().getIcon("move_right.gif"));
        this.buttonRechtHinzufuegen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.addFunktionsrecht();
            }
        });
        this.buttonalleRechteHinzufuegen = new JButtonEx(ImageCache.getInstance().getIcon("scrollend.gif"));
        this.buttonalleRechteHinzufuegen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.addAlleFunktionsrechte();
            }
        });
        this.buttonRechtEntfernen = new JButtonEx(ImageCache.getInstance().getIcon("move_left.gif"));
        this.buttonRechtEntfernen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.removeFunktionsrecht();
            }
        });
        this.buttonalleRechteEntfernen = new JButtonEx(ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.buttonalleRechteEntfernen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.removeAlleFunktionsrechte();
            }
        });
        this.txtDefaultFiliale = new JLabel(Resource.getInstance().getDefaultFiliale() + ":");
        this.cbDefaultFiliale = new JComboBox();
        this.cbDefaultFiliale.setPreferredSize(new Dimension(200, (int)this.cbDefaultFiliale.getPreferredSize().getHeight()));
        this.cbDefaultFiliale.setRenderer(new TwoColumnsComboBoxRenderer(130, 45));
        this.txtBearbeiter = new JLabel(Resource.getInstance().getBearbeiternummer() + ":");
        this.tfBearbeiter = new LimitedNumberField(3);
        this.buttonSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonZuruecksetzen = new JButtonEx(Resource.getInstance().getZuruecksetzen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonLoeschen = new JButtonEx(Resource.getInstance().getLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.nutzerSpeichern();
            }
        });
        this.buttonZuruecksetzen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.nutzerBearbeiten(true);
                int nAnzFunktionsrechteAkt = DlgNutzereinstellungenView.this.model.getAktuelleFunktionsrechte().size();
                Nutzer oAktNutzer = DlgNutzereinstellungenView.this.model.getNutzer();
                int nAnzNutzerFunktionsrechte = oAktNutzer.getAnzahlFunktionsrechte();
                if (nAnzFunktionsrechteAkt == 0) {
                    DlgNutzereinstellungenView.this.enableEntfernenButtons();
                } else if (nAnzNutzerFunktionsrechte == 0) {
                    DlgNutzereinstellungenView.this.enableHinzufuegenButtons();
                } else {
                    DlgNutzereinstellungenView.this.buttonalleRechteHinzufuegen.setEnabled(true);
                    DlgNutzereinstellungenView.this.buttonRechtHinzufuegen.setEnabled(true);
                    DlgNutzereinstellungenView.this.buttonalleRechteEntfernen.setEnabled(true);
                    DlgNutzereinstellungenView.this.buttonRechtEntfernen.setEnabled(true);
                }
            }
        });
        this.buttonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzereinstellungenView.this.nutzerLoeschen();
            }
        });
        this.createLayout();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"init");
        this.model = (DlgNutzereinstellungenModel)oDlgModel;
        this.controller = (DlgNutzereinstellungenController)oController;
        this.initComponents();
        this.modus = 2;
        this.update();
    }

    @Override
    public void update() {
        Nutzer oAktNutzer = this.model.getNutzer();
        int nIndexNutzer = this.updateNutzerComboBox();
        this.updateFilialenComboBox();
        if (oAktNutzer != null) {
            String sBearbeiterNummer;
            this.alleFunktionsrechteList.setListData(this.model.getFunktionsrechteBezeichnungen());
            this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
            this.buttonSpeichern.setEnabled(true);
            this.buttonZuruecksetzen.setEnabled(true);
            this.buttonLoeschen.setEnabled(true);
            this.tfNutzername.setEnabled(true);
            this.tfNutzerId.setEnabled(true);
            this.tfPasswort.setEnabled(true);
            this.cbDefaultFiliale.setEnabled(true);
            this.tfBearbeiter.setEnabled(true);
            this.tfNutzername.setText(oAktNutzer.getNutzername());
            this.tfNutzerId.setText(oAktNutzer.getNutzerId());
            this.tfPasswort.setText(oAktNutzer.getPassword());
            if (this.modus == 1) {
                this.tfNutzerId.setEnabled(false);
            }
            if ((sBearbeiterNummer = oAktNutzer.getBearbeiterNummer()) != null) {
                this.tfBearbeiter.setText(sBearbeiterNummer);
            } else {
                this.tfBearbeiter.setText("");
            }
            int nAnzFunktionsrechteAkt = this.model.getAktuelleFunktionsrechte().size();
            int nAnzNutzerFunktionsrechte = oAktNutzer.getAnzahlFunktionsrechte();
            if (nAnzFunktionsrechteAkt == 0) {
                this.enableEntfernenButtons();
            } else if (nAnzNutzerFunktionsrechte == 0) {
                this.enableHinzufuegenButtons();
            } else {
                this.buttonalleRechteHinzufuegen.setEnabled(true);
                this.buttonRechtHinzufuegen.setEnabled(true);
                this.buttonalleRechteEntfernen.setEnabled(true);
                this.buttonRechtEntfernen.setEnabled(true);
            }
            Firma oFirma = this.model.getFirma();
            int rows = this.mrkSelPanel.getList().getModel().getSize();
            if (rows > 0) {
                int ind;
                int[] indices = new int[rows];
                for (ind = 0; ind < rows; ++ind) {
                    indices[ind] = -1;
                }
                for (ind = 0; ind < rows; ++ind) {
                    Marke oMarke;
                    String sMarke;
                    Object obj = this.mrkSelPanel.getList().getModel().getElementAt(ind);
                    if (!(obj instanceof Marke) || !oFirma.getMarkeBerechtigung(sMarke = (oMarke = (Marke)obj).getBerechtigung()).booleanValue() || !oAktNutzer.getMarkeBerechtigung(sMarke).booleanValue()) continue;
                    indices[ind] = ind;
                }
                this.mrkSelPanel.getList().setSelectedIndices(indices);
            }
            for (Produkt oProdukt : this.hChkbProdukt.keySet()) {
                String sProdukt = oProdukt.getBerechtigung();
                if (!oFirma.getProduktBerechtigung(sProdukt).booleanValue() || !oAktNutzer.getProduktBerechtigung(sProdukt).booleanValue()) continue;
                this.hChkbProdukt.get(oProdukt).setSelected(true);
            }
            this.chkbKatalogumfangMobileTradition.setSelected(oFirma.hatBerechtigungKatalogumfangST() && oAktNutzer.hatBerechtigungKatalogumfangST());
            this.chkbKatalogumfangHauptkatalog.setSelected(oFirma.hatBerechtigungKatalogumfangVT() && oAktNutzer.hatBerechtigungKatalogumfangVT());
            boolean bProduktionsdatum = oFirma.hatBerechtigungAnzeigeProdDatum() && oAktNutzer.hatBerechtigungAnzeigeProdDatum();
            this.rbProduktionsdatumJa.setSelected(bProduktionsdatum);
            this.rbProduktionsdatumNein.setSelected(!bProduktionsdatum);
            this.alleFunktionsrechteList.setListData(this.model.getFunktionsrechteBezeichnungen());
            this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
            if (oAktNutzer.getNutzerId().equalsIgnoreCase("admin")) {
                this.buttonLoeschen.setEnabled(false);
            }
            if (this.cbNutzer != null) {
                this.cbNutzer.setSelectedIndex(nIndexNutzer);
            }
        } else {
            this.cbDefaultFiliale.setSelectedIndex(-1);
            this.tfNutzername.setText("");
            this.tfNutzerId.setText("");
            this.tfPasswort.setText("");
            this.tfBearbeiter.setText("");
            this.tfNutzername.setEnabled(false);
            this.tfNutzerId.setEnabled(false);
            this.tfPasswort.setEnabled(false);
            this.cbDefaultFiliale.setEnabled(false);
            this.tfBearbeiter.setEnabled(false);
            this.buttonSpeichern.setEnabled(false);
            this.buttonZuruecksetzen.setEnabled(false);
            this.buttonLoeschen.setEnabled(false);
            this.buttonalleRechteHinzufuegen.setEnabled(false);
            this.buttonRechtHinzufuegen.setEnabled(false);
            this.buttonalleRechteEntfernen.setEnabled(false);
            this.buttonRechtEntfernen.setEnabled(false);
            this.mrkSelPanel.getList().clearSelection();
            for (Produkt oProdukt : this.hChkbProdukt.keySet()) {
                this.hChkbProdukt.get(oProdukt).setSelected(false);
            }
            this.chkbKatalogumfangMobileTradition.setSelected(false);
            this.chkbKatalogumfangMobileTradition.setEnabled(false);
            this.chkbKatalogumfangHauptkatalog.setSelected(false);
            this.rbProduktionsdatumJa.setSelected(true);
            this.alleFunktionsrechteList.setListData(new Vector());
            this.nutzerFunktionsrechteList.setListData(new Vector());
            Collection<Nutzer> cAlleNutzer = this.model.getAlleNutzer();
            if (cAlleNutzer != null) {
                if (cAlleNutzer.size() == 1) {
                    if (this.cbNutzer != null) {
                        this.cbNutzer.setSelectedIndex(0);
                    }
                    this.nutzerBearbeiten(false);
                } else if (this.cbNutzer != null) {
                    this.cbNutzer.setSelectedIndex(-1);
                }
            }
        }
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createAnzeigePanel(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createAnzeigePanel() {
        this.nutzerattributePanel = new TitledPanel(Resource.getInstance().getNutzerBearbeitenAnlegen());
        int[] w_anzeige = new int[]{5, 0, 5};
        int[] h_anzeige = new int[]{5, 0, 10, 0, 10, 0, 10, 0, 5};
        HIGLayout layoutAnzeige = new HIGLayout(w_anzeige, h_anzeige);
        layoutAnzeige.setColumnWeight(2, 1);
        layoutAnzeige.setRowWeight(6, 1);
        HIGConstraints c = new HIGConstraints();
        this.nutzerattributePanel.setLayout(layoutAnzeige);
        this.nutzerattributePanel.add((Component)this.createNeuanlagePanel(), c.rcwh(2, 2, 1, 1, "lrtb"));
        this.nutzerattributePanel.add((Component)this.createBerechtigungenPanel(), c.rcwh(4, 2, 1, 1, "lrtb"));
        this.nutzerattributePanel.add((Component)this.createFunktionsrechtePanel(), c.rcwh(6, 2, 1, 1, "lrtb"));
        this.nutzerattributePanel.add((Component)this.createButtonPanel(), c.rcwh(8, 2, 1, 1, "lrtb"));
        JPanel anzeigePanel = new JPanel();
        w_anzeige = new int[]{5, 0, 5};
        h_anzeige = new int[]{5, 0, 10, 0, 5};
        layoutAnzeige = new HIGLayout(w_anzeige, h_anzeige);
        layoutAnzeige.setColumnWeight(3, 1);
        layoutAnzeige.setRowWeight(5, 1);
        anzeigePanel.setLayout(layoutAnzeige);
        anzeigePanel.add((Component)this.createFirmaNutzerPanel(), c.rcwh(2, 2, 1, 1, "lrtb"));
        anzeigePanel.add((Component)this.nutzerattributePanel, c.rcwh(4, 2, 1, 1, "lrtb"));
        return anzeigePanel;
    }

    private JPanel createFirmaNutzerPanel() {
        HIGConstraints c = new HIGConstraints();
        TitledPanel nutzerPanel = new TitledPanel(Resource.getInstance().getNutzerBearbeitenAnlegen());
        int[] w_Nutzer = new int[]{5, 0, 10, 0, 10, -8, 10, -6, 5};
        int[] h_Nutzer = new int[]{5, 0, 5};
        HIGLayout layoutNutzer = new HIGLayout(w_Nutzer, h_Nutzer);
        layoutNutzer.setColumnWeight(4, 1);
        layoutNutzer.setRowWeight(2, 1);
        nutzerPanel.setLayout(layoutNutzer);
        nutzerPanel.add((Component)this.txtNutzer, c.rc(2, 2, "l"));
        if (this.cbNutzer != null) {
            nutzerPanel.add((Component)this.cbNutzer, c.rc(2, 4, "lr"));
        } else {
            nutzerPanel.add((Component)this.buttonNutzer, c.rc(2, 4, "l"));
        }
        nutzerPanel.add((Component)this.buttonNutzerNeu, c.rc(2, 8, "lr"));
        return nutzerPanel;
    }

    private JPanel createNeuanlagePanel() {
        TitledPanel defaultNeuanlagePanel = new TitledPanel(Resource.getInstance().getNutzerattribute());
        int[] w_Neuanlage = new int[]{5, 0, 10, 200, 20, 0, 10, 200, 20, 0, 10, 200, 5};
        int[] h_Neuanlage = new int[]{5, 0, 10, 0, 5};
        HIGLayout layoutNeuanlage = new HIGLayout(w_Neuanlage, h_Neuanlage);
        layoutNeuanlage.setColumnWeight(4, 1);
        layoutNeuanlage.setColumnWeight(8, 1);
        layoutNeuanlage.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        defaultNeuanlagePanel.setLayout(layoutNeuanlage);
        defaultNeuanlagePanel.add((Component)this.txtNutzername, c.rc(2, 2, "l"));
        defaultNeuanlagePanel.add((Component)this.tfNutzername, c.rc(2, 4, "lr"));
        defaultNeuanlagePanel.add((Component)this.txtNutzerId, c.rc(2, 6, "l"));
        defaultNeuanlagePanel.add((Component)this.tfNutzerId, c.rc(2, 8, "lr"));
        defaultNeuanlagePanel.add((Component)this.txtPasswort, c.rc(2, 10, "r"));
        defaultNeuanlagePanel.add((Component)this.tfPasswort, c.rc(2, 12, "lr"));
        defaultNeuanlagePanel.add((Component)this.txtDefaultFiliale, c.rc(4, 2, "l"));
        defaultNeuanlagePanel.add((Component)this.cbDefaultFiliale, c.rc(4, 4, "lr"));
        defaultNeuanlagePanel.add((Component)this.txtBearbeiter, c.rc(4, 6, "l"));
        defaultNeuanlagePanel.add((Component)this.tfBearbeiter, c.rc(4, 8, "lr"));
        return defaultNeuanlagePanel;
    }

    private JPanel createBerechtigungenPanel() {
        TitledPanel berechtigungenPanel = new TitledPanel(Resource.getInstance().getBerechtigungen());
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        berechtigungenPanel.setLayout(gridBagLayout);
        GridBagConstraints gbc_markePanel = new GridBagConstraints();
        gbc_markePanel.fill = 2;
        gbc_markePanel.anchor = 18;
        gbc_markePanel.insets = new Insets(0, 0, 0, 5);
        gbc_markePanel.gridx = 0;
        gbc_markePanel.gridy = 0;
        berechtigungenPanel.add((Component)this.markePanel, gbc_markePanel);
        GridBagConstraints gbc_produktartPanel = new GridBagConstraints();
        gbc_produktartPanel.fill = 2;
        gbc_produktartPanel.anchor = 18;
        gbc_produktartPanel.insets = new Insets(0, 0, 0, 5);
        gbc_produktartPanel.gridx = 1;
        gbc_produktartPanel.gridy = 0;
        berechtigungenPanel.add((Component)this.produktartPanel, gbc_produktartPanel);
        GridBagConstraints gbc_katalogUmfangPanel = new GridBagConstraints();
        gbc_katalogUmfangPanel.fill = 2;
        gbc_katalogUmfangPanel.anchor = 18;
        gbc_katalogUmfangPanel.insets = new Insets(0, 0, 0, 5);
        gbc_katalogUmfangPanel.gridx = 2;
        gbc_katalogUmfangPanel.gridy = 0;
        berechtigungenPanel.add((Component)this.katalogUmfangPanel, gbc_katalogUmfangPanel);
        GridBagConstraints gbc_produktionsdatumPanel = new GridBagConstraints();
        gbc_produktionsdatumPanel.fill = 2;
        gbc_produktionsdatumPanel.anchor = 18;
        gbc_produktionsdatumPanel.insets = new Insets(0, 0, 0, 5);
        gbc_produktionsdatumPanel.gridx = 3;
        gbc_produktionsdatumPanel.gridy = 0;
        berechtigungenPanel.add((Component)this.produktionsdatumPanel, gbc_produktionsdatumPanel);
        return berechtigungenPanel;
    }

    private JPanel createFunktionsrechtePanel() {
        JPanel funktionsrechteButtonPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 10, 0, 30, 0, 10, 0, 5};
        HIGLayout layoutFunktionsrechteButton = new HIGLayout(w, h);
        layoutFunktionsrechteButton.setColumnWeight(1, 1);
        layoutFunktionsrechteButton.setRowWeight(1, 1);
        layoutFunktionsrechteButton.setRowWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        funktionsrechteButtonPanel.setLayout(layoutFunktionsrechteButton);
        funktionsrechteButtonPanel.add((Component)this.buttonRechtHinzufuegen, c.rc(2, 1));
        funktionsrechteButtonPanel.add((Component)this.buttonalleRechteHinzufuegen, c.rc(4, 1));
        funktionsrechteButtonPanel.add((Component)this.buttonRechtEntfernen, c.rc(6, 1));
        funktionsrechteButtonPanel.add((Component)this.buttonalleRechteEntfernen, c.rc(8, 1));
        TitledPanel funktionsrechtePanel = new TitledPanel(Resource.getInstance().getFunktionsrechte());
        int[] w_funktionsrechte = new int[]{5, 150, 20, 0, 20, 150, 5};
        int[] h_funktionsrechte = new int[]{5, 180, 5};
        HIGLayout layoutFunktionsrechte = new HIGLayout(w_funktionsrechte, h_funktionsrechte);
        layoutFunktionsrechte.setColumnWeight(2, 1);
        layoutFunktionsrechte.setColumnWeight(6, 1);
        layoutFunktionsrechte.setRowWeight(2, 1);
        funktionsrechtePanel.setLayout(layoutFunktionsrechte);
        funktionsrechtePanel.add((Component)this.alleFunktionsrechtePanel, c.rc(2, 2, "tlrb"));
        funktionsrechtePanel.add((Component)funktionsrechteButtonPanel, c.rc(2, 4, "tlrb"));
        funktionsrechtePanel.add((Component)this.nutzerFunktionsrechtePanel, c.rc(2, 6, "tlrb"));
        return funktionsrechtePanel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        int[] w1 = new int[]{5, -4, 10, -6, 10, -2, 5};
        int[] h1 = new int[]{5, 0, 5};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setColumnWeight(7, 1);
        panel.setLayout(l);
        panel.add((Component)this.buttonSpeichern, c.rc(2, 2, "ltbr"));
        panel.add((Component)this.buttonZuruecksetzen, c.rc(2, 4, "ltbr"));
        panel.add((Component)this.buttonLoeschen, c.rc(2, 6, "ltbr"));
        return panel;
    }

    private void addFunktionsrecht() {
        Nutzer oAktNutzer = this.model.getNutzer();
        Object[] selektierteRechte = this.alleFunktionsrechteList.getSelectedValues();
        if (selektierteRechte == null) {
            return;
        }
        for (int i = 0; i < selektierteRechte.length; ++i) {
            String sRechtBezeichnung = (String)selektierteRechte[i];
            Funktionsrecht oFunktionsrecht = this.model.getFunktionsrecht(sRechtBezeichnung);
            oAktNutzer.addFunktionsrecht(oFunktionsrecht);
            this.model.removeFunktionsrecht(oFunktionsrecht);
        }
        this.alleFunktionsrechteList.setListData(this.model.getFunktionsrechteBezeichnungen());
        this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
        int nAnzahlNutzerFunktionsrechte = oAktNutzer.getAnzahlFunktionsrechte();
        int nAnzahlAktuelleFunktionsrechte = this.model.getAnzahlAktuelleFunktionsrechte();
        if (nAnzahlAktuelleFunktionsrechte == 0) {
            this.enableEntfernenButtons();
        }
        if (nAnzahlNutzerFunktionsrechte > 0) {
            this.buttonalleRechteEntfernen.setEnabled(true);
            this.buttonRechtEntfernen.setEnabled(true);
        }
    }

    private void removeFunktionsrecht() {
        Nutzer oAktNutzer = this.model.getNutzer();
        Object[] selektierteRechte = this.nutzerFunktionsrechteList.getSelectedValues();
        if (selektierteRechte == null) {
            return;
        }
        for (int i = 0; i < selektierteRechte.length; ++i) {
            String sRechtBezeichnung = (String)selektierteRechte[i];
            Funktionsrecht oFunktionsrecht = oAktNutzer.getFunktionsrecht(sRechtBezeichnung);
            oAktNutzer.removeFunktionsrecht(oFunktionsrecht);
            this.model.addFunktionsrecht(oFunktionsrecht);
        }
        this.alleFunktionsrechteList.setListData(this.model.getFunktionsrechteBezeichnungen());
        this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
        int nAnzahlNutzerFunktionsrechte = oAktNutzer.getAnzahlFunktionsrechte();
        int nAnzahlAktuelleFunktionsrechte = this.model.getAnzahlAktuelleFunktionsrechte();
        if (nAnzahlNutzerFunktionsrechte == 0) {
            this.enableHinzufuegenButtons();
        }
        if (nAnzahlAktuelleFunktionsrechte > 0) {
            this.buttonalleRechteHinzufuegen.setEnabled(true);
            this.buttonRechtHinzufuegen.setEnabled(true);
        }
    }

    private void addAlleFunktionsrechte() {
        Nutzer oAktNutzer = this.model.getNutzer();
        oAktNutzer.addFunktionsrechte(this.model.getAktuelleFunktionsrechte());
        this.model.resetAktuelleFunktionsrechte();
        this.alleFunktionsrechteList.setListData(this.model.getFunktionsrechteBezeichnungen());
        this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
        this.enableEntfernenButtons();
    }

    private void removeAlleFunktionsrechte() {
        Nutzer oAktNutzer = this.model.getNutzer();
        TreeSet<Funktionsrecht> cEntfernteRechte = oAktNutzer.removeAlleFunktionsrechte();
        this.model.addFunktionsrechte(cEntfernteRechte);
        this.alleFunktionsrechteList.setListData(this.model.getFunktionsrechteBezeichnungen());
        this.nutzerFunktionsrechteList.setListData(oAktNutzer.getFunktionsrechteBezeichnungen());
        this.enableHinzufuegenButtons();
    }

    private void enableHinzufuegenButtons() {
        this.buttonalleRechteHinzufuegen.setEnabled(true);
        this.buttonRechtHinzufuegen.setEnabled(true);
        this.buttonalleRechteEntfernen.setEnabled(false);
        this.buttonRechtEntfernen.setEnabled(false);
    }

    private void enableEntfernenButtons() {
        this.buttonalleRechteHinzufuegen.setEnabled(false);
        this.buttonRechtHinzufuegen.setEnabled(false);
        this.buttonalleRechteEntfernen.setEnabled(true);
        this.buttonRechtEntfernen.setEnabled(true);
    }

    private void nutzerBearbeiten(boolean bMitUpdate) {
        this.modus = 1;
        this.buttonSpeichern.setEnabled(true);
        this.buttonZuruecksetzen.setEnabled(true);
        this.tfNutzername.requestFocus();
        this.nutzerattributePanel.setTitle(Resource.getInstance().getNutzerBearbeiten());
        this.tfNutzername.setEnabled(true);
        this.tfNutzerId.setEnabled(false);
        this.tfPasswort.setEnabled(true);
        this.cbDefaultFiliale.setEnabled(true);
        this.tfBearbeiter.setEnabled(true);
        Nutzer oAktNutzer = null;
        String sNutzerUndId = null;
        if (this.cbNutzer != null) {
            String sNutzerId = "";
            sNutzerUndId = (String)this.cbNutzer.getSelectedItem();
            int tabulatorposition = -1;
            if (sNutzerUndId != null) {
                tabulatorposition = sNutzerUndId.indexOf("\t");
            }
            if (tabulatorposition != -1) {
                sNutzerId = sNutzerUndId.substring(tabulatorposition + 1);
                if (sNutzerId.equalsIgnoreCase("admin")) {
                    this.buttonLoeschen.setEnabled(false);
                } else {
                    this.buttonLoeschen.setEnabled(true);
                }
            }
            oAktNutzer = this.model.findNutzerByNutzerId(sNutzerId);
        } else {
            oAktNutzer = this.model.getNutzer();
        }
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        oAktNutzer.initNutzer(sFirmaId);
        TreeSet<Funktionsrecht> cFunktionsrechteAkt = oAktNutzer.abgleichenFunktionsrechte(this.model.getAlleFunktionsrechte());
        this.model.storeAktuelleFunktionsrechte(cFunktionsrechteAkt);
        this.model.storeNutzer(oAktNutzer);
        this.model.storeNutzerInit(oAktNutzer);
        if (bMitUpdate) {
            this.update();
        }
    }

    private boolean sindBerechtigungenNichtVergeben() {
        Produkt oProdukt;
        Boolean produktSelected = false;
        Iterator<Produkt> i$ = this.hChkbProdukt.keySet().iterator();
        while (i$.hasNext() && !(produktSelected = Boolean.valueOf(this.hChkbProdukt.get(oProdukt = i$.next()).isSelected())).booleanValue()) {
        }
        return this.mrkSelPanel.getList().getSelectedIndex() == -1 || produktSelected == false || !this.chkbKatalogumfangMobileTradition.isSelected() && !this.chkbKatalogumfangHauptkatalog.isSelected();
    }

    private boolean sindAdminRechteVergeben() {
        Nutzer oAktNutzer = this.model.getNutzer();
        if (oAktNutzer == null) {
            return false;
        }
        boolean bKonfiguration = oAktNutzer.hasRecht("R_WEBETK_KONFIGURATION");
        boolean bFirmaAdmin = oAktNutzer.hasRecht("R_WEBETK_FIRMA_ADMIN");
        boolean bNutzerAdmin = oAktNutzer.hasRecht("R_WEBETK_NUTZER_ADMIN");
        return bKonfiguration || bFirmaAdmin || bNutzerAdmin;
    }

    private boolean sindAdminRechteNichtVergeben() {
        Nutzer oAktNutzer = this.model.getNutzer();
        if (oAktNutzer == null) {
            return false;
        }
        boolean bKonfiguration = oAktNutzer.hasRecht("R_WEBETK_KONFIGURATION");
        boolean bFirmaAdmin = oAktNutzer.hasRecht("R_WEBETK_FIRMA_ADMIN");
        boolean bNutzerAdmin = oAktNutzer.hasRecht("R_WEBETK_NUTZER_ADMIN");
        return !bKonfiguration || !bFirmaAdmin || !bNutzerAdmin;
    }

    private void nutzerSpeichern() {
        Nutzer oAktNutzer = this.model.getNutzer();
        if (oAktNutzer == null) {
            return;
        }
        String sNutzername = this.tfNutzername.getText().trim();
        oAktNutzer.setNutzername(sNutzername);
        String sNutzerId = this.tfNutzerId.getText().trim();
        oAktNutzer.setNutzerId(sNutzerId);
        String sPasswort = this.tfPasswort.getText().trim();
        oAktNutzer.setPassword(sPasswort);
        String sFiliale = this.cbDefaultFiliale.getSelectedItem() != null ? this.cbDefaultFiliale.getSelectedItem().toString() : "";
        String sBearbeiterNummer = this.tfBearbeiter.getText().trim();
        sBearbeiterNummer = sBearbeiterNummer.equals("") ? null : sBearbeiterNummer;
        oAktNutzer.setBearbeiterNummer(sBearbeiterNummer);
        if (sNutzerId.equalsIgnoreCase("score")) {
            String sMeldung = Resource.getInstance().getDoNotUseThisUserId();
            JOptionPane.showMessageDialog(MainView.getInstance(), sMeldung, Resource.getInstance().getBenutzerverwaltung(), 1);
            this.tfNutzerId.requestFocus();
        } else if (sNutzername.length() == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEinenNutzernamenAn(), Resource.getInstance().getBenutzerverwaltung(), 1);
            this.tfNutzername.requestFocus();
        } else if (sPasswort.length() == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEinPasswortAn(), Resource.getInstance().getBenutzerverwaltung(), 1);
            this.tfPasswort.requestFocus();
        } else if (sNutzerId.length() == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEineNutzeridAn(), Resource.getInstance().getBenutzerverwaltung(), 1);
            this.tfNutzerId.requestFocus();
        } else if (StringUtils.enthaeltHochkomma(sNutzername) || StringUtils.enthaeltHochkomma(sNutzerId) || StringUtils.enthaeltHochkomma(sPasswort)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeinHochkomma(), Resource.getInstance().getBenutzerverwaltung(), 1);
        } else if (sFiliale.length() == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEineDefaultfilialeAn(), Resource.getInstance().getBenutzerverwaltung(), 1);
            this.cbDefaultFiliale.requestFocus();
        } else if (this.sindBerechtigungenNichtVergeben()) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteTeilenSieBerechtigungenZu(), Resource.getInstance().getBenutzerverwaltung(), 1);
        } else if (this.controller.existiertNutzerId(sNutzerId) && this.modus == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNutzeridWirdSchonVerwendet(), Resource.getInstance().getBenutzerverwaltung(), 1);
        } else if (!sNutzerId.equalsIgnoreCase("admin") && this.sindAdminRechteVergeben()) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNutzerDarfKeineAdminrechteHaben(), Resource.getInstance().getBenutzerverwaltung(), 1);
        } else if (sNutzerId.equalsIgnoreCase("admin") && this.sindAdminRechteNichtVergeben()) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getAdminMussAdminrechteHaben(), Resource.getInstance().getBenutzerverwaltung(), 1);
        } else {
            Nutzer oNutzerInit;
            boolean bUserBerechtigungenChanged;
            String sOldFilialeId = this.model.getNutzer().getDefaultFiliale();
            int tabulatorposition = -1;
            String sFilialeId = "";
            if (sFiliale != null) {
                tabulatorposition = sFiliale.indexOf("\t");
            }
            if (tabulatorposition != -1) {
                sFilialeId = sFiliale.substring(tabulatorposition + 1);
            }
            oAktNutzer.setDefaultFiliale(sFilialeId);
            oAktNutzer.resetMarkenBerechtigungen();
            for (Object obj : this.mrkSelPanel.getList().getSelectedValues()) {
                if (!(obj instanceof Marke)) continue;
                Marke oMarke = (Marke)obj;
                oAktNutzer.setMarkeBerechtigung(oMarke.getBerechtigung(), Boolean.TRUE);
            }
            oAktNutzer.resetProduktBerechtigungen();
            for (Produkt oProdukt : this.hChkbProdukt.keySet()) {
                oAktNutzer.setProduktBerechtigung(oProdukt.getBerechtigung(), this.hChkbProdukt.get(oProdukt).isSelected());
            }
            oAktNutzer.hatBerechtigungKatalogumfangVT(this.chkbKatalogumfangHauptkatalog.isSelected());
            oAktNutzer.hatBerechtigungKatalogumfangST(this.chkbKatalogumfangMobileTradition.isSelected());
            oAktNutzer.hatBerechtigungAnzeigeProdDatum(this.rbProduktionsdatumJa.isSelected());
            this.controller.storeNutzer();
            if (this.modus == 1 && sFilialeId != null && !sFilialeId.equals(sOldFilialeId)) {
                String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
                this.controller.moveTeilelisten(sFirmaId, sNutzerId, sFilialeId, sOldFilialeId);
            }
            if (bUserBerechtigungenChanged = oAktNutzer.hasChangedBerechtigungen(oNutzerInit = this.model.getNutzerInit())) {
                String sHinweistext = Resource.getInstance().getNutzeradminChangeBerechtigungen();
                sHinweistext = StringUtils.substituteStringStraight(sHinweistext, "{0}", "'" + sNutzerId + "'");
                JOptionPane.showMessageDialog(MainView.getInstance(), sHinweistext, Resource.getInstance().getBenutzerverwaltung(), 1);
            }
            this.model.storeNutzerInit(oAktNutzer);
            MainView.getInstance().initMenus();
            if (this.modus == 0 || this.cbNutzer.getSelectedItem() == null) {
                String sFirmaId = this.model.getFirma().getFirmaId();
                this.controller.loadAllNutzer(sFirmaId);
                int nIndexNutzer = this.updateNutzerComboBox();
                if (this.cbNutzer != null) {
                    this.cbNutzer.setSelectedIndex(nIndexNutzer);
                }
            }
            this.nutzerBearbeiten(true);
        }
    }

    private void nutzerLoeschen() {
        int n = JOptionPane.showConfirmDialog(MainView.getInstance(), Resource.getInstance().getNutzerdatenLoeschen(), Resource.getInstance().getBenutzerverwaltung(), 0);
        if (n == 0) {
            String sId = this.tfNutzerId.getText();
            if (sId != null) {
                this.controller.deleteNutzer(sId, GlobalObjects.getInstance().getSessionInfo().getFirmaId());
            }
            this.tfNutzername.setText("");
            this.tfNutzerId.setText("");
            this.tfPasswort.setText("");
            this.tfBearbeiter.setText("");
            Firma oFirma = this.model.getFirma();
            String sFirmaId = oFirma.getFirmaId();
            this.controller.loadAllNutzer(sFirmaId);
            this.model.storeNutzer(null);
            this.model.storeNutzerInit(null);
            this.update();
        }
    }

    private int updateNutzerComboBox() {
        Collection<Nutzer> cAlleNutzer;
        Nutzer oAktNutzer = this.model.getNutzer();
        this.mbSuppressActionComboNutzer = true;
        int nIndexNutzer = -1;
        int nIndex = 0;
        if (this.cbNutzer != null) {
            this.cbNutzer.removeAllItems();
        }
        if ((cAlleNutzer = this.model.getAlleNutzer()) != null) {
            for (Nutzer oNutzer : cAlleNutzer) {
                String sNutzerName = oNutzer.getNutzername();
                String sNutzerId = oNutzer.getNutzerId();
                if (oAktNutzer != null && oAktNutzer.getNutzerId().equalsIgnoreCase(sNutzerId)) {
                    nIndexNutzer = nIndex;
                }
                ++nIndex;
                if (this.cbNutzer == null) continue;
                this.cbNutzer.addItem(sNutzerName + "\t" + sNutzerId);
            }
        }
        this.mbSuppressActionComboNutzer = false;
        return nIndexNutzer;
    }

    private void updateFilialenComboBox() {
        this.cbDefaultFiliale.removeAllItems();
        Firma oFirma = this.model.getFirma();
        Collection<Filiale> cFilialen = oFirma.getFilialen();
        for (Filiale oFiliale : cFilialen) {
            String sFiliale = oFiliale.getFiliale();
            String sFilialId = oFiliale.getFilialId();
            this.cbDefaultFiliale.addItem(sFiliale + "\t" + sFilialId);
            if (this.model.getNutzer() == null || !sFilialId.equals(this.model.getNutzer().getDefaultFiliale())) continue;
            this.cbDefaultFiliale.setSelectedItem(sFiliale + "\t" + sFilialId);
        }
    }
}

