/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.nutzereinstellungen;

import de.esg.commonclient.GlobalObjects;
import java.awt.Cursor;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Berechtigungen;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Firma;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Funktionsrecht;
import webetk.javaclient.dialog.administration.nutzereinstellungen.FunktionsrechtKomparator;
import webetk.javaclient.framework.MainView;
import webetk.mrkprd.MarkenProdukteBerechtigungen;
import webetk.resources.Resource;

public class Nutzer
extends MarkenProdukteBerechtigungen {
    private static Logger log = Logger.getLogger(Nutzer.class);
    private String msNutzerId = null;
    private String msNutzername = null;
    private String msPassword = null;
    private String msDefaultFiliale = null;
    private String msBearbeiterNummer = null;
    private boolean mbHatBerechtigungKatalogumfangVT = false;
    private boolean mbHatBerechtigungKatalogumfangST = false;
    private boolean mbHatBerechtigungAnzeigeProdDatum = true;
    private TreeSet<Funktionsrecht> mcFunktionsrechte;

    public Nutzer() {
    }

    public Nutzer(String sNutzerName, String sNutzerId, String sPassword, String sDefaultFiliale, String sBearbeiternummer) {
        this.msNutzername = sNutzerName;
        this.msNutzerId = sNutzerId;
        this.msPassword = sPassword;
        this.msDefaultFiliale = sDefaultFiliale;
        this.msBearbeiterNummer = sBearbeiternummer;
    }

    public Nutzer(Nutzer oNutzer) {
        super(oNutzer.getMarkenBerechtigungen(), oNutzer.getProdukteBerechtigungen());
        this.msNutzerId = oNutzer.getNutzerId();
        this.msNutzername = oNutzer.getNutzername();
        this.msPassword = oNutzer.getPassword();
        this.msBearbeiterNummer = oNutzer.getBearbeiterNummer();
        this.msDefaultFiliale = oNutzer.getDefaultFiliale();
        this.mbHatBerechtigungKatalogumfangVT = oNutzer.hatBerechtigungKatalogumfangVT();
        this.mbHatBerechtigungKatalogumfangST = oNutzer.hatBerechtigungKatalogumfangST();
        this.mbHatBerechtigungAnzeigeProdDatum = oNutzer.hatBerechtigungAnzeigeProdDatum();
        this.mcFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        TreeSet<Funktionsrecht> oFunktionsrechte = oNutzer.getFunkionsrechte();
        for (Funktionsrecht oFunktionsrechtSrc : oFunktionsrechte) {
            Funktionsrecht oFunktionsrechtCopy = new Funktionsrecht(oFunktionsrechtSrc.getRechtId(), oFunktionsrechtSrc.getRechtBezeichnung());
            this.mcFunktionsrechte.add(oFunktionsrechtCopy);
        }
    }

    public String getNutzerId() {
        return this.msNutzerId;
    }

    public String getNutzername() {
        return this.msNutzername;
    }

    public String getPassword() {
        return this.msPassword;
    }

    public String getDefaultFiliale() {
        return this.msDefaultFiliale;
    }

    public String getBearbeiterNummer() {
        return this.msBearbeiterNummer;
    }

    public boolean hatBerechtigungKatalogumfangVT() {
        return this.mbHatBerechtigungKatalogumfangVT;
    }

    public boolean hatBerechtigungKatalogumfangST() {
        return this.mbHatBerechtigungKatalogumfangST;
    }

    public boolean hatBerechtigungAnzeigeProdDatum() {
        return this.mbHatBerechtigungAnzeigeProdDatum;
    }

    public TreeSet<Funktionsrecht> getFunkionsrechte() {
        return this.mcFunktionsrechte;
    }

    public boolean initNutzer(String sFirmaId) {
        if (!this.loadBerechtigungen(sFirmaId)) {
            return false;
        }
        return this.loadFunktionsrechte(sFirmaId);
    }

    public void setNutzerId(String sNutzerId) {
        this.msNutzerId = sNutzerId;
    }

    public void setNutzername(String sNutzername) {
        this.msNutzername = sNutzername;
    }

    public void setPassword(String sPassword) {
        this.msPassword = sPassword;
    }

    public void setDefaultFiliale(String sDefaultFiliale) {
        this.msDefaultFiliale = sDefaultFiliale;
    }

    public void setBearbeiterNummer(String sBearbeiterNummer) {
        this.msBearbeiterNummer = sBearbeiterNummer;
    }

    public void hatBerechtigungKatalogumfangVT(boolean bHatBerechtigungKatalogumfangVT) {
        this.mbHatBerechtigungKatalogumfangVT = bHatBerechtigungKatalogumfangVT;
    }

    public void hatBerechtigungKatalogumfangST(boolean bHatBerechtigungKatalogumfangST) {
        this.mbHatBerechtigungKatalogumfangST = bHatBerechtigungKatalogumfangST;
    }

    public void hatBerechtigungAnzeigeProdDatum(boolean bHatBerechtigungAnzeigeProdDatum) {
        this.mbHatBerechtigungAnzeigeProdDatum = bHatBerechtigungAnzeigeProdDatum;
    }

    public boolean loadBerechtigungen(String sFirmaId) {
        log.debug((Object)"Performing Load Berechtigungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBerechtigungen = new TrfHashMap(null);
        trfBerechtigungen.setValue("firmaid", sFirmaId);
        trfBerechtigungen.setValue("user_id", this.msNutzerId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBerechtigungen, Command.LOAD_NUTZER_BERECHTIGUNGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfBerechtigungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBerechtigungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBerechtigungen.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return false;
        }
        Berechtigungen berechtigungen = (Berechtigungen)trfBerechtigungen.getValue("berechtigungen");
        this.setMarkenBerechtigungen(berechtigungen.getMarkenBerechtigungen());
        this.setProdukteBerechtigungen(berechtigungen.getProdukteBerechtigungen());
        this.mbHatBerechtigungKatalogumfangVT = berechtigungen.isKatalogumfangVT();
        this.mbHatBerechtigungKatalogumfangST = berechtigungen.isKatalogumfangST();
        this.mbHatBerechtigungAnzeigeProdDatum = berechtigungen.isProdDatum();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public boolean loadFunktionsrechte(String sFirmaId) {
        log.debug((Object)"Performing Load Nutzer Funktionsrechte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        String sRegIso = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        sRegIso = sRegIso == null ? "  " : sRegIso;
        String sIso = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        TrfHashMap trfFunktionsrechte = new TrfHashMap(null);
        trfFunktionsrechte.setValue("firmaid", sFirmaId);
        trfFunktionsrechte.setValue("user_id", this.msNutzerId);
        trfFunktionsrechte.setValue("iso", sIso);
        trfFunktionsrechte.setValue("regiso", sRegIso);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFunktionsrechte, Command.LOAD_NUTZER_FUNKTIONSRECHTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFunktionsrechte.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFunktionsrechte.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFunktionsrechte.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return false;
        }
        if (this.mcFunktionsrechte == null) {
            this.mcFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        } else {
            this.mcFunktionsrechte.clear();
        }
        List funktionsrechtList = (List)trfFunktionsrechte.getValue("funktionsrecht_list");
        for (webetk.app.konfiguration.Funktionsrecht funktionsrecht : funktionsrechtList) {
            if (funktionsrecht.getBezeichnung().equals("R_WEBETK_FILIALE_AENDERN")) {
                Firma oFirma = new Firma();
                oFirma.initFirma(sFirmaId);
                int nAnzahlFilialen = oFirma.getAnzahlFilialen();
                if (nAnzahlFilialen == 1) continue;
            }
            Funktionsrecht oFunktionsrecht = new Funktionsrecht(funktionsrecht.getBezeichnung(), funktionsrecht.getText());
            this.mcFunktionsrechte.add(oFunktionsrecht);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public int getAnzahlFunktionsrechte() {
        if (this.mcFunktionsrechte == null) {
            return 0;
        }
        return this.mcFunktionsrechte.size();
    }

    public void addFunktionsrecht(Funktionsrecht oFunktionsrecht) {
        if (this.mcFunktionsrechte == null) {
            this.mcFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        }
        this.mcFunktionsrechte.add(oFunktionsrecht);
    }

    public void addFunktionsrechte(TreeSet<Funktionsrecht> cFunktionsrechte) {
        if (cFunktionsrechte == null) {
            return;
        }
        if (this.mcFunktionsrechte == null) {
            this.mcFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        }
        for (Funktionsrecht oFunktionsrecht : cFunktionsrechte) {
            this.mcFunktionsrechte.add(oFunktionsrecht);
        }
    }

    public void removeFunktionsrecht(Funktionsrecht oFunktionsrecht) {
        this.mcFunktionsrechte.remove(oFunktionsrecht);
    }

    public TreeSet<Funktionsrecht> removeAlleFunktionsrechte() {
        TreeSet<Funktionsrecht> cResult = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        for (Funktionsrecht oFunktionsrecht : this.mcFunktionsrechte) {
            cResult.add(oFunktionsrecht);
        }
        this.mcFunktionsrechte.clear();
        return cResult;
    }

    public TreeSet<Funktionsrecht> initFunktionsrechte(TreeSet<Funktionsrecht> cAlleFunktionsrechte, int nAnzahlFilialen) {
        if (this.mcFunktionsrechte == null) {
            this.mcFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        } else {
            this.mcFunktionsrechte.clear();
        }
        TreeSet<Funktionsrecht> cAktFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        for (Funktionsrecht oFunktionsrecht : cAlleFunktionsrechte) {
            String sRechtId = oFunktionsrecht.getRechtId();
            if (nAnzahlFilialen == 1 && sRechtId.equals("R_WEBETK_FILIALE_AENDERN")) continue;
            if (sRechtId.equals("R_WEBETK_TEILEVERWENDUNG_TEIL") || sRechtId.equals("R_WEBETK_TEILEVERWENDUNG_FZG") || sRechtId.equals("R_WEBETK_INTERPRETATION") || sRechtId.equals("R_WEBETK_TEILEERSETZUNG") || sRechtId.equals("R_WEBETK_ERSTBEVORRATUNG") || sRechtId.equals("R_WEBETK_LAGERZEIT") || sRechtId.equals("R_WEBETK_SATZ_EINZELTEILE") || sRechtId.equals("R_WEBETK_NORMTEILE") || sRechtId.equals("R_WEBETK_TECHNISCHE_LITERATUR") || sRechtId.equals("R_WEBETK_FUELLMENGEN")) {
                this.mcFunktionsrechte.add(oFunktionsrecht);
                continue;
            }
            cAktFunktionsrechte.add(oFunktionsrecht);
        }
        return cAktFunktionsrechte;
    }

    public TreeSet<Funktionsrecht> abgleichenFunktionsrechte(TreeSet<Funktionsrecht> cAlleFunktionsrechte) {
        TreeSet<Funktionsrecht> cAktFunktionsrechte = new TreeSet<Funktionsrecht>(new FunktionsrechtKomparator());
        for (Funktionsrecht oFunktionsrecht : cAlleFunktionsrechte) {
            String sRechtId = oFunktionsrecht.getRechtId();
            boolean bGefunden = false;
            for (Funktionsrecht oFunktionsrecht2 : this.mcFunktionsrechte) {
                String sRechtId2 = oFunktionsrecht2.getRechtId();
                if (!sRechtId.equals(sRechtId2)) continue;
                bGefunden = true;
                break;
            }
            if (bGefunden) continue;
            cAktFunktionsrechte.add(oFunktionsrecht);
        }
        return cAktFunktionsrechte;
    }

    public Funktionsrecht getFunktionsrecht(String sRechtBezeichnung) {
        if (this.mcFunktionsrechte == null) {
            return null;
        }
        for (Funktionsrecht oFunktionsrecht : this.mcFunktionsrechte) {
            if (!oFunktionsrecht.getRechtBezeichnung().equals(sRechtBezeichnung)) continue;
            return oFunktionsrecht;
        }
        return null;
    }

    public Vector<String> getFunktionsrechteIds() {
        Vector<String> cResult = new Vector<String>();
        if (this.mcFunktionsrechte == null) {
            return cResult;
        }
        for (Funktionsrecht oFunktionsrecht : this.mcFunktionsrechte) {
            cResult.add(oFunktionsrecht.getRechtId());
        }
        return cResult;
    }

    public Vector<String> getFunktionsrechteBezeichnungen() {
        Vector<String> cResult = new Vector<String>();
        if (this.mcFunktionsrechte == null) {
            return cResult;
        }
        for (Funktionsrecht oFunktionsrecht : this.mcFunktionsrechte) {
            cResult.add(oFunktionsrecht.getRechtBezeichnung());
        }
        return cResult;
    }

    public boolean hasChangedBerechtigungen(Nutzer oNutzer) {
        if (oNutzer == null) {
            return false;
        }
        if (this.hasChangedMarkenBerechtigungen(oNutzer.getMarkenBerechtigungen())) {
            return true;
        }
        if (this.hasChangedProduktBerechtigungen(oNutzer.getProdukteBerechtigungen())) {
            return true;
        }
        if (this.mbHatBerechtigungKatalogumfangVT != oNutzer.hatBerechtigungKatalogumfangVT()) {
            return true;
        }
        if (this.mbHatBerechtigungKatalogumfangST != oNutzer.hatBerechtigungKatalogumfangST()) {
            return true;
        }
        if (this.mbHatBerechtigungAnzeigeProdDatum != oNutzer.hatBerechtigungAnzeigeProdDatum()) {
            return true;
        }
        int nAnzahlFunktionsrechte = this.mcFunktionsrechte.size();
        if (nAnzahlFunktionsrechte != oNutzer.getAnzahlFunktionsrechte()) {
            return true;
        }
        for (Funktionsrecht oFunktionsrecht : this.mcFunktionsrechte) {
            boolean bGefunden = false;
            TreeSet<Funktionsrecht> oFunktionsrechte = oNutzer.getFunkionsrechte();
            for (Funktionsrecht oFunktionsrecht2 : oFunktionsrechte) {
                if (!oFunktionsrecht.getRechtId().equals(oFunktionsrecht2.getRechtId())) continue;
                bGefunden = true;
                break;
            }
            if (bGefunden) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecht(String sRechtId) {
        if (this.mcFunktionsrechte == null || sRechtId == null) {
            return false;
        }
        for (Funktionsrecht oFunktionsrecht : this.mcFunktionsrechte) {
            if (oFunktionsrecht == null || !oFunktionsrecht.getRechtId().equals(sRechtId)) continue;
            return true;
        }
        return false;
    }

    public boolean saveNutzer() {
        String sRegIso = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        sRegIso = sRegIso == null ? "  " : sRegIso;
        String sIso = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        String sNutzername = this.getNutzername();
        String sNutzerId = this.getNutzerId();
        String sPasswort = this.getPassword();
        String sFilialeId = this.getDefaultFiliale();
        String sBearbeiterNummer = this.getBearbeiterNummer();
        boolean bHatBerechtungungKatalogumfangVT = this.hatBerechtigungKatalogumfangVT();
        boolean bHatBerechtungungKatalogumfangST = this.hatBerechtigungKatalogumfangST();
        boolean bHatBerechtungungAnzeigeProdDatum = this.hatBerechtigungAnzeigeProdDatum();
        Vector<String> saNutzerFunktionsrechte = this.getFunktionsrechteIds();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("username", sNutzername);
        trfNutzer.setValue("user_id", sNutzerId.toLowerCase());
        trfNutzer.setValue("iso", sIso);
        trfNutzer.setValue("regiso", sRegIso);
        trfNutzer.setValue("pwd", sPasswort);
        trfNutzer.setValue("filialid", sFilialeId);
        trfNutzer.setValue("bearbeiter_nummer", sBearbeiterNummer);
        Berechtigungen berechtigungen = new Berechtigungen(sFirmaId, sNutzerId.toLowerCase());
        berechtigungen.setMarkenBerechtigungen(this.getMarkenBerechtigungen());
        berechtigungen.setProdukteBerechtigungen(this.getProdukteBerechtigungen());
        berechtigungen.setKatalogumfangST(bHatBerechtungungKatalogumfangST);
        berechtigungen.setKatalogumfangVT(bHatBerechtungungKatalogumfangVT);
        berechtigungen.setProdDatum(bHatBerechtungungAnzeigeProdDatum);
        trfNutzer.setValue("berechtigungen", berechtigungen);
        trfNutzer.setValue("funktionsrechte_list", saNutzerFunktionsrechte);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.STORE_USER);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            return false;
        }
        if (trfNutzer.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerBeimAnlegenAendernDesNutzers(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mbHatBerechtigungAnzeigeProdDatum ? 1231 : 1237);
        result = 31 * result + (this.mbHatBerechtigungKatalogumfangST ? 1231 : 1237);
        result = 31 * result + (this.mbHatBerechtigungKatalogumfangVT ? 1231 : 1237);
        result = 31 * result + (this.mcFunktionsrechte == null ? 0 : this.mcFunktionsrechte.hashCode());
        result = 31 * result + (this.msBearbeiterNummer == null ? 0 : this.msBearbeiterNummer.hashCode());
        result = 31 * result + (this.msDefaultFiliale == null ? 0 : this.msDefaultFiliale.hashCode());
        result = 31 * result + (this.msNutzerId == null ? 0 : this.msNutzerId.hashCode());
        result = 31 * result + (this.msNutzername == null ? 0 : this.msNutzername.hashCode());
        result = 31 * result + (this.msPassword == null ? 0 : this.msPassword.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Nutzer other = (Nutzer)obj;
        if (this.mbHatBerechtigungAnzeigeProdDatum != other.mbHatBerechtigungAnzeigeProdDatum) {
            return false;
        }
        if (this.mbHatBerechtigungKatalogumfangST != other.mbHatBerechtigungKatalogumfangST) {
            return false;
        }
        if (this.mbHatBerechtigungKatalogumfangVT != other.mbHatBerechtigungKatalogumfangVT) {
            return false;
        }
        if (this.mcFunktionsrechte == null ? other.mcFunktionsrechte != null : !this.mcFunktionsrechte.equals(other.mcFunktionsrechte)) {
            return false;
        }
        if (this.msBearbeiterNummer == null ? other.msBearbeiterNummer != null : !this.msBearbeiterNummer.equals(other.msBearbeiterNummer)) {
            return false;
        }
        if (this.msDefaultFiliale == null ? other.msDefaultFiliale != null : !this.msDefaultFiliale.equals(other.msDefaultFiliale)) {
            return false;
        }
        if (this.msNutzerId == null ? other.msNutzerId != null : !this.msNutzerId.equals(other.msNutzerId)) {
            return false;
        }
        if (this.msNutzername == null ? other.msNutzername != null : !this.msNutzername.equals(other.msNutzername)) {
            return false;
        }
        return !(this.msPassword == null ? other.msPassword != null : !this.msPassword.equals(other.msPassword));
    }
}

