/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingung;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.SearchBTETeile;
import webetk.app.aspg.Teil;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.RawZeile;
import webetk.app.etktext.ETKTextZeile;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.konfiguration.Konfiguration;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfImage;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.bte.BTEModel;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.bte.BTEperMail;
import webetk.javaclient.dialog.fzgid.DlgFzgIdController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.framework.MainViewController;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class BTEController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(BTEController.class);
    private BTEView view = new BTEView();
    private BTEModel model = new BTEModel();
    private String msAnsicht = "normal";

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.initUSA(this.model);
        this.view.init(this.model, this);
    }

    public void reinit() {
        log.debug((Object)"reinit");
        this.view = new BTEView();
        this.view.init(this.model, this);
        MainViewController.getInstance().displayDialogView(this.view);
    }

    public boolean isEmailButtonAvailable() {
        String sProduktArt;
        boolean bIsModelId;
        boolean bIsVinId;
        if (!GlobalObjects.getInstance().hasNetz()) {
            return false;
        }
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        String sLanguage = oLoginInfo.getLanguage();
        boolean bIsLanguageOk = sLanguage != null && sLanguage.equals("de");
        JavaFzgSucheInfo oFzgSuche = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSuche == null) {
            bIsVinId = false;
            bIsModelId = false;
        } else {
            String sFgstnr = oFzgSuche.getFahrgestellnummer();
            bIsVinId = sFgstnr != null && sFgstnr.length() >= 7;
            String sFzgIdString = oFzgSuche.getFzgIdString();
            bIsModelId = sFzgIdString != null && sFzgIdString.length() != 0;
        }
        boolean bIsIdentified = bIsVinId || bIsModelId;
        JavaSucheInfo oSuche = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        boolean bIsProduktArtOK = oSuche == null ? false : (sProduktArt = oSuche.getProduktart()) != null && sProduktArt.equals("P");
        String sFzgId = this.model.getFzgIdString();
        boolean bIsFzgBTE = sFzgId != null && sFzgId.length() != 0;
        return !GlobalObjects.getInstance().isIsisServer() && bIsIdentified && bIsProduktArtOK && bIsLanguageOk && bIsFzgBTE;
    }

    private void initUSA(BTEModel oBteModel) {
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (oLoginInfo == null) {
            return;
        }
        int[] maerkte = oLoginInfo.getUserMaerkte();
        if (maerkte == null || maerkte.length == 0) {
            oBteModel.setUSMarkt(false);
        } else {
            boolean bIsUsMarkt = maerkte[0] == 211 || maerkte[0] == 2;
            oBteModel.setUSMarkt(bIsUsMarkt);
        }
        boolean bHasIGDOM = oLoginInfo.getIGDOMAngeschlossen();
        boolean bUseIGDOM = oLoginInfo.isIGDOMKontaktieren();
        boolean bIsIGDOM = bHasIGDOM && bUseIGDOM;
        oBteModel.setIGDOM(bIsIGDOM);
        boolean bIsAbBandVerbaut = !oLoginInfo.getNachruestungenRelevant();
        oBteModel.setAbBandVerbaut(bIsAbBandVerbaut);
    }

    public boolean isUSA() {
        boolean bIsUSMarkt = this.model.isUSMarkt();
        boolean bIsIGDOM = this.model.isIGDOM();
        boolean bIsAbBand = this.model.isAbBandVerbaut();
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null) {
            return bIsUSMarkt && bIsIGDOM && bIsAbBand;
        }
        BTEBedingungsmenge oBedingungen = oCurrentBTE.getBedingungen();
        if (oBedingungen == null) {
            return bIsUSMarkt && bIsIGDOM && bIsAbBand;
        }
        try {
            oBedingungen.goFirst();
            boolean bContinue = true;
            while (bContinue) {
                Long lBedingungsID = oBedingungen.getCurrentId();
                if (lBedingungsID == null) {
                    if (oBedingungen.hasNext()) {
                        oBedingungen.next();
                        continue;
                    }
                    bContinue = false;
                    continue;
                }
                boolean bIsBedingungRelevant = oBedingungen.isBteBedingung(lBedingungsID);
                if (!bIsBedingungRelevant) {
                    if (oBedingungen.hasNext()) {
                        oBedingungen.next();
                        continue;
                    }
                    bContinue = false;
                    continue;
                }
                String sBedingungswert = oBedingungen.getCurrentWert();
                String sCompare = "??";
                if (sBedingungswert != null && sBedingungswert.equals(sCompare)) {
                    return false;
                }
                if (oBedingungen.hasNext()) {
                    oBedingungen.next();
                    continue;
                }
                bContinue = false;
            }
        }
        catch (NoDataFoundException exc) {
            // empty catch block
        }
        return bIsUSMarkt && bIsIGDOM && bIsAbBand;
    }

    @Override
    public WorkflowStateData getExitData() {
        String sExitAction;
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("HGFG_BENENNUNG", this.model.getHgFgList());
        exitData.setWert("FG_OBJECT", this.model.getFGs());
        if (this.model.getBildtafeln() != null && !this.model.getBildtafeln().isEmpty()) {
            exitData.setWert("bildtafeln_bed_aend", this.model.getBildtafeln());
        } else if (exitData.getWert("bildtafeln_bed_aend") != null) {
            exitData.setWert("bildtafeln_bed_aend", exitData.getWert("bildtafeln_bed_aend"));
        }
        if (this.model.getExitAction().equals("prev_bt") || this.model.getExitAction().equals("next_bt") || this.model.getExitAction().equals("this_bt")) {
            CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
            String sBteNr = oCurrentBTE.getBTENr();
            Collection<SearchBTETeile.PartOrBTE> cBildtafeln = this.model.getBildtafelnBlaettern();
            Iterator<SearchBTETeile.PartOrBTE> itr = cBildtafeln.iterator();
            boolean bIsFound = false;
            int nSelBte = 0;
            while (itr.hasNext() && !bIsFound) {
                SearchBTETeile.PartOrBTE oBte = itr.next();
                String sBTNummer = oBte.getIdNummer();
                if (sBteNr.equals(sBTNummer)) {
                    bIsFound = true;
                    continue;
                }
                ++nSelBte;
            }
            ArrayList<SearchBTETeile.PartOrBTE> cBildtafelnSelect = new ArrayList<SearchBTETeile.PartOrBTE>();
            if (this.model.getExitAction().equals("prev_bt")) {
                if (--nSelBte < 0) {
                    nSelBte = 0;
                }
            } else if (this.model.getExitAction().equals("next_bt") && ++nSelBte > cBildtafeln.size() - 1) {
                nSelBte = cBildtafeln.size() - 1;
            }
            itr = cBildtafeln.iterator();
            bIsFound = false;
            int nCount = 0;
            while (itr.hasNext() && !bIsFound) {
                SearchBTETeile.PartOrBTE oBTE = itr.next();
                if (nCount == nSelBte) {
                    cBildtafelnSelect.add(oBTE);
                    bIsFound = true;
                }
                ++nCount;
            }
            if (bIsFound) {
                exitData.setWert("bildtafeln_sel", cBildtafelnSelect);
            }
            exitData.setWert("bildtafeln", cBildtafeln);
        }
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("teilelisten", this.model.getTeilelistenIDs());
        if (this.model.getSmallFont()) {
            exitData.setWert("small_font", "true");
        }
        if (this.model.getExitAction().equals("anzeige_teileliste")) {
            exitData.setWert("wsd", this.model.getWorkflowStateData());
        }
        if ((sExitAction = this.model.getExitAction()).equals("search_hg_at_index")) {
            exitData.setWert("index", Integer.toString(this.model.getIndexHGtoSearch()));
            exitData.setWert("marke", this.model.getMarke());
            exitData.setWert("filter", "true");
            if (GlobalObjects.getInstance().getEtkData().getAssSucheInfo() != null) {
                exitData.setWert("produktart", GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getProduktart());
                exitData.setWert("katalogumfang", GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getKatalogumfang());
            }
        }
        if (sExitAction.equals("zurueckzuteilesuche") || sExitAction.equals("zurueck_zu_fi")) {
            exitData.setWert("bed_filter", "true");
            this.model.setBildtafeln(null);
            this.model.setBildtafelnBlaettern(null);
            exitData.setWert("bildtafeln", this.model.getBildtafeln());
        }
        if (sExitAction.equals("zurueck_zu_bt_ergebnisse")) {
            exitData.setWert("bildtafeln", this.model.getBildtafeln());
        }
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void onExit() {
        boolean bBigFont = GlobalObjects.getInstance().getSessionInfo().getSettings().getSchriftgroesse().equals("G");
        WebETKTheme.useGrosseSchriftart(bBigFont);
    }

    void expandBildnummer(String sBildnummer) {
        log.debug((Object)"Performing Expand");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfExpand = new TrfHashMap(null);
        trfExpand.setValue("bildnummer", sBildnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfExpand, Command.BT_EXPAND_BILDNUMMER);
        }
        catch (CommunicationException ex) {
            log.error((Object)("BTEController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfExpand.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfExpand.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfExpand.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfExpand.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void applyBedAuswertung(boolean bBedAuswertung) {
        log.debug((Object)"Performing Apply BedAuswertung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBedAuswertung = new TrfHashMap(null);
        String sBedAuswertung = bBedAuswertung ? "true" : "false";
        trfBedAuswertung.setValue("apply_bed_auswertung", sBedAuswertung);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBedAuswertung, Command.BT_APPLY_BEDINGUNGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("BTEController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfBedAuswertung.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBedAuswertung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBedAuswertung.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfBedAuswertung.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void changeBedingung(Long lBedId, Bedingungswert oBedWert) {
        log.debug((Object)"Performing Change Bedingung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfChangeBed = new TrfHashMap(null);
        trfChangeBed.setValue("id", lBedId);
        trfChangeBed.setValue("wert", oBedWert);
        String sAktualisierenDurchfuehren = this.model.getBedAuswertung() ? "true" : "false";
        trfChangeBed.setValue("aktualisieren", sAktualisierenDurchfuehren);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfChangeBed, Command.BT_CHANGE_BED);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfChangeBed.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfChangeBed.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfChangeBed.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfChangeBed.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        SearchBTETeile oSearchBTETeile = (SearchBTETeile)trfChangeBed.getValue("searchbteteile");
        if (oSearchBTETeile != null && oSearchBTETeile.getBTEs() != null) {
            if (this.model.getBildtafeln() != null) {
                this.model.getBildtafeln().clear();
            }
            this.model.setBildtafeln(oSearchBTETeile.getBTEs());
        }
    }

    void collapseBildnummer(String sBildnummer) {
        log.debug((Object)"Performing Expand");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfExpand = new TrfHashMap(null);
        trfExpand.setValue("bildnummer", sBildnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfExpand, Command.BT_COLLAPSE_BILDNUMMER);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfExpand.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfExpand.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfExpand.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfExpand.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void ladenBildafelNochmals(boolean bVinIdent) {
        log.debug((Object)"Performing Load This-Bildtafel again");
        this.model.setExitAction("this_bt");
        this.notifyAllExitListeners();
    }

    void ladenBildtafelNext(boolean bVerweisBildtafel) {
        log.debug((Object)"Performing Load Next-Bildtafel");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (bVerweisBildtafel) {
            TrfHashMap trfNext = new TrfHashMap(null);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfNext, Command.BT_NEXT_BTE);
            }
            catch (CommunicationException ex) {
                log.error((Object)"Communication Layer is not initialised!", (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (trfNext.getError() != null) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNext.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), trfNext.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
                return;
            }
            this.model.storeCurrentBTE((CurrentBTE)trfNext.getValue("currentbte"));
            String sHasNextBT = (String)trfNext.getValue("hasnextbt");
            this.model.hasNextBT(sHasNextBT.equals("true"));
            String sHasPrevBT = (String)trfNext.getValue("hasprevbt");
            this.model.hasPrevBT(sHasPrevBT.equals("true"));
        } else {
            this.model.setExitAction("next_bt");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            this.notifyAllExitListeners();
        }
    }

    void ladenBildtafelPrev(boolean bVerweisBildtafel) {
        log.debug((Object)"Performing Load Pev-Bildtafel");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (bVerweisBildtafel) {
            TrfHashMap trfPrev = new TrfHashMap(null);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfPrev, Command.BT_PREV_BTE);
            }
            catch (CommunicationException ex) {
                log.error((Object)"Communication Layer is not initialised!", (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (trfPrev.getError() != null) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfPrev.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), trfPrev.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
                return;
            }
            this.model.storeCurrentBTE((CurrentBTE)trfPrev.getValue("currentbte"));
            String sHasNextBT = (String)trfPrev.getValue("hasnextbt");
            this.model.hasNextBT(sHasNextBT.equals("true"));
            String sHasPrevBT = (String)trfPrev.getValue("hasprevbt");
            this.model.hasPrevBT(sHasPrevBT.equals("true"));
        } else {
            this.model.setExitAction("prev_bt");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            this.notifyAllExitListeners();
        }
    }

    void showVerweisBildtafel(String sBtNummerNach) {
        log.debug((Object)"Performing Show Verweis-Bildtafel");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfVerweis = new TrfHashMap(null);
        trfVerweis.setValue("btnummer", sBtNummerNach);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfVerweis, Command.BT_LOAD_VERWEIS_BT);
        }
        catch (CommunicationException ex) {
            log.error((Object)"Communication Layer is not initialised!", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfVerweis.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfVerweis.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfVerweis.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfVerweis.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void loadGrafik() {
        log.debug((Object)"Performing Load Grafik");
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfImage bild = new TrfImage(null);
        bild.setImageID(oCurrentBTE.getBildIdAsString());
        bild.setFormFactor("Z");
        bild.setTimestamp(oCurrentBTE.getBildTimestamp());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(bild, Command.GET_IMAGE);
        }
        catch (CommunicationException ex) {
            log.error((Object)"Communication Layer is not initialised!", (Throwable)ex);
            this.model.storeCurrentGrafik(null);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (bild.getError() != null) {
            log.error((Object)"Login Failed!", (Throwable)bild.getError());
            this.model.storeCurrentGrafik(null);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.model.storeImageFormat(bild.getImageFormat());
        this.model.storeCurrentGrafik(bild.getAsStream());
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public String getAnsicht() {
        return this.msAnsicht;
    }

    public void setAnsicht(String sAnsicht) {
        this.msAnsicht = sAnsicht;
    }

    protected Konfiguration getKonfiguration() {
        if (this.model.getKonfiguration() != null) {
            return this.model.getKonfiguration();
        }
        this.model.setKonfiguration(GlobalObjects.getInstance().getConfig());
        return this.model.getKonfiguration();
    }

    protected ArrayList<Teil> getAspgTeil(ArrayList<Teil> cAspgTeile) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        Vector<Teil> teilVector = new Vector<Teil>();
        teilVector.addAll(cAspgTeile);
        TrfHashMap trfHashMap = new TrfHashMap(null);
        try {
            String sprache = GlobalObjects.getInstance().getLanguage();
            trfHashMap.setValue("sprache", sprache);
            trfHashMap.setValue("teileaspg", teilVector);
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_ASPGTEILE);
        }
        catch (CommunicationException e) {
            log.error((Object)("ladeAspgTeile: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return null;
        }
        if (trfHashMap.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLadenKonfiguration() + ": " + trfHashMap.getError().getMessage()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenKonfiguration() + ": " + trfHashMap.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Vector trfHashMapValue = (Vector)trfHashMap.getValue("teileaspg");
        cAspgTeile.clear();
        cAspgTeile.addAll(trfHashMapValue);
        return cAspgTeile;
    }

    protected ArrayList<Teil> getAspgTeilFromBTE(ArrayList<Teil> cAspgTeile, boolean pVerbaumenge) {
        ArrayList<Teil> res = new ArrayList<Teil>();
        Vector<RawZeile> zeilen = this.model.getCurrentBTE().getRawZeilenTemp();
        block0: for (Teil aTeil : cAspgTeile) {
            RawZeile zeile;
            res.add(aTeil);
            int ankerPos = 0;
            int ankerMenge = 1;
            for (RawZeile object : zeilen) {
                zeile = object;
                if (!zeile.isTeilASPG() || !aTeil.getSachnummer().equals(zeile.getSachnummer()) || zeile.getBildnummer().equals("--")) continue;
                ankerPos = zeile.getPos();
                ankerMenge = Integer.parseInt(zeile.getMenge());
                break;
            }
            if (ankerPos == 0) {
                return res;
            }
            int curPos = ankerPos + 1;
            int maxPos = this.getMaxPos(zeilen);
            while (curPos <= maxPos) {
                zeile = this.getZeileByPos(zeilen, curPos);
                ++curPos;
                if (zeile == null) continue;
                if (!zeile.getBildnummer().equals("--")) continue block0;
                String sMenge = zeile.getMenge().equals("") || zeile.getMenge().equals("X") ? "1" : zeile.getMenge();
                Teil koppel = new Teil(zeile.getSachnummer(), sMenge, "AS");
                if (!pVerbaumenge) {
                    int x = Integer.parseInt(sMenge) / ankerMenge;
                    sMenge = Integer.toString(x);
                    koppel.setMenge(sMenge);
                }
                koppel.setAspgTyp("K");
                koppel.setAspgRef(aTeil.getSachnummer());
                koppel.setAspgMenge(sMenge);
                res.add(koppel);
            }
        }
        return res;
    }

    private int getMaxPos(Vector<RawZeile> zeilen) {
        int res = 1;
        for (RawZeile object : zeilen) {
            RawZeile zeile = object;
            if (zeile.getPos() <= res) continue;
            res = zeile.getPos();
        }
        return res;
    }

    private RawZeile getZeileByPos(Vector<RawZeile> zeilen, int curPos) {
        for (RawZeile object : zeilen) {
            RawZeile zeile = object;
            if (zeile.getPos() != curPos) continue;
            return zeile;
        }
        return null;
    }

    public boolean identifiziereFahrzeugByFgstnr(String sFgstnr, String sachnummer) {
        Collection<Object> cFzgInfo = null;
        return DlgFzgIdController.doFIByFahrgestellnummer(sFgstnr, false, cFzgInfo);
    }

    public boolean synchronisierenFI(JavaFzgSucheInfo oFzgSucheInfoClient, JavaFzgIdInfo oFzgIdInfoClient, FzgSucheInfo oFzgSucheInfoServer, FzgIdInfo oFzgIdInfoServer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfHashMap = new TrfFahrzeugId(null);
        trfHashMap.setValue("fzgsucheinfo_java", oFzgSucheInfoClient);
        trfHashMap.setValue("fzgidinfo_java", oFzgIdInfoClient);
        trfHashMap.setValue("fzgidinfo_app", oFzgIdInfoServer);
        trfHashMap.setValue("fzgsucheinfo_app", oFzgSucheInfoServer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.SYNCHRONIZE_FI);
        }
        catch (CommunicationException e) {
            log.error((Object)("synchronisierenFI: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getBildtafel(), 0);
            return false;
        }
        if (trfHashMap.getError() != null) {
            log.error((Object)("synchronisierenFI: " + trfHashMap.getError().getMessage()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHashMap.getError().getMessage(), Resource.getInstance().getBildtafel(), 0);
            return false;
        }
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfoClient);
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfoClient);
        try {
            CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
            BTEBedingungsmenge oBTEBedingungsmenge = oCurrentBTE.getBedingungen();
            Bedingungsmenge oBedingungsmenge = oFzgSucheInfoClient.getBedingungsMenge();
            if (oBedingungsmenge != null) {
                oBedingungsmenge.goFirst();
                boolean bIsContinue = true;
                while (bIsContinue) {
                    if (!oBedingungsmenge.hasNext()) {
                        bIsContinue = false;
                    }
                    Long nBedID = oBedingungsmenge.getCurrentId();
                    String sBedWert = oBedingungsmenge.getCurrentWert();
                    Bedingung oBedingung = oBTEBedingungsmenge.getBed(nBedID);
                    if (oBedingung != null && oBedingung.isBteBedingung()) {
                        String sCurrentValue;
                        String string = sCurrentValue = oBTEBedingungsmenge.getBedWert(nBedID) == null ? "0" : oBTEBedingungsmenge.getBedWert(nBedID);
                        if (!sCurrentValue.equals(sBedWert)) {
                            Bedingungswert sNewValue = new Bedingungswert(sBedWert);
                            oBTEBedingungsmenge.setBedWert(nBedID, sNewValue);
                        }
                    }
                    if (!bIsContinue) continue;
                    oBedingungsmenge.next();
                }
            }
        }
        catch (NoDataFoundException exc) {
            log.error((Object)("synchronisierenFI: Keine Daten gefunden: " + exc.getMessage()));
            return false;
        }
        catch (NullPointerException exc) {
            log.error((Object)("synchronisierenFI: Current-BTE nicht vorhanden: " + exc.getMessage()));
            return false;
        }
        catch (InvalidInitializationException exc) {
            log.error((Object)("synchronisierenFI: Neuer Bedingungswert kann nicht erzeugt werden: " + exc.getMessage()));
            return false;
        }
        catch (InvalidDataException exc) {
            log.error((Object)("synchronisierenFI: Neuer Bedingungswert ist ungueltig und kann nicht zugewiesen werden: " + exc.getMessage()));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public Collection<Bedingung> getJaBedingungen() {
        Vector<Bedingung> cJaBedingungen = new Vector<Bedingung>();
        BTEBedingungsmenge oBTEBedmenge = this.model.getCurrentBTE().getBedingungen();
        if (oBTEBedmenge == null) {
            return new Vector<Bedingung>();
        }
        TreeSet<Bedingung> oBedingungen = oBTEBedmenge.getBedingungsmenge().getSortedKeys();
        for (Bedingung bed : oBedingungen) {
            Long lElemId = bed.getId();
            String sWert = oBTEBedmenge.getBedWert(lElemId);
            if (sWert == null || !sWert.equals("1")) continue;
            cJaBedingungen.add(bed);
        }
        return cJaBedingungen;
    }

    public Collection<ETKTextZeile> evalETKTexte(boolean bIgnoreAngezeigtFlag, boolean bSetAngezeigt) {
        String sHG = this.model.getCurrentBTE().getHG();
        String sFG = this.model.getCurrentBTE().getFG();
        String sProduktart = this.model.getProduktart();
        Collection<ETKTextZeile> cETKTextZeilen = GlobalObjects.getInstance().evalETKTextZeilen(sHG, sFG, sProduktart, bIgnoreAngezeigtFlag, bSetAngezeigt);
        return cETKTextZeilen;
    }

    public boolean hatETKTexte(boolean bIgnoreAngezeigtFlag) {
        String sHG = this.model.getCurrentBTE().getHG();
        String sFG = this.model.getCurrentBTE().getFG();
        String sProduktart = this.model.getProduktart();
        return GlobalObjects.getInstance().hatETKTextZeilen(sHG, sFG, sProduktart, bIgnoreAngezeigtFlag);
    }

    public void sendMail(String sFzgInfo, String sBteInfo) {
        BTEperMail dlgBTEMail = new BTEperMail();
        dlgBTEMail.setAnEMailAdresse("mirror-support-F30F31@bmw.de");
        dlgBTEMail.setAn("ETK Support");
        dlgBTEMail.setBetreff("Fahrzeug: " + sFzgInfo + " BTE: " + sBteInfo);
        dlgBTEMail.show();
    }

    public static class Ansicht {
        public static final String NORMAL = "normal";
        public static final String GRAFIK = "grafik";
        public static final String TEXT = "text";
    }

    public static class ExitActions {
        public static final String THIS_BT = "this_bt";
        public static final String NEXT_BT = "next_bt";
        public static final String PREV_BT = "prev_bt";
        public static final String SHOW_VERWEIS_BT = "show_verweis_bt";
        public static final String ZURUECK_ZU_FI = "zurueck_zu_fi";
        public static final String ZURUECK_ZU_BT_ERGEBNISSE = "zurueck_zu_bt_ergebnisse";
        public static final String ZURUECK_ZU_TNRBT_ERGEBNISSE = "zurueck_zu_tnrbt_ergebnisse";
        public static final String ANZEIGE_TEILELISTE = "anzeige_teileliste";
    }
}

