/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte;

import de.esg.commonclient.GlobalObjects;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import rasterviewer.imageloaders.ImageLoader;
import webetk.app.FGs;
import webetk.app.HauptgruppeTO;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.RawZeile;
import webetk.app.konfiguration.Konfiguration;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class BTEModel
extends AbstractDlgMitTLModel {
    private static Logger log = Logger.getLogger(BTEModel.class);
    private String msDialogModus = null;
    private String msDialogTitel = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msFzgIdString = null;
    private CurrentBTE moCurrentBTE = null;
    private ByteArrayInputStream maBild = null;
    private Image maBildAsImage = null;
    private boolean mbHasNextBT = false;
    private boolean mbHasPrevBT = false;
    private boolean mbZurueckZuBtVisible = false;
    private boolean mbZurueckZuBtSensitiv = false;
    private boolean mbZurueckZuTnrBtVisible = false;
    private boolean mbZurueckZuTnrBtSensitiv = false;
    private boolean mbZurueckZuTVErlauben = false;
    private boolean mbZurueckZuTeilesucheErlauben = false;
    private String msExitAction = null;
    private String msVerweisBtNummer = null;
    private Collection<SearchBTETeile.PartOrBTE> moBildtafeln = null;
    private boolean bIsUsMarkt = false;
    private boolean bIsIGDOM = false;
    private boolean bIsAbBandVerbaut = false;
    private boolean bShowUsFilter = false;
    private Collection<SearchBTETeile.PartOrBTE> mcBildtafelnBlaettern = null;
    private WorkflowStateData moWsd = null;
    private boolean mbBedAuswertung = false;
    private String msBedAnzeigeModus = null;
    private boolean mbSuchwegVerkuerzen = false;
    private boolean mbNachruestungenRelevant = false;
    private String msSachnummerTVInit = null;
    private String msMarkeTVInit = null;
    private String msProduktartTVInit = null;
    private String msKatalogumfangTVInit = null;
    private String msSachnummerTVExit = null;
    private String msMarkeTVExit = null;
    private String msProduktartTVExit = null;
    private String msKatalogumfangTVExit = null;
    private String msSachnummerSuch = null;
    private String msImageFormat = null;
    private boolean mbSmallFont = false;
    private boolean mbAufrufAusWorklow = false;
    private int mnIndexHGNext = -1;
    private int mnIndexHGPrev = -1;
    private int mnIndexHGtoSearch = -1;
    private int mnRowShowVisible = -1;
    private boolean mbIpacView = false;
    private Konfiguration moKonfiguration = null;
    private boolean vinButton = false;
    private boolean mbIsRotgefaerbt = false;
    private List<HauptgruppeTO> hgfgList;
    private FGs fGs;

    public boolean isVinButton() {
        return this.vinButton;
    }

    public void setVinButton(boolean vinButton) {
        this.vinButton = vinButton;
    }

    public String getDialogModus() {
        return this.msDialogModus;
    }

    public String getDialogTitel() {
        return this.msDialogTitel;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public void storeCurrentBTE(CurrentBTE oCurrentBTE) {
        this.moCurrentBTE = oCurrentBTE;
    }

    public CurrentBTE getCurrentBTE() {
        return this.moCurrentBTE;
    }

    public boolean isRotGefaerbt() {
        return this.mbIsRotgefaerbt;
    }

    public void setIsRotGefaerbt(boolean bIsRotGefaerbt) {
        this.mbIsRotgefaerbt = bIsRotGefaerbt;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafelnBlaettern() {
        return this.mcBildtafelnBlaettern;
    }

    public void setBildtafelnBlaettern(Collection<SearchBTETeile.PartOrBTE> cBildtafelnBlaettern) {
        this.mcBildtafelnBlaettern = cBildtafelnBlaettern;
    }

    public Image getCurrentGrafikAsImage() {
        if (this.maBild == null) {
            return null;
        }
        if (this.maBildAsImage != null) {
            return this.maBildAsImage;
        }
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            byte[] r = new byte[4096];
            int read = this.maBild.read(r);
            while (read != -1) {
                bos.write(r, 0, read);
                read = this.maBild.read(r);
            }
        }
        catch (IOException iox) {
            log.error((Object)"Error loading bte image", (Throwable)iox);
        }
        ImageLoader loader = new ImageLoader();
        this.maBildAsImage = this.getImageFormat().equalsIgnoreCase("TIF") || this.getImageFormat().equalsIgnoreCase("TIFF") ? loader.loadImage(bos.toByteArray(), 3, 0) : loader.loadImage(bos.toByteArray(), 2, 0);
        return this.maBildAsImage;
    }

    public void storeCurrentGrafik(ByteArrayInputStream aBild) {
        this.maBild = aBild;
        this.maBildAsImage = null;
    }

    public String getFzgIdString() {
        return this.msFzgIdString;
    }

    public String getBtNummerUeberschrift() {
        if (this.moCurrentBTE == null) {
            return "";
        }
        return this.moCurrentBTE.getBTENr() + " " + this.moCurrentBTE.getBTEUeberschrift();
    }

    public boolean hasNextBT() {
        return this.mbHasNextBT;
    }

    public void hasNextBT(boolean bHasNextBT) {
        this.mbHasNextBT = bHasNextBT;
    }

    public boolean hasPrevBT() {
        return this.mbHasPrevBT;
    }

    public void hasPrevBT(boolean bHasPrevBT) {
        this.mbHasPrevBT = bHasPrevBT;
    }

    public boolean getBedAuswertung() {
        return this.mbBedAuswertung;
    }

    public void setBedAuswertung(boolean bBedAuswertung) {
        this.mbBedAuswertung = bBedAuswertung;
    }

    public boolean getSuchwegVerkuerzen() {
        return this.mbSuchwegVerkuerzen;
    }

    public void setSuchwegVerkuerzen(boolean bSuchwegVerk) {
        this.mbSuchwegVerkuerzen = bSuchwegVerk;
    }

    public boolean getNachruestungenRelevant() {
        return this.mbNachruestungenRelevant;
    }

    public void setNachruestungenRelevant(boolean bNachruestRel) {
        this.mbNachruestungenRelevant = bNachruestRel;
    }

    public String getExitAction() {
        return this.msExitAction;
    }

    public void setExitAction(String sExitAction) {
        this.msExitAction = sExitAction;
    }

    public void setWorkflowStateData(WorkflowStateData oWsd) {
        this.moWsd = oWsd;
    }

    public WorkflowStateData getWorkflowStateData() {
        return this.moWsd;
    }

    public void setVerweisBtNummer(String sVerweisBtNummer) {
        this.msVerweisBtNummer = sVerweisBtNummer;
    }

    public String getVerweisBtNummer() {
        return this.msVerweisBtNummer;
    }

    public boolean isVisibleZurueckZuBtErgebnisse() {
        return this.mbZurueckZuBtVisible;
    }

    public boolean isErlaubtZurueckZuTeilesuche() {
        return this.mbZurueckZuTeilesucheErlauben;
    }

    public boolean isSensitivZurueckZuBtErgebnisse() {
        return this.mbZurueckZuBtSensitiv;
    }

    public boolean isVisibleZurueckZuTnrBtErgebnisse() {
        return this.mbZurueckZuTnrBtVisible;
    }

    public boolean isSensitivZurueckZuTnrBtErgebnisse() {
        return this.mbZurueckZuTnrBtSensitiv;
    }

    public String getSachnummerSuch() {
        return this.msSachnummerSuch;
    }

    public String getSachnummerTVInit() {
        return this.msSachnummerTVInit;
    }

    public String getMarkeTVInit() {
        return this.msMarkeTVInit;
    }

    public String getProduktartTVInit() {
        return this.msProduktartTVInit;
    }

    public String getKatalogumfangTVInit() {
        return this.msKatalogumfangTVInit;
    }

    public boolean isErlaubtZurueckZuTeileverwendung() {
        return this.mbZurueckZuTVErlauben;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        Collection BTElist;
        String sAufrufAusWorklow;
        super.init(oWFStateData);
        this.hgfgList = (List)oWFStateData.getWert("HGFG_BENENNUNG");
        this.fGs = (FGs)oWFStateData.getWert("FG_OBJECT");
        if (oWFStateData.getWert("bildtafeln_bed_aend") != null) {
            this.setBildtafeln((Collection)oWFStateData.getWert("bildtafeln_bed_aend"));
        }
        Collection cBildtafelnBlaettern = (Collection)oWFStateData.getWert("bildtafeln");
        this.setBildtafelnBlaettern(cBildtafelnBlaettern);
        this.moCurrentBTE = (CurrentBTE)oWFStateData.getWert("currentbte");
        String sHasNextBT = (String)oWFStateData.getWert("hasnextbt");
        this.mbHasNextBT = sHasNextBT.equals("true");
        String sHasPrevBT = (String)oWFStateData.getWert("hasprevbt");
        this.mbHasPrevBT = sHasPrevBT.equals("true");
        this.moTeilelistenIDs = (TrfHashMap)oWFStateData.getWert("teilelisten");
        this.msSachnummerSuch = (String)oWFStateData.getWert("sachnummersuch");
        String sZurueckZuBtVisible = (String)oWFStateData.getWert("zurueck_zu_ergebnisse_bt_visible");
        this.mbZurueckZuBtVisible = sZurueckZuBtVisible != null && !sZurueckZuBtVisible.equals("false");
        String sZurueckZuBtSensitiv = (String)oWFStateData.getWert("zurueck_zu_ergebnisse_bt_sensitiv");
        this.mbZurueckZuBtSensitiv = sZurueckZuBtSensitiv != null && !sZurueckZuBtSensitiv.equals("false");
        String sZurueckZuTnrBtVisible = (String)oWFStateData.getWert("zurueck_zu_ergebnisse_tnrbt_visile");
        this.mbZurueckZuTnrBtVisible = sZurueckZuTnrBtVisible != null && !sZurueckZuTnrBtVisible.equals("false");
        String sZurueckZuTnrBtSensitiv = (String)oWFStateData.getWert("zurueck_zu_ergebnisse_tnrbt_sensitiv");
        this.mbZurueckZuTnrBtSensitiv = sZurueckZuTnrBtSensitiv != null && !sZurueckZuTnrBtSensitiv.equals("false");
        String sZurueckZuTeilesucheErlauben = (String)oWFStateData.getWert("zurueck_zu_teilesuche_erlauben");
        this.mbZurueckZuTeilesucheErlauben = sZurueckZuTeilesucheErlauben != null && !sZurueckZuTeilesucheErlauben.equals("false");
        String sZurueckZuTVErlauben = (String)oWFStateData.getWert("zurueck_zu_teileverwendung_erlauben");
        boolean bl = this.mbZurueckZuTVErlauben = sZurueckZuTVErlauben != null && !sZurueckZuTVErlauben.equals("false");
        if (this.mbZurueckZuTVErlauben) {
            this.msSachnummerTVInit = (String)oWFStateData.getWert("sachnummersuch");
            this.msMarkeTVInit = (String)oWFStateData.getWert("marke");
            this.msProduktartTVInit = (String)oWFStateData.getWert("produktart");
            this.msKatalogumfangTVInit = (String)oWFStateData.getWert("katalogumfang");
        }
        this.mbAufrufAusWorklow = (sAufrufAusWorklow = (String)oWFStateData.getWert("aufruf_aus_workflow")) != null && !sAufrufAusWorklow.equals("false");
        this.msDialogModus = (String)oWFStateData.getWert("modus");
        Collection list = (Collection)oWFStateData.getWert("bildtafeln_sel");
        SearchBTETeile.PartOrBTE partBte2 = null;
        if (list != null && list.size() > 0) {
            for (SearchBTETeile.PartOrBTE partBte2 : list) {
                if (this.moCurrentBTE.getBTENr().equals(partBte2.getIdNummer())) {
                    this.setIsRotGefaerbt(partBte2.isRotMarkiert());
                    break;
                }
                partBte2 = null;
            }
        }
        this.msDialogTitel = Resource.getInstance().getAnzeigeBildtafel();
        if (partBte2 != null && partBte2.getMarktIso() != null && (BTElist = (Collection)oWFStateData.getWert("bildtafeln")) != null && BTElist.size() == 1) {
            String locSting = partBte2.getMarktBen();
            if (locSting == null) {
                locSting = partBte2.getMarktIso();
            }
            final String message = MessageFormat.format(Resource.getInstance().getWarnungLokaleBildTafel(), locSting);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainView.getInstance(), message, Resource.getInstance().getLokaleBildtafeln(), 1);
                }
            });
            this.setIsRotGefaerbt(partBte2.isRotMarkiert());
        }
        if (this.msDialogModus.equals("Fahrzeugteile") || this.msDialogModus.equals("ValueLine")) {
            this.msFzgIdString = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getFzgIdString();
            this.setMarke(GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getMarke());
            this.msProduktart = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getProduktart();
            this.msKatalogumfang = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getKatalogumfang();
            this.mbBedAuswertung = true;
            this.mbSuchwegVerkuerzen = GlobalObjects.getInstance().getSessionInfo().getSuchwegVerkuerzen();
            this.mbNachruestungenRelevant = GlobalObjects.getInstance().getSessionInfo().getNachruestungenRelevant();
            log.debug((Object)"Zeilen gefunden!");
        } else {
            this.setMarke(GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getMarke());
            this.msProduktart = GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getProduktart();
            this.msKatalogumfang = GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getKatalogumfang();
        }
        String sSmallFont = (String)oWFStateData.getWert("small_font");
        this.mbSmallFont = sSmallFont == null ? !GlobalObjects.getInstance().getSessionInfo().getSettings().getSchriftgroesse().equals("G") : sSmallFont.equals("true");
        String sIndexHGNext = (String)oWFStateData.getWert("index_next_hg");
        this.mnIndexHGNext = sIndexHGNext == null ? -1 : Integer.parseInt(sIndexHGNext);
        String sIndexHGPrev = (String)oWFStateData.getWert("index_prev_hg");
        this.mnIndexHGPrev = sIndexHGPrev == null ? -1 : Integer.parseInt(sIndexHGPrev);
        this.msBedAnzeigeModus = this.isRotGefaerbt() ? "btanzeige_ungefiltert" : "btanzeige_gefiltert";
        Boolean ipacView = (Boolean)oWFStateData.getWert("ipacView");
        this.mbIpacView = ipacView != null ? ipacView : false;
    }

    public String getImageFormat() {
        return this.msImageFormat;
    }

    public void storeImageFormat(String string) {
        this.msImageFormat = string;
    }

    public boolean getSmallFont() {
        return this.mbSmallFont;
    }

    public void setSmallFont(boolean bSmallFont) {
        this.mbSmallFont = bSmallFont;
    }

    public void setSachnummerTVExit(String sSachnummerTVExit) {
        this.msSachnummerTVExit = sSachnummerTVExit;
    }

    public void setMarkeTVExit(String sMarkeTVExit) {
        this.msMarkeTVExit = sMarkeTVExit;
    }

    public void setProduktartTVExit(String sProduktartTVExit) {
        this.msProduktartTVExit = sProduktartTVExit;
    }

    public void setKatalogumfangTVExit(String sKatalogumfangTVExit) {
        this.msKatalogumfangTVExit = sKatalogumfangTVExit;
    }

    public String getSachnummerTVExit() {
        return this.msSachnummerTVExit;
    }

    public String getMarkeTVExit() {
        return this.msMarkeTVExit;
    }

    public String getProduktartTVExit() {
        return this.msProduktartTVExit;
    }

    public String getKatalogumfangTVExit() {
        return this.msKatalogumfangTVExit;
    }

    public boolean isAufrufAusWorkflow() {
        return this.mbAufrufAusWorklow;
    }

    public int getIndexHGNext() {
        return this.mnIndexHGNext;
    }

    public int getIndexHGPrev() {
        return this.mnIndexHGPrev;
    }

    public void setIndexHGtoSearch(int nIndexHGtoSearch) {
        this.mnIndexHGtoSearch = nIndexHGtoSearch;
    }

    public int getIndexHGtoSearch() {
        return this.mnIndexHGtoSearch;
    }

    public void setBedAnzeigeModus(String sBedAnzeigeModus) {
        this.msBedAnzeigeModus = sBedAnzeigeModus;
    }

    public String getBedAnzeigeModus() {
        return this.msBedAnzeigeModus;
    }

    public String getBildtafelType() {
        if (this.moCurrentBTE == null) {
            return "FZG";
        }
        return this.moCurrentBTE.getBTEType();
    }

    public void setRowShowVisible(int nRowShowVisible) {
        this.mnRowShowVisible = nRowShowVisible;
    }

    public int getRowShowVisible() {
        return this.mnRowShowVisible;
    }

    public Konfiguration getKonfiguration() {
        return this.moKonfiguration;
    }

    public void setKonfiguration(Konfiguration oKonfiguration) {
        this.moKonfiguration = oKonfiguration;
    }

    public boolean showNVinButton() {
        boolean isProduktionsdatumOk;
        this.setVinButton(false);
        if (!this.getBildtafelType().equals("FZG")) {
            return false;
        }
        JavaFzgSucheInfo oFzgSucheInfoClientAkt = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfoClientAkt == null) {
            return false;
        }
        String sFgstnr = oFzgSucheInfoClientAkt.getFahrgestellnummer();
        if (!StringUtils.isEmpty(sFgstnr, true)) {
            return false;
        }
        String bj = oFzgSucheInfoClientAkt.getBaujahr();
        String zm = oFzgSucheInfoClientAkt.getZulassungsmonat();
        boolean bl = isProduktionsdatumOk = bj != null && !bj.equals("") && zm != null && !zm.equals("") || oFzgSucheInfoClientAkt.getProduktionsdatum() != null && !oFzgSucheInfoClientAkt.getProduktionsdatum().equals("");
        if (!isProduktionsdatumOk && this.isProduktionsdatumNoetig() || this.isBTEAspgMitBeds()) {
            this.showMessageFzgIdentifikationNichtAusreichend(false);
            this.setVinButton(true);
            return true;
        }
        if (!this.moCurrentBTE.hatChangepoints()) {
            return false;
        }
        this.showMessageFzgIdentifikationNichtAusreichend(true);
        return true;
    }

    private void showMessageFzgIdentifikationNichtAusreichend(boolean bShowBTEZeilen) {
        if (!bShowBTEZeilen) {
            this.moCurrentBTE.setZeilen(new Vector<AbstractZeile>());
        }
        final String message = Resource.getInstance().getFahrzeugidentifikationNichtAusreichendVIN();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(MainView.getInstance(), message, Resource.getInstance().getFahrzeugidentifikation(), 0);
            }
        });
    }

    private boolean isProduktionsdatumNoetig() {
        Vector<RawZeile> zeilen = this.moCurrentBTE.getRawZeilen();
        boolean isAspg = false;
        for (RawZeile zeile : zeilen) {
            if (zeile.getBildnummer().equals("--")) {
                if (!isAspg || !(zeile.getBedingungArt() != null && !zeile.getBedingungArt().equals("") || zeile.getEinsatz() != null && !zeile.getEinsatz().equals("")) && (zeile.getAuslauf() == null || zeile.getAuslauf().equals(""))) continue;
                return true;
            }
            if (zeile.isTeilASPG()) {
                isAspg = true;
                continue;
            }
            isAspg = false;
        }
        return false;
    }

    public boolean isBTEAspgMitBeds() {
        Vector<RawZeile> zeilen = this.moCurrentBTE.getRawZeilen();
        boolean isAspg = false;
        for (RawZeile zeile : zeilen) {
            if (zeile.getBildnummer().equals("--")) {
                if (!isAspg || zeile.getBedkezPG() == null || zeile.getBedkezPG().equals("")) continue;
                return true;
            }
            if (zeile.isTeilASPG()) {
                isAspg = true;
                continue;
            }
            isAspg = false;
        }
        return false;
    }

    public boolean showIPACButton() {
        boolean isUs = true;
        if (MainView.getInstance().isIsis()) {
            isUs = GlobalObjects.getInstance().getIsoCountryCode().equals("US") || GlobalObjects.getInstance().getIsoCountryCode().equals("");
        } else {
            LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
            int[] result = loginInfo.getUserMaerkte();
            log.info((Object)("result[0]: " + result[0]));
            log.info((Object)("result[1]: " + result[1]));
            if (result[0] == 211 || result[0] == 2) {
                if (result[1] == 1) {
                    log.info((Object)"isUs = true");
                    isUs = true;
                } else {
                    isUs = false;
                }
            } else {
                isUs = false;
            }
        }
        boolean isScore = GlobalObjects.isScore();
        if (this.isMotorradBte()) {
            isUs = false;
        }
        return !this.isIpacView() && this.isZubehoerBte() && !isUs && !isScore && this.existsForIpacMarkt();
    }

    public boolean isIpacView() {
        return this.mbIpacView;
    }

    public boolean isZubehoerBte() {
        if (this.moCurrentBTE == null) {
            return false;
        }
        return this.moCurrentBTE.isZubehoerBte();
    }

    public boolean isMotorradBte() {
        if (this.moCurrentBTE == null) {
            return false;
        }
        return this.moCurrentBTE.getProduktart().equals("M");
    }

    public boolean existsForIpacMarkt() {
        String lkz = this.moCurrentBTE.getLkz();
        if (lkz == null) {
            return true;
        }
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        Markt marktIpac = loginInfo.getSettings().getIPACMarkt();
        if (marktIpac == null) {
            return false;
        }
        return lkz.equals(marktIpac.getLkz());
    }

    public void setBildtafeln(Collection<SearchBTETeile.PartOrBTE> moBildtafeln) {
        this.moBildtafeln = moBildtafeln;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafeln() {
        return this.moBildtafeln;
    }

    public boolean isUSMarkt() {
        return this.bIsUsMarkt;
    }

    public void setUSMarkt(boolean bIsUsMarkt) {
        this.bIsUsMarkt = bIsUsMarkt;
    }

    public boolean isIGDOM() {
        return this.bIsIGDOM;
    }

    public void setIGDOM(boolean bIsIGDOM) {
        this.bIsIGDOM = bIsIGDOM;
    }

    public boolean isAbBandVerbaut() {
        return this.bIsAbBandVerbaut;
    }

    public void setAbBandVerbaut(boolean bIsAbBandVerbaut) {
        this.bIsAbBandVerbaut = bIsAbBandVerbaut;
    }

    public boolean isShowUsFilter() {
        return this.bShowUsFilter;
    }

    public void setShowUsFilter(boolean bShowUsFilter) {
        this.bShowUsFilter = bShowUsFilter;
    }

    public List<HauptgruppeTO> getHgFgList() {
        return this.hgfgList;
    }

    public void setHgFgList(List<HauptgruppeTO> hgfgList) {
        this.hgfgList = hgfgList;
    }

    public FGs getFGs() {
        return this.fGs;
    }

    public void setFGs(FGs fGs) {
        this.fGs = fGs;
    }
}

