/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import webetk.ListLockedException;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.extras.teileinfo.Teilenotiz;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.dialog.extras.teileliste.EditTeilKlein;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.IconAndTooltip;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.mrkprd.Marken;
import webetk.resources.Resource;

public class KleineTeilelistePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(KleineTeilelistePanel.class);
    private DlgTeilelisteModel mModel;
    private DlgTeilelisteController mController = null;
    private JButtonEx mButtonDMSDirect = null;
    private GenericTable mtable = null;
    private GenericTableModel mtabmodel = null;
    private JPanel mtableScoreRahmen = null;
    private Vector<JTable> maScoreTeileTables = new Vector();
    private HashMap<JTable, ScorelisteJob> mMapScoreJobToTable = new HashMap();
    private HashMap<JTable, ScorelisteSrp> mMapScoreSrpToTable = new HashMap();
    private JPopupMenu popupMenu = null;
    private JMenuItem popupActionBearbeiten = null;
    private JMenuItem popupActionLoeschen = null;
    private JMenuItem popupActionNotiz = null;
    private JMenuItem popupActionCopySachnummer = null;
    private final int COL_ICON_EDIT = 0;
    private final int COL_ICON_DEL = 1;
    private final int COL_ICON_NOTIZ = 2;
    private final int POPUP_IND_NOTIZ = 3;
    private final int POPUP_IND_SACHNR = 4;
    private final int POPUP_IND_BEARBEITEN = 0;
    private final int POPUP_IND_LOESCHEN = 2;
    private BTEView mView;
    private static final Color JOB_BACK_COLOR = new Color(192, 192, 190);
    private static final Color SRP_BACK_COLOR = new Color(238, 238, 236);
    private static final Color LOCK_BACK_COLOR = new Color(212, 212, 210);

    public KleineTeilelistePanel(BTEView view) {
        this.mView = view;
        this.mModel = new DlgTeilelisteModel();
        this.mController = new DlgTeilelisteController();
        this.mController.setModel(this.mModel);
        this.mController.setDialogView(null);
        this.mModel.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
    }

    public void setSplitPane(JSplitPane oSplitPane) {
    }

    public void init(String sID, String sEigentuemer, boolean bForceReload) {
        if ((bForceReload || this.mModel.getTLDaten() == null || !this.mModel.getTLDaten().getID().equals(sID) || !this.mModel.getTLDaten().getNutzerID().equals(sEigentuemer)) && this.loadTeileliste(sID, sEigentuemer)) {
            Teileliste oTL = this.mModel.getTLDaten();
            if (oTL != null) {
                this.mModel.setSelTL(new ComboTeilelisteItem(oTL.getID(), oTL.getID(), oTL.getNutzerID(), oTL.getFiliale(), oTL.getMarke()));
            }
            if (Marken.getInstance().getEigenschaften("marke.usListenIds").contains(this.mModel.getSelTLID())) {
                String sFilename = GlobalObjects.getInstance().getEtkData().getUSDealerFilename();
                this.mModel.setUSSchnittstelleFilename(sFilename);
            }
        }
        this.mModel.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        this.initComponents();
        this.update();
    }

    public void setTeileliste(Teileliste oTL) {
        this.mModel.setTLDaten(oTL);
        if (oTL != null) {
            this.mModel.setSelTLID(oTL.getID());
            this.mModel.setSelTL(new ComboTeilelisteItem(oTL.getID(), oTL.getID(), oTL.getNutzerID(), oTL.getFiliale(), oTL.getMarke()));
        } else {
            this.mModel.setSelTLID(null);
            this.mModel.setSelTL(null);
        }
    }

    public DlgTeilelisteModel getTeilelisteModel() {
        return this.mModel;
    }

    private void initComponents() {
        this.mButtonDMSDirect = new JButtonEx(Resource.getInstance().getNueDmsDirect(), ImageCache.getInstance().getIcon("abgleichdaten.jpg"));
        this.mButtonDMSDirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KleineTeilelistePanel.this.mController.handleDMSDirect();
                KleineTeilelistePanel.this.update();
            }
        });
        this.initMenus();
        this.layoutAll();
        this.update();
    }

    private void layoutAll() {
        this.removeAll();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{0, 0};
        int[] heights = new int[]{5, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(4, 1);
        this.setLayout(layout);
        JPanel buttonPanel = new JPanel();
        int[] buttonPanelWidths = new int[]{5, 0};
        int[] buttonPanelHeights = new int[]{0};
        HIGLayout buttonPanelLayout = new HIGLayout(buttonPanelWidths, buttonPanelHeights);
        buttonPanel.setLayout(buttonPanelLayout);
        buttonPanel.add((Component)this.mButtonDMSDirect, c.rc(1, 2, "l"));
        this.add((Component)buttonPanel, c.rc(2, 2, "l"));
        if (!GlobalObjects.isScore()) {
            this.add((Component)this.createTabelle(), c.rc(4, 2));
        } else {
            this.add((Component)this.createScoreTabelle(), c.rc(4, 2));
        }
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        tableConfig.addIconColumn("teil_bearbeiten.jpg", Resource.getInstance().getTeilBearbeiten());
        ++nCol;
        tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
        ++nCol;
        tableConfig.addIconColumn("notiz.gif", Resource.getInstance().getNotiz());
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXX");
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getMenge(), 4, false, "X00000.00");
        tableConfig.addColumn("N", 4, false, "X");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getNotiz());
        if (this.mModel.istDMSAngeschlossen()) {
            tableConfig.addColumn(Resource.getInstance().getNueSplitt(), 4, false, "XX");
            tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getSplittKennzeichen());
            tableConfig.addColumn(Resource.getInstance().getNueRetr(), 4, false, "XXXX");
            tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getRechnungstransparenz());
        }
        tableConfig.setUsePrototypeIcons(true);
        this.mtabmodel = new GenericTableModel(tableConfig);
        this.mtable = new GenericTable(this.mtabmodel);
        this.mtable.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(2).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(2).setWidth(20);
        if (!GlobalObjects.isScore()) {
            this.mtable.getTable().setSelectionMode(2);
        } else {
            this.mtable.getTable().setSelectionMode(0);
        }
        this.mtable.addMouseListener(new TeilelisteMouseListener());
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        return this.mtable.getScrollPane();
    }

    protected JComponent createScoreTabelle() {
        this.mtableScoreRahmen = new JPanel();
        this.updateScoreTabelle();
        JScrollPane sc = new JScrollPane(this.mtableScoreRahmen);
        sc.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), UIHelper.getStandardBorder()));
        Dimension dim = sc.getPreferredSize();
        dim.height = 300;
        sc.setPreferredSize(dim);
        return sc;
    }

    protected JPanel createScoreJobTable(ScorelisteJob job) {
        JPanel panel = new JPanel();
        int[] w_t = new int[]{10, 240, 10, 0};
        int[] h_t = new int[]{0};
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(4, 1);
        lo.setRowWeight(1, 1);
        panel.setLayout(lo);
        panel.setBackground(JOB_BACK_COLOR);
        JLabel id = new JLabel(job.getId());
        panel.add((Component)id, c.rc(1, 2, "lr"));
        panel.add((Component)new JLabel(job.getBezeichnung()), c.rc(1, 4));
        return panel;
    }

    protected JPanel createScoreSRPTable(ScorelisteJob job, ScorelisteSrp srp) {
        JPanel panel = new JPanel();
        int[] w_t = new int[]{20, 0};
        int[] h_t = new int[]{0, 0};
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(2, 1);
        lo.setRowWeight(2, 1);
        panel.setLayout(lo);
        panel.add((Component)this.createScoreSRPTableSRP(srp), c.rcwh(1, 1, 2, 1));
        JComponent scoreTabelleDetail = this.createScoreTabelleTeile(srp.getTeile(), job, srp);
        panel.add((Component)scoreTabelleDetail, c.rc(2, 2));
        return panel;
    }

    protected JPanel createScoreSRPTableSRP(ScorelisteSrp srp) {
        JPanel panel = new JPanel();
        int[] w_t = new int[]{240, 10, 0};
        int[] h_t = new int[]{0};
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(3, 1);
        lo.setRowWeight(1, 1);
        panel.setLayout(lo);
        panel.setBackground(SRP_BACK_COLOR);
        JLabel id = new JLabel(srp.getId());
        id.setHorizontalAlignment(0);
        panel.add((Component)id, c.rc(1, 1, "lr"));
        panel.add((Component)new JLabel(srp.getBezeichnung()), c.rc(1, 3, "lr"));
        return panel;
    }

    protected JComponent createScoreTabelleTeile(Collection<Teil> aTeile, ScorelisteJob job, ScorelisteSrp srp) {
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        tableConfig.addIconColumn("teil_bearbeiten.jpg", Resource.getInstance().getTeilBearbeiten());
        ++nCol;
        tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXX");
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getMenge(), 4, false, "X00000.00");
        ++nCol;
        if (this.mModel.istDMSAngeschlossen()) {
            tableConfig.addColumn(Resource.getInstance().getNueSplitt(), 4, false, "XX");
            ++nCol;
            tableConfig.addColumn(Resource.getInstance().getNueRetr(), 4, false, "XXXX");
            ++nCol;
        }
        tableConfig.setUsePrototypeIcons(false);
        GenericTableModel tabmodel = new GenericTableModel(tableConfig);
        this.mtable = new GenericTable(tabmodel);
        this.mtable.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        if (aTeile != null) {
            for (Teil oTeil : aTeile) {
                if (oTeil.getScoreAenderung() == 4) continue;
                boolean bJobOrSrpLock = job.isLock() || srp.isLock();
                this.addScoreTeil(tabmodel, oTeil, bJobOrSrpLock);
            }
        }
        this.mtable.getTable().setSelectionMode(0);
        this.mtable.addMouseListener(new TeilelisteMouseListener());
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        this.maScoreTeileTables.add(this.mtable);
        this.mMapScoreJobToTable.put(this.mtable, job);
        this.mMapScoreSrpToTable.put(this.mtable, srp);
        return this.mtable.getScrollPane();
    }

    protected void addScoreTeil(GenericTableModel tabmodel, Teil oTeil, boolean bJobOrSrpLock) {
        IconAndTooltip bearbeiten = null;
        IconAndTooltip loeschen = null;
        if (!bJobOrSrpLock && !oTeil.isScoreLock()) {
            bearbeiten = new IconAndTooltip(ImageCache.getInstance().getIcon("teil_bearbeiten.jpg"), Resource.getInstance().getTeilBearbeiten());
            loeschen = new IconAndTooltip(ImageCache.getInstance().getIcon("trashbin.gif"), Resource.getInstance().getLoeschen());
        }
        AbstractRow oRow = null;
        oRow = this.mModel.istDMSAngeschlossen() ? new AbstractRow(new Object[]{bearbeiten, loeschen, oTeil.getTeilenummerGespreizt(), oTeil.getMenge(), oTeil.getSplitt(), oTeil.getTransparenz()}) : new AbstractRow(new Object[]{bearbeiten, loeschen, oTeil.getTeilenummerGespreizt(), oTeil.getMenge()});
        if (bJobOrSrpLock || oTeil.isScoreLock()) {
            oRow.setBackColor(LOCK_BACK_COLOR);
        }
        tabmodel.addRow(oRow);
    }

    private void initMenus() {
        this.popupMenu = new JPopupMenu();
        this.popupActionBearbeiten = new JMenuItem(Resource.getInstance().getMarkiertesTeilBearbeiten() + "...");
        this.popupActionBearbeiten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<Teil> aSelTeile = KleineTeilelistePanel.this.getSelTeileFromTab(KleineTeilelistePanel.this.mtable);
                if (KleineTeilelistePanel.this.mModel.istDMSAngeschlossen() && KleineTeilelistePanel.this.mtable.getSelectedRowCount() > 1) {
                    KleineTeilelistePanel.this.handleEditTeileMultiSelect(aSelTeile);
                } else {
                    KleineTeilelistePanel.this.handleEditTeile(aSelTeile);
                }
            }
        });
        this.popupMenu.add(this.popupActionBearbeiten);
        this.popupActionLoeschen = new JMenuItem(Resource.getInstance().getLoeschen());
        this.popupActionLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<Teil> aSelTeile = KleineTeilelistePanel.this.getSelTeileFromTab(KleineTeilelistePanel.this.mtable);
                Teileliste oTL = KleineTeilelistePanel.this.mModel.getTLDaten();
                KleineTeilelistePanel.this.mController.deleteTeile(oTL.getID(), oTL.getNutzerID(), oTL.getFiliale(), aSelTeile);
                KleineTeilelistePanel.this.update();
            }
        });
        this.popupMenu.add(this.popupActionLoeschen);
        if (!GlobalObjects.isScore()) {
            this.popupMenu.addSeparator();
            this.popupActionNotiz = new JMenuItem(Resource.getInstance().getNotiz() + "...");
            this.popupActionNotiz.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector<Teil> aSelTeile = KleineTeilelistePanel.this.getSelTeileFromTab(KleineTeilelistePanel.this.mtable);
                    KleineTeilelistePanel.this.handleShowTeilenotiz(aSelTeile.get(0));
                }
            });
            this.popupMenu.add(this.popupActionNotiz);
        }
        this.popupMenu.addSeparator();
        this.popupActionCopySachnummer = new JMenuItem(Resource.getInstance().getSachnummerKopieren());
        this.popupActionCopySachnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<Teil> aSelTeile = KleineTeilelistePanel.this.getSelTeileFromTab(KleineTeilelistePanel.this.mtable);
                Teil oTeil = aSelTeile.get(0);
                String sSachnummer = oTeil.getSachnummer();
                if (sSachnummer.trim().equals("")) {
                    return;
                }
                GlobalObjects.getInstance().getEtkData().copySachnummerIntoClipboard(sSachnummer);
            }
        });
        this.popupMenu.add(this.popupActionCopySachnummer);
    }

    public void update() {
        this.mButtonDMSDirect.setVisible(this.mModel.getSelTLID() != null && Marken.getInstance().getEigenschaften("marke.usListenIds").contains(this.mModel.getSelTLID()));
        Teileliste oTLDaten = this.mModel.getTLDaten();
        if (this.mtabmodel != null) {
            this.mtabmodel.removeAllRows();
        }
        if (oTLDaten == null) {
            return;
        }
        Vector<Teil> aTeile = oTLDaten.getTeile();
        if (aTeile == null) {
            return;
        }
        if (!GlobalObjects.isScore()) {
            this.updateListe();
        } else {
            this.updateScoreListe();
        }
    }

    public void scrollToLastRow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollPane sc = KleineTeilelistePanel.this.mtable.getScrollPane();
                sc.getVerticalScrollBar().setValue(sc.getVerticalScrollBar().getMaximum());
            }
        });
    }

    protected void updateListe() {
        Teileliste oTl = this.mModel.getTLDaten();
        Vector<Teil> aTeile = oTl.getTeile();
        for (Teil oTeil : aTeile) {
            IconAndTooltip notiz = null;
            String sNotizKz = null;
            if (oTeil.getHatNotiz()) {
                sNotizKz = "N";
                notiz = new IconAndTooltip(ImageCache.getInstance().getIcon("notiz.gif"), Resource.getInstance().getNotiz());
            } else {
                sNotizKz = "";
                notiz = new IconAndTooltip(ImageCache.getInstance().getIcon("notiz.gif"), null);
            }
            if (this.mModel.istDMSAngeschlossen()) {
                this.mtabmodel.addRow(new AbstractRow(new Object[]{null, null, notiz, oTeil.getTeilenummerGespreizt(), oTeil.getMenge(), sNotizKz, oTeil.getSplitt(), oTeil.getTransparenz()}));
                continue;
            }
            this.mtabmodel.addRow(new AbstractRow(new Object[]{null, null, notiz, oTeil.getTeilenummerGespreizt(), oTeil.getMenge(), sNotizKz}));
        }
    }

    protected void updateScoreListe() {
        this.updateScoreTabelle();
        for (GenericTable genericTable : this.maScoreTeileTables) {
            int height = genericTable.calcRowHeights();
            genericTable.calcMinSizeNow();
            int width = genericTable.getMinWidth();
            Dimension dim = new Dimension(width + 18, height + 2);
            genericTable.getScrollPane().setPreferredSize(dim);
            genericTable.getScrollPane().setMinimumSize(dim);
            genericTable.setPreferredSize(dim);
            genericTable.repaint();
        }
        this.validate();
        this.repaint();
    }

    protected void updateScoreTabelle() {
        int anzZeilen = 0;
        Teileliste oTLDaten = this.mModel.getTLDaten();
        if (oTLDaten != null && oTLDaten instanceof Scoreliste) {
            Scoreliste scoreliste = (Scoreliste)oTLDaten;
            Collection<ScorelisteJob> cJobs = scoreliste.getJobs();
            for (ScorelisteJob job : cJobs) {
                ++anzZeilen;
                Collection<ScorelisteSrp> cSrps = job.getSrps();
                Iterator<ScorelisteSrp> iterSrps = cSrps.iterator();
                while (iterSrps.hasNext()) {
                    iterSrps.next();
                    ++anzZeilen;
                }
            }
        }
        int[] w_t = new int[]{20, 0};
        int[] h_t = new int[anzZeilen];
        for (int ii = 0; ii < anzZeilen; ++ii) {
            h_t[ii] = 0;
        }
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(2, 1);
        this.mtableScoreRahmen.setLayout(lo);
        this.mtableScoreRahmen.removeAll();
        this.mMapScoreJobToTable.clear();
        this.mMapScoreSrpToTable.clear();
        this.maScoreTeileTables.removeAllElements();
        if (oTLDaten != null && oTLDaten instanceof Scoreliste) {
            Scoreliste scoreliste = (Scoreliste)oTLDaten;
            Collection<ScorelisteJob> cJobs = scoreliste.getJobs();
            int nRow = 0;
            for (ScorelisteJob job : cJobs) {
                this.mtableScoreRahmen.add((Component)this.createScoreJobTable(job), c.rcwh(++nRow, 1, 2, 1));
                Collection<ScorelisteSrp> cSrps = job.getSrps();
                for (ScorelisteSrp srp : cSrps) {
                    this.mtableScoreRahmen.add((Component)this.createScoreSRPTable(job, srp), c.rc(++nRow, 2, "lr"));
                }
            }
        }
    }

    private boolean loadTeileliste(String sID, String sEigentuemer) {
        log.debug((Object)("Performing loadTeileliste for ID " + sID));
        this.entsperreListe();
        this.mModel.setTLDaten(null);
        this.mModel.setSelTLID(null);
        if (sID == null || sID.length() < 1) {
            return false;
        }
        if (sID.equals(Resource.getInstance().getNeueListe()) || sID.equals(Resource.getInstance().getAndereListe())) {
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sID);
        trfTL.setValue("eigentuemer", sEigentuemer);
        trfTL.setValue("lock", true);
        if (GlobalObjects.isScore()) {
            trfTL.setValue("score", true);
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            if (ex instanceof ListLockedException) {
                String sMsg = null;
                Teileliste oTeileliste = (Teileliste)trfTL.getValue("teileliste");
                String sVon = oTeileliste.getGesperrtVon();
                String sVonName = (String)trfTL.getValue("username");
                if (sVon != null) {
                    Object[] arguments = new Object[]{sVon, sVonName};
                    sMsg = MessageFormat.format(Resource.getInstance().getTeilelisteGesperrtNutzer(), arguments);
                    log.info((Object)("Liste gesperrt von " + sVon));
                } else {
                    sMsg = Resource.getInstance().getTeilelisteGesperrtDms();
                    log.info((Object)"Liste gesperrt vom DMS.");
                }
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileliste(), 0);
                return false;
            }
            log.error((Object)(Resource.getInstance().getFehlerLadenTeileliste() + ": "), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenTeileliste() + ": " + ex.getMessage(), Resource.getInstance().getTeileliste(), 0);
            return false;
        }
        Teileliste oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        if (oTeileliste == null) {
            oTeileliste = (Scoreliste)trfTL.getValue("scoreliste");
        }
        this.mModel.setTLDaten(oTeileliste);
        this.mModel.setSelTLID(sID);
        this.mModel.setSelTLMarke(oTeileliste.getMarke());
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    private void handleEditTeile(Vector<Teil> aTeile) {
        this.mModel.setSelTeile(aTeile);
        Teil oTeil = aTeile.elementAt(0);
        String sMenge = oTeil.getMenge();
        EditTeilKlein editTeil = new EditTeilKlein(this.mModel, sMenge);
        Teileliste oTL = this.mModel.getTLDaten();
        if (oTL instanceof Scoreliste) {
            editTeil.setJobSrp(oTeil.getJobId(), oTeil.getSrpId());
        }
        editTeil.setVisible(true);
        this.update();
    }

    private void handleEditTeileMultiSelect(Vector<Teil> aTeile) {
        this.mModel.setSelTeile(aTeile);
        EditTeilKlein editTeil = new EditTeilKlein(this.mModel);
        editTeil.setVisible(true);
        this.update();
    }

    private void handleShowTeilenotiz(Teil oTeil) {
        if (!oTeil.getHatNotiz()) {
            return;
        }
        String sTeilenummer = oTeil.getTeilenummer();
        Teilenotiz dlgHinweis = new Teilenotiz(MainView.getInstance(), sTeilenummer);
        dlgHinweis.setVisible(true);
    }

    public void entsperreListe() {
        if (this.mModel.getTLDaten() == null) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teileliste", this.mModel.getTLDaten());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.UNLOCK_BESTELLLISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerBestelllisteEntsperren() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerBestelllisteEntsperren() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeileliste(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected Vector<Teil> getSelTeileFromTab(GenericTable table) {
        Vector aTeile = null;
        Teileliste oTl = this.mModel.getTLDaten();
        if (oTl instanceof Scoreliste) {
            Scoreliste oSl = (Scoreliste)oTl;
            ScorelisteJob job = this.mMapScoreJobToTable.get(table);
            ScorelisteSrp srp = this.mMapScoreSrpToTable.get(table);
            aTeile = (Vector)oSl.getTeileOhneLoeschflag(job.getId(), srp.getId());
        } else {
            aTeile = oTl.getTeile();
        }
        Vector<Teil> aSelTeile = new Vector<Teil>();
        int[] aRows = table.getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            Teil oTeil = aTeile.get(aRows[ii]);
            aSelTeile.add(oTeil);
        }
        return aSelTeile;
    }

    protected class TeilelisteMouseListener
    extends GenericTableMouseEventAdapter {
        protected TeilelisteMouseListener() {
        }

        @Override
        public void popupOnCell(GenericTableMouseEvent evt) {
            GenericTable table = (GenericTable)evt.getSource();
            KleineTeilelistePanel.this.mtable = table;
            Vector<Teil> aSelTeile = KleineTeilelistePanel.this.getSelTeileFromTab(table);
            if (aSelTeile.size() == 1) {
                KleineTeilelistePanel.this.popupMenu.show(KleineTeilelistePanel.this.mtable.getTable(), evt.getX(), evt.getY());
                boolean bScoreLock = false;
                Teileliste oTl = KleineTeilelistePanel.this.mModel.getTLDaten();
                if (oTl instanceof Scoreliste) {
                    ScorelisteJob job = (ScorelisteJob)KleineTeilelistePanel.this.mMapScoreJobToTable.get(table);
                    ScorelisteSrp srp = (ScorelisteSrp)KleineTeilelistePanel.this.mMapScoreSrpToTable.get(table);
                    boolean bl = bScoreLock = job.isLock() || srp.isLock();
                    if (!bScoreLock) {
                        for (Teil oTeil : aSelTeile) {
                            if (!oTeil.isScoreLock()) continue;
                            bScoreLock = true;
                        }
                    }
                }
                if (!GlobalObjects.isScore()) {
                    Teil oTeil = aSelTeile.get(0);
                    KleineTeilelistePanel.this.popupActionNotiz.setEnabled(oTeil.getHatNotiz());
                } else {
                    KleineTeilelistePanel.this.popupActionBearbeiten.setEnabled(!bScoreLock);
                    KleineTeilelistePanel.this.popupActionLoeschen.setEnabled(!bScoreLock);
                }
            }
            if (!GlobalObjects.isScore()) {
                if (aSelTeile.size() > 1) {
                    if (KleineTeilelistePanel.this.mModel.istDMSAngeschlossen()) {
                        KleineTeilelistePanel.this.popupMenu.show(KleineTeilelistePanel.this.mtable.getTable(), evt.getX(), evt.getY());
                        KleineTeilelistePanel.this.popupActionNotiz.setEnabled(false);
                        KleineTeilelistePanel.this.popupActionCopySachnummer.setEnabled(false);
                    } else {
                        KleineTeilelistePanel.this.popupMenu.show(KleineTeilelistePanel.this.mtable.getTable(), evt.getX(), evt.getY());
                        KleineTeilelistePanel.this.popupActionBearbeiten.setEnabled(false);
                        KleineTeilelistePanel.this.popupActionLoeschen.setEnabled(true);
                        KleineTeilelistePanel.this.popupActionNotiz.setEnabled(false);
                        KleineTeilelistePanel.this.popupActionCopySachnummer.setEnabled(false);
                    }
                } else if (aSelTeile.size() == 1) {
                    KleineTeilelistePanel.this.popupActionBearbeiten.setEnabled(true);
                    KleineTeilelistePanel.this.popupActionCopySachnummer.setEnabled(true);
                }
            }
        }

        @Override
        public void clickedOnCell(GenericTableMouseEvent evt) {
            GenericTable table = (GenericTable)evt.getSource();
            Teil oTeil = null;
            int nCol = evt.getColumn();
            Vector aTeile = null;
            Teileliste oTl = KleineTeilelistePanel.this.mModel.getTLDaten();
            boolean bScoreLock = false;
            if (oTl instanceof Scoreliste) {
                Scoreliste oSl = (Scoreliste)oTl;
                ScorelisteJob job = (ScorelisteJob)KleineTeilelistePanel.this.mMapScoreJobToTable.get(table);
                ScorelisteSrp srp = (ScorelisteSrp)KleineTeilelistePanel.this.mMapScoreSrpToTable.get(table);
                aTeile = (Vector)oSl.getTeileOhneLoeschflag(job.getId(), srp.getId());
                boolean bl = bScoreLock = job.isLock() || srp.isLock();
                if (!bScoreLock && (oTeil = (Teil)aTeile.get(evt.getRow())).isScoreLock()) {
                    bScoreLock = true;
                }
                for (GenericTable otherTable : KleineTeilelistePanel.this.maScoreTeileTables) {
                    if (otherTable == table) continue;
                    otherTable.clearSelection();
                }
            } else {
                aTeile = oTl.getTeile();
            }
            oTeil = aTeile.get(evt.getRow());
            Vector<Teil> cSelTeile = null;
            if (!bScoreLock) {
                switch (nCol) {
                    case 0: {
                        if (KleineTeilelistePanel.this.mModel.istDMSAngeschlossen() && table.getSelectedRowCount() > 1) break;
                        cSelTeile = new Vector();
                        cSelTeile.add(oTeil);
                        KleineTeilelistePanel.this.handleEditTeile(cSelTeile);
                        break;
                    }
                    case 1: {
                        cSelTeile = new Vector<Teil>();
                        cSelTeile.add(oTeil);
                        Teileliste oTL = KleineTeilelistePanel.this.mModel.getTLDaten();
                        KleineTeilelistePanel.this.mController.deleteTeile(oTL.getID(), oTL.getNutzerID(), oTL.getFiliale(), cSelTeile);
                        KleineTeilelistePanel.this.update();
                        break;
                    }
                    case 2: {
                        if (KleineTeilelistePanel.this.mModel.istDMSAngeschlossen() && table.getSelectedRowCount() > 1) break;
                        cSelTeile = new Vector();
                        cSelTeile.add(oTeil);
                        KleineTeilelistePanel.this.handleShowTeilenotiz(oTeil);
                    }
                }
            }
        }
    }
}

