/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte.bedingungen;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class BTEBedingungenTabelleModel
extends AbstractTableModel {
    private static final long serialVersionUID = 309669252658785196L;
    private static Logger log = Logger.getLogger(BTEBedingungenTabelleModel.class);
    public static final int STATUS_JA = 1;
    public static final int STATUS_NEIN = 2;
    public static final int STATUS_UNBEKANNT = 3;
    private boolean mbBteAnzeige;
    private ArrayList<BedingungRow> rows = new ArrayList();
    private Object[] prototypes;
    private boolean[] resizeable;

    public BTEBedingungenTabelleModel(boolean bBteAnzeige) {
        this.mbBteAnzeige = bBteAnzeige;
        this.resizeable = this.mbBteAnzeige ? new boolean[]{false, false, false, true, true} : new boolean[]{true, true, false, false, false};
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BedingungRow row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (this.mbBteAnzeige) {
                    return row.getStatus();
                }
                return row.getCode();
            }
            case 1: {
                if (this.mbBteAnzeige) {
                    return row.getStatus();
                }
                return row.getBenennung();
            }
            case 2: {
                if (this.mbBteAnzeige) {
                    return row.getStatus();
                }
                return row.getStatus();
            }
            case 3: {
                if (this.mbBteAnzeige) {
                    return row.getCode();
                }
                return row.getStatus();
            }
            case 4: {
                if (this.mbBteAnzeige) {
                    return row.getBenennung();
                }
                return row.getStatus();
            }
        }
        throw new IllegalArgumentException("columnIndex " + columnIndex + " nicht in [1,..,5]");
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if (this.mbBteAnzeige) {
                    return this.getStatusName(1);
                }
                return Resource.getInstance().getCode();
            }
            case 1: {
                if (this.mbBteAnzeige) {
                    return this.getStatusName(2);
                }
                return Resource.getInstance().getBenennung();
            }
            case 2: {
                if (this.mbBteAnzeige) {
                    return this.getStatusName(3);
                }
                return this.getStatusName(1);
            }
            case 3: {
                if (this.mbBteAnzeige) {
                    return Resource.getInstance().getCode();
                }
                return this.getStatusName(2);
            }
            case 4: {
                if (this.mbBteAnzeige) {
                    return Resource.getInstance().getBenennung();
                }
                return this.getStatusName(3);
            }
        }
        return "";
    }

    public String getStatusName(int status) {
        switch (status) {
            case 1: {
                return Resource.getInstance().getJa();
            }
            case 2: {
                return Resource.getInstance().getNein();
            }
            case 3: {
                return Resource.getInstance().getFrage();
            }
        }
        throw new IllegalArgumentException("getStatusName must not be called with status " + status);
    }

    public int getStatusValue(String status) {
        if (status.equals(Resource.getInstance().getJa())) {
            return 1;
        }
        if (status.equals(Resource.getInstance().getNein())) {
            return 2;
        }
        if (status.equals(Resource.getInstance().getFrage())) {
            return 3;
        }
        throw new IllegalArgumentException("getStatusName must not be called with status " + status);
    }

    public void addBedingung(Long lBedId, String code, String benennung, int status) {
        this.rows.add(new BedingungRow(lBedId, code, benennung, status, null));
    }

    public void addBedingung(Long lBedId, String code, String benennung, int status, Color color) {
        this.rows.add(new BedingungRow(lBedId, code, benennung, status, color));
    }

    public Object[] getPrototypes() {
        if (this.prototypes == null && this.mbBteAnzeige) {
            this.prototypes = new Object[]{Resource.getInstance().getJa(), Resource.getInstance().getNein(), Resource.getInstance().getFrage(), "XXXXX", "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"};
        }
        if (this.prototypes == null && !this.mbBteAnzeige) {
            this.prototypes = new Object[]{"XXXXX", "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", Resource.getInstance().getJa(), Resource.getInstance().getNein(), Resource.getInstance().getFrage()};
        }
        return this.prototypes;
    }

    public void setPrototypes(Object[] prototypeStrings) {
        this.prototypes = prototypeStrings;
    }

    public boolean isColumnResizable(int columnIndex) {
        return this.resizeable[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public BedingungRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        log.debug((Object)("setValueAt rowIndex=" + rowIndex + " columnIndex=" + columnIndex + " aValue=" + aValue));
        if (this.mbBteAnzeige && columnIndex >= 0 && columnIndex <= 2 || !this.mbBteAnzeige && columnIndex >= 2 && columnIndex <= 4) {
            this.rows.get(rowIndex).setStatus((Integer)aValue);
        }
        if (this.mbBteAnzeige) {
            this.fireTableCellUpdated(rowIndex, 0);
            this.fireTableCellUpdated(rowIndex, 1);
            this.fireTableCellUpdated(rowIndex, 2);
        } else {
            this.fireTableCellUpdated(rowIndex, 2);
            this.fireTableCellUpdated(rowIndex, 3);
            this.fireTableCellUpdated(rowIndex, 4);
        }
    }

    public void removeAllRows() {
        this.rows = new ArrayList();
        this.fireTableDataChanged();
    }

    public ArrayList<BedingungRow> getAllRows() {
        return this.rows;
    }

    public static class BedingungRow {
        public static final int JA = 1;
        public static final int NEIN = 2;
        public static final int UNBEKANNT = 3;
        private Long lBedId;
        private String code;
        private String benennung;
        private Color rowColor = null;
        private int status = 3;

        public BedingungRow() {
            this.initRadioButtons();
        }

        public BedingungRow(Long lBedId, String code, String benennung, int status, Color color) {
            this.lBedId = lBedId;
            this.code = code;
            this.benennung = benennung;
            this.status = status;
            this.rowColor = color;
            this.initRadioButtons();
        }

        private void initRadioButtons() {
        }

        public boolean isJa() {
            return this.status == 1;
        }

        public boolean isNein() {
            return this.status == 2;
        }

        public boolean isUnbekannt() {
            return this.status == 3;
        }

        public Long getBedId() {
            return this.lBedId;
        }

        public String getBenennung() {
            return this.benennung;
        }

        public String getCode() {
            return this.code;
        }

        public int getStatus() {
            return this.status;
        }

        public void setBenennung(String benennung) {
            this.benennung = benennung;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public Color getRowColor() {
            return this.rowColor;
        }

        public void setRowColor(Color rowColor) {
            this.rowColor = rowColor;
        }
    }
}

