/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.btinfo;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.bteinfo.Info;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class Bildtafelinfo
extends JDialog {
    Logger log = Logger.getLogger(Bildtafelinfo.class);
    private String msBildtafelNr;
    private String msProduktart;
    private String msUeberschrift;
    private String msHinweise;
    protected Color textColor = new Color(14, 8, 104);

    public Bildtafelinfo(Frame owner, String sBildtafelNr, String sProduktart) {
        super(owner, true);
        this.msBildtafelNr = sBildtafelNr;
        this.msProduktart = sProduktart;
        this.setTitle(Resource.getInstance().getBildtafelinformation());
        this.loadBTInfo();
        this.initComponents();
    }

    void loadBTInfo() {
        this.log.debug((Object)"Performing Search Visualisierung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfDaten = new TrfHashMap(null);
        trfDaten.setValue("btnummer", this.msBildtafelNr);
        trfDaten.setValue("produktart", this.msProduktart);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfDaten, Command.LOAD_BT_INFO);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfDaten.getError() != null) {
            if (trfDaten.getError() instanceof NoDataFoundException) {
                this.log.error((Object)Resource.getInstance().getKeineDatenGefunden(), (Throwable)trfDaten.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getVisualisierungDesTeils(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfDaten.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfDaten.getError().getMessage(), Resource.getInstance().getVisualisierungDesTeils(), 0);
            return;
        }
        this.msUeberschrift = (String)trfDaten.getValue("ueberschrift");
        Info info = (Info)trfDaten.getValue("bte_info");
        this.msHinweise = "";
        if (info != null) {
            for (Hashtable hash : info.getHinweise()) {
                this.msHinweise = this.msHinweise + (String)hash.get("Text") + (hash.get("Zusatz") == null ? "" : " " + (String)hash.get("Zusatz")) + "\n";
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void initComponents() {
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getBildtafelinformation(), null);
        JTextArea txtHinweise = new JTextArea(this.msHinweise);
        txtHinweise.setAutoscrolls(true);
        txtHinweise.setEditable(false);
        txtHinweise.setLineWrap(true);
        txtHinweise.setWrapStyleWord(true);
        txtHinweise.setEnabled(true);
        txtHinweise.setFont(this.getFont());
        txtHinweise.setForeground(this.textColor);
        JPanel panel = new JPanel();
        int[] w_gesamt = new int[]{10, 0, 10, 0, 10};
        int[] h_gesamt = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout layoutGesamt = new HIGLayout(w_gesamt, h_gesamt);
        layoutGesamt.setColumnWeight(4, 1);
        layoutGesamt.setRowWeight(6, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(layoutGesamt);
        panel.add((Component)new JLabel(Resource.getInstance().getBildtafel()), c.rc(2, 2, "l"));
        panel.add((Component)this.createValue(this.msBildtafelNr), c.rc(2, 4, "l"));
        panel.add((Component)new JLabel(Resource.getInstance().getUeberschrift()), c.rc(4, 2, "l"));
        panel.add((Component)this.createValue(this.msUeberschrift), c.rc(4, 4, "l"));
        panel.add((Component)new JLabel(Resource.getInstance().getHinweiseEinschraenkungen()), c.rc(6, 2, "lt"));
        JScrollPane sc = new JScrollPane(txtHinweise);
        panel.add((Component)sc, c.rc(6, 4, "lrtb"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panHeader, "North");
        this.getContentPane().add((Component)panel, "Center");
        this.setSize(600, 300);
    }

    protected JLabel createValue(String s) {
        JLabel label = new JLabel(s);
        label.setForeground(this.textColor);
        return label;
    }
}

