/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.einstellungen;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.Markt;
import webetk.app.settings.EinstellungenBasis;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.MarktDaten;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenModel;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenView;
import webetk.javaclient.dialog.extras.einstellungen.Sprache;
import webetk.javaclient.dialog.hilfe.abkuerzungen.Abkuerzungen;
import webetk.javaclient.dialog.hilfe.polstercode.PolsterCode;
import webetk.javaclient.dialog.hilfe.sonderausstattung.Sonderausstattungen;
import webetk.javaclient.dialog.hilfe.tfattribute.TFAttribute;
import webetk.javaclient.dialog.hilfe.version.Version;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.workflow.WfFILoeschen;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgEinstellungenController
extends AbstractDialogViewController {
    private static Logger log = Logger.getLogger(DlgEinstellungenController.class);
    DlgEinstellungenView view = new DlgEinstellungenView();
    DlgEinstellungenModel model = new DlgEinstellungenModel();

    public DlgEinstellungenController(boolean bFirstLogin) {
        this.model.setFirstLogin(bFirstLogin);
    }

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.loadAuswahlListen();
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    private void loadAuswahlListen() {
        this.loadRegionen();
        this.loadLenkungen();
        this.loadSprachen();
    }

    private void loadSprachen() {
        log.debug((Object)"Performing Load Settings-Sprachen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSprachen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSprachen, Command.LOAD_SETTINGS_SPRACHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgEinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfSprachen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSprachen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSprachen.getError().getMessage(), Resource.getInstance().getEinstellungen(), 0);
            return;
        }
        List isoList = (List)trfSprachen.getValue("iso_list");
        List regisoList = (List)trfSprachen.getValue("regiso_list");
        List benennungList = (List)trfSprachen.getValue("benennung_list");
        ArrayList<Sprache> sprachen = new ArrayList<Sprache>();
        for (int i = 0; i < isoList.size(); ++i) {
            sprachen.add(new Sprache((String)isoList.get(i), (String)regisoList.get(i), (String)benennungList.get(i)));
        }
        this.model.storeSprachen(sprachen);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void loadRegionen() {
        log.debug((Object)"Performing Load Settings-Katalogausf\u00fchrungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfRegionen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfRegionen, Command.LOAD_SETTINGS_REGIONEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgEinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfRegionen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfRegionen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfRegionen.getError().getMessage(), Resource.getInstance().getEinstellungen(), 0);
            return;
        }
        this.model.storeRegionen((List)trfRegionen.getValue("region"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void loadLenkungen() {
        log.debug((Object)"Performing Settings-Lenkungen");
        HashMap<String, String> hashLenkungen = new HashMap<String, String>();
        hashLenkungen.put("1lenkung", "kA");
        hashLenkungen.put("1benennung", Resource.getInstance().getKeineEinschraenkung());
        hashLenkungen.put("2lenkung", "L");
        hashLenkungen.put("2benennung", Resource.getInstance().getLinkslenker());
        hashLenkungen.put("3lenkung", "R");
        hashLenkungen.put("3benennung", Resource.getInstance().getRechtslenker());
        this.model.storeLenkungen(hashLenkungen);
    }

    public boolean checkEinstellungen(EinstellungenBasis oEinstellungen) {
        log.debug((Object)"Performing Check Einstellungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfEinstellungen = new TrfHashMap(null);
        trfEinstellungen.setValue("einstellungen", oEinstellungen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinstellungen, Command.CHECK_SETTINGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgEinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (trfEinstellungen.getError() != null) {
            if (!(trfEinstellungen.getError() instanceof NoDataFoundException)) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfEinstellungen.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), trfEinstellungen.getError().getMessage(), Resource.getInstance().getEinstellungen(), 0);
            }
            return false;
        }
        return true;
    }

    public boolean saveEinstellungen(EinstellungenBasis oEinstellungen) {
        log.debug((Object)"Performing Save Einstellungen");
        boolean bSpracheChanged = false;
        if (this.model.getEinstellungen() != null) {
            String sSpracheOld = this.model.getEinstellungen().getSprache() + this.model.getEinstellungen().getSpracheRegion();
            String sSpracheNew = oEinstellungen.getSprache() + oEinstellungen.getSpracheRegion();
            if (sSpracheOld != null && !sSpracheOld.equals("") && !sSpracheOld.equals(sSpracheNew)) {
                bSpracheChanged = true;
            }
        }
        boolean bSuchraumChanged = false;
        if (this.model.getEinstellungen() != null) {
            String sSuchraumOld = this.model.getEinstellungen().getSuchraum();
            String sSuchraumNew = oEinstellungen.getSuchraum();
            if (sSuchraumOld != null && !sSuchraumOld.equals("") && !sSuchraumOld.equals(sSuchraumNew)) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFrageSuchraum(), Resource.getInstance().getEinstellungen(), 1);
                bSuchraumChanged = true;
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfEinstellungen = new TrfHashMap(null);
        trfEinstellungen.setValue("einstellungen", oEinstellungen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinstellungen, Command.SAVE_SETTINGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgEinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfEinstellungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfEinstellungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfEinstellungen.getError().getMessage(), Resource.getInstance().getEinstellungen(), 0);
            return false;
        }
        boolean bUseGrosseSchrift = oEinstellungen.getSchriftgroesse().equals("G");
        WebETKTheme.useGrosseSchriftart(bUseGrosseSchrift);
        int nDefaultResizingMode = oEinstellungen.getTabellenanzeige().equals("V") ? 1 : 2;
        GenericTable.setDefaultResizingMode(nDefaultResizingMode);
        String sISO = oEinstellungen.getSprache();
        String sRegISO = oEinstellungen.getSpracheRegion();
        sRegISO = sRegISO == null ? "" : sRegISO;
        String sSprache = sISO + sRegISO;
        Resource.setLanguage(sSprache.trim());
        WebETKTheme.changeFont(sSprache.substring(0, 2));
        GlobalObjects.getInstance().getSessionInfo().setEinstellungenDisharmonie(false);
        oEinstellungen.markLoaded();
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        oLoginInfo.setSettings(oEinstellungen);
        if (bSpracheChanged) {
            Markt prioMarkt = oEinstellungen.getEtkPrimaerMarkt();
            MarktDaten marktDaten = this.model.getMarktDaten();
            marktDaten.loadMaerkteandFillListen();
            Collection<Markt> auswahlMaerkte = marktDaten.getAuswahlPrimaerMarkt();
            for (Markt auswahlMarkt : auswahlMaerkte) {
                if (auswahlMarkt.getMarktId() != prioMarkt.getMarktId()) continue;
                prioMarkt.setName(auswahlMarkt.getName());
                break;
            }
        }
        GlobalObjects.getInstance().getEtkData().setMainViewTitle();
        if (bSuchraumChanged) {
            WfFILoeschen.resetFahrzeugidentifikation();
        }
        if (bSpracheChanged || bSuchraumChanged) {
            Abkuerzungen.resetInstance();
            PolsterCode.resetInstance();
            Sonderausstattungen.resetInstance();
            TFAttribute.resetInstance();
            Version.resetInstance();
        }
        WebETKTheme.changeFont(sISO);
        MainView.getInstance().initMenus();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public static void setEinstellungenInServerSessionInfo(EinstellungenBasis oEinstellungen) {
        TrfHashMap trfEinstellungen = new TrfHashMap(null);
        trfEinstellungen.setValue("einstellungen", oEinstellungen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinstellungen, Command.SET_SETTINGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            return;
        }
        if (trfEinstellungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfEinstellungen.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), trfEinstellungen.getError().getMessage(), Resource.getInstance().getEinstellungen(), 0);
        }
    }

    public boolean isUSETK() {
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (oLoginInfo == null) {
            return false;
        }
        return oLoginInfo.isUsETK();
    }
}

