/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.einstellungen;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import webetk.app.settings.EinstellungenBasis;
import webetk.communication.LoginInfo;
import webetk.javaclient.MarktDaten;
import webetk.javaclient.dialog.extras.einstellungen.Sprache;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgEinstellungenModel
extends AbstractDialogModel {
    private EinstellungenBasis moEinstellungen = null;
    private List<Sprache> mSprachen;
    private List<String> moRegionen = null;
    private HashMap<String, String> moLenkungen = null;
    private boolean mbFirstLogin = false;
    private MarktDaten mMarktDaten = null;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        this.storeEinstellungen(oLoginInfo.getSettings());
    }

    private void storeEinstellungenToMarktdaten() {
        this.mMarktDaten = new MarktDaten();
        this.mMarktDaten.setSelPrimaerMarkt(this.moEinstellungen.getEtkPrimaerMarkt());
        this.mMarktDaten.setSelSonstigeMaerkte(this.moEinstellungen.getEtkSonstigeMaerkte());
        this.mMarktDaten.loadMaerkteandFillListen();
    }

    protected EinstellungenBasis getEinstellungen() {
        return this.moEinstellungen;
    }

    protected void storeEinstellungen(EinstellungenBasis oEinstellungen) {
        this.moEinstellungen = new EinstellungenBasis(oEinstellungen);
        this.storeEinstellungenToMarktdaten();
    }

    protected List<Sprache> getSprachen() {
        return this.mSprachen;
    }

    protected void storeSprachen(List<Sprache> pSprachen) {
        this.mSprachen = pSprachen;
    }

    public int getIndexSelSprache(String pSprache) {
        if (this.mSprachen == null || this.mSprachen.isEmpty() || pSprache == null) {
            return -1;
        }
        for (int i = 0; i < this.mSprachen.size(); ++i) {
            String iso = this.mSprachen.get(i).getIso();
            String regIso = this.mSprachen.get(i).getRegIso();
            if (!(iso = iso + regIso).equals(pSprache)) continue;
            return i;
        }
        return -1;
    }

    protected Vector<String> getRegionenVector(boolean bMitAlle) {
        Vector<String> aRegionen = new Vector<String>();
        if (this.moRegionen == null) {
            return aRegionen;
        }
        if (bMitAlle) {
            aRegionen.add(Resource.getInstance().getAlle());
        }
        aRegionen.addAll(this.moRegionen);
        return aRegionen;
    }

    protected int[] getSelRegionenIndizes() {
        if (this.moEinstellungen == null || this.moRegionen == null) {
            return null;
        }
        Vector<String> aSelRegionen = this.moEinstellungen.getRegionen();
        Iterator iterator = aSelRegionen.iterator();
        int[] aSelIndizes = new int[aSelRegionen.size()];
        int i = 0;
        block0: while (iterator.hasNext()) {
            String sRegion = (String)iterator.next();
            for (int j = 0; j < this.moRegionen.size(); ++j) {
                String sRegionComp = this.moRegionen.get(j);
                if (!sRegionComp.equals(sRegion)) continue;
                aSelIndizes[i++] = j + 1;
                continue block0;
            }
        }
        return aSelIndizes;
    }

    protected void storeRegionen(List<String> oRegionen) {
        this.moRegionen = oRegionen;
    }

    protected HashMap<String, String> getLenkungen() {
        return this.moLenkungen;
    }

    protected void storeLenkungen(HashMap<String, String> oLenkungen) {
        this.moLenkungen = oLenkungen;
    }

    public int getIndexSelLenkung(String sLenkung) {
        if (this.moLenkungen == null || sLenkung == null) {
            return -1;
        }
        int i = 1;
        String sLenkungComp;
        while ((sLenkungComp = this.moLenkungen.get(i + "lenkung")) != null) {
            if (sLenkungComp.equals(sLenkung)) {
                return i - 1;
            }
            ++i;
        }
        return -1;
    }

    public Collection<String> getUserMarken() {
        return GlobalObjects.getInstance().getSessionInfo().getUserMarken();
    }

    public Collection<String> getUserProdukte() {
        return GlobalObjects.getInstance().getSessionInfo().getUserProdukte();
    }

    public String getUserKatalogumfang() {
        return GlobalObjects.getInstance().getSessionInfo().getUserKatUmfang();
    }

    public boolean enableKatalogumfangChoice() {
        return GlobalObjects.getInstance().getSessionInfo().displayRadioKatUmfang();
    }

    public boolean hatRechtAnzeigeProduktionsdatum() {
        return GlobalObjects.getInstance().getSessionInfo().hasRechtAnzeigeProddatum();
    }

    public boolean hatRechtAnzeigePreise() {
        return GlobalObjects.getInstance().getSessionInfo().hatRecht("R_WEBETK_PREISE_ANZEIGEN");
    }

    public boolean isFirstLogin() {
        return this.mbFirstLogin;
    }

    public void setFirstLogin(boolean b) {
        this.mbFirstLogin = b;
    }

    public boolean showSuchraumAuswahl() {
        boolean bHatRechtZentraleSuche = GlobalObjects.getInstance().getSessionInfo().hatRecht("R_WEBETK_RECHERCHE");
        boolean bHatNetz = GlobalObjects.getInstance().hasNetz();
        return bHatNetz && bHatRechtZentraleSuche;
    }

    public MarktDaten getMarktDaten() {
        return this.mMarktDaten;
    }
}

