/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.login;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.extras.login.DlgLoginController;
import de.esg.commonclient.dialog.extras.login.DlgLoginModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class DlgLoginView
extends AbstractDialogView {
    private static final long serialVersionUID = -514670255028403732L;
    private static Logger log = Logger.getLogger(DlgLoginView.class);
    private DlgLoginModel model = null;
    private DlgLoginController controller = null;
    private JPanel headerPanel;
    private JPanel contentPanel;
    private JPanel entryPane = new JPanel();
    private JLabel labelFiliale = new JLabel();
    private JLabel labelUsername = new JLabel();
    private JTextField textUsername = new JTextField(20);
    private JLabel labelPwd = new JLabel();
    private JPasswordField textPassword = new JPasswordField(20);
    private JTextField textFiliale = new JTextField(20);
    private JButtonEx buttonFiliale = new JButtonEx();
    private JButtonEx buttonLogin = new JButtonEx();
    private String msNutzer = null;

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgContoller) {
        log.debug((Object)"init");
        this.model = (DlgLoginModel)oDlgModel;
        this.controller = (DlgLoginController)oDlgContoller;
        this.controller.loadFilialen(GlobalObjects.getInstance().getFirmaId());
        log.debug((Object)"Init components");
        this.initComponents();
        try {
            log.debug((Object)"Constructing menues");
            this.constructMenus(this.controller);
            this.setupListeners();
        }
        catch (ClassCastException e) {
            log.error((Object)"Illegal initialization!", (Throwable)e);
            throw new IllegalComponentStateException("View called with wrong controller!");
        }
        if (GlobalObjects.getInstance().getIstStandalone() && this.controller.existiertEineFirmaFilialeNutzer() || this.model.getUserId() != null) {
            if (this.model.getUserId() != null) {
                this.textUsername.setText(this.model.getUserId());
            } else {
                this.textUsername.setText("admin");
            }
            this.loadFilialePasswort();
            this.textPassword.setText(this.model.getPasswort());
            this.buttonLogin.doClick(10);
        }
        this.textUsername.requestFocus();
    }

    @Override
    public void update() throws IllegalStateException {
    }

    protected void constructMenus(DlgLoginController oController) {
    }

    protected void setupListeners() {
        this.textPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLoginView.this.doLogin();
            }
        });
        this.buttonLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgLoginView.this.doLogin();
            }
        });
        this.buttonFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bNutzerDarfFilialeAendern = DlgLoginView.this.controller.doLoginFilialeAendern(DlgLoginView.this.textUsername.getText());
                if (bNutzerDarfFilialeAendern) {
                    DlgLoginView.this.textFiliale.setText(DlgLoginView.this.model.getFilialeBezeichnung());
                    DlgLoginView.this.buttonLogin.requestFocus();
                }
            }
        });
        this.textUsername.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DlgLoginView.this.msNutzer = DlgLoginView.this.textUsername.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DlgLoginView.this.textUsername.getText().equals("score")) {
                    String sMeldung = Resource.getInstance().getLoginScoreNotAllowed();
                    JOptionPane.showMessageDialog(MainView.getInstance(), sMeldung, Resource.getInstance().getLogin(), 1);
                    DlgLoginView.this.textUsername.setText("");
                    DlgLoginView.this.textUsername.requestFocus();
                    return;
                }
                DlgLoginView.this.loadFilialePasswort();
            }
        });
        this.textFiliale.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DlgLoginView.this.buttonLogin.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.headerPanel = new HeaderPanel(Resource.getInstance().getAnmeldung(), "", ImageCache.getInstance().getHeaderIcon("login"));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout(UIHelper.getHorizonzalBorderGap(), UIHelper.getVerticalBorderGap()));
        this.labelFiliale.setText(Resource.getInstance().getAnmeldenAnFiliale() + ":");
        this.textFiliale.setPreferredSize(new Dimension(250, 21));
        this.textFiliale.setEditable(false);
        this.labelUsername.setText(Resource.getInstance().getNutzerId() + ":");
        this.textUsername.setPreferredSize(new Dimension(250, 21));
        EnhancedTextDocument ehDocUser = new EnhancedTextDocument(20, 0);
        this.textUsername.setDocument(ehDocUser);
        this.labelPwd.setText(Resource.getInstance().getPasswort() + ":");
        this.textPassword.setPreferredSize(new Dimension(250, 21));
        EnhancedTextDocument ehDocPasswort = new EnhancedTextDocument(20, 0);
        this.textPassword.setDocument(ehDocPasswort);
        this.buttonFiliale.setText(Resource.getInstance().getAndereFiliale() + "...");
        this.buttonLogin.setText(Resource.getInstance().getLogin());
        this.buttonFiliale.setEnabled(false);
        int nAnzahlFilialen = this.model.getAnzahlFilialen();
        if (nAnzahlFilialen <= 1) {
            this.buttonFiliale.setVisible(false);
        }
        this.createLayout();
    }

    private void createLayout() {
        int[] w = new int[]{20, 0, 5, 0, 5, 0, 20};
        int[] h = new int[]{30, 0, 5, 0, 5, 0, 8, 0, 30};
        HIGLayout entryLayout = new HIGLayout(w, h);
        entryLayout.setColumnWeight(1, 1);
        entryLayout.setColumnWeight(7, 1);
        entryLayout.setRowWeight(1, 1);
        entryLayout.setRowWeight(9, 1);
        this.entryPane.setLayout(entryLayout);
        HIGConstraints hc = new HIGConstraints();
        this.entryPane.add((Component)this.labelUsername, hc.rc(2, 2, "r"));
        this.entryPane.add((Component)this.textUsername, hc.rc(2, 4, "l"));
        this.entryPane.add((Component)this.labelPwd, hc.rc(4, 2, "r"));
        this.entryPane.add((Component)this.textPassword, hc.rc(4, 4, "l"));
        this.entryPane.add((Component)this.labelFiliale, hc.rc(6, 2, "r"));
        this.entryPane.add((Component)this.textFiliale, hc.rc(6, 4, "l"));
        this.entryPane.add((Component)this.buttonFiliale, hc.rc(6, 6, "l"));
        this.entryPane.add((Component)this.buttonLogin, hc.rc(8, 4, "tl"));
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.contentPanel.add((Component)this.entryPane, "Center");
    }

    private boolean existiertNutzerId(String sFirmaId, String sNutzerId) {
        return this.controller.existiertNutzerId(sFirmaId, sNutzerId);
    }

    private void loadDefaultFilialePasswort(String sFirmaId, String sNutzerId) {
        this.controller.loadDefaultFilialePasswort(sFirmaId, sNutzerId);
    }

    private void loadFilialePasswort() {
        String sFirmaId = GlobalObjects.getInstance().getFirmaId();
        String sNutzerId = this.textUsername.getText();
        if (!this.textUsername.getText().equals(this.msNutzer) && sNutzerId.trim().length() != 0) {
            if (this.existiertNutzerId(sFirmaId, sNutzerId)) {
                this.loadDefaultFilialePasswort(sFirmaId, sNutzerId);
                this.textFiliale.setText(this.model.getFilialeBezeichnung());
                this.textUsername.setText(this.model.getUserId());
                this.textPassword.requestFocus();
                this.buttonFiliale.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNutzerNichtVorhanden(), Resource.getInstance().getAnmeldung(), 1);
                this.textFiliale.setText("");
                this.textUsername.setText("");
                this.textUsername.requestFocus();
                this.buttonFiliale.setEnabled(false);
            }
        }
    }

    private boolean checkEingaben() {
        String sUserId = this.textUsername.getText();
        String sPassword = new String(this.textPassword.getPassword());
        if (sUserId == null || sUserId.length() == 0) {
            log.debug((Object)"No username entered.");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNutzernameAngeben(), Resource.getInstance().getInformation(), 1);
            this.textUsername.requestFocus();
            return false;
        }
        if (sPassword == null || sPassword.length() == 0) {
            log.debug((Object)"No password entered.");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getPasswortAngeben(), Resource.getInstance().getInformation(), 1);
            this.textPassword.requestFocus();
            return false;
        }
        if (!sPassword.toUpperCase().equals(this.model.getPasswort().toUpperCase())) {
            log.debug((Object)"Wrong password entered.");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getPasswortNichtKorrekt(), Resource.getInstance().getInformation(), 1);
            this.textPassword.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void setFocus() {
        this.textUsername.requestFocus();
    }

    public void doLogin() {
        if (!this.checkEingaben()) {
            return;
        }
        String sFirmaId = GlobalObjects.getInstance().getFirmaId();
        String sFilialId = this.model.getFiliale();
        String sUserId = this.textUsername.getText();
        this.controller.performLogin(sFirmaId, sFilialId, sUserId, this.model.getPasswort());
    }
}

