/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.proxy;

import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedPasswordField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.proxy.DlgProxyController;
import webetk.javaclient.dialog.extras.proxy.DlgProxyModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.resources.Resource;

public class DlgProxyView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgProxyView.class);
    private DlgProxyController controller;
    private DlgProxyModel model;
    private JPanel headerPanel = new HeaderPanel(Resource.getInstance().getProxy(), ImageCache.getInstance().getHeaderIcon("einstell"));
    private JPanel mainPanel;
    private JCheckBox chkbxProxyserverVerwenden;
    private JLabel lblNameOderIp;
    private LimitedTextField fldNameOderIP;
    private JLabel lblPort;
    private JTextField fldPort;
    private JPanel authPanel;
    private JCheckBox chkbxAuthentifizierung;
    private JLabel lblNutzername;
    private JTextField fldNutzerName;
    private JLabel lblPasswort;
    private LimitedPasswordField fldPassword;
    private JLabel lblRealminfo;
    private JTextField fldRealmInfo;
    private JButtonEx buttonSpeichern;
    private JButtonEx buttonAbbrechen;
    private JPanel buttonPanel;

    public DlgProxyView() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.mainPanel = new TitledPanel("");
        this.add((Component)this.mainPanel, "Center");
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        gbl_mainPanel.columnWidths = new int[]{0, 260, 50, 0};
        gbl_mainPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_mainPanel.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gbl_mainPanel);
        this.chkbxProxyserverVerwenden = new JCheckBox(Resource.getInstance().getProxyserverVerwenden());
        GridBagConstraints gbc_chckbxProxyserverVerwenden = new GridBagConstraints();
        gbc_chckbxProxyserverVerwenden.anchor = 17;
        gbc_chckbxProxyserverVerwenden.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxProxyserverVerwenden.gridx = 0;
        gbc_chckbxProxyserverVerwenden.gridy = 0;
        this.mainPanel.add((Component)this.chkbxProxyserverVerwenden, gbc_chckbxProxyserverVerwenden);
        this.lblNameOderIp = new JLabel(Resource.getInstance().getNameOderIpAdresse());
        GridBagConstraints gbc_lblNameOderIp = new GridBagConstraints();
        gbc_lblNameOderIp.insets = new Insets(0, 0, 5, 5);
        gbc_lblNameOderIp.anchor = 17;
        gbc_lblNameOderIp.gridx = 0;
        gbc_lblNameOderIp.gridy = 1;
        this.mainPanel.add((Component)this.lblNameOderIp, gbc_lblNameOderIp);
        this.fldNameOderIP = new LimitedTextField(64, 54);
        GridBagConstraints gbc_fldNameOderIP = new GridBagConstraints();
        gbc_fldNameOderIP.fill = 1;
        gbc_fldNameOderIP.insets = new Insets(0, 0, 5, 5);
        gbc_fldNameOderIP.gridx = 1;
        gbc_fldNameOderIP.gridy = 1;
        this.mainPanel.add((Component)this.fldNameOderIP, gbc_fldNameOderIP);
        this.fldNameOderIP.setColumns(10);
        this.lblPort = new JLabel(Resource.getInstance().getPort());
        GridBagConstraints gbc_lblPort = new GridBagConstraints();
        gbc_lblPort.anchor = 17;
        gbc_lblPort.insets = new Insets(0, 0, 5, 5);
        gbc_lblPort.gridx = 0;
        gbc_lblPort.gridy = 2;
        this.mainPanel.add((Component)this.lblPort, gbc_lblPort);
        this.fldPort = new JTextField();
        GridBagConstraints gbc_fldPort = new GridBagConstraints();
        gbc_fldPort.fill = 1;
        gbc_fldPort.insets = new Insets(0, 0, 5, 200);
        gbc_fldPort.gridx = 1;
        gbc_fldPort.gridy = 2;
        this.mainPanel.add((Component)this.fldPort, gbc_fldPort);
        this.fldPort.setColumns(10);
        this.authPanel = new TitledPanel("");
        GridBagConstraints gbc_authPanel = new GridBagConstraints();
        gbc_authPanel.insets = new Insets(0, 0, 5, 0);
        gbc_authPanel.gridwidth = 3;
        gbc_authPanel.fill = 1;
        gbc_authPanel.gridx = 0;
        gbc_authPanel.gridy = 3;
        this.mainPanel.add((Component)this.authPanel, gbc_authPanel);
        GridBagLayout gbl_authPanel = new GridBagLayout();
        gbl_authPanel.columnWidths = new int[]{0, 260, 229, 0};
        gbl_authPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gbl_authPanel.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_authPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.authPanel.setLayout(gbl_authPanel);
        this.chkbxAuthentifizierung = new JCheckBox(Resource.getInstance().getAuthentifizierung());
        GridBagConstraints gbc_chckbxAuthentifizierung = new GridBagConstraints();
        gbc_chckbxAuthentifizierung.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxAuthentifizierung.gridx = 0;
        gbc_chckbxAuthentifizierung.gridy = 0;
        this.authPanel.add((Component)this.chkbxAuthentifizierung, gbc_chckbxAuthentifizierung);
        this.lblNutzername = new JLabel(Resource.getInstance().getNutzername());
        GridBagConstraints gbc_lblNutzername = new GridBagConstraints();
        gbc_lblNutzername.anchor = 17;
        gbc_lblNutzername.insets = new Insets(0, 0, 5, 5);
        gbc_lblNutzername.gridx = 0;
        gbc_lblNutzername.gridy = 1;
        this.authPanel.add((Component)this.lblNutzername, gbc_lblNutzername);
        this.fldNutzerName = new JTextField();
        GridBagConstraints gbc_fldUserName = new GridBagConstraints();
        gbc_fldUserName.insets = new Insets(0, 0, 5, 5);
        gbc_fldUserName.fill = 1;
        gbc_fldUserName.gridx = 1;
        gbc_fldUserName.gridy = 1;
        this.authPanel.add((Component)this.fldNutzerName, gbc_fldUserName);
        this.fldNutzerName.setColumns(10);
        this.lblPasswort = new JLabel(Resource.getInstance().getPasswort());
        GridBagConstraints gbc_lblPasswort = new GridBagConstraints();
        gbc_lblPasswort.anchor = 17;
        gbc_lblPasswort.insets = new Insets(0, 0, 5, 5);
        gbc_lblPasswort.gridx = 0;
        gbc_lblPasswort.gridy = 2;
        this.authPanel.add((Component)this.lblPasswort, gbc_lblPasswort);
        this.fldPassword = new LimitedPasswordField(64, 20.0);
        GridBagConstraints gbc_fldUserPassword = new GridBagConstraints();
        gbc_fldUserPassword.insets = new Insets(0, 0, 5, 5);
        gbc_fldUserPassword.fill = 1;
        gbc_fldUserPassword.gridx = 1;
        gbc_fldUserPassword.gridy = 2;
        this.authPanel.add((Component)this.fldPassword, gbc_fldUserPassword);
        this.fldPassword.setColumns(10);
        this.lblRealminfo = new JLabel("Realm-Info:");
        GridBagConstraints gbc_lblRealminfo = new GridBagConstraints();
        gbc_lblRealminfo.anchor = 17;
        gbc_lblRealminfo.insets = new Insets(0, 0, 5, 5);
        gbc_lblRealminfo.gridx = 0;
        gbc_lblRealminfo.gridy = 3;
        this.authPanel.add((Component)this.lblRealminfo, gbc_lblRealminfo);
        this.fldRealmInfo = new JTextField();
        GridBagConstraints gbc_fldRealmInfo = new GridBagConstraints();
        gbc_fldRealmInfo.insets = new Insets(0, 0, 5, 5);
        gbc_fldRealmInfo.fill = 1;
        gbc_fldRealmInfo.gridx = 1;
        gbc_fldRealmInfo.gridy = 3;
        this.authPanel.add((Component)this.fldRealmInfo, gbc_fldRealmInfo);
        this.fldRealmInfo.setColumns(10);
        this.buttonPanel = new JPanel();
        GridBagConstraints gbc_buttonPanel = new GridBagConstraints();
        gbc_buttonPanel.gridwidth = 3;
        gbc_buttonPanel.insets = new Insets(0, 0, 0, 5);
        gbc_buttonPanel.fill = 2;
        gbc_buttonPanel.gridx = 0;
        gbc_buttonPanel.gridy = 4;
        this.mainPanel.add((Component)this.buttonPanel, gbc_buttonPanel);
        this.buttonSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonPanel.add(this.buttonSpeichern);
        this.buttonPanel.add(this.buttonAbbrechen);
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"*** init DlgProxyView");
        this.model = (DlgProxyModel)oDlgModel;
        this.controller = (DlgProxyController)oController;
        this.controller.loadProxySettings();
        if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
            JOptionPane.showMessageDialog(MainView.getInstance(), "<html>" + this.model.getDEBUGPropertyFileKommtVon() + "</html>", "*** DEBUG STATEMENT lesen-001 (getDEBUGPropertyFileKommtVon) ***", 1);
            JOptionPane.showMessageDialog(MainView.getInstance(), "<html>" + this.model.getDEBUGPropertyFile() + "</html>", "*** DEBUG STATEMENT lesen-002 (getDEBUGPropertyFile) ***", 1);
            JOptionPane.showMessageDialog(MainView.getInstance(), "<html>" + this.model.getDEBUGPropertyPath() + "</html>", "*** DEBUG STATEMENT lesen-003 (getDEBUGPropertyPath) ***", 1);
        }
        this.chkbxProxyserverVerwenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isVerwenden = DlgProxyView.this.chkbxProxyserverVerwenden.isSelected();
                DlgProxyView.this.model.setProxyServerVerwenden(isVerwenden);
                DlgProxyView.this.setModel();
                DlgProxyView.this.update();
            }
        });
        this.chkbxAuthentifizierung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgProxyView.this.model.setProxyServerAuth(DlgProxyView.this.chkbxAuthentifizierung.isSelected());
                DlgProxyView.this.setModel();
                DlgProxyView.this.update();
            }
        });
        this.buttonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgProxyView.this.setModel();
                DlgProxyView.this.controller.updateProxySettings();
                if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), "<html>" + DlgProxyView.this.model.getDEBUGPropertyFileUpdateIn() + "</html>", "*** DEBUG STATEMENT update-001 (getDEBUGPropertyFileUpdateIn) ***", 1);
                    JOptionPane.showMessageDialog(MainView.getInstance(), "<html>" + DlgProxyView.this.model.getDEBUGPropertyFile() + "</html>", "*** DEBUG STATEMENT update-002 (getDEBUGPropertyFile) ***", 1);
                    JOptionPane.showMessageDialog(MainView.getInstance(), "<html>" + DlgProxyView.this.model.getDEBUGPropertyPath() + "</html>", "*** DEBUG STATEMENT update-003 (getDEBUGPropertyPath) ***", 1);
                }
                DlgProxyView.this.update();
            }
        });
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgProxyView.this.controller.notifyAllExitListeners();
                MainWorkflowsteuerung.getInstance().displayDefaultDialog();
                MainView.getInstance().initMenus();
            }
        });
        this.update();
    }

    @Override
    public void initMenus() {
        log.debug((Object)"initMenus");
    }

    public void setModel() {
        this.model.setProxyHost(this.fldNameOderIP.getText());
        this.model.setProxyPort(this.fldPort.getText());
        this.model.setPassword(String.valueOf(this.fldPassword.getPassword()));
        this.model.setUserName(this.fldNutzerName.getText());
        this.model.setProxyServerAuth(this.chkbxAuthentifizierung.isSelected());
        this.model.setProxyServerVerwenden(this.chkbxProxyserverVerwenden.isSelected());
    }

    @Override
    public void update() throws IllegalStateException {
        log.debug((Object)"update");
        boolean isVerwenden = this.model.isProxyServerVerwenden();
        if (!isVerwenden) {
            this.model.setProxyServerAuth(false);
            this.chkbxAuthentifizierung.setSelected(false);
            this.chkbxAuthentifizierung.setEnabled(false);
        } else {
            this.chkbxAuthentifizierung.setEnabled(true);
        }
        boolean isAuth = this.model.isProxyServerAuth();
        this.fldNameOderIP.setText(this.model.getProxyHost());
        this.fldPort.setText(this.model.getProxyPort());
        this.fldNutzerName.setText(this.model.getUserName());
        this.fldPassword.setText(this.model.getPassword());
        this.chkbxProxyserverVerwenden.setSelected(isVerwenden);
        this.lblNameOderIp.setEnabled(isVerwenden);
        this.fldNameOderIP.setEnabled(isVerwenden);
        this.lblPort.setEnabled(isVerwenden);
        this.fldPort.setEnabled(isVerwenden);
        this.lblRealminfo.setEnabled(isAuth);
        this.fldRealmInfo.setEnabled(isAuth);
        this.lblNutzername.setEnabled(isAuth);
        this.fldNutzerName.setEnabled(isAuth);
        this.lblPasswort.setEnabled(isAuth);
        this.fldPassword.setEnabled(isAuth);
    }
}

