/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileinfo;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.NoDataFoundException;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.teileliste.Teil;
import webetk.communication.CommunicationException;
import webetk.communication.JavaSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoKleinController;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoView;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.TVNachTeilenController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class DlgTeileinfoController
extends DlgTeileinfoKleinController {
    private static Logger log = Logger.getLogger(DlgTeileinfoController.class);
    private DlgTeileinfoView view = new DlgTeileinfoView();

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.model.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        this.model.setFilialinfoAnzeigen(this.ermittleFilialinfoAnzeigen());
        this.loadTeileinfo(null, null, null);
        this.view.init(this.model, this);
    }

    @Override
    public DialogView getDialogView() {
        return this.view;
    }

    public void handleSuchen(String sHgUg, String sSachnummer, boolean bLokalteil, JComponent cTextfield) {
        if (!bLokalteil) {
            if (sHgUg.length() != 0 && sHgUg.length() != 4 || sSachnummer.length() != 7) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeileinfoNoSearchSachnr(), Resource.getInstance().getTeileinformation(), 0);
                return;
            }
            this.model.setLokalteil(bLokalteil);
            this.suche(sHgUg, sSachnummer, null, cTextfield);
        } else {
            this.model.setLokalteil(bLokalteil);
            this.suche(sHgUg, sSachnummer, cTextfield);
        }
        if (this.view.getAktuellerReiterIstFilialinfo()) {
            this.loadFilialinfo();
        }
        this.view.update();
    }

    public void handleSuchenFremdeTnr(String sFremdeTnr, JComponent cTextfield) {
        if (sFremdeTnr.length() < 1) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeileinfoNoSearchFremdetnr(), Resource.getInstance().getTeileinformation(), 0);
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int ii = 0; ii < sFremdeTnr.length(); ++ii) {
            if (!Character.isLetterOrDigit(sFremdeTnr.charAt(ii))) continue;
            buf.append(sFremdeTnr.charAt(ii));
        }
        String sFremdeTnrBereinigt = buf.toString();
        this.model.setLokalteil(false);
        this.suche(null, null, sFremdeTnrBereinigt, cTextfield);
        if (this.view.getAktuellerReiterIstFilialinfo()) {
            this.loadFilialinfo();
        }
        this.view.update();
    }

    public void handleTeileverwendung() {
        Teileinfo oTi = this.model.getTeileinfo();
        if (oTi == null) {
            return;
        }
        String sSachnummer = oTi.getSachnummer();
        Vector<String> aMarke = oTi.getMarken();
        String sMarkeVorgabe = GlobalObjects.getInstance().getSessionInfo().getMarke();
        String sMarke = GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeVorgabe);
        if (sMarke == null) {
            JOptionPane.showMessageDialog(MainView.getInstance(), "es konnte keine Marke ermittelt werden. Die Funktion wird nicht ausgef\u00fchrt", Resource.getInstance().getTeileinformation(), 0);
            return;
        }
        String sProduktart = oTi.getProduktart();
        if (sProduktart.equals(Produkte.getInstance().getProdukt("ALLE").getDbValue())) {
            sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        }
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
        WorkflowStateData oWsd = new WorkflowStateData();
        oWsd.setWert("sachnummer", sSachnummer);
        oWsd.setWert("marke", sMarke);
        oWsd.setWert("produktart", sProduktart);
        oWsd.setWert("katalogumfang", sKatalogumfang);
        MainView.getInstance().showDlg(TVNachTeilenController.class, oWsd);
    }

    public void handleStammsatz() {
        JavaSucheInfo oJavaSucheInfo;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        Teil oTeil = this.model.getKommerzielleInfo();
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teil", oTeil);
        Vector<String> aMarken = oTeil.getMarken();
        String sMarke = null;
        sMarke = aMarken.size() > 1 ? ((oJavaSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo()) != null ? oJavaSucheInfo.getMarke() : Marken.getInstance().getMarke("BMW").getBerechtigung()) : (String)aMarken.toArray()[0];
        if (sMarke == null) {
            JOptionPane.showMessageDialog(MainView.getInstance(), "es konnte keine Marke ermittelt werden. Die Funktion wird nicht ausgef\u00fchrt", Resource.getInstance().getTeileinformation(), 0);
            return;
        }
        trfTL.setValue("marke", sMarke);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_STAMMSATZ);
        }
        catch (CommunicationException e) {
            log.error((Object)("DlgTeileinfoController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        Integer nStatus = (Integer)trfTL.getValue("returncode");
        DmsUtils.showMsgTxt((String)trfTL.getValue("msgtxt"), nStatus, Resource.getInstance().getErfolgStammsatzanlage());
        if (trfTL.getError() != null) {
            String sMsg = null;
            if (trfTL.getError() instanceof NoDataFoundException) {
                if (trfTL.getError().getMessage().equals("Produktklasse")) {
                    sMsg = Resource.getInstance().getFehlerProduktklasse() + " " + Resource.getInstance().getStammsatzanlageNichtMoeglich();
                } else if (trfTL.getError().getMessage().equals("Teileart")) {
                    sMsg = Resource.getInstance().getFehlerTeileart() + " " + Resource.getInstance().getStammsatzanlageNichtMoeglich();
                } else if (trfTL.getError().getMessage().equals("RabattSchluessel")) {
                    sMsg = Resource.getInstance().getFehlerRabattschluesselTeil() + " " + Resource.getInstance().getStammsatzanlageNichtMoeglich();
                }
            } else if (!(trfTL.getError() instanceof DMSException)) {
                sMsg = Resource.getInstance().getFehlerStammsatz() + ": " + trfTL.getError().getMessage();
            }
            log.error(sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (sMsg != null) {
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileinfo(), 0);
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

