/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileinfo;

import de.esg.commonclient.GlobalObjects;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.NoDataFoundException;
import webetk.app.SearchBTETeile;
import webetk.app.teileinfo.Notiz;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teil;
import webetk.communication.CommunicationException;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfString;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoKlein;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoModel;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;
import webetk.xmlapi.XmlCommunicationException;

public class DlgTeileinfoKleinController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(DlgTeileinfoKleinController.class);
    private DlgTeileinfoKlein dlg;
    protected DlgTeileinfoModel model;

    public DlgTeileinfoKleinController() {
        this.model = new DlgTeileinfoModel();
        super.init(this.model);
    }

    public DlgTeileinfoKleinController(Frame oOwner, String sSachnummer) {
        ArrayList<String> aSachnummern = new ArrayList<String>();
        aSachnummern.add(sSachnummer);
        this.init(oOwner, aSachnummern);
    }

    public DlgTeileinfoKleinController(Frame oOwner, ArrayList<String> aSachnummern) {
        this.init(oOwner, aSachnummern);
    }

    public DlgTeileinfoKleinController(Frame oOwner, String sHgUg, String sSachnummer, String sBenennung) {
        ArrayList<String> aSachnummern = new ArrayList<String>();
        aSachnummern.add(sSachnummer);
        this.init(oOwner, aSachnummern, true, sHgUg, sSachnummer, sBenennung);
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
    }

    protected void init(Frame oOwner, ArrayList<String> aSachnummern) {
        this.init(oOwner, aSachnummern, false, null, null, null);
    }

    protected void init(Frame oOwner, ArrayList<String> aSachnummern, boolean bLokalteil, String sHgUg, String sSachnummer, String sBenennung) {
        this.model = new DlgTeileinfoModel();
        super.init(this.model);
        this.model.setSachnummern(aSachnummern);
        this.model.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        this.model.setFilialinfoAnzeigen(this.ermittleFilialinfoAnzeigen());
        this.model.setLokalteil(bLokalteil);
        if (!bLokalteil) {
            String sAktSachnummer;
            if (this.model.hasNextSachnummer() && !this.suche(sAktSachnummer = this.model.nextSachnummer(), null) && GlobalObjects.isScore()) {
                this.model.setLokalteil(true);
                this.suche("", sAktSachnummer, "");
            }
        } else {
            this.suche(sHgUg, sSachnummer, sBenennung);
        }
        this.dlg = new DlgTeileinfoKlein(oOwner, this.model, this);
        if (this.dlg.getAktuellerReiterIstFilialinfo()) {
            this.loadFilialinfo();
        }
        this.dlg.update();
        this.dlg.setModal(true);
        this.dlg.setVisible(true);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void showNextSachnummer(JComponent component) {
        String sSachnummer = this.model.nextSachnummer();
        if (sSachnummer != null) {
            this.suche(sSachnummer, component);
        }
        this.dlg.update();
    }

    public void showPrevSachnummer(JComponent component) {
        String sSachnummer = this.model.prevSachnummer();
        if (sSachnummer != null) {
            this.suche(sSachnummer, component);
        }
        this.dlg.update();
    }

    protected boolean suche(String sHgUg, String sSachnummer, String sFremdeTnr, String sBenennung, JComponent cTextfield) {
        boolean bFound = true;
        if (this.model.getLokalteil()) {
            String sMarke = null;
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            JavaSucheInfo objSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
            sMarke = objSucheInfo != null ? objSucheInfo.getMarke() : oLoginInfo.getSettings().getMarke();
            Teileinfo oTeileinfo = new Teileinfo(sHgUg, sSachnummer, sBenennung, sMarke);
            this.model.setTeileinfo(oTeileinfo);
        } else {
            bFound = this.loadTeileinfo(sHgUg, sSachnummer, sFremdeTnr, cTextfield);
        }
        this.loadTLZumUebernehmen();
        this.loadKommerzielleInfo(cTextfield);
        this.model.setFilialBez(null);
        this.model.setFilialBestand(null);
        return bFound;
    }

    protected boolean suche(String sSachnummer, JComponent component) {
        return this.suche(null, sSachnummer, null, null, component);
    }

    protected boolean suche(String sHgUg, String sSachnummer, String sBenennung) {
        return this.suche(sHgUg, sSachnummer, null, sBenennung, null);
    }

    protected boolean suche(String sHgUg, String sSachnummer, JComponent component) {
        return this.suche(sHgUg, sSachnummer, null, null, component);
    }

    protected boolean suche(String sHgUg, String sSachnummer, String sFremdeTnr, JComponent component) {
        return this.suche(sHgUg, sSachnummer, sFremdeTnr, null, component);
    }

    protected boolean loadTeileinfo(String sHgUg, String sSachnummer, String sFremdeTnr) {
        return this.loadTeileinfo(sHgUg, sSachnummer, sFremdeTnr, null);
    }

    protected boolean loadTeileinfo(String sHgUg, String sSachnummer, String sFremdeTnr, JComponent component) {
        Cursor cursor = null;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (component != null) {
            cursor = component.getCursor();
            component.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.model.setTeileinfo(null);
        TrfHashMap trfHashMap = new TrfHashMap(null);
        trfHashMap.setValue("hgug", sHgUg);
        trfHashMap.setValue("sachnummer", sSachnummer);
        trfHashMap.setValue("fremdetnr", sFremdeTnr);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_TEILEINFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("loadTeileinfo: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (component != null) {
                component.setCursor(cursor);
            }
            return false;
        }
        boolean bFound = true;
        if (trfHashMap.getError() != null) {
            String sMsg = "";
            if (trfHashMap.getError() instanceof NoDataFoundException) {
                sMsg = Resource.getInstance().getTeilNichtGefundenZuSuchkriterium();
                log.info((Object)sMsg);
            } else {
                sMsg = Resource.getInstance().getFehlerLadeTeileinfo() + ": " + trfHashMap.getError().getMessage();
                log.error((Object)sMsg);
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (component != null) {
                component.setCursor(cursor);
            }
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileinformation(), 0);
            bFound = false;
        }
        Teileinfo oTeileinfo = (Teileinfo)trfHashMap.getValue("teileinfo");
        this.model.setTeileinfo(oTeileinfo);
        Vector<String> aMarken = null;
        if (oTeileinfo != null) {
            aMarken = oTeileinfo.getMarken();
        }
        this.model.setMarken(aMarken);
        if (oTeileinfo != null && oTeileinfo.getSachnummern() != null && oTeileinfo.getSachnummern().size() > 0) {
            this.showFremdeTnrSucheErgebnisliste(oTeileinfo.getSachnummern());
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (component != null) {
            component.setCursor(cursor);
        }
        return bFound;
    }

    protected void loadFilialinfo() {
        this.loadFilialinfo(null);
    }

    protected void loadFilialinfo(JComponent cTextfield) {
        if (this.model.getFilialBez() != null) {
            return;
        }
        Teileinfo oTI = this.model.getTeileinfo();
        if (oTI == null || oTI.getSachnummer().length() < 1) {
            return;
        }
        Cursor cursor = null;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (cTextfield != null) {
            cursor = cTextfield.getCursor();
            cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        }
        TrfHashMap trfHashMap = new TrfHashMap(null);
        trfHashMap.setValue("teilenummer", oTI.getTeilenummer());
        Vector<String> aMarke = oTI.getMarken();
        String sMarkeVorgabe = GlobalObjects.getInstance().getSessionInfo().getMarke();
        String sMarke = GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeVorgabe);
        if (sMarke == null) {
            JOptionPane.showMessageDialog(MainView.getInstance(), "es konnte keine Marke ermittelt werden. Die Funktion wird nicht ausgef\u00fchrt", Resource.getInstance().getTeileinformation(), 0);
            return;
        }
        trfHashMap.setValue("marke", sMarke);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.DO_DMS_FILIALBESTAND);
        }
        catch (CommunicationException ex) {
            log.error((Object)("loadFilialinfo: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (cTextfield != null) {
                cTextfield.setCursor(cursor);
            }
            return;
        }
        Integer nStatus = (Integer)trfHashMap.getValue("returncode");
        DmsUtils.showMsgTxt((String)trfHashMap.getValue("msgtxt"), nStatus);
        if (trfHashMap.getError() != null && !(trfHashMap.getError() instanceof DMSException)) {
            String sMsg = Resource.getInstance().getFehlerLadeTeileinfo() + ": " + trfHashMap.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (cTextfield != null) {
                cTextfield.setCursor(cursor);
            }
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileinformation(), 0);
        }
        Vector aFilialen = (Vector)trfHashMap.getValue("filialenDMS");
        Vector aBestaende = (Vector)trfHashMap.getValue("bestaendeDMS");
        this.model.setFilialBez(aFilialen);
        this.model.setFilialBestand(aBestaende);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (cTextfield != null) {
            cTextfield.setCursor(cursor);
        }
    }

    protected void loadKommerzielleInfo(JComponent cTextfield) {
        Teileinfo oTI = this.model.getTeileinfo();
        if (oTI == null || !this.model.getLokalteil() && oTI.getSachnummer().length() < 1 || this.model.getLokalteil() && oTI.getTeilenummer().length() < 1) {
            this.model.setKommerzielleInfo(null);
            return;
        }
        Cursor cursor = null;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (cTextfield != null) {
            cursor = cTextfield.getCursor();
            cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        }
        TrfHashMap trfHashMap = new TrfHashMap(null);
        Teil oTeil = new Teil(oTI.getSachnummer());
        oTeil.setHG(oTI.getHg());
        oTeil.setUG(oTI.getUg());
        oTeil.setMarken(oTI.getMarken());
        oTeil.setTeileart(oTI.getTeileart());
        oTeil.setProduktklasse(oTI.getProduktklasse());
        oTeil.setVVM(oTI.getVVMInt());
        oTeil.setLVM(oTI.getLVMInt());
        oTeil.setBVM(oTI.getBVMInt());
        trfHashMap.setValue("teil", oTeil);
        this.model.setKommerzielleInfo(oTeil);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_KOMMERZIELLE_INFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("loadKommerzielleInfo: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (cTextfield != null) {
                cTextfield.setCursor(cursor);
            }
            return;
        }
        Integer nStatus = (Integer)trfHashMap.getValue("returncode");
        DmsUtils.showMsgTxt((String)trfHashMap.getValue("msgtxt"), nStatus);
        if (trfHashMap.getError() != null) {
            String sMsg = "";
            sMsg = trfHashMap.getError() instanceof XmlCommunicationException ? Resource.getInstance().getFehlerLadeTeileinfo() + "\n" + Resource.getInstance().getNoDms() + "\n" + trfHashMap.getError().getMessage() : Resource.getInstance().getFehlerLadeTeileinfo() + "\n" + trfHashMap.getError().getMessage();
            if (!(trfHashMap.getError() instanceof DMSException)) {
                log.error((Object)sMsg);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                if (cTextfield != null) {
                    cTextfield.setCursor(cursor);
                }
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileinformation(), 0);
            }
        }
        if ((oTeil = (Teil)trfHashMap.getValue("teil")).getBenennung() == null || oTeil.getBenennung().length() < 1) {
            oTeil.setBenennung(oTI.getBenennung());
        }
        this.model.setKommerzielleInfo(oTeil);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (cTextfield != null) {
            cTextfield.setCursor(cursor);
        }
    }

    public void handleUebernehmen(int nIndex) {
        if (this.model.getTeileinfo() == null || this.model.getTeileinfo().getSachnummer().length() < 1) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeileinfoNoUebernehmen(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        Vector<Teil> aTeile = new Vector<Teil>();
        Teil oTeil = new Teil(this.model.getTeileinfo().getSachnummer());
        oTeil.setUG(this.model.getTeileinfo().getUg());
        oTeil.setHG(this.model.getTeileinfo().getHg());
        oTeil.setBenennung(this.model.getTeileinfo().getBenennung());
        if (this.model.getLokalteil()) {
            oTeil.setLokalteil(true);
        }
        aTeile.add(oTeil);
        ComboTeilelisteItem oTeilelisteItem = this.getListeZuIndex(nIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        if (sTeilelisteID == null || sTeilelisteID.trim().equals("")) {
            return;
        }
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        String sMarke = oTeilelisteItem.getMarke();
        if (sMarke == null || sMarke.equals("")) {
            Vector<String> cMarken = this.model.getTeileinfo().getMarken();
            if (cMarken.size() != 1) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), "unerwarteter Fehler: es darf keine neue Teileliste angelegt werden, wenn die Marke nicht eindeutig ist", Resource.getInstance().getTeileinfo(), 0);
                return;
            }
            sMarke = (String)cMarken.toArray()[0];
        }
        DlgTeilelisteController ctrl = new DlgTeilelisteController();
        ctrl.uebernehmeTeile(MainView.getInstance(), oTeilelisteItem, sMarke, aTeile, false);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.loadTLZumUebernehmen();
        }
    }

    public void handleNotizLoeschen() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfString trString = new TrfString(null);
        Teileinfo oTI = this.model.getTeileinfo();
        String sSachnummer = oTI.getSachnummer();
        trString.setString(sSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trString, Command.DELETE_NOTIZ);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenNotiz() + " " + ex.getMessage(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        if (trString.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenNotiz() + " " + trString.getError().getMessage(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        oTI.setNotiz(null);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void handleNotizSpeichern(String sText, boolean bAllgemein, String sJahr, String sMonat) {
        Teileinfo oTI = this.model.getTeileinfo();
        String sSachnummer = oTI.getSachnummer();
        if (sSachnummer.length() < 1 || sText.length() < 1 || sJahr.equals("0") || sMonat == null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeileinfoNoSaveNotiz(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        Notiz notiz = new Notiz();
        notiz.setSachnummer(sSachnummer);
        notiz.setNotiz(sText);
        notiz.setBisMonat(Integer.parseInt(sMonat));
        notiz.setBisJahr(Integer.parseInt(sJahr));
        notiz.setAllgemein(bAllgemein);
        TrfHashMap trfHasMap = new TrfHashMap(null);
        trfHasMap.setValue("notiz_objekt", notiz);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHasMap, Command.SAVE_NOTIZ);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerSpeichernNotiz() + " " + ex.getMessage(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        if (trfHasMap.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerSpeichernNotiz() + " " + trfHasMap.getError().getMessage(), Resource.getInstance().getTeileinfo(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void loadTLZumUebernehmen() {
        log.debug((Object)"Performing loadTLZumUebernehmen");
        this.model.storeTeilelistenIDs(null);
        Teileinfo oTI = this.model.getTeileinfo();
        if (oTI == null || oTI.getSachnummer().length() < 1) {
            return;
        }
        Vector<String> aMarke = oTI.getMarken();
        TrfHashMap trfTeilelistenIDs = DlgTeilelisteController.loadTeilelistenIDs(aMarke, false);
        if (trfTeilelistenIDs == null) {
            return;
        }
        this.model.storeTeilelistenIDs(trfTeilelistenIDs);
    }

    protected boolean ermittleFilialinfoAnzeigen() {
        if (!this.model.getDMSVerwenden()) {
            return false;
        }
        GlobalObjects.getInstance().loadKonfiguration();
        String sBestandFiliale = GlobalObjects.getInstance().getConfig().getBestandFiliale();
        return sBestandFiliale != null && sBestandFiliale.equals("J");
    }

    protected boolean ermittleKommerzielleInfoInitialSelektiert() {
        if (this.model.getDMSVerwenden()) {
            return true;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfString trf = new TrfString(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.CHECK_PREISE_GELADEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeileinfoKleinController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getTeileinfo(), 0);
            return false;
        }
        String sResult = trf.getString();
        return sResult != null && sResult.equals("J");
    }

    protected ComboTeilelisteItem getListeZuIndex(int nInd) {
        return this.model.getTeileliste(nInd);
    }

    protected void showFremdeTnrSucheErgebnisliste(Collection<SearchBTETeile.PartOrBTE> teile) {
        WorkflowStateData data = new WorkflowStateData();
        data.setWert("modus", "Teileinfo");
        data.setWert("teilenummern", teile);
        MainView.getInstance().showDlg(SuchergebnisseController.class, data);
    }
}

