/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.fzgid.Auftrag;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.utils.DmsUtils;
import webetk.resources.Resource;

public class Barverkauf {
    private HashMap<String, Object> mMapReturnValues;
    private static Logger log = Logger.getLogger(Barverkauf.class);
    private JDialog mDlg;
    private DlgTeilelisteModel mModel;
    private DlgTeilelisteController mController;
    protected HeaderPanel mHeaderPanel;
    private Container mContentPane;
    private JLabel mTxtKundennummer;
    private JTextField mTfKundennummer;
    private JLabel mTxtPasswort;
    private JPasswordField mTfPasswort;
    private JLabel mTxtBearbeiter;
    private JTextField mTfBearbeiter;
    private JLabel mTxtSondersteuerung;
    private JTextField mTfSondersteuerung;
    private JLabel mTxtBar;
    private JTextField mTfBar;
    private JLabel mTxtUnBar;
    private JTextField mTfUnBar;
    private JLabel mTxtFreitext;
    private JTextArea mTaFreitext;
    private JLabel mTxtZurueck;
    private JLabel mTxtZurueckWert;
    private JCheckBox mChkRechnung;
    private JCheckBox mChkLieferschein;
    private JCheckBox mChkGreiferschein;
    private JCheckBox mChkWiederverwenden;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;

    public Barverkauf(HashMap<String, Object> mapReturnValues) {
        this.mMapReturnValues = mapReturnValues;
        this.mDlg = new JDialog((Frame)MainView.getInstance(), false);
        this.mDlg.setModal(true);
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getBarverkauf(), null);
        this.mDlg.setSize(540, 460);
        this.mDlg.setLocation(50, 10);
    }

    public void setController(DlgTeilelisteController oController) {
        this.mController = oController;
        if (oController != null) {
            this.mModel = oController.getModel();
        }
    }

    public void initComponents() {
        this.mDlg.setTitle(Resource.getInstance().getBarverkauf());
        this.mTxtKundennummer = new JLabel(Resource.getInstance().getKundennummer());
        this.mTfKundennummer = new LimitedNumberField(7);
        this.mTxtPasswort = new JLabel(Resource.getInstance().getPasswort());
        this.mTfPasswort = new JPasswordField(10);
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(10, 0);
        this.mTfPasswort.setDocument(ehDoc);
        this.mTxtBearbeiter = new JLabel(Resource.getInstance().getBearbeiter());
        this.mTfBearbeiter = new LimitedNumberField(3);
        this.mTxtSondersteuerung = new JLabel(Resource.getInstance().getSondersteuerung());
        this.mTfSondersteuerung = new LimitedNumberField(1);
        this.mTxtBar = new JLabel(Resource.getInstance().getGegebenBar());
        this.mTfBar = new LimitedNumberField(12, true, false);
        this.mTfBar.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                Barverkauf.this.mTxtZurueckWert.setText(WebetkUtils.getPriceString(Barverkauf.this.ermittleZurueck()));
                return true;
            }
        });
        this.mTxtUnBar = new JLabel(Resource.getInstance().getGegebenUnbar());
        this.mTfUnBar = new LimitedNumberField(12, true, false);
        this.mTfUnBar.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                Barverkauf.this.mTxtZurueckWert.setText(WebetkUtils.getPriceString(Barverkauf.this.ermittleZurueck()));
                return true;
            }
        });
        this.mTxtFreitext = new JLabel(Resource.getInstance().getFreitext());
        this.mTaFreitext = new JTextArea("");
        this.mTaFreitext.setAutoscrolls(false);
        this.mTaFreitext.setEditable(true);
        this.mTaFreitext.setEnabled(true);
        this.mTaFreitext.setLineWrap(true);
        this.mTaFreitext.setWrapStyleWord(true);
        this.mTaFreitext.setForeground(Color.black);
        ehDoc = new EnhancedTextDocument(150, 0);
        this.mTaFreitext.setDocument(ehDoc);
        this.mTxtZurueck = new JLabel(Resource.getInstance().getZurueck());
        this.mTxtZurueckWert = new JLabel("");
        this.mChkRechnung = new JCheckBox(Resource.getInstance().getRechnung(), false);
        if (this.mModel.getRechnung()) {
            this.mChkRechnung.setSelected(true);
        }
        this.mChkLieferschein = new JCheckBox(Resource.getInstance().getLieferschein(), false);
        if (this.mModel.getLieferschein()) {
            this.mChkLieferschein.setSelected(true);
        }
        this.mChkGreiferschein = new JCheckBox(Resource.getInstance().getGreiferschein(), false);
        if (this.mModel.getGreiferschein()) {
            this.mChkGreiferschein.setSelected(true);
        }
        this.mChkWiederverwenden = new JCheckBox(Resource.getInstance().getListeWiederVerwenden(), false);
        this.mButtonUebernehmen = new JButtonEx("", ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        if (this.mModel.getGesperrt()) {
            this.mTfBearbeiter.setText(this.mModel.getMitarbeiterNr());
            this.mTaFreitext.setText(this.mModel.getFreitext());
        } else {
            this.mTfBearbeiter.setText(DlgTeilelisteController.loadBearbeiterNr());
        }
        this.layoutAll();
    }

    protected void layoutAll() {
        this.mContentPane = this.mDlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mContentPane.setLayout(l);
        this.mContentPane.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.mContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 60, 0, 10, 0, 10};
        int[] heights = new int[]{10, 0, 20, 0, 5, 0, 5, 0, 5, 0, 10, 0, 5, 0, 5, 0, 5, 0, 5};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mTxtKundennummer, c.rc(2, 2));
        panel.add((Component)this.mTfKundennummer, c.rc(2, 4));
        panel.add((Component)this.mTxtBearbeiter, c.rc(2, 6, "l"));
        panel.add((Component)this.mTfBearbeiter, c.rc(2, 8, "l"));
        panel.add((Component)this.mTxtPasswort, c.rc(4, 6, "l"));
        panel.add((Component)this.mTfPasswort, c.rc(4, 8, "l"));
        panel.add((Component)this.mChkRechnung, c.rc(4, 2, "l"));
        panel.add((Component)this.mChkLieferschein, c.rc(6, 2, "l"));
        panel.add((Component)this.mChkGreiferschein, c.rc(8, 2, "l"));
        panel.add((Component)this.mTxtSondersteuerung, c.rc(10, 2, "l"));
        panel.add((Component)this.mTfSondersteuerung, c.rc(10, 4, "l"));
        panel.add((Component)this.mTxtBar, c.rc(6, 6, "l"));
        panel.add((Component)this.mTfBar, c.rc(6, 8, "l"));
        panel.add((Component)this.mTxtUnBar, c.rc(8, 6, "l"));
        panel.add((Component)this.mTfUnBar, c.rc(8, 8, "l"));
        panel.add((Component)this.mTxtZurueck, c.rc(10, 6, "l"));
        panel.add((Component)this.mTxtZurueckWert, c.rc(10, 8, "l"));
        panel.add((Component)this.mTxtFreitext, c.rcwh(12, 2, 7, 1, "l"));
        panel.add((Component)this.createFreitextComponent(), c.rcwh(14, 2, 7, 1, "lr"));
        if (this.mModel.getTLDaten().getAuftrag() == null && !this.mModel.getGesperrt()) {
            panel.add((Component)this.mChkWiederverwenden, c.rcwh(16, 2, 7, 1, "lr"));
        }
        return panel;
    }

    public JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nRet = Barverkauf.this.sendeBarverkauf();
                if (nRet == 1) {
                    return;
                }
                Barverkauf.this.mMapReturnValues.put("ret", nRet);
                boolean bWiederVerwenden = Barverkauf.this.mChkWiederverwenden.isSelected();
                Barverkauf.this.mMapReturnValues.put("wieder_verwenden", bWiederVerwenden);
                Barverkauf.this.mDlg.dispose();
            }
        });
        this.mButtonAbbrechen.setVerifyInputWhenFocusTarget(false);
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Barverkauf.this.mMapReturnValues.put("ret", 1);
                Barverkauf.this.mDlg.dispose();
            }
        });
        return panel;
    }

    protected JComponent createFreitextComponent() {
        JScrollPane sc = new JScrollPane(this.mTaFreitext);
        sc.setPreferredSize(new Dimension(460, 80));
        this.mTaFreitext.setCaretPosition(0);
        sc.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), UIHelper.getStandardBorder()));
        return sc;
    }

    protected double ermittleZurueck() {
        double dBar = 0.0;
        if (this.mTfBar.getText().length() > 0) {
            dBar = Double.parseDouble(this.mTfBar.getText());
        }
        double dUnBar = 0.0;
        if (this.mTfUnBar.getText().length() > 0) {
            dUnBar = Double.parseDouble(this.mTfUnBar.getText());
        }
        double dZurueck = dBar + dUnBar - this.mModel.getTLDaten().ermittleSummeBrutto();
        dZurueck = Math.floor(dZurueck * 100.0 + 0.5) / 100.0;
        return dZurueck;
    }

    protected int sendeBarverkauf() {
        if (this.mTfKundennummer.getText().length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoKundennr(), this.mDlg.getTitle(), 0);
            return 1;
        }
        if (this.mTfBearbeiter.getText().length() < 1 || Integer.parseInt(this.mTfBearbeiter.getText()) < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoMitarbeiternummer(), this.mDlg.getTitle(), 0);
            return 1;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        Teileliste oTL = this.mModel.getTLDaten();
        if (this.mChkWiederverwenden.isSelected() && !this.mModel.getGesperrt()) {
            String sOldID = oTL.getID();
            String sNutzerID = oTL.getNutzerID();
            String sFiliale = oTL.getFiliale();
            String sNewID = DlgTeilelisteController.copyTeileliste(sOldID, sNutzerID, sFiliale);
            oTL.setID(sNewID);
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            oTL.setNutzerID(oLoginInfo.getLogin());
            oTL.setFiliale(oLoginInfo.getFilialeId());
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teileliste", oTL);
        trfTL.setValue("art", "Barverkauf");
        trfTL.setValue("kundennr", this.mTfKundennummer.getText());
        if (this.mChkRechnung.isSelected()) {
            trfTL.setValue("rechnung", "J");
        }
        if (this.mChkLieferschein.isSelected()) {
            trfTL.setValue("lieferschein", "J");
        }
        if (this.mChkGreiferschein.isSelected()) {
            trfTL.setValue("greiferschein", "J");
        }
        trfTL.setValue("bearbeiter", this.mTfBearbeiter.getText());
        char[] aPasswort = this.mTfPasswort.getPassword();
        trfTL.setValue("pwd", new String(aPasswort));
        trfTL.setValue("sondersteuerung", this.mTfSondersteuerung.getText());
        trfTL.setValue("bar", this.mTfBar.getText());
        trfTL.setValue("unbar", this.mTfUnBar.getText());
        trfTL.setValue("freitext", this.mTaFreitext.getText());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_SEND_LIST);
        }
        catch (CommunicationException e) {
            log.error((Object)(this.mDlg.getTitle() + ": " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), this.mDlg.getTitle(), 0);
            return 1;
        }
        if (trfTL.getError() != null) {
            String sMsg = null;
            if (trfTL.getError() instanceof NoDataFoundException) {
                String sTNr = trfTL.getError().getMessage();
                Object[] arguments = new Object[]{sTNr};
                sMsg = MessageFormat.format(Resource.getInstance().getFehlerRabattschluesselTeilInListe(), arguments);
            } else {
                sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            }
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, this.mDlg.getTitle(), 0);
            return 1;
        }
        oTL = (Teileliste)trfTL.getValue("teileliste");
        this.mModel.setTLDaten(oTL);
        String sMsgTxt = (String)trfTL.getValue("msgtxt");
        int[] aRetCodes = (int[])trfTL.getValue("returncodes");
        Teil[] aTeile = this.mController.getTeile(aRetCodes);
        if (!DmsUtils.showMsgTxt(sMsgTxt, aRetCodes, aTeile, this.mController.getKonfiguration(), Resource.getInstance().getSendenErfolgreich())) {
            return 2;
        }
        return 0;
    }

    protected String ladeBarverkaufsnummer() {
        return GlobalObjects.getInstance().getConfig().getStandardBarVerkaufsNummer();
    }

    public void show() {
        Long lKundennummer;
        String sKundennummer = null;
        Auftrag oAuftrag = this.mModel.getTLDaten().getAuftrag();
        if (oAuftrag != null && (lKundennummer = oAuftrag.getKundenNr()) != null) {
            sKundennummer = lKundennummer.toString();
        }
        if (sKundennummer == null && this.mModel.getTLDaten().getKundenNrLokal() != null) {
            sKundennummer = this.mModel.getTLDaten().getKundenNrLokal().toString();
        }
        if (sKundennummer == null) {
            sKundennummer = this.ladeBarverkaufsnummer();
        }
        if (sKundennummer != null) {
            this.mTfKundennummer.setText(sKundennummer);
        }
        this.mTaFreitext.setText(this.mModel.getTLDaten().getBemerkung());
        if (this.mModel.getGesperrt()) {
            this.mTfKundennummer.setText(this.mModel.getKundenNr());
            this.mTfBearbeiter.setText(this.mModel.getMitarbeiterNr());
            this.mTfSondersteuerung.setText(this.mModel.getSondersteuerung());
            this.mTaFreitext.setText(this.mModel.getFreitext());
            this.mTfPasswort.setText(this.mModel.getPasswort());
            this.mTfBar.setText(this.mModel.getBar());
            this.mTfUnBar.setText(this.mModel.getUnbar());
            this.mTxtZurueckWert.setText(WebetkUtils.getPriceString(this.ermittleZurueck()));
            if (this.mModel.getRechnung()) {
                this.mChkRechnung.setSelected(true);
            }
            if (this.mModel.getLieferschein()) {
                this.mChkLieferschein.setSelected(true);
            }
            if (this.mModel.getGreiferschein()) {
                this.mChkGreiferschein.setSelected(true);
            }
        }
        this.mDlg.setVisible(true);
    }
}

