/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teil;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.defaultdialog.DlgDefaultController;
import webetk.javaclient.dialog.extras.teileliste.AbstractListeController;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteModel;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteView;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.dialog.extras.teileliste.EditTeil;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgBestelllisteController
extends AbstractListeController {
    private static Logger log = Logger.getLogger(DlgBestelllisteController.class);
    private DlgBestelllisteView view = new DlgBestelllisteView();
    private DlgBestelllisteModel model = new DlgBestelllisteModel();

    public DlgBestelllisteController() {
        super.setModel(this.model);
    }

    public void setModel(DlgBestelllisteModel model) {
        super.setModel(model);
        this.model = model;
    }

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void updateView() {
        if (this.view != null) {
            this.view.update();
        }
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        this.model.setAnsichtsmodus(!loginInfo.hatRecht("R_WEBETK_BESTELLLISTEN"));
        this.model.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        this.loadTLZurAuswahl();
        String sID = (String)oWFStateData.getWert("ID");
        if (sID == null) {
            sID = this.ermittleSelTL();
        }
        this.model.setSelTLID(sID);
        this.loadTeileliste(sID);
        String sZurueckZurBildtafelErlauben = (String)oWFStateData.getWert("zurueck_zu_bt_erlauben");
        boolean bZurueckZurBildtafelErlauben = sZurueckZurBildtafelErlauben != null && sZurueckZurBildtafelErlauben.equalsIgnoreCase("true");
        this.model.isZurueckZurBildtafelErlaubt(bZurueckZurBildtafelErlauben);
        String sAufrufAusWorklow = (String)oWFStateData.getWert("aufruf_aus_workflow");
        boolean bAufrufAusWorklow = sAufrufAusWorklow != null && !sAufrufAusWorklow.equals("false");
        this.model.isAufrufAusWorkflow(bAufrufAusWorklow);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        return exitData;
    }

    protected void loadTLZurAuswahl() {
        log.debug((Object)"Performing loadTLZurAuswahl");
        this.model.setTLZurAuswahl(new Vector<ComboTeilelisteItem>());
        TrfHashMap trfTeilelistenIDs = DlgBestelllisteController.loadBestelllistenIDs();
        if (trfTeilelistenIDs == null) {
            return;
        }
        Vector<ComboTeilelisteItem> aTL = new Vector<ComboTeilelisteItem>();
        if (trfTeilelistenIDs != null) {
            ComboTeilelisteItem oItem;
            int ii = 1;
            while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
                aTL.add(oItem);
                ++ii;
            }
        }
        this.model.setTLZurAuswahl(aTL);
    }

    public static TrfHashMap loadBestelllistenIDs() {
        ComboTeilelisteItem oItem;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeilelistenIDs = new TrfHashMap(null);
        trfTeilelistenIDs.setValue("nurbestelllisten", "J");
        trfTeilelistenIDs.setValue("ohnebestelllisten", "N");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeilelistenIDs, Command.LOAD_TEILELISTEN_IDS);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return null;
        }
        if (trfTeilelistenIDs.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ": " + trfTeilelistenIDs.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return null;
        }
        Vector value = (Vector)trfTeilelistenIDs.getValue("Combo_teilelisteid");
        for (int i = 1; i < value.size() + 1; ++i) {
            trfTeilelistenIDs.setValue(i + "teilelisteid", value.get(i - 1));
        }
        int ii = 1;
        while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
            if (oItem.getID().equals("EILAUFTRAGSLISTE")) {
                oItem.setName(Resource.getInstance().getEilauftragsliste());
            } else if (oItem.getID().equals("NORMALAUFTRAGSLISTE")) {
                oItem.setName(Resource.getInstance().getNormalauftragsliste());
            } else {
                oItem.setName(oItem.getID());
            }
            ++ii;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfTeilelistenIDs;
    }

    protected void loadTeileliste(String sID) {
        log.debug((Object)("Performing loadTeileliste for ID " + sID));
        this.model.setTLDaten(null);
        this.model.setSelTLID(null);
        if (sID == null) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sID);
        if (!this.model.getAnsichtsmodus()) {
            trfTL.setValue("lock", true);
        } else {
            trfTL.setValue("lock", false);
        }
        trfTL.setValue("forcelock", false);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_BESTELLLISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgBestelllisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerBestellliste() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerBestellliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Bestellliste oBestellliste = (Bestellliste)trfTL.getValue("bestellliste");
        if (!this.model.getAnsichtsmodus()) {
            LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
            String sNutzerId = loginInfo.getLogin();
            if (!oBestellliste.getGesperrtVon().equals(sNutzerId)) {
                String sAm = oBestellliste.getDatGesperrtAmString();
                String sVon = oBestellliste.getGesperrtVon();
                Object[] arguments = new Object[]{sAm, sVon};
                String sMsg = MessageFormat.format(Resource.getInstance().getBestelllisteGesperrt(), arguments);
                int nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
                if (nRet == 1) {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                    trfTL = new TrfTeileliste(null);
                    trfTL.setValue("bestellliste", oBestellliste);
                    trfTL.setValue("lock", true);
                    trfTL.setValue("forcelock", true);
                    try {
                        GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_BESTELLLISTE);
                    }
                    catch (CommunicationException ex) {
                        log.error((Object)("DlgBestelllisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
                        this.model.setAnsichtsmodus(true);
                    }
                    if (trfTL.getError() != null) {
                        this.model.setAnsichtsmodus(true);
                    }
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    this.model.setAnsichtsmodus(true);
                }
            }
        }
        this.model.setTLDaten(oBestellliste);
        this.model.setSelTLID(sID);
    }

    public void handleExit() {
        if (!this.model.getAnsichtsmodus()) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            TrfTeileliste trfTL = new TrfTeileliste(null);
            trfTL.setValue("teileliste", this.model.getTLDaten());
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.UNLOCK_BESTELLLISTE);
            }
            catch (CommunicationException ex) {
                log.error((Object)("DlgBestelllisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (trfTL.getError() != null) {
                log.error((Object)(Resource.getInstance().getFehlerBestelllisteEntsperren() + ": "), (Throwable)trfTL.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerBestelllisteEntsperren() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
                return;
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected String ermittleSelTL() {
        return "EILAUFTRAGSLISTE";
    }

    protected void deleteTeile(Collection<Teil> cTeile) {
        log.debug((Object)"Performing deleteTeil");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        String sListenID = this.model.getSelTLID();
        trfTL.setValue("teilelisteid", sListenID);
        trfTL.setValue("teile", cTeile);
        trfTL.setValue("istbestellliste", "J");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_DELETE_TEIL);
        }
        catch (CommunicationException e) {
            log.error((Object)("DlgBestelllisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeile() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeile() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        for (Teil oTeil : cTeile) {
            Vector<Teil> aTeile = this.model.getTLDaten().getTeile();
            aTeile.remove(oTeil.getPosInt() - 1);
            for (Teil oTeil2 : aTeile) {
                if (oTeil2.getPosInt() <= oTeil.getPosInt()) continue;
                oTeil2.setPos(oTeil2.getPosInt() - 1);
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void handleSelChangeCbTeilelisten(String sNewID) {
        log.debug((Object)("handleSelChangeCbTeilelisten for new ID " + sNewID));
        WorkflowStateData oWsd = new WorkflowStateData();
        oWsd.setWert("ID", sNewID);
        MainView.getInstance().showDlg(DlgBestelllisteController.class, oWsd);
    }

    public void handleNewTeil() {
        log.debug((Object)"handleNewTeil");
        EditTeil editTeil = new EditTeil();
        editTeil.setModel(this.model);
        editTeil.setController(this);
        editTeil.setNeuanlage(true);
        editTeil.initComponents();
        editTeil.setVisible(true);
        this.view.update();
    }

    public void handleEditTeile(Vector<Teil> aTeile) {
        log.debug((Object)"handleEditTeil");
        this.model.setSelTeile(aTeile);
        EditTeil editTeil = new EditTeil();
        editTeil.setModel(this.model);
        editTeil.setNeuanlage(false);
        editTeil.initComponents();
        editTeil.setVisible(true);
        this.view.update();
    }

    public void handleDeleteTeile(Collection<Teil> cTeile) {
        log.debug((Object)"handleDeleteTeil");
        this.deleteTeile(cTeile);
        this.view.update();
    }

    public void handleSendDMS() {
        log.debug((Object)"handleSendDMS");
        Bestellliste oBL = this.model.getTLDaten();
        if (oBL.getTeile().isEmpty()) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getEmptyListNoSend(), Resource.getInstance().getBestelllisten(), 0);
            return;
        }
        this.sendDMS();
        WorkflowStateData oWsd = new WorkflowStateData();
        MainView.getInstance().showDlg(DlgDefaultController.class, oWsd);
    }

    public void sendDMS() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        Bestellliste oBL = this.model.getTLDaten();
        trfTL.setValue("bestellliste", oBL);
        if (oBL.getID().equals("EILAUFTRAGSLISTE")) {
            trfTL.setValue("art", "Eilauftrag");
        } else {
            trfTL.setValue("art", "Normalauftrag");
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_SEND_LIST);
        }
        catch (CommunicationException e) {
            log.error((Object)("DlgBestelllisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getBestelllisten(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getBestelllisten(), 0);
            return;
        }
        oBL = (Bestellliste)trfTL.getValue("bestellliste");
        this.model.setTLDaten(oBL);
        String sMsgTxt = (String)trfTL.getValue("msgtxt");
        int[] aRetCodes = (int[])trfTL.getValue("returncodes");
        Teil[] aTeile = this.getTeile(aRetCodes, oBL);
        if (!DmsUtils.showMsgTxt(sMsgTxt, aRetCodes, aTeile, this.getKonfiguration(), Resource.getInstance().getSendenErfolgreich())) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected Teil[] getTeile(int[] aRetCodes, Bestellliste oBL) {
        Teil[] aTeile = new Teil[aRetCodes.length];
        for (int ii = 0; ii < aRetCodes.length; ++ii) {
            Teil oTeil;
            aTeile[ii] = oTeil = DlgTeilelisteModel.getTeil(oBL, ii + 1);
        }
        return aTeile;
    }

    protected void handleStammsatzDMS(Teil oTeil) {
        log.debug((Object)"handleStammsatzDMS");
        if (!this.checkPflichtfelderStammsatzDMS(oTeil)) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teil", oTeil);
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        trfTL.setValue("marke", oLoginInfo.getSettings().getMarke());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_STAMMSATZ);
        }
        catch (CommunicationException e) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getBestelllisteBearbeiten(), 0);
            return;
        }
        Integer nStatus = (Integer)trfTL.getValue("returncode");
        if (!DmsUtils.showMsgTxt((String)trfTL.getValue("msgtxt"), nStatus)) {
            return;
        }
        if (trfTL.getError() != null) {
            String sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getBestelllisteBearbeiten(), 0);
        } else {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getErfolgStammsatzanlage(), Resource.getInstance().getBestelllisteBearbeiten(), 1);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected boolean checkPflichtfelderStammsatzDMS(Teil oTeil) {
        if (oTeil.getTeilenummer().length() < 1) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoTeilenummer(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        if (oTeil.getBenennung().length() < 1) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoBenennung(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        return true;
    }
}

