/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teil;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.HeaderRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;

public class DlgBestelllisteView
extends AbstractDialogView
implements Printable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgBestelllisteView.class);
    private DlgBestelllisteModel model;
    private ArrayList<JComponent> menuCollection = new ArrayList();
    private JPopupMenu popupMenu;
    private JMenuItem popupActionTeileinfo = null;
    private JMenuItem popupActionTeileverwendungTeil = null;
    private JMenuItem popupActionInterpretation = null;
    private JMenuItem popupActionEinzelteile = null;
    private JMenuItem popupActionStammsatz;
    private JMenuItem popupActionBearbeiten;
    private JMenuItem popupActionLoeschen;
    private JMenuItem popupActionCopySachnummer = null;
    private JPanel headerPanel;
    private JPanel teilelistePanel;
    private JPanel posteilelistePanel;
    private JButtonEx buttonSenden;
    private JButtonEx buttonNeu;
    private JComboBox cbTeilelisten;
    private boolean mbHandleSelChangeCbTeilelisten = true;
    protected Color textColor = new Color(14, 8, 104);
    private GenericTable mtable;
    private GenericTableModel mtabmodel;
    private DlgBestelllisteController moController;
    private int mnColInfo = -1;
    private int mnColEdit = -1;
    private int mnColDel = -1;
    private int mnColPos = -1;
    private int mnColTeilenummer = -1;
    private int mnColBenennung = -1;
    private int mnColBemerkung = -1;
    private int mnColAuftragsnr = -1;
    private int mnColKundennr = -1;
    private JButtonEx mbUpPos;
    private JButtonEx mbDownPos;
    private JButtonEx mbUpTeilenummer;
    private JButtonEx mbDownTeilenummer;
    private JButtonEx mbUpBenennung;
    private JButtonEx mbDownBenennung;
    private JButtonEx mbUpBemerkung;
    private JButtonEx mbDownBemerkung;
    private JButtonEx mbUpAuftragsnr;
    private JButtonEx mbDownAuftragsnr;
    private JButtonEx mbUpKundennr;
    private JButtonEx mbDownKundennr;
    private int mnPrintRow;
    private int mnPrintOInd;
    private int mPrintLastPageIndex;
    private int mnSortierung = 0;
    private boolean mbSortierungAsc = true;

    private void initComponents() {
        this.initMenus();
        this.headerPanel = new HeaderPanel(Resource.getInstance().getBestellliste(), ImageCache.getInstance().getHeaderIcon("bestell"));
        if (this.model.getAnsichtsmodus()) {
            this.teilelistePanel = new TitledPanel(Resource.getInstance().getBestelllisteAnzeigen());
            this.posteilelistePanel = new TitledPanel(Resource.getInstance().getPositionenBestelllisteAnzeigen());
        } else {
            this.teilelistePanel = new TitledPanel(Resource.getInstance().getBestelllisteBearbeiten());
            this.posteilelistePanel = new TitledPanel(Resource.getInstance().getPositionenBestelllisteBearbeiten());
        }
        this.cbTeilelisten = new JComboBox();
        this.cbTeilelisten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgBestelllisteView.this.mbHandleSelChangeCbTeilelisten) {
                    DlgBestelllisteView.this.moController.handleSelChangeCbTeilelisten(((ComboTeilelisteItem)DlgBestelllisteView.this.cbTeilelisten.getSelectedItem()).getID());
                }
            }
        });
        this.buttonNeu = new JButtonEx(Resource.getInstance().getTeilHinzufuegen(), ImageCache.getInstance().getIcon("bi_teilhinzufuegen.jpg"));
        this.buttonNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.moController.handleNewTeil();
            }
        });
        this.buttonSenden = new JButtonEx(Resource.getInstance().getAnDmsSenden(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonSenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.moController.handleSendDMS();
            }
        });
        this.mbUpPos = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(0, true);
            }
        });
        this.mbDownPos = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(0, false);
            }
        });
        this.mbUpTeilenummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(1, true);
            }
        });
        this.mbDownTeilenummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(1, false);
            }
        });
        this.mbUpBenennung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBenennung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(2, true);
            }
        });
        this.mbDownBenennung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBenennung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(2, false);
            }
        });
        this.mbUpBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(5, true);
            }
        });
        this.mbDownBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(5, false);
            }
        });
        this.mbUpAuftragsnr = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpAuftragsnr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(6, true);
            }
        });
        this.mbDownAuftragsnr = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownAuftragsnr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(6, false);
            }
        });
        this.mbUpKundennr = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpKundennr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(7, true);
            }
        });
        this.mbDownKundennr = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownKundennr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.handleClick(7, false);
            }
        });
        this.createLayout();
        this.update();
    }

    @Override
    public void initMenus() {
        this.menuCollection.clear();
        JMenu menu = new JMenu(Resource.getInstance().getBestellliste());
        menu.setBackground(UIHelper.getDarkerBackground());
        menu.add(this.createPrintMenuItem(Resource.getInstance().getDrucken()));
        this.menuCollection.add(menu);
        this.popupMenu = new JPopupMenu();
        this.popupActionTeileinfo = new MenuItemTeileinformation(this);
        this.popupMenu.add(this.popupActionTeileinfo);
        this.popupActionTeileverwendungTeil = new MenuItemTeileverwendungTeil("bestellliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionTeileverwendungTeil);
        this.popupActionInterpretation = new MenuItemInterpretation("bestellliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionInterpretation);
        this.popupActionEinzelteile = new MenuItemEinzelteile("bestellliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionEinzelteile);
        if (!this.model.getAnsichtsmodus()) {
            this.popupMenu.addSeparator();
            this.popupActionBearbeiten = new JMenuItem(Resource.getInstance().getMarkiertesTeilBearbeiten() + "...");
            this.popupActionBearbeiten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector aSelTeile = DlgBestelllisteView.this.getSelTeileFromTab();
                    DlgBestelllisteView.this.moController.handleEditTeile(aSelTeile);
                }
            });
            this.popupMenu.add(this.popupActionBearbeiten);
            this.popupActionLoeschen = new JMenuItem(Resource.getInstance().getLoeschen());
            this.popupMenu.add(this.popupActionLoeschen);
            this.popupActionLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector aSelTeile = DlgBestelllisteView.this.getSelTeileFromTab();
                    DlgBestelllisteView.this.moController.handleDeleteTeile(aSelTeile);
                }
            });
            this.popupMenu.addSeparator();
            this.popupActionStammsatz = new JMenuItem(Resource.getInstance().getAnlageStammsatzImDms() + "...");
            this.popupActionStammsatz.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector aSelTeile = DlgBestelllisteView.this.getSelTeileFromTab();
                    Teil oTeil = (Teil)aSelTeile.get(0);
                    DlgBestelllisteView.this.moController.handleStammsatzDMS(oTeil);
                }
            });
            this.popupMenu.add(this.popupActionStammsatz);
        }
        this.popupActionCopySachnummer = new MenuItemCopySachnummer(this);
        this.popupMenu.add(this.popupActionCopySachnummer);
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"init");
        this.model = (DlgBestelllisteModel)oDlgModel;
        this.moController = (DlgBestelllisteController)oController;
        this.initComponents();
    }

    @Override
    public void update() {
        if (this.model.getAnsichtsmodus()) {
            this.buttonNeu.setVisible(false);
            this.buttonSenden.setVisible(false);
        } else {
            this.buttonNeu.setVisible(true);
            this.buttonSenden.setVisible(true);
        }
        this.mbHandleSelChangeCbTeilelisten = false;
        this.cbTeilelisten.removeAllItems();
        Vector<ComboTeilelisteItem> aItems = this.model.getTLZurAuswahl();
        if (aItems != null) {
            for (int ii = 0; ii < aItems.size(); ++ii) {
                this.cbTeilelisten.addItem(aItems.get(ii));
            }
        }
        this.cbTeilelisten.setSelectedIndex(this.model.getSelTLIndex());
        this.mbHandleSelChangeCbTeilelisten = true;
        if (this.model.getTLDaten() == null) {
            this.mtabmodel.removeAllRows();
            this.buttonSenden.setEnabled(false);
            this.buttonNeu.setEnabled(false);
        } else {
            this.buttonSenden.setEnabled(true);
            this.buttonNeu.setEnabled(true);
            this.updateTabellenInhalt();
        }
    }

    private void updateTabellenInhalt() {
        this.mtabmodel.removeAllRows();
        Bestellliste oTLDaten = this.model.getTLDaten();
        Vector<Teil> aTeile = oTLDaten.getTeile();
        if (aTeile != null) {
            aTeile = this.mnSortierung == 0 && this.mbSortierungAsc ? oTLDaten.getTeile() : oTLDaten.getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
            for (Teil oTeil : aTeile) {
                String sKundennummer = "";
                if (oTeil.getKundennummer() != null) {
                    sKundennummer = oTeil.getKundennummer().toString();
                }
                if (!this.model.getAnsichtsmodus()) {
                    this.mtabmodel.addRow(new AbstractRow(new Object[]{null, null, null, oTeil.getPos(), oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), oTeil.getBemerkung(), oTeil.getAuftragsnummer(), sKundennummer}));
                    continue;
                }
                this.mtabmodel.addRow(new AbstractRow(new Object[]{null, oTeil.getPos(), oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), oTeil.getBemerkung(), oTeil.getAuftragsnummer(), sKundennummer}));
            }
        }
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createTeilelistePanel(), c.rc(1, 1));
        contentPanel.add((Component)this.createPosTeilelistePanel(), c.rc(3, 1));
        return contentPanel;
    }

    private JPanel createTeilelistePanel() {
        int[] w_teileliste = new int[]{10, 0, 10, 0, 10};
        int[] h_teileliste = new int[]{10, 0, 10};
        HIGLayout layoutTeileliste = new HIGLayout(w_teileliste, h_teileliste);
        HIGConstraints c = new HIGConstraints();
        this.teilelistePanel.setLayout(layoutTeileliste);
        this.teilelistePanel.add((Component)this.cbTeilelisten, c.rc(2, 2));
        this.teilelistePanel.add((Component)this.buttonSenden, c.rc(2, 4));
        return this.teilelistePanel;
    }

    private JPanel createPosTeilelistePanel() {
        int[] w_posteileliste = new int[]{10, -4, 10, -2, 10, 0, 10};
        int[] h_posteileliste = new int[]{10, 0, 14, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(w_posteileliste, h_posteileliste);
        layoutPosTeileliste.setColumnWeight(6, 1);
        layoutPosTeileliste.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.posteilelistePanel.setLayout(layoutPosTeileliste);
        this.posteilelistePanel.add((Component)this.buttonNeu, c.rc(2, 2, "lr"));
        this.posteilelistePanel.add((Component)this.createTabelle(), c.rcwh(4, 2, 5, 1));
        return this.posteilelistePanel;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        this.mnColInfo = -1;
        this.mnColEdit = -1;
        this.mnColDel = -1;
        this.mnColPos = -1;
        this.mnColTeilenummer = -1;
        this.mnColBenennung = -1;
        this.mnColBemerkung = -1;
        this.mnColAuftragsnr = -1;
        this.mnColKundennr = -1;
        tableConfig.setHasButtons(true);
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        this.mnColInfo = nCol++;
        if (!this.model.getAnsichtsmodus()) {
            tableConfig.addIconColumn("teil_bearbeiten.jpg", Resource.getInstance().getTeilBearbeiten());
            this.mnColEdit = nCol++;
            tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
            this.mnColDel = nCol;
        }
        tableConfig.addColumn(Resource.getInstance().getPos(), 0, false, "XXXXX");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getPosition());
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpPos);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownPos);
        this.mnColPos = nCol++;
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXX");
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpTeilenummer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownTeilenummer);
        this.mnColTeilenummer = nCol++;
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpBenennung);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownBenennung);
        this.mnColBenennung = nCol++;
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getMe(), 4, false, "X000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getMenge());
        tableConfig.addColumn(Resource.getInstance().getBemerkung(), 2, true, "XXXXXXXXXXXXXXXYYY");
        tableConfig.setHeaderButtonLeft(++nCol, this.mbUpBemerkung);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownBemerkung);
        this.mnColBemerkung = nCol++;
        tableConfig.addColumn(Resource.getInstance().getAuftragsnummer(), 2, true, "AuftragsnummerYY");
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpAuftragsnr);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownAuftragsnr);
        this.mnColAuftragsnr = nCol++;
        tableConfig.addColumn(Resource.getInstance().getKundennummer(), 2, true, "KundennummerYY");
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpKundennr);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownKundennr);
        this.mnColKundennr = nCol;
        tableConfig.setUsePrototypeIcons(true);
        this.mtabmodel = new GenericTableModel(tableConfig);
        this.mtable = new GenericTable(this.mtabmodel);
        this.mtable.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setWidth(20);
        if (!this.model.getAnsichtsmodus()) {
            this.mtable.getTable().getColumnModel().getColumn(1).setMinWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(1).setWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(2).setMinWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(2).setWidth(20);
        }
        this.mtable.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                Vector aSelTeile = DlgBestelllisteView.this.getSelTeileFromTab();
                if (aSelTeile.size() > 0) {
                    DlgBestelllisteView.this.popupMenu.show(DlgBestelllisteView.this.mtable.getTable(), evt.getX(), evt.getY());
                    if (aSelTeile.size() > 1) {
                        DlgBestelllisteView.this.popupActionCopySachnummer.setEnabled(false);
                        DlgBestelllisteView.this.popupActionTeileverwendungTeil.setEnabled(false);
                        DlgBestelllisteView.this.popupActionInterpretation.setEnabled(false);
                        DlgBestelllisteView.this.popupActionEinzelteile.setEnabled(false);
                        DlgBestelllisteView.this.popupActionTeileinfo.setEnabled(false);
                        if (!DlgBestelllisteView.this.model.getAnsichtsmodus() && DlgBestelllisteView.this.model.istDMSAngeschlossen()) {
                            DlgBestelllisteView.this.popupActionStammsatz.setEnabled(false);
                        }
                    } else {
                        DlgBestelllisteView.this.popupActionCopySachnummer.setEnabled(true);
                        DlgBestelllisteView.this.popupActionTeileverwendungTeil.setEnabled(true);
                        DlgBestelllisteView.this.popupActionEinzelteile.setEnabled(((MenuItemEinzelteile)DlgBestelllisteView.this.popupActionEinzelteile).hatEinzelteile());
                        DlgBestelllisteView.this.popupActionInterpretation.setEnabled(((MenuItemInterpretation)DlgBestelllisteView.this.popupActionInterpretation).hatInterpretation());
                        DlgBestelllisteView.this.popupActionTeileinfo.setEnabled(true);
                        if (!DlgBestelllisteView.this.model.getAnsichtsmodus()) {
                            DlgBestelllisteView.this.popupActionBearbeiten.setEnabled(true);
                            if (DlgBestelllisteView.this.model.istDMSAngeschlossen()) {
                                DlgBestelllisteView.this.popupActionStammsatz.setEnabled(true);
                            }
                        }
                    }
                }
            }

            @Override
            public void clickedOnCell(GenericTableMouseEvent evt) {
                Teil oTeil = null;
                int nCol = evt.getColumn();
                Vector<Teil> aTeile = DlgBestelllisteView.this.model.getTLDaten().getTeile();
                oTeil = aTeile.get(evt.getRow());
                if (nCol == DlgBestelllisteView.this.mnColInfo) {
                    DlgBestelllisteView.this.moController.handleTeileinfo(oTeil);
                } else if (nCol == DlgBestelllisteView.this.mnColEdit) {
                    Vector<Teil> cSelTeile = new Vector<Teil>();
                    cSelTeile.add(oTeil);
                    DlgBestelllisteView.this.moController.handleEditTeile(cSelTeile);
                } else if (nCol == DlgBestelllisteView.this.mnColDel) {
                    oTeil = new Teil();
                    oTeil.setPos(evt.getRow() + 1);
                    Vector<Teil> cSelTeile = new Vector<Teil>();
                    cSelTeile.add(oTeil);
                    DlgBestelllisteView.this.moController.handleDeleteTeile(cSelTeile);
                }
            }
        });
        final JTableHeader th = this.mtable.getTable().getTableHeader();
        th.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                int col = th.columnAtPoint(ev.getPoint());
                TableColumn column = DlgBestelllisteView.this.mtable.getColumnModel().getColumn(col);
                HeaderRenderer renderer = (HeaderRenderer)column.getHeaderRenderer();
                if (renderer.handleClick(DlgBestelllisteView.this.mtable, ev)) {
                    return;
                }
                if (col == DlgBestelllisteView.this.mnColPos) {
                    this.handleClick(0);
                } else if (col == DlgBestelllisteView.this.mnColTeilenummer) {
                    this.handleClick(1);
                } else if (col == DlgBestelllisteView.this.mnColBenennung) {
                    this.handleClick(2);
                } else if (col == DlgBestelllisteView.this.mnColBemerkung) {
                    this.handleClick(5);
                } else if (col == DlgBestelllisteView.this.mnColAuftragsnr) {
                    this.handleClick(6);
                } else if (col == DlgBestelllisteView.this.mnColKundennr) {
                    this.handleClick(7);
                }
            }

            private void handleClick(int comp) {
                if (DlgBestelllisteView.this.mnSortierung == comp) {
                    DlgBestelllisteView.this.mbSortierungAsc = !DlgBestelllisteView.this.mbSortierungAsc;
                } else {
                    DlgBestelllisteView.this.mbSortierungAsc = true;
                }
                DlgBestelllisteView.this.mnSortierung = comp;
                DlgBestelllisteView.this.updateTabellenInhalt();
            }
        });
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        return this.mtable.getScrollPane();
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuCollection.iterator();
    }

    @Override
    public void onExit() {
        log.debug((Object)"onExit");
        this.moController.handleExit();
    }

    private Vector<Teil> getSelTeileFromTab() {
        Vector<Teil> aSelTeile = new Vector<Teil>();
        int[] aRows = this.mtable.getTable().getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            Vector<Teil> aTeile = this.model.getTLDaten().getTeile();
            Teil oTeil = aTeile.get(aRows[ii]);
            aSelTeile.add(oTeil);
        }
        return aSelTeile;
    }

    private JMenuItem createPrintMenuItem(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBestelllisteView.this.print();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    private void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        pageFormat.setOrientation(0);
        printJob.setPrintable(this, pageFormat);
        printJob.setJobName(Resource.getInstance().getBestellliste());
        this.mnPrintOInd = 0;
        this.mnPrintRow = 0;
        this.mPrintLastPageIndex = -1;
        if (printJob.printDialog()) {
            pageFormat.setOrientation(0);
            printJob.setPrintable(this, pageFormat);
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.mPrintLastPageIndex == pageIndex) {
            this.mnPrintRow = this.mnPrintOInd;
        } else {
            this.mPrintLastPageIndex = pageIndex;
            this.mnPrintOInd = this.mnPrintRow;
        }
        if (this.mnPrintRow >= this.mtabmodel.getRowCount()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int maxWidth = (int)pageFormat.getImageableWidth() - 1;
        int maxHeight = (int)pageFormat.getImageableHeight() - 2;
        Font headlinefont = UIHelper.getPrintTitleFont();
        Font textfont = UIHelper.getPrintFont();
        int xPosition = 0;
        int yPosition = 0;
        int secondColPosition = 475;
        int nMiddlePosition = (int)(pageFormat.getImageableWidth() / 2.0);
        g2d.setFont(headlinefont);
        int fontSize = headlinefont.getSize();
        if (pageIndex == 0) {
            yPosition = fontSize;
            String sUeberschrift = Resource.getInstance().getBestellliste();
            g2d.drawString(sUeberschrift, nMiddlePosition - sUeberschrift.length() * 3, yPosition);
        }
        yPosition += 20;
        g2d.setFont(textfont);
        fontSize = textfont.getSize();
        Konfiguration config = this.moController.getKonfiguration();
        g2d.drawString(config.getHaendleranschriftZeile1(), xPosition, yPosition += fontSize);
        g2d.drawString(Resource.getInstance().getSeite() + ": " + (pageIndex + 1), secondColPosition, yPosition);
        g2d.drawString(config.getHaendleranschriftZeile2(), xPosition, yPosition += fontSize);
        Date currentDate = new Date();
        g2d.drawString(Resource.getInstance().getDatumZeit() + ": " + DateFormat.getDateTimeInstance().format(currentDate), secondColPosition, yPosition);
        g2d.drawString(config.getHaendleranschriftZeile3(), xPosition, yPosition += fontSize);
        g2d.drawString(config.getHaendleranschriftPLZ() + " " + config.getHaendleranschriftOrt(), xPosition, yPosition += fontSize);
        g2d.drawString(config.getHaendleranschriftTelefon(), xPosition, yPosition += fontSize);
        boolean left = false;
        boolean right = true;
        String[] tableHeaderStrings = null;
        String[] printHeaderStrings = null;
        int[] columnBegin = null;
        int[] columnEnd = null;
        int[] columnFormat = null;
        tableHeaderStrings = new String[]{Resource.getInstance().getPos(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getMe(), Resource.getInstance().getBemerkung(), Resource.getInstance().getAuftragsnummer(), Resource.getInstance().getKundennummer()};
        printHeaderStrings = new String[]{Resource.getInstance().getPos() + ".", Resource.getInstance().getTeilenummer(), Resource.getInstance().getBenennung(), Resource.getInstance().getMenge(), Resource.getInstance().getBemerkung(), Resource.getInstance().getAuftragsnummer(), Resource.getInstance().getKundennummer()};
        columnBegin = new int[]{0, 35, 120, 340, 405, 500, 585};
        columnEnd = new int[]{24, 109, 329, 394, 489, 574, maxWidth - 5};
        columnFormat = new int[]{1, 0, 0, 1, 0, 0, 0};
        if (this.mnPrintRow < this.mtabmodel.getRowCount()) {
            yPosition += 30;
            for (int i = 0; i < printHeaderStrings.length; ++i) {
                if (columnFormat[i] == 0) {
                    g2d.drawString(printHeaderStrings[i], xPosition + columnBegin[i], yPosition);
                    continue;
                }
                String value = printHeaderStrings[i];
                g2d.drawString(value, xPosition + this.getPosition(value, columnEnd[i], g2d, textfont), yPosition);
            }
            yPosition += fontSize;
            while (this.mnPrintRow < this.mtabmodel.getRowCount()) {
                int nOffset = 0;
                if ((yPosition += fontSize) + fontSize > maxHeight) {
                    return 0;
                }
                for (int i = 0; i < this.mtabmodel.getColumnCount(); ++i) {
                    for (int j = 0; j < tableHeaderStrings.length; ++j) {
                        String sValue;
                        Object oValue;
                        CharSequence value;
                        if (!this.mtabmodel.getConfiguration().getColumnName(i).equals(tableHeaderStrings[j])) continue;
                        if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilenummer())) {
                            value = new StringBuffer(this.mtabmodel.getValueAt(this.mnPrintRow, i).toString());
                            g2d.drawString(value.toString(), xPosition + columnBegin[j], yPosition);
                            continue;
                        }
                        if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilebenennung())) {
                            TextLayout layout;
                            value = this.mtabmodel.getValueAt(this.mnPrintRow, i).toString();
                            if (value == null || ((String)value).equals("")) {
                                value = " ";
                            }
                            AttributedString cellText = new AttributedString((String)value);
                            cellText.addAttribute(TextAttribute.FONT, textfont);
                            cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                            LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
                            boolean bFirstRow = true;
                            while ((layout = lineBreaker.nextLayout(columnEnd[j] - columnBegin[j])) != null) {
                                if (!bFirstRow) {
                                    nOffset += fontSize;
                                }
                                bFirstRow = false;
                                layout.draw(g2d, xPosition + columnBegin[j], yPosition + nOffset);
                            }
                            continue;
                        }
                        if (columnFormat[j] == 0) {
                            oValue = this.mtabmodel.getValueAt(this.mnPrintRow, i);
                            sValue = "";
                            if (oValue != null) {
                                sValue = oValue.toString();
                            }
                            g2d.drawString(sValue, xPosition + columnBegin[j], yPosition);
                            continue;
                        }
                        oValue = this.mtabmodel.getValueAt(this.mnPrintRow, i);
                        sValue = "";
                        if (oValue != null) {
                            sValue = oValue.toString();
                        }
                        g2d.drawString(sValue.replace(',', '.'), xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), yPosition);
                    }
                }
                yPosition += nOffset;
                ++this.mnPrintRow;
            }
        }
        if (maxHeight - yPosition < 60) {
            return 0;
        }
        return 0;
    }

    private int getPosition(String value, int endPosition, Graphics2D g2d, Font textfont) {
        if (value == null || value.equals("")) {
            value = " ";
        }
        AttributedString cellText = new AttributedString(value);
        cellText.addAttribute(TextAttribute.FONT, textfont);
        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
        TextLayout layout = lineBreaker.nextLayout(1000.0f);
        float lText = layout.getAdvance();
        int pX = endPosition - (int)lText;
        return pX;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        Vector<Teil> aSelTeile = this.getSelTeileFromTab();
        if (aSelTeile == null || aSelTeile.size() == 0) {
            return null;
        }
        Teil oTeil = aSelTeile.get(0);
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = oTeil.getSachnummer();
        String sTeilenummer = oTeil.getTeilenummerGespreizt();
        String sBenennungZusatz = oTeil.getBenennung();
        String sZusatz = oTeil.getZusatz();
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        Vector<String> aMarke = oTeil.getMarken();
        Bestellliste oBestellliste = this.model.getTLDaten();
        String sMarkeTeileliste = null;
        if (oBestellliste != null) {
            sMarkeTeileliste = oBestellliste.getMarke();
        }
        String sMarke = GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeTeileliste);
        String sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    private void handleClick(int comp, boolean bAsc) {
        this.mbSortierungAsc = bAsc;
        this.mnSortierung = comp;
        this.updateTabellenInhalt();
    }
}

