/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.RrNutzerdaten;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.GlassPane;
import webetk.javaclient.dialog.SwingWorker;
import webetk.javaclient.dialog.extras.teileliste.AbstractListeController;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeModel;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeView;
import webetk.javaclient.dialog.extras.teileliste.EditTeil;
import webetk.javaclient.dialog.extras.teileliste.NewRrSapListe;
import webetk.javaclient.dialog.extras.teileliste.RrSapMsgDlg;
import webetk.javaclient.dialog.extras.teileliste.RrSapWaitDlg;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.framework.MainViewController;
import webetk.javaclient.utils.BooleanWrapper;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgSapRrListeController
extends AbstractListeController {
    private static Logger log = Logger.getLogger(DlgSapRrListeController.class);
    private DlgSapRrListeView view = new DlgSapRrListeView();
    private DlgSapRrListeModel model = new DlgSapRrListeModel();
    private static final double MAX_MENGE = 999.99;

    public DlgSapRrListeController() {
        super.setModel(this.model);
    }

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void updateView() {
        if (this.view != null) {
            this.view.update();
        }
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.model.setDMSVerwenden(false);
        this.loadTLZurAuswahl();
        String sID = (String)oWFStateData.getWert("ID");
        if (sID == null) {
            sID = this.model.getLastTLId();
        }
        this.model.setSelTLID(sID);
        this.loadTeileliste(sID);
        if (!MainViewController.getInstance().isIsisServer()) {
            RrNutzerdaten rrNutzerdaten;
            TrfTeileliste pTransferable = new TrfTeileliste();
            pTransferable.setForceAsap(true);
            if (GlobalObjects.getInstance().hasNetz()) {
                try {
                    GlobalObjects.getInstance().getServiceExecutor().executeService(pTransferable, Command.GET_RR_NUTZERDATEN_PSI);
                }
                catch (CommunicationException ex) {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                }
                if (pTransferable.getError() != null) {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + pTransferable.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                }
            }
            if ((rrNutzerdaten = (RrNutzerdaten)pTransferable.getValue("RRNUTZERDATEN")) != null && rrNutzerdaten.getHaendlernummer() != null) {
                boolean bIntranet;
                String sHaendlerNummer = rrNutzerdaten.getHaendlernummer();
                String sHaendlerName = rrNutzerdaten.getNutzerName();
                String sHaendlerTel = rrNutzerdaten.getNutzerTelefon();
                String sHaendlerEmail = rrNutzerdaten.getNutzerEMail();
                RrNutzerdaten oNutzerdaten = null;
                if (this.model.getTLDaten() != null) {
                    oNutzerdaten = this.model.getTLDaten().getRrNutzerdaten();
                }
                if (oNutzerdaten == null) {
                    oNutzerdaten = new RrNutzerdaten();
                }
                if (!(bIntranet = GlobalObjects.getInstance().usesIntranet()) || oNutzerdaten.getHaendlernummer() == null || oNutzerdaten.getHaendlernummer().length() == 0) {
                    oNutzerdaten.setHaendlernummer(sHaendlerNummer);
                }
                if (oNutzerdaten.getNutzerName() == null || oNutzerdaten.getNutzerName().length() == 0) {
                    oNutzerdaten.setNutzerName(sHaendlerName);
                }
                if (oNutzerdaten.getNutzerTelefon() == null || oNutzerdaten.getNutzerTelefon().length() == 0) {
                    oNutzerdaten.setNutzerTelefon(sHaendlerTel);
                }
                if (oNutzerdaten.getNutzerEMail() == null || oNutzerdaten.getNutzerEMail().length() == 0) {
                    oNutzerdaten.setNutzerEMail(sHaendlerEmail);
                }
                this.model.setNutzerdaten(oNutzerdaten);
            }
        } else {
            String sHaendlerNummer = GlobalObjects.getInstance().getFirmaId();
            RrNutzerdaten oNutzerdaten = null;
            if (this.model.getTLDaten() != null) {
                oNutzerdaten = this.model.getTLDaten().getRrNutzerdaten();
            }
            if (oNutzerdaten == null) {
                oNutzerdaten = new RrNutzerdaten();
            }
            oNutzerdaten.setHaendlernummer(sHaendlerNummer);
            this.model.setNutzerdaten(oNutzerdaten);
        }
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        return exitData;
    }

    public void loadTeileliste(String sID) {
        log.debug((Object)("Performing loadTeileliste for ID " + sID));
        this.model.setTLDaten(null);
        this.model.setSelTL(null);
        if (sID == null || sID.length() < 1 || sID.equals("null")) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        trfTL.setValue("teilelisteid", sID);
        trfTL.setValue("rrsaplisten", true);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            log.error((Object)(Resource.getInstance().getFehlerLadenTeileliste() + ": "), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenTeileliste() + ": " + ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        Teileliste oTeileliste = null;
        oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        this.model.setTLDaten(oTeileliste);
        this.model.setSelTL(new ComboTeilelisteItem(sID, sID, oTeileliste.getNutzerID(), oTeileliste.getFiliale(), oTeileliste.getMarke()));
        if (oTeileliste.getSapStatus() != null && oTeileliste.getSapStatus().length() > 0 && (oTeileliste.getSapStatus().equals("A") || oTeileliste.getSapStatus().equals("B") || oTeileliste.getSapStatus().equals("E"))) {
            this.holeAntwortVonSAP();
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void deleteTeile(Collection<Teil> cTeile) {
        log.debug((Object)"Performing deleteTeil");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        String sListenID = this.model.getSelTLID();
        trfTL.setValue("teilelisteid", sListenID);
        trfTL.setValue("teile", cTeile);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_DELETE_TEIL);
        }
        catch (CommunicationException e) {
            log.error((Object)"CommunicationException", (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeile() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeile() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        for (Teil oTeil : cTeile) {
            Vector<Teil> aTeile = this.model.getTLDaten().getTeile();
            aTeile.remove(oTeil.getPosInt() - 1);
            for (Teil oTeil2 : aTeile) {
                if (oTeil2.getPosInt() <= oTeil.getPosInt()) continue;
                oTeil2.setPos(oTeil2.getPosInt() - 1);
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void handleNewListe() {
        log.debug((Object)"handleNewListe");
        this.saveTeileliste();
        String sName = null;
        HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
        NewRrSapListe dlg = new NewRrSapListe((Frame)MainView.getInstance(), mapRetVal);
        dlg.setVisible(true);
        Integer nRet = (Integer)mapRetVal.get("ret");
        if (nRet == null || nRet != 0) {
            return;
        }
        sName = (String)mapRetVal.get("id");
        this.insertListe(sName);
        this.view.update();
    }

    protected void handleSelChangeCbTeilelisten(final String sNewID) {
        GlassPane glassPane = new GlassPane();
        MainView.getInstance().setGlassPane(glassPane);
        glassPane.setVisible(true);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                log.debug((Object)("handleSelChangeCbTeilelisten for new ID " + sNewID));
                DlgSapRrListeController.this.saveTeileliste();
                DlgSapRrListeController.this.loadTeileliste(sNewID);
                if (DlgSapRrListeController.this.view != null) {
                    DlgSapRrListeController.this.view.update();
                }
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                MainView.getInstance().getGlassPane().setVisible(false);
                if (DlgSapRrListeController.this.view != null) {
                    DlgSapRrListeController.this.view.requestFocusCbTeilelisten();
                }
                return null;
            }
        };
        worker.start();
    }

    public void handleNewTeil() {
        log.debug((Object)"handleNewTeil");
        this.view.setzeKopfdatenInModel();
        EditTeil editTeil = new EditTeil();
        editTeil.setModel(this.model);
        editTeil.setController(this);
        editTeil.setNeuanlage(true);
        editTeil.initComponents();
        editTeil.setVisible(true);
        this.stornoSAP();
        this.view.update();
    }

    public void handleEditTeile(Vector<Teil> aTeile) {
        log.debug((Object)"handleEditTeil");
        this.view.setzeKopfdatenInModel();
        this.model.setSelTeile(aTeile);
        EditTeil editTeil = new EditTeil();
        editTeil.setModel(this.model);
        editTeil.setNeuanlage(false);
        editTeil.initComponents();
        editTeil.setVisible(true);
        this.stornoSAP();
        this.view.update();
    }

    public void handleDeleteTeile(Collection<Teil> cTeile) {
        log.debug((Object)"handleDeleteTeil");
        this.view.setzeKopfdatenInModel();
        this.deleteTeile(cTeile);
        this.stornoSAP();
        this.view.update();
    }

    public void handleListeLoeschen() {
        int nRet;
        log.debug((Object)"handleListeLoeschen");
        if (this.model.getTLDaten().getSapStatus().equals("B") && (nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), Resource.getInstance().getAskRrsapListeDel(), Resource.getInstance().getRrSap(), 0)) != 0) {
            return;
        }
        this.deleteTeileliste();
        String sID = this.model.getLastTLId();
        this.model.setSelTLID(sID);
        this.loadTeileliste(sID);
        this.view.update();
    }

    protected void deleteTeileliste() {
        log.debug((Object)"Performing deleteTeileliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        Teileliste oTL = this.model.getTLDaten();
        trfTL.setValue("teilelisteid", oTL.getID());
        trfTL.setValue("eigentuemer", oTL.getNutzerID());
        trfTL.setValue("filialid", oTL.getFiliale());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DELETE_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException: ", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeileliste() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getRrSap(), 0);
            return;
        }
        this.model.removeTL(this.model.getSelTL());
        this.model.setTLDaten(null);
        this.model.setSelTL(null);
        if (this.view != null) {
            this.view.update();
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void handleAktualisieren() {
        log.debug((Object)"handleAktualisieren");
        this.holeAntwortVonSAP();
        this.view.update();
    }

    public void handleSendeAnfrage() {
        log.debug((Object)"handleSendeAnfrage");
        this.doSAPKommunikation(false);
        this.view.update();
    }

    public void handleSendeBestellung() {
        log.debug((Object)"handleSendeBestellung");
        this.doSAPKommunikation(true);
        this.view.update();
    }

    protected void doSAPKommunikation(boolean bBestellung) {
        Teileliste oTL = this.model.getTLDaten();
        if (oTL.getTeile() == null || oTL.getTeile().isEmpty()) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getEmptyListNoSend(), Resource.getInstance().getRrSap(), 0);
            return;
        }
        int nMaxTeile = GlobalObjects.getInstance().getEtkData().getRrSapMaxParts();
        if (oTL.getTeile().size() > nMaxTeile) {
            String sMsg = null;
            sMsg = bBestellung ? Resource.getInstance().getMsgOrderZuVieleTeile() : Resource.getInstance().getMsgInformationZuVieleTeile();
            Object[] arguments = new Object[]{nMaxTeile};
            sMsg = MessageFormat.format(sMsg, arguments);
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getRrSap(), 0);
            return;
        }
        if ("_RRSAPLIST".equals(oTL.getID())) {
            if (!this.renameList()) {
                return;
            }
            Object[] arguments = new Object[]{oTL.getID()};
            String sMsg = MessageFormat.format(Resource.getInstance().getMsgRenamedRrlist(), arguments);
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getRrSap(), 1);
        }
        if (this.sendSAP(bBestellung)) {
            if (bBestellung) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgBestellung(), Resource.getInstance().getRrSap(), 1);
            }
            this.showWaitDlg();
        }
    }

    protected boolean sendSAP(boolean bBestellung) {
        LoginInfo oLoginInfo;
        ComboTeilelisteItem oAktTL;
        Teileliste oTL = this.model.getTLDaten();
        Vector<Teil> teile = oTL.getTeile();
        for (Teil teil : teile) {
            if (!(teil.getMengeDouble() > 999.99)) continue;
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgRrsapMengeZuGross(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        this.model.getTLDaten().resetSapDaten();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        oTL = this.model.getTLDaten();
        trfTL.setValue("teileliste", oTL);
        String sArt = null;
        sArt = bBestellung ? "B" : "A";
        oTL.setSapArt(sArt);
        oTL.setSapStatus(sArt);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAP_SENDE);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        if (trfTL.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        Teileliste oTeileliste = null;
        oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        this.model.setTLDaten(oTeileliste);
        this.model.setSelTL(new ComboTeilelisteItem(oTeileliste.getID(), oTeileliste.getID(), oTeileliste.getNutzerID(), oTeileliste.getFiliale(), oTeileliste.getMarke()));
        if (bBestellung && (oAktTL = (oLoginInfo = GlobalObjects.getInstance().getSessionInfo()).getAktuelleTeileliste()) != null && oAktTL.isRrSapListe()) {
            oLoginInfo.setAktuelleTeileliste(null);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected boolean renameList() {
        if (this.model.getTLDaten() == null) {
            log.error((Object)"renameList model.getTLDaten() == null");
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        String sName = null;
        HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
        NewRrSapListe dlg = new NewRrSapListe((Frame)MainView.getInstance(), mapRetVal);
        dlg.setVisible(true);
        Integer nRet = (Integer)mapRetVal.get("ret");
        if (nRet == null || nRet != 0) {
            return false;
        }
        sName = (String)mapRetVal.get("id");
        trfTL.setValue("teilelisteid", sName);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.RENAME_RRSAP_LISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        if (trfTL.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        String sNewID = (String)trfTL.getValue("teilelistenewid");
        this.model.getTLDaten().setID(sNewID);
        int indOldItem = this.model.getSelTLIndex();
        this.model.getTLZurAuswahl().remove(indOldItem);
        ComboTeilelisteItem oNewItem = new ComboTeilelisteItem(this.model.getTLDaten().getID(), this.model.getTLDaten().getID(), this.model.getTLDaten().getNutzerID(), this.model.getTLDaten().getFiliale(), this.model.getTLDaten().getMarke());
        this.model.getTLZurAuswahl().add(oNewItem);
        this.model.setSelTL(oNewItem);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected void stornoSAP() {
        if (this.model.getTLDaten() == null) {
            return;
        }
        String sStatus = this.model.getTLDaten().getSapStatus();
        if (sStatus != null && sStatus.equals("E")) {
            this.model.getTLDaten().resetSapDaten();
            return;
        }
        if (sStatus == null || !sStatus.equals("A")) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        Teileliste oTL = this.model.getTLDaten();
        trfTL.setValue("teileliste", oTL);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAP_STORNO);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getRrSap(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getRrSap(), 0);
            return;
        }
        Teileliste oTeileliste = null;
        oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        this.model.setTLDaten(oTeileliste);
        this.model.setSelTL(new ComboTeilelisteItem(oTeileliste.getID(), oTeileliste.getID(), oTeileliste.getNutzerID(), oTeileliste.getFiliale(), oTeileliste.getMarke()));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void showWaitDlg() {
        BooleanWrapper bResult = new BooleanWrapper(false);
        RrSapWaitDlg dlg = new RrSapWaitDlg(this, bResult);
        dlg.setVisible(true);
        if (bResult.getValue()) {
            log.info((Object)"true");
        } else {
            log.info((Object)"false");
        }
    }

    protected boolean holeAntwortVonSAP() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        Teileliste oTL = this.model.getTLDaten();
        trfTL.setValue("teileliste", oTL);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAP_HOLE_ANTWORT);
        }
        catch (CommunicationException ex) {
            log.error((Object)"CommunicationException", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        if (trfTL.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getRrSap(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Teileliste oTeileliste = null;
        oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        if (!oTeileliste.getSapStatus().equals("A") && !oTeileliste.getSapStatus().equals("B")) {
            String sSapError = oTeileliste.getSapError();
            if (sSapError != null && sSapError.length() > 0) {
                int indUmbruch = sSapError.indexOf("Part", 1);
                int indAnfang = 0;
                while (indUmbruch > -1) {
                    sSapError = sSapError.substring(0, indUmbruch) + "\n" + sSapError.substring(indUmbruch);
                    indAnfang = indUmbruch + 4;
                    indUmbruch = sSapError.indexOf("Part", indAnfang);
                }
                boolean bMengeZuGross = false;
                int indMinMenge = sSapError.indexOf("minimum order quantity of ", 1);
                while (indMinMenge > -1) {
                    int indKomma = sSapError.indexOf(".", indMinMenge + 26);
                    String sMenge = sSapError.substring(indMinMenge + 26, indKomma + 4);
                    double dMenge = Double.parseDouble(sMenge);
                    if (dMenge > 999.99) {
                        bMengeZuGross = true;
                    }
                    sMenge = sMenge.substring(0, sMenge.length() - 1);
                    sSapError = sSapError.substring(0, indMinMenge + 26) + sMenge + sSapError.substring(indMinMenge + 26 + sMenge.length() + 1);
                    indMinMenge = sSapError.indexOf("minimum order quantity of ", indMinMenge + 26);
                }
                if (bMengeZuGross) {
                    sSapError = sSapError + Resource.getInstance().getMsgRrsapMengeZuGross();
                }
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                RrSapMsgDlg msgDlg = new RrSapMsgDlg(sSapError);
                msgDlg.setVisible(true);
            }
            this.model.setTLDaten(oTeileliste);
            return true;
        }
        return false;
    }

    protected void loadTLZurAuswahl() {
        log.debug((Object)"Performing loadTLZurAuswahl");
        this.model.setTLZurAuswahl(new Vector<ComboTeilelisteItem>());
        TrfHashMap trfTeilelistenIDs = DlgSapRrListeController.loadTeilelistenIDs();
        if (trfTeilelistenIDs == null) {
            return;
        }
        Vector<ComboTeilelisteItem> aTL = new Vector<ComboTeilelisteItem>();
        if (trfTeilelistenIDs != null) {
            ComboTeilelisteItem oItem;
            int ii = 1;
            while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
                aTL.add(oItem);
                ++ii;
            }
        }
        this.model.setTLZurAuswahl(aTL);
    }

    protected static TrfHashMap loadTeilelistenIDs() {
        ComboTeilelisteItem oItem;
        TrfHashMap trfTeilelistenIDs = new TrfHashMap(null);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        trfTeilelistenIDs.setValue("rrsaplisten", "J");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeilelistenIDs, Command.LOAD_TEILELISTEN_IDS);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return null;
        }
        if (trfTeilelistenIDs.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ": " + trfTeilelistenIDs.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return null;
        }
        Vector value = (Vector)trfTeilelistenIDs.getValue("Combo_teilelisteid");
        for (int i = 1; i < value.size() + 1; ++i) {
            trfTeilelistenIDs.setValue(i + "teilelisteid", value.get(i - 1));
        }
        int ii = 1;
        while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
            if ("_RRSAPLIST".equals(oItem.getID())) {
                oItem.setName(Resource.getInstance().getRrSap());
            } else {
                oItem.setName(oItem.getID());
            }
            ++ii;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfTeilelistenIDs;
    }

    protected boolean insertListe(String sName) {
        log.debug((Object)"Performing insertListe");
        if (sName == null || sName.length() < 1) {
            return false;
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        trfTL.setValue("teilelisteid", sName);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.INSERT_RRSAP_LISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            String sMsg = Resource.getInstance().getFehlerSpeichernTeileliste() + ": " + ex.getMessage();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        Teileliste newTL = (Teileliste)trfTL.getValue("teileliste");
        this.model.setTLDaten(newTL);
        this.model.setSelTL(new ComboTeilelisteItem(newTL.getID(), newTL.getID(), newTL.getNutzerID(), newTL.getFiliale(), newTL.getMarke()));
        Vector<Teil> cTeile = this.model.getTeile();
        if (cTeile == null) {
            cTeile = new Vector();
            this.model.setTeile(cTeile);
        }
        Vector<ComboTeilelisteItem> aTL = this.model.getTLZurAuswahl();
        aTL.add(this.model.getSelTL());
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected boolean saveTeileliste() {
        log.debug((Object)"Performing saveTeileliste");
        Teileliste oTeileliste = this.model.getTLDaten();
        if (oTeileliste == null) {
            return false;
        }
        if (oTeileliste.getSapStatus() == null || oTeileliste.getSapStatus().length() < 1) {
            oTeileliste.setSapStatus("N");
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setIgdom(true);
        trfTL.setValue("teileliste", oTeileliste);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAVE_TEILELISTE_KOPFDATEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgSapRrListeController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerSpeichernTeileliste() + ": " + ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        return true;
    }
}

