/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import webetk.app.ValueAndNameSupport;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.RrNutzerdaten;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeController;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.HeaderRenderer;
import webetk.javaclient.generictable.IconAndTooltip;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;

public class DlgSapRrListeView
extends AbstractDialogView
implements Printable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgSapRrListeView.class);
    private DlgSapRrListeModel model;
    private ArrayList<JComponent> menuCollection = new ArrayList();
    private JPopupMenu popupMenu;
    private JMenuItem popupActionTeileinfo = null;
    private JMenuItem popupActionTeileverwendungTeil = null;
    private JMenuItem popupActionInterpretation = null;
    private JMenuItem popupActionEinzelteile = null;
    private JMenuItem popupActionBearbeiten;
    private JMenuItem popupActionLoeschen;
    private JMenuItem popupActionCopySachnummer = null;
    private JPanel headerPanel;
    private JPanel teilelistePanel;
    private JPanel posteilelistePanel;
    private JButtonEx buttonAnfrage;
    private JButtonEx buttonBestellung;
    private JButtonEx buttonNeu;
    private JButtonEx buttonListeNeu;
    private JButtonEx buttonListeLeeren;
    private JButtonEx buttonAktualisieren;
    private JLabel txtVin;
    private JTextField txtVinWert;
    private JLabel txtPrio;
    private JComboBox cbPrioWert;
    private JLabel txtBestellnummer;
    private JLabel txtBestellnummerWert;
    private JLabel txtNutzerName;
    private JTextField txtNutzerNameWert;
    private JLabel txtNutzerTel;
    private JTextField txtNutzerTelWert;
    private JLabel txtNutzerMail;
    private JTextField txtNutzerMailWert;
    private JLabel txtHaendlerNr;
    private JTextField txtHaendlerNrWert;
    private JTextArea mTaHistorie;
    private JComboBox cbTeilelisten;
    private boolean mbHandleSelChangeCbTeilelisten = true;
    private GenericTable mtable;
    private GenericTableModel mtabmodel;
    private DlgSapRrListeController moController;
    private int mnColInfo = -1;
    private int mnColEdit = -1;
    private int mnColDel = -1;
    private int mnColPos = -1;
    private int mnColTeilenummer = -1;
    private int mnColBenennung = -1;
    private int mnColBemerkung = -1;
    private JButtonEx mbUpPos;
    private JButtonEx mbDownPos;
    private JButtonEx mbUpTeilenummer;
    private JButtonEx mbDownTeilenummer;
    private JButtonEx mbUpBenennung;
    private JButtonEx mbDownBenennung;
    private JButtonEx mbUpBemerkung;
    private JButtonEx mbDownBemerkung;
    private int mnPrintRow;
    private int mnPrintOInd;
    private int mPrintLastPageIndex;
    private int mnSortierung = 0;
    private boolean mbSortierungAsc = true;

    private void initComponents() {
        this.initMenus();
        this.headerPanel = new HeaderPanel(Resource.getInstance().getRrSap(), ImageCache.getInstance().getHeaderIcon("bestell"));
        this.teilelistePanel = new TitledPanel(Resource.getInstance().getRrSapListeEdit());
        this.posteilelistePanel = new TitledPanel(Resource.getInstance().getRrSapPosEdit());
        this.buttonListeNeu = new JButtonEx(Resource.getInstance().getNeueListe(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonListeNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.setzeKopfdatenInModel();
                DlgSapRrListeView.this.moController.handleNewListe();
            }
        });
        this.buttonNeu = new JButtonEx(Resource.getInstance().getTeilHinzufuegen(), ImageCache.getInstance().getIcon("bi_teilhinzufuegen.jpg"));
        this.buttonNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.moController.handleNewTeil();
            }
        });
        this.buttonAnfrage = new JButtonEx(Resource.getInstance().getAnfrageAnSap(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonAnfrage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.setzeKopfdatenInModel();
                if (!DlgSapRrListeView.this.checkHaendlernummer()) {
                    return;
                }
                DlgSapRrListeView.this.moController.handleSendeAnfrage();
            }
        });
        this.buttonBestellung = new JButtonEx(Resource.getInstance().getBestellung(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonBestellung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.setzeKopfdatenInModel();
                if (!DlgSapRrListeView.this.checkHaendlernummer()) {
                    return;
                }
                if (!DlgSapRrListeView.this.checkVin()) {
                    return;
                }
                DlgSapRrListeView.this.moController.handleSendeBestellung();
            }
        });
        this.buttonAktualisieren = new JButtonEx(Resource.getInstance().getAktualisieren(), ImageCache.getInstance().getIcon("reload.gif"));
        this.buttonAktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.moController.handleAktualisieren();
            }
        });
        this.buttonListeLeeren = new JButtonEx(Resource.getInstance().getListeLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonListeLeeren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.moController.handleListeLoeschen();
            }
        });
        this.cbTeilelisten = new JComboBox();
        this.cbTeilelisten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgSapRrListeView.this.mbHandleSelChangeCbTeilelisten) {
                    ComboTeilelisteItem newItem = (ComboTeilelisteItem)DlgSapRrListeView.this.cbTeilelisten.getSelectedItem();
                    ComboTeilelisteItem oldItem = DlgSapRrListeView.this.model.getSelTL();
                    if (newItem == null || newItem.equals(oldItem)) {
                        return;
                    }
                    DlgSapRrListeView.this.setzeKopfdatenInModel();
                    DlgSapRrListeView.this.mbHandleSelChangeCbTeilelisten = false;
                    ComboTeilelisteItem oNewTL = (ComboTeilelisteItem)DlgSapRrListeView.this.cbTeilelisten.getSelectedItem();
                    DlgSapRrListeView.this.moController.handleSelChangeCbTeilelisten(oNewTL.getID());
                    DlgSapRrListeView.this.mbHandleSelChangeCbTeilelisten = true;
                }
            }
        });
        this.txtVin = new JLabel(Resource.getInstance().getFahrgestellnummer());
        this.txtVinWert = new LimitedTextField(17);
        this.txtPrio = new JLabel(Resource.getInstance().getDringlichkeit());
        this.cbPrioWert = new JComboBox();
        ValueAndNameSupport item = new ValueAndNameSupport("VOR", Resource.getInstance().getVor());
        this.cbPrioWert.addItem(item);
        item = new ValueAndNameSupport("urgent", Resource.getInstance().getRush());
        this.cbPrioWert.addItem(item);
        item = new ValueAndNameSupport("Stock", Resource.getInstance().getStock());
        this.cbPrioWert.addItem(item);
        this.txtBestellnummer = new JLabel(Resource.getInstance().getSapBestellNr());
        this.txtBestellnummerWert = new JLabel("");
        this.txtNutzerName = new JLabel(Resource.getInstance().getNameOhneKlammern());
        this.txtNutzerNameWert = new LimitedTextField(50, 20);
        this.txtNutzerTel = new JLabel(Resource.getInstance().getTelefon());
        this.txtNutzerTelWert = new LimitedTextField(20, 15);
        this.txtNutzerMail = new JLabel(Resource.getInstance().getEmail());
        this.txtNutzerMailWert = new LimitedTextField(50, 35);
        this.txtHaendlerNr = new JLabel(Resource.getInstance().getHaendlernummer());
        this.txtHaendlerNrWert = new LimitedTextField(5, 5);
        if (!GlobalObjects.getInstance().usesIntranet()) {
            this.txtHaendlerNrWert.setEditable(false);
        }
        this.mTaHistorie = new JTextArea();
        this.mbUpPos = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(0, true);
            }
        });
        this.mbDownPos = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(0, false);
            }
        });
        this.mbUpTeilenummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(1, true);
            }
        });
        this.mbDownTeilenummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(1, false);
            }
        });
        this.mbUpBenennung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBenennung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(2, true);
            }
        });
        this.mbDownBenennung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBenennung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(2, false);
            }
        });
        this.mbUpBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(5, true);
            }
        });
        this.mbDownBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.handleClick(5, false);
            }
        });
        this.createLayout();
        this.update();
    }

    private boolean checkHaendlernummer() {
        if (this.model.getTLDaten().getRrNutzerdaten().getHaendlernummer().length() < 1) {
            String sMsg = null;
            sMsg = !this.txtHaendlerNrWert.isEditable() ? Resource.getInstance().getFehlerVerbindungAsap() : Resource.getInstance().getMsgNoHaendlernummer();
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getRrSap(), 0);
            return false;
        }
        return true;
    }

    private boolean checkVin() {
        if (!this.model.getTLDaten().getDringlichkeit().equals("Stock") || this.model.getTLDaten().hatMinEinTeilFertigungshinweis()) {
            if (this.model.getTLDaten().getVIN().length() != 7) {
                if (this.model.getTLDaten().getVIN().length() != 17) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFzgidInvalidFzgnr(), Resource.getInstance().getRrSap(), 0);
                }
                return false;
            }
        } else if (this.model.getTLDaten().getVIN().length() > 0 && this.model.getTLDaten().getVIN().length() != 7) {
            if (this.model.getTLDaten().getVIN().length() != 17) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFzgidInvalidFzgnr(), Resource.getInstance().getRrSap(), 0);
            }
            return false;
        }
        return true;
    }

    @Override
    public void initMenus() {
        this.menuCollection.clear();
        JMenu menu = new JMenu(Resource.getInstance().getRrSap());
        menu.setBackground(UIHelper.getDarkerBackground());
        menu.add(this.createPrintMenuItem(Resource.getInstance().getDrucken()));
        this.menuCollection.add(menu);
        this.popupMenu = new JPopupMenu();
        this.popupActionTeileinfo = new MenuItemTeileinformation(this);
        this.popupMenu.add(this.popupActionTeileinfo);
        this.popupActionTeileverwendungTeil = new MenuItemTeileverwendungTeil("bestellliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionTeileverwendungTeil);
        this.popupActionInterpretation = new MenuItemInterpretation("bestellliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionInterpretation);
        this.popupActionEinzelteile = new MenuItemEinzelteile("bestellliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionEinzelteile);
        this.popupMenu.addSeparator();
        this.popupActionBearbeiten = new JMenuItem(Resource.getInstance().getMarkiertesTeilBearbeiten() + "...");
        this.popupActionBearbeiten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector aSelTeile = DlgSapRrListeView.this.getSelTeileFromTab();
                DlgSapRrListeView.this.moController.handleEditTeile(aSelTeile);
            }
        });
        this.popupMenu.add(this.popupActionBearbeiten);
        this.popupActionLoeschen = new JMenuItem(Resource.getInstance().getLoeschen());
        this.popupMenu.add(this.popupActionLoeschen);
        this.popupActionLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector aSelTeile = DlgSapRrListeView.this.getSelTeileFromTab();
                DlgSapRrListeView.this.moController.handleDeleteTeile(aSelTeile);
            }
        });
        this.popupActionCopySachnummer = new MenuItemCopySachnummer(this);
        this.popupMenu.add(this.popupActionCopySachnummer);
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"init");
        this.model = (DlgSapRrListeModel)oDlgModel;
        this.moController = (DlgSapRrListeController)oController;
        this.initComponents();
    }

    @Override
    public void update() {
        this.mbHandleSelChangeCbTeilelisten = false;
        this.cbTeilelisten.removeAllItems();
        Vector<ComboTeilelisteItem> aItems = this.model.getTLZurAuswahl();
        if (aItems != null) {
            for (int ii = 0; ii < aItems.size(); ++ii) {
                this.cbTeilelisten.addItem(aItems.get(ii));
            }
            if (this.model.getSelTLID() != null) {
                this.cbTeilelisten.setSelectedIndex(this.model.getSelTLIndex());
            }
        }
        this.mbHandleSelChangeCbTeilelisten = true;
        if (this.model.getTLDaten() == null) {
            RrNutzerdaten oNutzerdaten = this.model.getNutzerdaten();
            if (oNutzerdaten != null) {
                this.txtNutzerNameWert.setText(oNutzerdaten.getNutzerName());
                this.txtNutzerTelWert.setText(oNutzerdaten.getNutzerTelefon());
                this.txtNutzerMailWert.setText(oNutzerdaten.getNutzerEMail());
                this.txtHaendlerNrWert.setText(oNutzerdaten.getHaendlernummer());
            } else {
                this.txtNutzerNameWert.setText("");
                this.txtNutzerTelWert.setText("");
                this.txtNutzerMailWert.setText("");
                this.txtHaendlerNrWert.setText("");
            }
            this.txtVinWert.setText("");
            this.mTaHistorie.setText("");
            this.cbPrioWert.setSelectedIndex(1);
            this.mtabmodel.removeAllRows();
            this.buttonAnfrage.setEnabled(false);
            this.buttonBestellung.setEnabled(false);
            this.buttonNeu.setEnabled(false);
            this.buttonListeLeeren.setEnabled(false);
            this.buttonAktualisieren.setEnabled(false);
        } else {
            boolean bHatNetz = GlobalObjects.getInstance().hasNetz();
            boolean bIntranet = GlobalObjects.getInstance().usesIntranet();
            if (this.model.getTLDaten().getSapBestellung()) {
                this.buttonListeLeeren.setEnabled(true);
                this.buttonAnfrage.setEnabled(false);
                this.buttonBestellung.setEnabled(false);
                this.buttonNeu.setVisible(false);
            } else {
                this.buttonListeLeeren.setEnabled(true);
                this.buttonAnfrage.setEnabled(bHatNetz);
                this.buttonBestellung.setEnabled(bHatNetz && !bIntranet);
                this.buttonNeu.setVisible(true);
                this.buttonNeu.setEnabled(true);
            }
            String sStatus = this.model.getTLDaten().getSapStatus();
            if (sStatus != null && (sStatus.equals("B") || sStatus.equals("A"))) {
                this.buttonAktualisieren.setEnabled(bHatNetz);
            } else {
                this.buttonAktualisieren.setEnabled(false);
            }
            RrNutzerdaten oNutzerdaten = this.model.getTLDaten().getRrNutzerdaten();
            this.txtNutzerNameWert.setText(oNutzerdaten.getNutzerName());
            this.txtNutzerTelWert.setText(oNutzerdaten.getNutzerTelefon());
            this.txtNutzerMailWert.setText(oNutzerdaten.getNutzerEMail());
            this.txtHaendlerNrWert.setText(oNutzerdaten.getHaendlernummer());
            this.txtVinWert.setText(this.model.getTLDaten().getVIN());
            this.txtBestellnummerWert.setText(this.model.getTLDaten().getSapOrderNo());
            this.mTaHistorie.setText(this.model.getTLDaten().getHistory());
            this.mTaHistorie.setCaretPosition(0);
            for (int ii = 0; ii < this.cbPrioWert.getItemCount(); ++ii) {
                ValueAndNameSupport item = (ValueAndNameSupport)this.cbPrioWert.getItemAt(ii);
                if (!item.getValue().equals(this.model.getTLDaten().getDringlichkeit())) continue;
                this.cbPrioWert.setSelectedIndex(ii);
            }
            this.updateTabellenInhalt();
        }
    }

    private void updateTabellenInhalt() {
        this.mtabmodel.removeAllRows();
        Teileliste oTLDaten = this.model.getTLDaten();
        Vector<Teil> aTeile = oTLDaten.getTeile();
        if (aTeile != null) {
            aTeile = this.mnSortierung == 0 && this.mbSortierungAsc ? oTLDaten.getTeile() : oTLDaten.getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
            for (Teil oTeil : aTeile) {
                IconAndTooltip oVerfuegbar = null;
                String sapVerfuegbarkeit = oTeil.getSapVerfuegbarkeit();
                if (sapVerfuegbarkeit != null) {
                    switch (sapVerfuegbarkeit) {
                        case "AMB_US": {
                            oVerfuegbar = new IconAndTooltip(ImageCache.getInstance().getIcon("us_nok.png"), Resource.getInstance().getNichtVerfuegbar());
                            break;
                        }
                        case "GRE_US": {
                            oVerfuegbar = new IconAndTooltip(ImageCache.getInstance().getIcon("us_ok.png"), Resource.getInstance().getVerfuegbar());
                            break;
                        }
                        case "AMBER": {
                            oVerfuegbar = new IconAndTooltip(ImageCache.getInstance().getIcon("uk_nok.png"), Resource.getInstance().getKeineInformationVorhanden());
                            break;
                        }
                        case "RED": {
                            oVerfuegbar = new IconAndTooltip(ImageCache.getInstance().getIcon("delete.gif"), Resource.getInstance().getNichtVerfuegbar());
                            break;
                        }
                        case "GREEN": {
                            oVerfuegbar = new IconAndTooltip(ImageCache.getInstance().getIcon("uk_ok.png"), Resource.getInstance().getVerfuegbar());
                            break;
                        }
                        default: {
                            oVerfuegbar = null;
                        }
                    }
                }
                IconAndTooltip info = new IconAndTooltip(ImageCache.getInstance().getIcon("info.gif"), Resource.getInstance().getTeileinformation());
                IconAndTooltip edit = null;
                IconAndTooltip del = null;
                if (!this.model.getTLDaten().getSapBestellung()) {
                    edit = new IconAndTooltip(ImageCache.getInstance().getIcon("teil_bearbeiten.jpg"), Resource.getInstance().getTeilBearbeiten());
                    del = new IconAndTooltip(ImageCache.getInstance().getIcon("trashbin.gif"), Resource.getInstance().getLoeschen());
                }
                this.mtabmodel.addRow(new AbstractRow(new Object[]{info, edit, del, oTeil.getPos(), oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), oVerfuegbar, oTeil.getSapPreisString(), oTeil.getSapKodierungsstufe(), oTeil.getBemerkung()}));
            }
            this.mtabmodel.addRow(new AbstractRow(new Object[]{null, null, null, "", "", "", "", "", null, Resource.getInstance().getRrpTotal(), Resource.getInstance().getDealerNetto(), ""}));
            if (this.model.getTLDaten().getSapAnfrage() && this.model.getTLDaten().getSapStatus() != null && this.model.getTLDaten().getSapStatus().equals("N")) {
                this.mtabmodel.addRow(new AbstractRow(new Object[]{null, null, null, "", "", "", "", "", null, oTLDaten.ermittleSummeSapPreisOhneRabatt(), oTLDaten.getSapPreisSumme(), ""}));
                this.mtable.changeHeaderText(9, Resource.getInstance().getRrp() + " " + oTLDaten.getSapWaehrung());
            } else {
                this.mtabmodel.addRow(new AbstractRow(new Object[]{null, null, null, "", "", "", "", "", null, "", "", ""}));
                this.mtable.changeHeaderText(9, Resource.getInstance().getRrp());
            }
        }
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createTeilelistePanel(), c.rc(1, 1));
        contentPanel.add((Component)this.createPosTeilelistePanel(), c.rc(3, 1));
        return contentPanel;
    }

    private JPanel createTeilelistePanel() {
        int[] w_teileliste = new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10, -12, 10, -10, 10};
        int[] h_teileliste = new int[]{10, 0, 10, 0, 10, 5, 5, 0, 10, 0, 10, 5, 5, 0, 10};
        HIGLayout layoutTeileliste = new HIGLayout(w_teileliste, h_teileliste);
        layoutTeileliste.setColumnWeight(8, 1);
        HIGConstraints c = new HIGConstraints();
        this.teilelistePanel.setLayout(layoutTeileliste);
        this.teilelistePanel.add((Component)this.createNutzerpanel(), c.rcwh(2, 2, 11, 1));
        this.teilelistePanel.add((Component)new JLabel(Resource.getInstance().getTeileliste()), c.rc(4, 2));
        this.teilelistePanel.add((Component)this.cbTeilelisten, c.rc(4, 4));
        this.teilelistePanel.add((Component)this.buttonListeNeu, c.rc(4, 6));
        this.teilelistePanel.add((Component)this.txtVin, c.rc(8, 2));
        this.teilelistePanel.add((Component)this.txtVinWert, c.rc(8, 4));
        this.teilelistePanel.add((Component)this.txtPrio, c.rc(10, 2));
        this.teilelistePanel.add((Component)this.cbPrioWert, c.rc(10, 4));
        this.teilelistePanel.add((Component)this.createHistorienPanel(), c.rcwh(6, 6, 7, 7));
        this.teilelistePanel.add((Component)this.buttonAnfrage, c.rc(14, 2));
        this.teilelistePanel.add((Component)this.buttonBestellung, c.rc(14, 4));
        this.teilelistePanel.add((Component)this.txtBestellnummer, c.rc(14, 6));
        this.teilelistePanel.add((Component)this.txtBestellnummerWert, c.rc(14, 8));
        this.teilelistePanel.add((Component)this.buttonAktualisieren, c.rc(14, 10));
        this.teilelistePanel.add((Component)this.buttonListeLeeren, c.rc(14, 12));
        return this.teilelistePanel;
    }

    private JPanel createNutzerpanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getNutzer());
        int[] w_panel = new int[]{10, 0, 5, 0, 10, 0, 5, 0, 10, 0, 5, 0, 10, 0, 5, 0, 10};
        int[] h_panel = new int[]{5, 0, 5};
        HIGLayout layout = new HIGLayout(w_panel, h_panel);
        layout.setColumnWeight(17, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(layout);
        panel.add((Component)this.txtNutzerName, c.rc(2, 2));
        panel.add((Component)this.txtNutzerNameWert, c.rc(2, 4));
        panel.add((Component)this.txtNutzerTel, c.rc(2, 6));
        panel.add((Component)this.txtNutzerTelWert, c.rc(2, 8));
        panel.add((Component)this.txtNutzerMail, c.rc(2, 10));
        panel.add((Component)this.txtNutzerMailWert, c.rc(2, 12));
        panel.add((Component)this.txtHaendlerNr, c.rc(2, 14));
        panel.add((Component)this.txtHaendlerNrWert, c.rc(2, 16));
        return panel;
    }

    private JPanel createHistorienPanel() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getHistorie());
        Dimension dim = new Dimension(600, 70);
        p.setPreferredSize(dim);
        int[] w1 = new int[]{5, dim.width - 10, 5};
        int[] h1 = new int[]{1, dim.height - 20, 5};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        p.setLayout(l);
        this.mTaHistorie.setBackground(this.getBackground());
        this.mTaHistorie.setEditable(false);
        this.mTaHistorie.setLineWrap(true);
        this.mTaHistorie.setWrapStyleWord(true);
        this.mTaHistorie.setFont(UIHelper.getNormalFont());
        this.mTaHistorie.setForeground(Color.black);
        this.mTaHistorie.setEnabled(false);
        this.mTaHistorie.setDisabledTextColor(Color.black);
        JScrollPane scOthers = new JScrollPane(this.mTaHistorie);
        scOthers.setBorder(null);
        p.add((Component)scOthers, c.rc(2, 2, "tlrb"));
        return p;
    }

    private JPanel createPosTeilelistePanel() {
        int[] w_posteileliste = new int[]{10, -4, 10, -2, 10, 0, 10};
        int[] h_posteileliste = new int[]{10, 0, 14, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(w_posteileliste, h_posteileliste);
        layoutPosTeileliste.setColumnWeight(6, 1);
        layoutPosTeileliste.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.posteilelistePanel.setLayout(layoutPosTeileliste);
        this.posteilelistePanel.add((Component)this.buttonNeu, c.rc(2, 2, "lr"));
        this.posteilelistePanel.add((Component)this.createTabelle(), c.rcwh(4, 2, 5, 1));
        return this.posteilelistePanel;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        this.mnColInfo = -1;
        this.mnColEdit = -1;
        this.mnColDel = -1;
        this.mnColPos = -1;
        this.mnColTeilenummer = -1;
        this.mnColBenennung = -1;
        this.mnColBemerkung = -1;
        tableConfig.setHasButtons(true);
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        this.mnColInfo = nCol++;
        tableConfig.addIconColumn("teil_bearbeiten.jpg", Resource.getInstance().getTeilBearbeiten());
        this.mnColEdit = nCol++;
        tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
        this.mnColDel = nCol++;
        tableConfig.addColumn(Resource.getInstance().getPos(), 0, false, "XXXXX");
        tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getPosition());
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpPos);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownPos);
        this.mnColPos = nCol++;
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXX");
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpTeilenummer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownTeilenummer);
        this.mnColTeilenummer = nCol++;
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpBenennung);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownBenennung);
        this.mnColBenennung = nCol++;
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getMe(), 4, false, "X000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getMenge());
        tableConfig.addIconColumn(null, Resource.getInstance().getNueStk(), null);
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getStock());
        tableConfig.addColumn(Resource.getInstance().getRrp(), 4, true, "000000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getUnverbindlichePreisempfehlung());
        tableConfig.addColumn(Resource.getInstance().getNueProz(), 4, true, "XXXXXXXX");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getHaendlerRabatt());
        tableConfig.addColumn(Resource.getInstance().getBemerkung(), 2, true, "XXXXXXXXXXXXXXXYYY");
        tableConfig.setHeaderButtonLeft(++nCol, this.mbUpBemerkung);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownBemerkung);
        this.mnColBemerkung = nCol;
        tableConfig.setUsePrototypeIcons(false);
        this.mtabmodel = new GenericTableModel(tableConfig);
        this.mtable = new GenericTable(this.mtabmodel);
        this.mtable.getColumnModel().getColumn(0).setMinWidth(20);
        this.mtable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.mtable.getColumnModel().getColumn(0).setWidth(20);
        this.mtable.getColumnModel().getColumn(1).setMinWidth(20);
        this.mtable.getColumnModel().getColumn(1).setMaxWidth(20);
        this.mtable.getColumnModel().getColumn(1).setWidth(20);
        this.mtable.getColumnModel().getColumn(2).setMinWidth(20);
        this.mtable.getColumnModel().getColumn(2).setMaxWidth(20);
        this.mtable.getColumnModel().getColumn(2).setWidth(20);
        this.mtable.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                Vector aSelTeile = DlgSapRrListeView.this.getSelTeileFromTab();
                if (aSelTeile.size() > 0) {
                    DlgSapRrListeView.this.popupMenu.show(DlgSapRrListeView.this.mtable, evt.getX(), evt.getY());
                    if (aSelTeile.size() > 1) {
                        DlgSapRrListeView.this.popupActionCopySachnummer.setEnabled(false);
                        DlgSapRrListeView.this.popupActionTeileverwendungTeil.setEnabled(false);
                        DlgSapRrListeView.this.popupActionInterpretation.setEnabled(false);
                        DlgSapRrListeView.this.popupActionEinzelteile.setEnabled(false);
                        DlgSapRrListeView.this.popupActionTeileinfo.setEnabled(false);
                    } else {
                        Teil oTeil = (Teil)aSelTeile.get(0);
                        if (oTeil.getLokalteil()) {
                            DlgSapRrListeView.this.popupActionTeileverwendungTeil.setEnabled(false);
                            DlgSapRrListeView.this.popupActionEinzelteile.setEnabled(false);
                            DlgSapRrListeView.this.popupActionInterpretation.setEnabled(false);
                        } else {
                            DlgSapRrListeView.this.popupActionTeileverwendungTeil.setEnabled(true);
                            DlgSapRrListeView.this.popupActionEinzelteile.setEnabled(((MenuItemEinzelteile)DlgSapRrListeView.this.popupActionEinzelteile).hatEinzelteile());
                            DlgSapRrListeView.this.popupActionInterpretation.setEnabled(((MenuItemInterpretation)DlgSapRrListeView.this.popupActionInterpretation).hatInterpretation());
                        }
                        DlgSapRrListeView.this.popupActionTeileinfo.setEnabled(true);
                        DlgSapRrListeView.this.popupActionCopySachnummer.setEnabled(true);
                        DlgSapRrListeView.this.popupActionBearbeiten.setEnabled(true);
                    }
                    if (DlgSapRrListeView.this.model.getTLDaten() != null && DlgSapRrListeView.this.model.getTLDaten().getSapBestellung()) {
                        DlgSapRrListeView.this.popupActionLoeschen.setEnabled(false);
                        DlgSapRrListeView.this.popupActionBearbeiten.setEnabled(false);
                    }
                }
            }

            @Override
            public void clickedOnCell(GenericTableMouseEvent evt) {
                boolean bBestellung = DlgSapRrListeView.this.model.getTLDaten() != null && DlgSapRrListeView.this.model.getTLDaten().getSapBestellung();
                Teil oTeil = null;
                int nCol = evt.getColumn();
                Vector<Teil> aTeile = DlgSapRrListeView.this.model.getTLDaten().getTeile();
                if (evt.getRow() < aTeile.size()) {
                    oTeil = aTeile.get(evt.getRow());
                }
                if (oTeil != null) {
                    if (nCol == DlgSapRrListeView.this.mnColInfo) {
                        DlgSapRrListeView.this.moController.handleTeileinfo(oTeil);
                    } else if (nCol == DlgSapRrListeView.this.mnColEdit) {
                        if (bBestellung) {
                            return;
                        }
                        Vector<Teil> cSelTeile = new Vector<Teil>();
                        cSelTeile.add(oTeil);
                        DlgSapRrListeView.this.moController.handleEditTeile(cSelTeile);
                    } else if (nCol == DlgSapRrListeView.this.mnColDel) {
                        if (bBestellung) {
                            return;
                        }
                        oTeil = new Teil();
                        oTeil.setPos(evt.getRow() + 1);
                        Vector<Teil> cSelTeile = new Vector<Teil>();
                        cSelTeile.add(oTeil);
                        DlgSapRrListeView.this.moController.handleDeleteTeile(cSelTeile);
                    }
                }
            }
        });
        final JTableHeader th = this.mtable.getTableHeader();
        th.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                int col = th.columnAtPoint(ev.getPoint());
                TableColumn column = DlgSapRrListeView.this.mtable.getColumnModel().getColumn(col);
                HeaderRenderer renderer = (HeaderRenderer)column.getHeaderRenderer();
                if (renderer.handleClick(DlgSapRrListeView.this.mtable, ev)) {
                    return;
                }
                if (col == DlgSapRrListeView.this.mnColPos) {
                    this.handleClick(0);
                } else if (col == DlgSapRrListeView.this.mnColTeilenummer) {
                    this.handleClick(1);
                } else if (col == DlgSapRrListeView.this.mnColBenennung) {
                    this.handleClick(2);
                } else if (col == DlgSapRrListeView.this.mnColBemerkung) {
                    this.handleClick(5);
                }
            }

            private void handleClick(int comp) {
                if (DlgSapRrListeView.this.mnSortierung == comp) {
                    DlgSapRrListeView.this.mbSortierungAsc = !DlgSapRrListeView.this.mbSortierungAsc;
                } else {
                    DlgSapRrListeView.this.mbSortierungAsc = true;
                }
                DlgSapRrListeView.this.mnSortierung = comp;
                DlgSapRrListeView.this.updateTabellenInhalt();
            }
        });
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        return this.mtable.getScrollPane();
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuCollection.iterator();
    }

    private Vector<Teil> getSelTeileFromTab() {
        Vector<Teil> aSelTeile = new Vector<Teil>();
        int[] aRows = this.mtable.getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            Vector<Teil> aTeile = this.model.getTLDaten().getTeile();
            if (aRows[ii] >= aTeile.size()) continue;
            Teil oTeil = aTeile.get(aRows[ii]);
            aSelTeile.add(oTeil);
        }
        return aSelTeile;
    }

    private JMenuItem createPrintMenuItem(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSapRrListeView.this.print();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    private void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        pageFormat.setOrientation(0);
        printJob.setPrintable(this, pageFormat);
        printJob.setJobName(Resource.getInstance().getRrSap());
        this.mnPrintOInd = 0;
        this.mnPrintRow = 0;
        this.mPrintLastPageIndex = -1;
        if (printJob.printDialog()) {
            pageFormat.setOrientation(0);
            printJob.setPrintable(this, pageFormat);
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.mPrintLastPageIndex == pageIndex) {
            this.mnPrintRow = this.mnPrintOInd;
        } else {
            this.mPrintLastPageIndex = pageIndex;
            this.mnPrintOInd = this.mnPrintRow;
        }
        if (this.mnPrintRow >= this.mtabmodel.getRowCount()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int maxWidth = (int)pageFormat.getImageableWidth() - 1;
        int maxHeight = (int)pageFormat.getImageableHeight() - 2;
        Font headlinefont = UIHelper.getPrintTitleFont();
        Font textfont = UIHelper.getPrintFont();
        int xPosition = 0;
        int yPosition = 0;
        int secondColPosition = 475;
        int nMiddlePosition = (int)(pageFormat.getImageableWidth() / 2.0);
        g2d.setFont(headlinefont);
        int fontSize = headlinefont.getSize();
        if (pageIndex == 0) {
            yPosition = fontSize;
            String sUeberschrift = Resource.getInstance().getRrSap();
            g2d.drawString(sUeberschrift, nMiddlePosition - sUeberschrift.length() * 3, yPosition);
        }
        yPosition += 20;
        g2d.setFont(textfont);
        fontSize = textfont.getSize();
        g2d.drawString(Resource.getInstance().getSeite() + ": " + (pageIndex + 1), secondColPosition, yPosition += fontSize);
        Date currentDate = new Date();
        g2d.drawString(Resource.getInstance().getDatumZeit() + ": " + DateFormat.getDateTimeInstance().format(currentDate), secondColPosition, yPosition += fontSize);
        boolean left = false;
        boolean right = true;
        String[] tableHeaderStrings = null;
        String[] printHeaderStrings = null;
        int[] columnBegin = null;
        int[] columnEnd = null;
        int[] columnFormat = null;
        String sPreisHeader = Resource.getInstance().getRrp();
        if (this.model.getTLDaten() != null && this.model.getTLDaten().getSapAnfrage() && this.model.getTLDaten().getSapStatus() != null && this.model.getTLDaten().getSapStatus().equals("E")) {
            sPreisHeader = sPreisHeader + " " + this.model.getTLDaten().getSapWaehrung();
        }
        tableHeaderStrings = new String[]{Resource.getInstance().getPos(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getMe(), Resource.getInstance().getNueStk(), Resource.getInstance().getRrp(), Resource.getInstance().getNueProz(), Resource.getInstance().getBemerkung()};
        printHeaderStrings = new String[]{Resource.getInstance().getPos() + ".", Resource.getInstance().getTeilenummer(), Resource.getInstance().getBenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getMenge(), Resource.getInstance().getStock(), sPreisHeader, Resource.getInstance().getNueProz(), Resource.getInstance().getBemerkung()};
        columnBegin = new int[]{0, 35, 120, 340, 405, 445, 485, 555, 625};
        columnEnd = new int[]{24, 109, 329, 394, 434, 474, 544, 614, maxWidth - 5};
        columnFormat = new int[]{1, 0, 0, 0, 1, 0, 1, 1, 0};
        if (this.mnPrintRow < this.mtabmodel.getRowCount()) {
            yPosition += 30;
            for (int i = 0; i < printHeaderStrings.length; ++i) {
                if (columnFormat[i] == 0) {
                    g2d.drawString(printHeaderStrings[i], xPosition + columnBegin[i], yPosition);
                    continue;
                }
                String value = printHeaderStrings[i];
                g2d.drawString(value, xPosition + this.getPosition(value, columnEnd[i], g2d, textfont), yPosition);
            }
            yPosition += fontSize;
            while (this.mnPrintRow < this.mtabmodel.getRowCount()) {
                int nOffset = 0;
                if ((yPosition += fontSize) + fontSize > maxHeight) {
                    return 0;
                }
                for (int i = 0; i < this.mtabmodel.getColumnCount(); ++i) {
                    for (int j = 0; j < tableHeaderStrings.length; ++j) {
                        CharSequence value;
                        if (!this.mtabmodel.getConfiguration().getColumnName(i).equals(tableHeaderStrings[j])) continue;
                        if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilenummer())) {
                            value = new StringBuffer(this.mtabmodel.getValueAt(this.mnPrintRow, i).toString());
                            g2d.drawString(value.toString(), xPosition + columnBegin[j], yPosition);
                            continue;
                        }
                        if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilebenennung())) {
                            TextLayout layout;
                            value = this.mtabmodel.getValueAt(this.mnPrintRow, i).toString();
                            if (value == null || ((String)value).equals("")) {
                                value = " ";
                            }
                            AttributedString cellText = new AttributedString((String)value);
                            cellText.addAttribute(TextAttribute.FONT, textfont);
                            cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                            LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
                            boolean bFirstRow = true;
                            while ((layout = lineBreaker.nextLayout(columnEnd[j] - columnBegin[j])) != null) {
                                if (!bFirstRow) {
                                    nOffset += fontSize;
                                }
                                bFirstRow = false;
                                layout.draw(g2d, xPosition + columnBegin[j], yPosition + nOffset);
                            }
                            continue;
                        }
                        Image img = null;
                        String sValue = "";
                        Object oValue = this.mtabmodel.getValueAt(this.mnPrintRow, i);
                        if (oValue != null) {
                            if (oValue instanceof IconAndTooltip) {
                                IconAndTooltip iconTooltip = (IconAndTooltip)oValue;
                                ImageIcon icon = iconTooltip.getIcon();
                                img = icon.getImage();
                                img = img.getScaledInstance(-1, 12, 4);
                                MediaTracker tracker = new MediaTracker(this);
                                tracker.addImage(img, 0);
                                try {
                                    tracker.waitForID(0);
                                }
                                catch (Exception ex) {}
                            } else {
                                sValue = oValue.toString();
                            }
                        }
                        if (columnFormat[j] == 0) {
                            if (img != null) {
                                g2d.drawImage(img, xPosition + columnBegin[j], yPosition - fontSize, Color.WHITE, null);
                                continue;
                            }
                            g2d.drawString(sValue, xPosition + columnBegin[j], yPosition);
                            continue;
                        }
                        if (img != null) {
                            g2d.drawImage(img, xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), yPosition - fontSize, Color.WHITE, null);
                            continue;
                        }
                        g2d.drawString(sValue.replace(',', '.'), xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), yPosition);
                    }
                }
                yPosition += nOffset;
                ++this.mnPrintRow;
            }
        }
        if (maxHeight - yPosition < 60) {
            return 0;
        }
        return 0;
    }

    private int getPosition(String value, int endPosition, Graphics2D g2d, Font textfont) {
        if (value == null || value.equals("")) {
            value = " ";
        }
        AttributedString cellText = new AttributedString(value);
        cellText.addAttribute(TextAttribute.FONT, textfont);
        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
        TextLayout layout = lineBreaker.nextLayout(1000.0f);
        float lText = layout.getAdvance();
        int pX = endPosition - (int)lText;
        return pX;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        Vector<Teil> aSelTeile = this.getSelTeileFromTab();
        if (aSelTeile == null || aSelTeile.size() == 0) {
            return null;
        }
        Teil oTeil = aSelTeile.get(0);
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = oTeil.getSachnummer();
        String sTeilenummer = oTeil.getTeilenummerGespreizt();
        String sBenennungZusatz = oTeil.getBenennung();
        String sZusatz = oTeil.getZusatz();
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        Vector<String> aMarke = oTeil.getMarken();
        Teileliste oTeileliste = this.model.getTLDaten();
        String sMarkeTeileliste = null;
        if (oTeileliste != null) {
            sMarkeTeileliste = oTeileliste.getMarke();
        }
        String sMarke = null;
        sMarke = aMarke == null ? sMarkeTeileliste : GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeTeileliste);
        String sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    private void handleClick(int comp, boolean bAsc) {
        this.mbSortierungAsc = bAsc;
        this.mnSortierung = comp;
        this.updateTabellenInhalt();
    }

    public void setzeKopfdatenInModel() {
        Teileliste oTL = this.model.getTLDaten();
        if (oTL == null) {
            return;
        }
        RrNutzerdaten oNutzerdaten = oTL.getRrNutzerdaten();
        if (oNutzerdaten == null) {
            oNutzerdaten = new RrNutzerdaten();
        }
        oNutzerdaten.setNutzerName(this.txtNutzerNameWert.getText());
        oNutzerdaten.setNutzerTelefon(this.txtNutzerTelWert.getText());
        oNutzerdaten.setNutzerEMail(this.txtNutzerMailWert.getText());
        oNutzerdaten.setHaendlernummer(this.txtHaendlerNrWert.getText());
        ValueAndNameSupport item = (ValueAndNameSupport)this.cbPrioWert.getSelectedItem();
        oTL.setDringlichkeit(item.getValue());
        oTL.setVIN(this.txtVinWert.getText());
    }

    protected void requestFocusCbTeilelisten() {
        this.cbTeilelisten.requestFocus();
    }

    @Override
    public void onExit() {
        this.setzeKopfdatenInModel();
        this.moController.saveTeileliste();
    }
}

