/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.LoginInfo;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileliste.As2ClientScore;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.dialog.extras.teileliste.Druckausgabe;
import webetk.javaclient.dialog.extras.teileliste.FZZuordnung;
import webetk.javaclient.dialog.extras.teileliste.FaxAngaben;
import webetk.javaclient.dialog.extras.teileliste.MailAngaben;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.HeaderRenderer;
import webetk.javaclient.generictable.IconAndTooltip;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.mrkprd.Marken;
import webetk.resources.Resource;

public class DlgTeilelisteView
extends AbstractDialogView
implements Printable {
    private static Logger log = Logger.getLogger(DlgTeilelisteView.class);
    private DlgTeilelisteModel model;
    private DlgTeilelisteController moController;
    private ArrayList<JComponent> menuCollection = new ArrayList();
    private JPopupMenu popupMenu;
    private JMenuItem popupActionTeileinfo = null;
    private JMenuItem popupActionTeileverwendungTeil = null;
    private JMenuItem popupActionInterpretation = null;
    private JMenuItem popupActionEinzelteile = null;
    private JMenuItem popupActionStammsatz;
    private JMenuItem popupActionBearbeiten;
    private JMenuItem popupActionLoeschen;
    private JMenuItem popupActionCopySachnummer = null;
    private JMenuItem menuExportDatei;
    private JMenuItem menuExport;
    private JMenuItem menuImport;
    private JMenuItem menuKostenvoranschlag;
    private JMenuItem menuBarverkauf;
    private JMenuItem menuWerkstattauftrag;
    private JMenuItem menuitemZurueckZuBT = null;
    private JPanel headerPanel;
    private JPanel teilelistePanel;
    private JPanel posteilelistePanel;
    private JComponent tabelleComponent;
    private JPanel teilelisteButtonPanel;
    private JLabel txtTeileliste;
    private JLabel txtInTeileliste;
    private JLabel txtTeilelisteGewaehltWert;
    private JLabel txtTeilelisteGewaehltWert2;
    private JLabel txtTeilelisteGewaehlt;
    private JTextField tfTeilelisteNeu;
    private JLabel txtBemerkung;
    private JLabel txtBemerkungWert;
    private JTextField tfBemerkung;
    private JLabel txtErstelltAm;
    private JLabel txtErstelltAmWert;
    private JLabel txtGeaendertAm;
    private JLabel txtGeaendertAmWert;
    private JComboBox cbTeilelisten;
    private boolean mbHandleSelChangeCbTeilelisten = true;
    private JButtonEx buttonSpeichern;
    private JButtonEx buttonLoeschen;
    private JLabel txtAuftragsNr;
    private JTextField txtAuftragsNrWert;
    private JLabel tfAuftragsNr;
    private JLabel txtKundenNr;
    private JTextField txtKundenNrWert;
    private JLabel tfKundenNr;
    private JLabel txtKundenName;
    private JLabel tfKundenName;
    private JLabel txtSummeBruttoPrompt;
    private JLabel txtSummeBruttoWert;
    private JLabel txtSummeNettoPrompt;
    private JLabel txtSummeNettoWert;
    private JLabel txtRabatt;
    private JTextField tfRabatt;
    private JLabel txtFIStringPrompt;
    private JLabel txtFIString;
    private JCheckBox chkPrivat;
    private JComboBox cbInTeileliste;
    private JButtonEx buttonNeu;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonDatenAbgleich;
    private JButtonEx buttonDMSDirect;
    private JButtonEx buttonSendAs2;
    private JButtonEx buttonTransfer;
    private JButtonEx buttonEigentAendern;
    private JButtonEx buttonFzgUmfangAnzeigen;
    private GenericTable mtable;
    private GenericTableModel mtabmodel;
    private ArrayList<String> columnConfig;
    private int firstNonIconCol;
    private JPanel mtableScoreRahmen;
    private Vector<JTable> maScoreTeileTables = new Vector();
    private HashMap<JTable, ScorelisteJob> mMapScoreJobToTable = new HashMap();
    private HashMap<JTable, ScorelisteSrp> mMapScoreSrpToTable = new HashMap();
    private int mnPrintArt;
    private static final int PRINT_RECHNUNG = 0;
    private static final int PRINT_KOSTENVORANSCHLAG = 1;
    private static final int PRINT_GREIFERSCHEIN = 2;
    private boolean mbPrintQuerformat = false;
    private boolean mbPrintFISpalte = false;
    private boolean mbPrintFIBloecke = false;
    private boolean mbPrintReTrBloecke = false;
    private boolean mbSortierungGeaendert = false;
    private boolean mbZwischenSumme = false;
    private String msLastRetr = null;
    private String msLastFIStringZwSum = null;
    private String msLastFI = null;
    private String msLastReTrStringZwSum = null;
    private String msHelperFIString = "";
    private String msHelperLastFIStringZwSum = "";
    private String msHelperReTrString = "";
    private String msHelperLastReTrStringZwSum = "";
    private String msHelperReTrStringForPrint = "";
    private int mnPrintRow;
    private int mnPrintOInd;
    private int mnPrintSummeGedruckt;
    private int mPrintLastPageIndex;
    private boolean mbShowLegendeFH;
    private String msPrintRechnungsnummer = "";
    private JButtonEx mbUpPos;
    private JButtonEx mbDownPos;
    private JButtonEx mbUpTeilenummer;
    private JButtonEx mbDownTeilenummer;
    private JButtonEx mbUpBenennung;
    private JButtonEx mbDownBenennung;
    private JButtonEx mbUpLagerort;
    private JButtonEx mbDownLagerort;
    private JButtonEx mbUpFIKuerzel;
    private JButtonEx mbDownFIKuerzel;
    private int mnColInfo = -1;
    private int mnColEdit = -1;
    private int mnColDel = -1;
    private int mnColPos = -1;
    private int mnColTeilenummer = -1;
    private int mnColBenennung = -1;
    private int mnColLagerort = -1;
    private int mnColFIKuerzel = -1;
    private final int COL_ICON_INFO = 0;
    private final int COL_ICON_EDIT = 1;
    private final int COL_ICON_DEL = 2;
    private final int COL_ICON_DEL_GESPERRT = 1;
    private boolean mbColFahrzeugDisplayed;
    private static final Color JOB_BACK_COLOR = new Color(192, 192, 190);
    private static final Color SRP_BACK_COLOR = new Color(238, 238, 236);
    private static final Color LOCK_BACK_COLOR = new Color(212, 212, 210);
    private int mnSortierung = 0;
    private boolean mbSortierungAsc = true;

    protected void initComponents() {
        this.initMenus();
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeileliste(), ImageCache.getInstance().getHeaderIcon("tl"));
        this.teilelistePanel = new TitledPanel(Resource.getInstance().getTeilelisteBearbeiten());
        this.posteilelistePanel = new TitledPanel(Resource.getInstance().getTeilelisteUeberschrift2());
        this.cbTeilelisten = new JComboBox();
        this.cbTeilelisten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgTeilelisteView.this.mbHandleSelChangeCbTeilelisten) {
                    int nRet;
                    ComboTeilelisteItem oldItem;
                    ComboTeilelisteItem newItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                    if (newItem.equals(oldItem = DlgTeilelisteView.this.model.getSelTL())) {
                        return;
                    }
                    DlgTeilelisteView.this.mbHandleSelChangeCbTeilelisten = false;
                    if (DlgTeilelisteView.this.model.getKopfdatenGeaendert() && (nRet = JOptionPane.showConfirmDialog(null, Resource.getInstance().getKopfdatenFrageSpeichern(), Resource.getInstance().getTeilelisteBearbeiten(), 0)) == 0) {
                        String sNewID = null;
                        if (DlgTeilelisteView.this.model.getSelTLID().equals(Resource.getInstance().getNeueListe())) {
                            sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                        }
                        if (!DlgTeilelisteView.this.moController.saveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                            DlgTeilelisteView.this.cbTeilelisten.setSelectedIndex(DlgTeilelisteView.this.model.getSelTLIndex());
                            DlgTeilelisteView.this.mbHandleSelChangeCbTeilelisten = true;
                            return;
                        }
                    }
                    LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                    String sNutzerId = oLoginInfo.getLogin();
                    String sAktTLEigentuemer = null;
                    ComboTeilelisteItem oAktTL = DlgTeilelisteView.this.model.getSelTL();
                    if (oAktTL != null) {
                        sAktTLEigentuemer = oAktTL.getEigentuemer();
                    }
                    if (sAktTLEigentuemer != null && !sAktTLEigentuemer.equals(sNutzerId)) {
                        DlgTeilelisteView.this.cbTeilelisten.removeItemAt(DlgTeilelisteView.this.model.getSelTLIndex());
                        DlgTeilelisteView.this.model.getTLZurAuswahl().remove(DlgTeilelisteView.this.model.getSelTLIndex());
                    }
                    ComboTeilelisteItem oNewTL = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                    DlgTeilelisteView.this.moController.handleSelChangeCbTeilelisten(oNewTL.getID(), oNewTL.getEigentuemer());
                    DlgTeilelisteView.this.cbInTeileliste.setSelectedItem(DlgTeilelisteController.ermittleSelTL(DlgTeilelisteView.this.model.getTLZumUebernehmen(), false));
                    DlgTeilelisteView.this.mbHandleSelChangeCbTeilelisten = true;
                }
            }
        });
        this.txtTeileliste = new JLabel(Resource.getInstance().getTeileliste());
        this.txtTeileliste.setLabelFor(this.cbTeilelisten);
        this.txtTeilelisteGewaehlt = new JLabel(Resource.getInstance().getTeileliste());
        this.txtTeilelisteGewaehltWert = new JLabel("");
        this.txtTeilelisteGewaehltWert2 = new JLabel("");
        this.tfTeilelisteNeu = new LimitedTextField(20);
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            this.tfTeilelisteNeu.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (DlgTeilelisteView.this.tfTeilelisteNeu.getText() != null && DlgTeilelisteView.this.tfTeilelisteNeu.getText().equals("0")) {
                        String sID = DlgTeilelisteController.getNextTeilelistenId(DlgTeilelisteView.this.moController.getKonfiguration(), null);
                        DlgTeilelisteView.this.tfTeilelisteNeu.setText(sID);
                    }
                    return true;
                }
            });
        }
        this.txtBemerkung = new JLabel(Resource.getInstance().getBemerkung());
        this.txtBemerkungWert = new JLabel("");
        this.tfBemerkung = new LimitedTextField(20, 32);
        this.txtErstelltAm = new JLabel(Resource.getInstance().getErstelltAm());
        this.txtErstelltAmWert = new JLabel();
        this.txtGeaendertAm = new JLabel(Resource.getInstance().getLetztmalsGeaendertAm());
        this.txtGeaendertAmWert = new JLabel();
        this.chkPrivat = new JCheckBox(Resource.getInstance().getPrivat());
        this.txtAuftragsNr = GlobalObjects.isScore() ? new JLabel(Resource.getInstance().getFahrzeugdurchlauf()) : new JLabel(Resource.getInstance().getAuftragsnummer());
        this.txtAuftragsNrWert = new LimitedTextField(10);
        this.tfAuftragsNr = new JLabel();
        this.txtKundenNr = new JLabel(Resource.getInstance().getKundennummer());
        this.txtKundenNrWert = new LimitedNumberField(7);
        this.tfKundenNr = new JLabel();
        this.txtKundenName = new JLabel(Resource.getInstance().getKundenname());
        this.tfKundenName = new JLabel();
        this.txtSummeBruttoPrompt = new JLabel(Resource.getInstance().getSummeBrutto());
        this.txtSummeBruttoWert = new JLabel();
        this.txtSummeNettoPrompt = new JLabel(Resource.getInstance().getSummeNetto());
        this.txtSummeNettoWert = new JLabel();
        this.txtRabatt = new JLabel(Resource.getInstance().getRabatt());
        this.tfRabatt = new LimitedNumberField(6, true, true);
        this.tfRabatt.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String sRabatt = ((LimitedNumberField)input).getText();
                input.setCursor(Cursor.getPredefinedCursor(3));
                DlgTeilelisteView.this.moController.handleRabatt(sRabatt);
                input.setCursor(Cursor.getPredefinedCursor(0));
                return true;
            }
        });
        this.tfRabatt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 10) {
                    DlgTeilelisteView.this.tfRabatt.setCursor(Cursor.getPredefinedCursor(3));
                    DlgTeilelisteView.this.moController.handleRabatt(DlgTeilelisteView.this.tfRabatt.getText());
                    DlgTeilelisteView.this.tfRabatt.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.txtFIString = new JLabel("");
        this.txtFIStringPrompt = new JLabel("");
        this.tfTeilelisteNeu.addKeyListener(new ValueChangedListener());
        this.tfBemerkung.addKeyListener(new ValueChangedListener());
        this.txtAuftragsNrWert.addKeyListener(new ValueChangedListener());
        this.txtKundenNrWert.addKeyListener(new ValueChangedListener());
        this.chkPrivat.addActionListener(new ChkValueChangedListener());
        this.teilelisteButtonPanel = new JPanel();
        this.buttonSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected());
            }
        });
        this.buttonLoeschen = new JButtonEx(Resource.getInstance().getLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.moController.handleDeleteTeileliste();
            }
        });
        this.buttonFzgUmfangAnzeigen = new JButtonEx("", ImageCache.getInstance().getIcon("fzgumfang_detail.jpg"));
        this.buttonFzgUmfangAnzeigen.setToolTipText(Resource.getInstance().getZugeordneteFahrzeuge());
        this.buttonFzgUmfangAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FZZuordnung fzZuordung = new FZZuordnung(DlgTeilelisteView.this.model);
                fzZuordung.show();
            }
        });
        this.cbInTeileliste = new JComboBox();
        this.txtInTeileliste = new JLabel(Resource.getInstance().getInTeileliste());
        this.buttonNeu = new JButtonEx(Resource.getInstance().getTeilHinzufuegen(), ImageCache.getInstance().getIcon("bi_teilhinzufuegen.jpg"));
        this.buttonNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.moController.handleNewTeil();
            }
        });
        this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getUebernehmen(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<Teil> aSelTeile = DlgTeilelisteView.this.getSelTeileFromTab(DlgTeilelisteView.this.mtable);
                DlgTeilelisteView.this.moController.handleUebernehmeTeile(DlgTeilelisteView.this.cbInTeileliste.getSelectedIndex(), aSelTeile, DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText());
            }
        });
        this.buttonDatenAbgleich = new JButtonEx(Resource.getInstance().getDatenabgleich(), ImageCache.getInstance().getIcon("abgleichdaten.jpg"));
        this.buttonDatenAbgleich.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgTeilelisteView.this.txtAuftragsNrWert.getText() != null && DlgTeilelisteView.this.txtAuftragsNrWert.getText().length() > 0) {
                    DlgTeilelisteView.this.model.getTLDaten().setAuftragsNrLokal(DlgTeilelisteView.this.txtAuftragsNrWert.getText());
                } else {
                    DlgTeilelisteView.this.model.getTLDaten().setAuftragsNrLokal(null);
                }
                if (DlgTeilelisteView.this.txtKundenNrWert.getText() != null && DlgTeilelisteView.this.txtKundenNrWert.getText().length() > 0) {
                    DlgTeilelisteView.this.model.getTLDaten().setKundenNrLokal(new Long(DlgTeilelisteView.this.txtKundenNrWert.getText()));
                } else {
                    DlgTeilelisteView.this.model.getTLDaten().setKundenNrLokal(null);
                }
                DlgTeilelisteView.this.moController.handleDatenAbgleich();
                DlgTeilelisteView.this.txtAuftragsNrWert.setText(DlgTeilelisteView.this.model.getTLDaten().getAuftragsNrLokal());
                if (DlgTeilelisteView.this.model.getTLDaten().getKundenNrLokal() != null) {
                    DlgTeilelisteView.this.txtKundenNrWert.setText(DlgTeilelisteView.this.model.getTLDaten().getKundenNrLokal().toString());
                } else {
                    DlgTeilelisteView.this.txtKundenNrWert.setText("");
                }
            }
        });
        this.buttonDMSDirect = new JButtonEx(Resource.getInstance().getNueDmsDirect(), ImageCache.getInstance().getIcon("abgleichdaten.jpg"));
        this.buttonDMSDirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.moController.handleDMSDirect();
            }
        });
        this.buttonSendAs2 = new JButtonEx(Resource.getInstance().getAnIspa());
        this.buttonSendAs2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.moController.handleSendAs2();
                DlgTeilelisteView.this.invalidate();
            }
        });
        this.buttonTransfer = new JButtonEx(Resource.getInstance().getTransfer());
        this.buttonTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug((Object)"Dialog schliessen");
                MainView.getInstance().setVisible(false);
            }
        });
        this.buttonEigentAendern = new JButtonEx(Resource.getInstance().getEigentuemerAendern());
        this.buttonEigentAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = As2ClientScore.getInstance().eigentuemerAendern();
                if (retVal == 0) {
                    MainView.getInstance().setVisible(false);
                } else {
                    log.debug((Object)"Eigent\u00fcmer \u00c4ndern abgebrochen");
                }
            }
        });
        this.mbUpPos = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(0, true);
            }
        });
        this.mbDownPos = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(0, false);
            }
        });
        this.mbUpTeilenummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(1, true);
            }
        });
        this.mbDownTeilenummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(1, false);
            }
        });
        this.mbUpBenennung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBenennung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(2, true);
            }
        });
        this.mbDownBenennung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBenennung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(2, false);
            }
        });
        this.mbUpLagerort = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpLagerort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(4, true);
            }
        });
        this.mbDownLagerort = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownLagerort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(4, false);
            }
        });
        this.mbUpFIKuerzel = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpFIKuerzel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(3, true);
            }
        });
        this.mbDownFIKuerzel = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownFIKuerzel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.handleClick(3, false);
            }
        });
        this.createLayout();
        this.update();
        this.cbInTeileliste.setSelectedItem(DlgTeilelisteController.ermittleSelTL(this.model.getTLZumUebernehmen(), false));
    }

    @Override
    public void initMenus() {
        LoginInfo loginInfo;
        this.menuCollection.clear();
        JMenu menu = new JMenu(Resource.getInstance().getTeileliste());
        menu.setBackground(UIHelper.getDarkerBackground());
        if (!GlobalObjects.isScore()) {
            menu.add(this.createMenuItemPrint(Resource.getInstance().getRechnungDrucken(), 0));
            menu.add(this.createMenuItemPrint(Resource.getInstance().getKostenvoranschlagDrucken(), 1));
            menu.add(this.createMenuItemPrint(Resource.getInstance().getGreiferscheinDrucken(), 2));
            menu.addSeparator();
            menu.add(this.createMenuItemFaxDlg(Resource.getInstance().getAlsFaxDrucken() + "..."));
            String sMailServer = this.moController.getKonfiguration().getMailserver();
            if (sMailServer != null && sMailServer.trim().length() > 0) {
                menu.add(this.createMenuItemMailDlg(Resource.getInstance().getAlsEMailVersenden() + "..."));
            }
            menu.addSeparator();
            this.menuExportDatei = this.createMenuItemExportDatei(Resource.getInstance().getExportierenAlsDatei());
            menu.add(this.menuExportDatei);
        } else {
            String sScore = "ISPA";
            Object[] arguments = new Object[]{sScore};
            String sMsg = MessageFormat.format(Resource.getInstance().getTeilelisteZurueckSchicken(), arguments);
            menu.add(this.createMenuItemZurueckAnScore(sMsg));
        }
        menu.add(this.createPrintBenDefMenuItem(Resource.getInstance().getRechnungBenutzerdefiniert() + "...", 0));
        menu.add(this.createPrintBenDefMenuItem(Resource.getInstance().getKostenvoranschlagBenutzerdefiniert() + "...", 1));
        menu.add(this.createPrintBenDefMenuItem(Resource.getInstance().getGreiferscheinBenutzerdefiniert() + "...", 2));
        menu.addSeparator();
        JMenu menuExportImport = new JMenu(Resource.getInstance().getSpeichernOeffnen());
        menu.add(menuExportImport);
        this.menuExport = this.createMenuItemExport(Resource.getInstance().getSpeichernAlsTxtFile() + "...");
        menuExportImport.add(this.menuExport);
        this.menuImport = this.createMenuItemImport(Resource.getInstance().getOeffnenAlsTxtFile() + "...");
        menuExportImport.add(this.menuImport);
        if (this.model.istDMSAngeschlossen()) {
            menu.addSeparator();
            this.menuWerkstattauftrag = this.createWerkstattauftragMenuItem(Resource.getInstance().getWerkstattauftragAnDms());
            this.menuKostenvoranschlag = this.createKostenvoranschlagMenuItem(Resource.getInstance().getKostenvoranschlagAnDms());
            this.menuBarverkauf = this.createBarverkaufMenuItem(Resource.getInstance().getBarverkaufAnDms());
            loginInfo = GlobalObjects.getInstance().getSessionInfo();
            if (!this.model.getGesperrt()) {
                if (loginInfo.hatRecht("R_WEBETK_WERKSTATTAUFTRAG")) {
                    menu.add(this.menuWerkstattauftrag);
                }
                if (loginInfo.hatRecht("R_WEBETK_KOSTENVORANSCHLAG")) {
                    menu.add(this.menuKostenvoranschlag);
                }
                if (loginInfo.hatRecht("R_WEBETK_BARVERKAUF")) {
                    menu.add(this.menuBarverkauf);
                }
            } else if (this.model.getSendeArt() != null) {
                if (this.model.getSendeArt().equals("Werkstattauftrag") && loginInfo.hatRecht("R_WEBETK_WERKSTATTAUFTRAG")) {
                    menu.add(this.menuWerkstattauftrag);
                } else if (this.model.getSendeArt().equals("Kostenvoranschlag") && loginInfo.hatRecht("R_WEBETK_KOSTENVORANSCHLAG")) {
                    menu.add(this.menuKostenvoranschlag);
                } else if (this.model.getSendeArt().equals("Barverkauf") && loginInfo.hatRecht("R_WEBETK_BARVERKAUF")) {
                    menu.add(this.menuBarverkauf);
                }
            }
        }
        this.menuCollection.add(menu);
        if (this.model.isZurueckZurBildtafelErlaubt()) {
            JMenu menuZurueck = new JMenu(Resource.getInstance().getZurueck());
            menuZurueck.setBackground(UIHelper.getDarkerBackground());
            this.menuitemZurueckZuBT = new JMenuItem(Resource.getInstance().getZurBildtafel());
            this.menuitemZurueckZuBT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgTeilelisteView.this.moController.zurueckZurBildtafel();
                }
            });
            menuZurueck.add(this.menuitemZurueckZuBT);
            this.menuCollection.add(menuZurueck);
        }
        this.popupMenu = new JPopupMenu();
        this.popupActionTeileinfo = new MenuItemTeileinformation(this);
        this.popupMenu.add(this.popupActionTeileinfo);
        this.popupActionTeileverwendungTeil = new MenuItemTeileverwendungTeil("teileliste", this.moController, this.model, this);
        if (!GlobalObjects.isScore()) {
            this.popupMenu.add(this.popupActionTeileverwendungTeil);
        }
        this.popupActionInterpretation = new MenuItemInterpretation("teileliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionInterpretation);
        this.popupActionEinzelteile = new MenuItemEinzelteile("teileliste", this.moController, this.model, this);
        this.popupMenu.add(this.popupActionEinzelteile);
        this.popupMenu.addSeparator();
        if (!this.model.getGesperrt()) {
            this.popupActionBearbeiten = new JMenuItem(Resource.getInstance().getMarkiertesTeilBearbeiten() + "...");
            this.popupActionBearbeiten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector<Teil> aSelTeile = DlgTeilelisteView.this.getSelTeileFromTab(DlgTeilelisteView.this.mtable);
                    DlgTeilelisteView.this.moController.handleEditTeile(aSelTeile);
                }
            });
            this.popupMenu.add(this.popupActionBearbeiten);
        }
        this.popupActionLoeschen = new JMenuItem(Resource.getInstance().getLoeschen());
        this.popupActionLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<Teil> aSelTeile = DlgTeilelisteView.this.getSelTeileFromTab(DlgTeilelisteView.this.mtable);
                JScrollPane sc = DlgTeilelisteView.this.mtable.getScrollPane();
                JScrollBar sb = sc.getVerticalScrollBar();
                final int nScrollVal = sb.getValue();
                DlgTeilelisteView.this.moController.handleDeleteTeile(aSelTeile);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JScrollPane sc = DlgTeilelisteView.this.mtable.getScrollPane();
                        JScrollBar sb = sc.getVerticalScrollBar();
                        sb.setValue(nScrollVal);
                    }
                });
            }
        });
        this.popupMenu.add(this.popupActionLoeschen);
        if (this.model.istDMSAngeschlossen()) {
            this.popupActionStammsatz = new JMenuItem(Resource.getInstance().getAnlageStammsatzImDms() + "...");
            this.popupActionStammsatz.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DlgTeilelisteView.this.txtAuftragsNrWert.getText() != null && DlgTeilelisteView.this.txtAuftragsNrWert.getText().length() > 0) {
                        DlgTeilelisteView.this.model.getTLDaten().setAuftragsNrLokal(DlgTeilelisteView.this.txtAuftragsNrWert.getText());
                    } else {
                        DlgTeilelisteView.this.model.getTLDaten().setAuftragsNrLokal(null);
                    }
                    if (DlgTeilelisteView.this.txtKundenNrWert.getText() != null && DlgTeilelisteView.this.txtKundenNrWert.getText().length() > 0) {
                        DlgTeilelisteView.this.model.getTLDaten().setKundenNrLokal(new Long(DlgTeilelisteView.this.txtKundenNrWert.getText()));
                    } else {
                        DlgTeilelisteView.this.model.getTLDaten().setKundenNrLokal(null);
                    }
                    Vector<Teil> aSelTeile = DlgTeilelisteView.this.getSelTeileFromTab(DlgTeilelisteView.this.mtable);
                    DlgTeilelisteView.this.moController.handleStammsatzDMS(aSelTeile);
                    DlgTeilelisteView.this.txtAuftragsNrWert.setText(DlgTeilelisteView.this.model.getTLDaten().getAuftragsNrLokal());
                    if (DlgTeilelisteView.this.model.getTLDaten().getKundenNrLokal() != null) {
                        DlgTeilelisteView.this.txtKundenNrWert.setText(DlgTeilelisteView.this.model.getTLDaten().getKundenNrLokal().toString());
                    } else {
                        DlgTeilelisteView.this.txtKundenNrWert.setText("");
                    }
                }
            });
            loginInfo = GlobalObjects.getInstance().getSessionInfo();
            if (!GlobalObjects.isScore() && loginInfo.hatRecht("R_WEBETK_STAMMSATZ")) {
                this.popupMenu.addSeparator();
                this.popupMenu.add(this.popupActionStammsatz);
            }
        }
        this.popupActionCopySachnummer = new MenuItemCopySachnummer(this);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.popupActionCopySachnummer);
    }

    protected void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"init");
        this.model = (DlgTeilelisteModel)oDlgModel;
        this.moController = (DlgTeilelisteController)oController;
        this.initComponents();
    }

    @Override
    public void update() {
        JMenuItem oItem;
        int ii;
        JMenu oMenu;
        Iterator<JComponent> iMenues;
        if (this.model == null) {
            return;
        }
        if (this.model.getMustReload()) {
            ComboTeilelisteItem oSelListe = this.model.getSelTL();
            this.moController.loadTLZurAuswahl();
            this.moController.loadTeileliste(oSelListe.getID(), oSelListe.getEigentuemer(), oSelListe.getFiliale());
            this.model.setSelTL(oSelListe);
            this.moController.loadTLZumUebernehmen();
        }
        if (!GlobalObjects.isScore()) {
            this.posteilelistePanel.remove(this.tabelleComponent);
            this.tabelleComponent = this.createTabelle();
            HIGConstraints c2 = new HIGConstraints();
            this.posteilelistePanel.add((Component)this.tabelleComponent, c2.rcwh(6, 2, 13, 1));
        }
        this.mbHandleSelChangeCbTeilelisten = false;
        this.cbTeilelisten.removeAllItems();
        Vector<ComboTeilelisteItem> aItems = this.model.getTLZurAuswahl();
        if (aItems != null) {
            for (int ii2 = 0; ii2 < aItems.size(); ++ii2) {
                this.cbTeilelisten.addItem(aItems.get(ii2));
            }
            if (this.model.getSelTLID() != null) {
                this.cbTeilelisten.setSelectedIndex(this.model.getSelTLIndex());
            } else {
                this.cbTeilelisten.setSelectedIndex(0);
            }
        }
        this.mbHandleSelChangeCbTeilelisten = true;
        if (this.model.getTLDaten() == null) {
            this.txtTeilelisteGewaehltWert.setVisible(true);
            this.tfTeilelisteNeu.setVisible(false);
            this.txtTeilelisteGewaehltWert.setText("");
            this.tfBemerkung.setText("");
            this.txtErstelltAmWert.setText("");
            this.txtGeaendertAmWert.setText("");
            this.tfAuftragsNr.setText("");
            this.txtAuftragsNrWert.setText("");
            this.tfKundenNr.setText("");
            this.txtKundenNrWert.setText("");
            this.tfKundenName.setText("");
            this.txtSummeBruttoWert.setText("");
            this.txtSummeNettoWert.setText("");
            this.tfRabatt.setText("");
            this.txtFIString.setText("");
            this.txtFIStringPrompt.setText("");
            this.chkPrivat.setSelected(false);
            if (!GlobalObjects.isScore()) {
                this.mtabmodel.removeAllRows();
            }
            this.buttonSpeichern.setEnabled(false);
            this.buttonLoeschen.setEnabled(false);
            this.buttonDMSDirect.setEnabled(false);
            this.buttonSendAs2.setEnabled(false);
            this.buttonUebernehmen.setEnabled(false);
            this.buttonNeu.setEnabled(false);
            this.buttonDatenAbgleich.setEnabled(false);
            iMenues = this.getMenus();
            while (iMenues.hasNext()) {
                oMenu = (JMenu)iMenues.next();
                int nCount = oMenu.getItemCount();
                for (ii = 0; ii < nCount; ++ii) {
                    oItem = oMenu.getItem(ii);
                    if (oItem == null) continue;
                    oItem.setEnabled(false);
                }
            }
        } else {
            this.buttonSpeichern.setEnabled(true);
            this.buttonLoeschen.setEnabled(true);
            this.buttonUebernehmen.setEnabled(true);
            if (this.model.getUSSchnittstelleFilename() != null && this.model.getUSSchnittstelleFilename().trim().length() > 0) {
                this.buttonDMSDirect.setEnabled(true);
            } else {
                this.buttonDMSDirect.setEnabled(false);
            }
            if (this.model.getFzgDlfId() != null) {
                this.buttonSendAs2.setVisible(true);
                this.buttonSendAs2.setEnabled(true);
                this.invalidate();
            } else {
                this.buttonSendAs2.setVisible(false);
                this.buttonSendAs2.setEnabled(false);
            }
            if (this.model.istDMSAngeschlossen() && this.moController.ermittleDatenabgleichImmer()) {
                this.buttonDatenAbgleich.setEnabled(false);
            } else {
                this.buttonDatenAbgleich.setEnabled(true);
            }
            iMenues = this.getMenus();
            while (iMenues.hasNext()) {
                oMenu = (JMenu)iMenues.next();
                int nCount = oMenu.getItemCount();
                for (ii = 0; ii < nCount; ++ii) {
                    oItem = oMenu.getItem(ii);
                    if (oItem == null) continue;
                    oItem.setEnabled(true);
                }
            }
            if (this.model.istDMSAngeschlossen() && Marken.getInstance().getEigenschaften("marke.usListenIds").contains(this.model.getSelTLID())) {
                this.menuWerkstattauftrag.setEnabled(false);
                this.menuKostenvoranschlag.setEnabled(false);
                this.menuBarverkauf.setEnabled(false);
            }
            Teileliste oTLDaten = this.model.getTLDaten();
            if (this.model.getSelTLID() != null && this.model.getSelTLID().equals(Resource.getInstance().getNeueListe())) {
                this.txtTeilelisteGewaehltWert.setVisible(false);
                this.tfTeilelisteNeu.setVisible(true);
                this.tfTeilelisteNeu.setText("");
                this.buttonLoeschen.setEnabled(false);
                this.buttonDMSDirect.setEnabled(false);
                this.buttonSendAs2.setEnabled(false);
                this.buttonSendAs2.setVisible(false);
                this.buttonUebernehmen.setEnabled(false);
                this.buttonNeu.setEnabled(false);
                this.buttonDatenAbgleich.setEnabled(false);
            } else {
                this.tfTeilelisteNeu.setVisible(false);
                this.txtTeilelisteGewaehltWert.setVisible(true);
                this.txtTeilelisteGewaehltWert.setText(oTLDaten.getID());
                this.txtTeilelisteGewaehltWert2.setText(oTLDaten.getID());
                this.buttonNeu.setEnabled(true);
            }
            this.tfBemerkung.setText(oTLDaten.getBemerkung());
            this.txtBemerkungWert.setText(oTLDaten.getBemerkung());
            this.txtErstelltAmWert.setText(oTLDaten.getDatErstellungString());
            this.txtGeaendertAmWert.setText(oTLDaten.getDatAenderungString());
            this.tfAuftragsNr.setText(oTLDaten.getAuftragsNr());
            this.txtAuftragsNrWert.setText(oTLDaten.getAuftragsNrLokal());
            if (GlobalObjects.isScore()) {
                Scoreliste oSL = (Scoreliste)oTLDaten;
                this.txtAuftragsNrWert.setVisible(false);
                this.tfAuftragsNr.setVisible(true);
                this.tfAuftragsNr.setText(oSL.getDurchlaufId());
                this.txtKundenNrWert.setVisible(false);
                this.tfKundenNr.setVisible(true);
                this.chkPrivat.setVisible(false);
            } else if (oTLDaten.getAuftrag() == null) {
                this.txtAuftragsNrWert.setVisible(true);
                this.tfAuftragsNr.setVisible(false);
                this.txtKundenNrWert.setVisible(true);
                this.tfKundenNr.setVisible(false);
                this.chkPrivat.setVisible(true);
            } else {
                this.txtAuftragsNrWert.setVisible(false);
                this.tfAuftragsNr.setVisible(true);
                this.txtKundenNrWert.setVisible(false);
                this.tfKundenNr.setVisible(true);
                this.chkPrivat.setVisible(false);
            }
            if (GlobalObjects.isScore()) {
                String sKundennummer = "";
                if (oTLDaten.getKundenNrLokal() != null) {
                    sKundennummer = oTLDaten.getKundenNrLokal().toString();
                }
                this.tfKundenNr.setText(sKundennummer);
            } else {
                this.tfKundenNr.setText(oTLDaten.getKundenNr());
            }
            String sKundenNrLokal = "";
            if (oTLDaten.getKundenNrLokal() != null) {
                sKundenNrLokal = oTLDaten.getKundenNrLokal().toString();
            }
            this.txtKundenNrWert.setText(sKundenNrLokal);
            this.tfKundenName.setText(oTLDaten.getKundenName());
            this.chkPrivat.setSelected(oTLDaten.getPrivat());
            this.txtSummeBruttoWert.setText(WebetkUtils.getPriceString(oTLDaten.ermittleSummeBrutto()));
            this.txtSummeNettoWert.setText(WebetkUtils.getPriceString(oTLDaten.ermittleSummeNetto()));
            this.tfRabatt.setText("");
            int nAnzFzg = this.moController.ermittleAnzahlFahrzeuge();
            if (nAnzFzg == 1 || nAnzFzg == 2) {
                if (nAnzFzg == 2) {
                    oTLDaten.ermittleFIKuerzel(false);
                }
                Iterator<Teil> iter = this.model.getTeile().iterator();
                String sFIString = "";
                while (iter.hasNext()) {
                    Teil oTeil = iter.next();
                    if (oTeil.getFIString() == null || oTeil.getFIString().length() <= 0) continue;
                    if (nAnzFzg == 2) {
                        sFIString = oTeil.getFIKuerzel() + "   " + oTeil.getFIString();
                        break;
                    }
                    sFIString = oTeil.getFIString();
                    break;
                }
                this.txtFIStringPrompt.setText(Resource.getInstance().getFahrzeug());
                this.txtFIString.setText(sFIString);
            } else {
                this.txtFIStringPrompt.setText("");
                if (GlobalObjects.isScore()) {
                    this.txtFIString.setText(Resource.getInstance().getErstelltFuer() + " " + oTLDaten.getFzgIdString());
                } else {
                    this.txtFIString.setText(Resource.getInstance().getUrspruenglichErstelltFuer() + " " + oTLDaten.getFzgIdString());
                }
                this.txtFIString.setText("");
            }
            if (nAnzFzg == 3) {
                this.buttonFzgUmfangAnzeigen.setVisible(true);
            } else {
                this.buttonFzgUmfangAnzeigen.setVisible(false);
            }
            if (!GlobalObjects.isScore()) {
                this.updateListe();
            } else {
                this.updateScoreListe();
            }
        }
        this.cbInTeileliste.removeAllItems();
        aItems = this.model.getTLZumUebernehmen();
        if (aItems != null) {
            for (int ii3 = 0; ii3 < aItems.size(); ++ii3) {
                this.cbInTeileliste.addItem(aItems.get(ii3));
            }
        }
    }

    private void updateListe() {
        this.mtabmodel.removeAllRows();
        Teileliste oTLDaten = this.model.getTLDaten();
        Vector<Teil> aTeile = oTLDaten.getTeile();
        if (aTeile != null) {
            oTLDaten.ermittleFIKuerzel(true);
            aTeile = this.mnSortierung == 0 && this.mbSortierungAsc ? oTLDaten.getTeile() : oTLDaten.getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
            for (Teil oTeil : aTeile) {
                if (this.mnSortierung == 80) {
                    log.debug((Object)("*** -> " + (oTeil.getTransparenz() == null || oTeil.getTransparenz().trim().length() == 0 ? "\u00ff\u00ff\u00ff\u00ff" : oTeil.getTransparenz()) + oTeil.getPosWithLeadingZeros() + " <- ***"));
                }
                if (this.mnSortierung == 38) {
                    log.debug((Object)("*** -> " + (oTeil.getFIKuerzel() == null || oTeil.getFIKuerzel().trim().length() == 0 ? "\u00ff" : oTeil.getFIKuerzel()) + (oTeil.getTransparenz() == null || oTeil.getTransparenz().trim().length() == 0 ? "\u00ff\u00ff\u00ff\u00ff" : oTeil.getTransparenz()) + oTeil.getPosWithLeadingZeros() + " <- ***"));
                }
                Object[] newRow = new Object[this.columnConfig.size() + this.firstNonIconCol];
                int spaltenUebersprungen = 0;
                for (int col = 0; col < this.columnConfig.size(); ++col) {
                    if (this.columnConfig.get(col).equals("Fahrzeug") && !this.mbColFahrzeugDisplayed) {
                        ++spaltenUebersprungen;
                        continue;
                    }
                    newRow[col + this.firstNonIconCol - spaltenUebersprungen] = this.getCellValue(this.columnConfig.get(col), oTeil);
                }
                this.mtabmodel.addRow(new AbstractRow(newRow));
            }
        }
    }

    private Object getCellValue(String key, Teil oTeil) {
        if (key.equals("TeileInformation")) {
            return new IconAndTooltip(ImageCache.getInstance().getIcon("info.gif"), Resource.getInstance().getTeileinfo());
        }
        if (key.equals("TeilBearbeiten")) {
            return null;
        }
        if (key.equals("TeilLoeschen")) {
            return null;
        }
        if (key.equals("Position")) {
            return oTeil.getPos();
        }
        if (key.equals("TeileNummer")) {
            return oTeil.getTeilenummerGespreizt();
        }
        if (key.equals("TeileBenennung")) {
            return oTeil.getBenennung();
        }
        if (key.equals("Zusatz")) {
            return oTeil.getZusatz();
        }
        if (key.equals("Menge")) {
            return oTeil.getMenge();
        }
        if (key.equals("Bestand")) {
            return oTeil.getLagerbestand() == null ? "" : oTeil.getLagerbestand().toString();
        }
        if (key.equals("Lagerort")) {
            return oTeil.getLagerort();
        }
        if (key.equals("MinimalBestand")) {
            return oTeil.getMinimalbestand() == null ? "" : oTeil.getMinimalbestand().toString();
        }
        if (key.equals("BedarfsHinweis")) {
            return oTeil.getBedarfshinweis() == null ? "" : oTeil.getBedarfshinweis().toString();
        }
        if (key.equals("AusstehendeMenge")) {
            return oTeil.getAuMe() == null ? "" : oTeil.getAuMe().toString();
        }
        if (key.equals("Preis")) {
            return WebetkUtils.getPriceString(oTeil.getPreis());
        }
        if (key.equals("Rabatt")) {
            return oTeil.getRabattString();
        }
        if (key.equals("Splittkennzeichen")) {
            return oTeil.getSplitt();
        }
        if (key.equals("RechnungsTransparenz")) {
            return oTeil.getTransparenz();
        }
        if (key.equals("DispoCode")) {
            return oTeil.getDispo();
        }
        if (key.equals("Suffix")) {
            return oTeil.getSuffix();
        }
        if (key.equals("Netto")) {
            return WebetkUtils.getPriceString(oTeil.ermittleNetto());
        }
        if (key.equals("Brutto")) {
            return WebetkUtils.getPriceString(oTeil.ermittleBrutto());
        }
        if (key.equals("Mwst")) {
            return WebetkUtils.getPriceString(oTeil.ermittleMwSt());
        }
        if (key.equals("Ruecksendepflicht")) {
            return oTeil.getRuecksendepflicht();
        }
        if (key.equals("Bemerkung")) {
            return oTeil.getBemerkung();
        }
        if (key.equals("Fahrzeug")) {
            return oTeil.getFIKuerzel();
        }
        return null;
    }

    protected void updateScoreListe() {
        this.updateScoreTabelle();
        for (GenericTable genericTable : this.maScoreTeileTables) {
            int height = genericTable.calcRowHeights();
            genericTable.calcMinSizeNow();
            int width = genericTable.getMinWidth();
            Dimension dim = new Dimension(width + 18, height + 2);
            genericTable.getScrollPane().setPreferredSize(dim);
            genericTable.getScrollPane().setMinimumSize(dim);
            genericTable.setPreferredSize(dim);
            genericTable.repaint();
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void onExit() {
        if (this.moController != null) {
            this.moController.handleExit();
        }
    }

    protected JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createTeilelistePanel(), c.rc(1, 1));
        contentPanel.add((Component)this.createPosTeilelistePanel(), c.rc(3, 1));
        return contentPanel;
    }

    protected JPanel createTeilelistePanel() {
        int[] w_teileliste = new int[]{10, 0, 10, 190, 10, 0, 10, 0, 20, 0, 10};
        int[] h_teileliste = new int[]{10, 0, 15, 0, 5, 0, 5, 0, 20, 0, 5, 0, 5, 0, 10};
        int[] w_score = new int[]{10, 0, 10, 190, 10, 0, 10, 0, 20, 0, 10};
        int[] h_score = new int[]{10, 0, 15, 0, 5, 0, 5, 0, 10};
        HIGLayout layoutTeileliste = null;
        layoutTeileliste = !GlobalObjects.isScore() ? new HIGLayout(w_teileliste, h_teileliste) : new HIGLayout(w_score, h_score);
        layoutTeileliste.setColumnWeight(10, 1);
        HIGConstraints c = new HIGConstraints();
        this.teilelistePanel.setLayout(layoutTeileliste);
        int nRow = 0;
        if (!GlobalObjects.isScore()) {
            this.teilelistePanel.add((Component)this.txtTeileliste, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.createTeilelisteButtonPanel(), c.rcwh(nRow, 3, 8, 1, "lr"));
            this.teilelistePanel.add((Component)this.txtTeilelisteGewaehlt, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.txtTeilelisteGewaehltWert, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.tfTeilelisteNeu, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtBemerkung, c.rc(nRow, 6));
            if (!this.model.getGesperrt()) {
                this.teilelistePanel.add((Component)this.tfBemerkung, c.rc(nRow, 8));
            } else {
                this.teilelistePanel.add((Component)this.txtBemerkungWert, c.rc(nRow, 8));
            }
            this.teilelistePanel.add((Component)this.txtErstelltAm, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.txtErstelltAmWert, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtGeaendertAm, c.rc(nRow, 6));
            this.teilelistePanel.add((Component)this.txtGeaendertAmWert, c.rc(nRow, 8));
            this.teilelistePanel.add((Component)this.chkPrivat, c.rc(nRow, 10));
            this.teilelistePanel.add((Component)this.txtFIStringPrompt, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.txtFIString, c.rcwh(nRow, 4, 6, 1));
            this.teilelistePanel.add((Component)this.buttonFzgUmfangAnzeigen, c.rc(nRow, 2));
            if (this.model.istDMSAngeschlossen()) {
                this.teilelistePanel.add((Component)this.txtAuftragsNr, c.rc(nRow += 2, 2));
                this.teilelistePanel.add((Component)this.tfAuftragsNr, c.rc(nRow, 4));
                this.teilelistePanel.add((Component)this.txtAuftragsNrWert, c.rc(nRow, 4));
                this.teilelistePanel.add((Component)this.txtRabatt, c.rc(nRow, 6));
                if (!this.model.getGesperrt()) {
                    this.teilelistePanel.add((Component)this.tfRabatt, c.rc(nRow, 8));
                }
                this.teilelistePanel.add((Component)this.txtKundenNr, c.rc(nRow += 2, 2));
                this.teilelistePanel.add((Component)this.tfKundenNr, c.rc(nRow, 4));
                this.teilelistePanel.add((Component)this.txtKundenNrWert, c.rc(nRow, 4));
                this.teilelistePanel.add((Component)this.txtSummeNettoPrompt, c.rc(nRow, 6));
                this.teilelistePanel.add((Component)this.txtSummeNettoWert, c.rc(nRow, 8));
                this.teilelistePanel.add((Component)this.txtKundenName, c.rc(nRow += 2, 2));
                this.teilelistePanel.add((Component)this.tfKundenName, c.rc(nRow, 4));
                this.teilelistePanel.add((Component)this.txtSummeBruttoPrompt, c.rc(nRow, 6));
                this.teilelistePanel.add((Component)this.txtSummeBruttoWert, c.rc(nRow, 8));
            } else {
                this.teilelistePanel.add((Component)this.txtRabatt, c.rc(nRow += 2, 2));
                if (!this.model.getGesperrt()) {
                    this.teilelistePanel.add((Component)this.tfRabatt, c.rc(nRow, 4));
                }
                this.teilelistePanel.add((Component)this.txtSummeNettoPrompt, c.rc(nRow += 2, 2));
                this.teilelistePanel.add((Component)this.txtSummeNettoWert, c.rc(nRow, 4));
                this.teilelistePanel.add((Component)this.txtSummeBruttoPrompt, c.rc(nRow, 6));
                this.teilelistePanel.add((Component)this.txtSummeBruttoWert, c.rc(nRow, 8));
            }
        } else {
            this.teilelistePanel.add((Component)this.txtTeilelisteGewaehlt, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.txtTeilelisteGewaehltWert, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtFIString, c.rcwh(nRow += 2, 2, 9, 1));
            this.teilelistePanel.add((Component)this.txtAuftragsNr, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.tfAuftragsNr, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtAuftragsNrWert, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtSummeNettoPrompt, c.rc(nRow, 6));
            this.teilelistePanel.add((Component)this.txtSummeNettoWert, c.rc(nRow, 8));
            this.teilelistePanel.add((Component)this.txtKundenNr, c.rc(nRow += 2, 2));
            this.teilelistePanel.add((Component)this.tfKundenNr, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtKundenNrWert, c.rc(nRow, 4));
            this.teilelistePanel.add((Component)this.txtSummeBruttoPrompt, c.rc(nRow, 6));
            this.teilelistePanel.add((Component)this.txtSummeBruttoWert, c.rc(nRow, 8));
        }
        if (this.model.istDMSAngeschlossen()) {
            // empty if block
        }
        return this.teilelistePanel;
    }

    protected JPanel createTeilelisteButtonPanel() {
        int[] w_teilelistebutton = null;
        w_teilelistebutton = new int[]{10, 190, 10, -6, 10, -8, 10, -10, 10, -4};
        int[] h_teilelistebutton = new int[]{0};
        HIGLayout layoutTeilelisteButton = new HIGLayout(w_teilelistebutton, h_teilelistebutton);
        HIGConstraints c = new HIGConstraints();
        this.teilelisteButtonPanel.setLayout(layoutTeilelisteButton);
        if (!this.model.getGesperrt()) {
            this.teilelisteButtonPanel.add((Component)this.cbTeilelisten, c.rc(1, 2, "lr"));
            this.teilelisteButtonPanel.add((Component)this.buttonSpeichern, c.rc(1, 4, "lr"));
            this.teilelisteButtonPanel.add((Component)this.buttonLoeschen, c.rc(1, 6, "lr"));
            this.teilelisteButtonPanel.add((Component)this.buttonDMSDirect, c.rc(1, 8, "lr"));
            this.teilelisteButtonPanel.add((Component)this.buttonSendAs2, c.rc(1, 10, "lr"));
        } else {
            this.teilelisteButtonPanel.add((Component)this.txtTeilelisteGewaehltWert2, c.rc(1, 2, "lr"));
            this.teilelisteButtonPanel.add((Component)this.buttonLoeschen, c.rc(1, 4, "lr"));
        }
        return this.teilelisteButtonPanel;
    }

    protected JPanel createPosTeilelistePanel() {
        boolean isScore = GlobalObjects.isScore();
        int[] w_posteileliste = new int[]{10, 0, 10, 172, 10, 0, 20, -10, 10, -8, 20, 0, 10, 0, 10};
        if (isScore) {
            w_posteileliste[6] = w_posteileliste[4];
        }
        int[] h_posteileliste = new int[]{10, 0, 14, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(w_posteileliste, h_posteileliste);
        layoutPosTeileliste.setColumnWeight(14, 1);
        layoutPosTeileliste.setRowWeight(6, 1);
        HIGConstraints c = new HIGConstraints();
        this.posteilelistePanel.setLayout(layoutPosTeileliste);
        int nCol = 0;
        if (!this.model.getGesperrt()) {
            if (!isScore) {
                this.posteilelistePanel.add((Component)this.txtInTeileliste, c.rc(2, nCol += 2, "lr"));
                this.posteilelistePanel.add((Component)this.cbInTeileliste, c.rc(2, nCol += 2, "lr"));
                this.posteilelistePanel.add((Component)this.buttonUebernehmen, c.rc(2, nCol += 2, "lr"));
            }
            this.posteilelistePanel.add((Component)this.buttonNeu, c.rc(2, nCol += 2, "lr"));
            this.posteilelistePanel.add((Component)this.buttonDatenAbgleich, c.rc(2, nCol += 2, "lr"));
            if (isScore) {
                this.posteilelistePanel.add((Component)this.buttonTransfer, c.rc(2, nCol += 2, "lr"));
                this.posteilelistePanel.add((Component)this.buttonEigentAendern, c.rc(2, nCol += 2, "lr"));
            }
        }
        if (!GlobalObjects.isScore()) {
            JButtonEx butTableConfig = new JButtonEx(Resource.getInstance().getTabelleKonfigurieren(), ImageCache.getInstance().getIcon("tabelle.gif"));
            butTableConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgTeilelisteView.this.moController.configureTable();
                }
            });
            this.posteilelistePanel.add((Component)butTableConfig, c.rc(2, nCol += 2, "lr"));
        }
        if (GlobalObjects.isScore()) {
            this.posteilelistePanel.add((Component)this.createScoreTabelle(), c.rcwh(4, 2, 13, 1));
        } else {
            this.tabelleComponent = this.createTabelle();
            this.posteilelistePanel.add((Component)this.tabelleComponent, c.rcwh(6, 2, 13, 1));
        }
        return this.posteilelistePanel;
    }

    protected JComponent createTabelle() {
        this.mtabmodel = new GenericTableModel(this.getTableConfiguration());
        this.mtable = new GenericTable(this.mtabmodel);
        this.mtable.addMouseListener(new TeilelisteMouseListener());
        final JTableHeader th = this.mtable.getTableHeader();
        th.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                int col = th.columnAtPoint(ev.getPoint());
                TableColumn column = DlgTeilelisteView.this.mtable.getColumnModel().getColumn(col);
                HeaderRenderer renderer = (HeaderRenderer)column.getHeaderRenderer();
                if (renderer.handleClick(DlgTeilelisteView.this.mtable, ev)) {
                    return;
                }
                if (col == DlgTeilelisteView.this.mnColPos) {
                    this.handleClick(0);
                } else if (col == DlgTeilelisteView.this.mnColTeilenummer) {
                    this.handleClick(1);
                } else if (col == DlgTeilelisteView.this.mnColBenennung) {
                    this.handleClick(2);
                } else if (col == DlgTeilelisteView.this.mnColLagerort) {
                    this.handleClick(4);
                } else if (col == DlgTeilelisteView.this.mnColFIKuerzel) {
                    this.handleClick(3);
                }
            }

            private void handleClick(int comp) {
                if (DlgTeilelisteView.this.mnSortierung == comp) {
                    DlgTeilelisteView.this.mbSortierungAsc = !DlgTeilelisteView.this.mbSortierungAsc;
                } else {
                    DlgTeilelisteView.this.mbSortierungAsc = true;
                }
                DlgTeilelisteView.this.mnSortierung = comp;
                DlgTeilelisteView.this.updateListe();
            }
        });
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        return this.mtable.getScrollPane();
    }

    protected TableConfiguration getTableConfiguration() {
        int nCol;
        TableConfiguration tableConfig = new TableConfiguration();
        this.mnColInfo = -1;
        this.mnColEdit = -1;
        this.mnColDel = -1;
        this.mnColPos = -1;
        this.mnColTeilenummer = -1;
        this.mnColBenennung = -1;
        this.mnColLagerort = -1;
        this.mnColFIKuerzel = -1;
        tableConfig.setHasButtons(true);
        if (this.columnConfig == null) {
            this.columnConfig = this.moController.loadTableConfiguration();
            if (this.columnConfig == null || this.columnConfig.size() == 0) {
                this.columnConfig = this.getDefaultColumnConfig(this.model.istDMSAngeschlossen(), this.model.getGesperrt());
            }
        }
        if (this.addColumn(tableConfig, "TeileInformation", nCol = 0)) {
            ++nCol;
        }
        if (this.addColumn(tableConfig, "TeilBearbeiten", nCol)) {
            ++nCol;
        }
        if (this.addColumn(tableConfig, "TeilLoeschen", nCol)) {
            ++nCol;
        }
        this.firstNonIconCol = nCol;
        for (int columnIndex = 0; columnIndex < this.columnConfig.size(); ++columnIndex) {
            if (!this.addColumn(tableConfig, this.columnConfig.get(columnIndex), nCol)) continue;
            ++nCol;
        }
        tableConfig.setUsePrototypeIcons(true);
        return tableConfig;
    }

    protected ArrayList<String> getDefaultColumnConfig(boolean dmsAngeschlossen, boolean gesperrt) {
        ArrayList<String> config = this.model.istDMSAngeschlossen() ? DlgTeilelisteController.getColumnsMitDMS() : DlgTeilelisteController.getColumnsOhneDMS();
        return config;
    }

    protected boolean addColumn(TableConfiguration tableConfig, String column, int nCol) {
        if (column.equals("TeileInformation")) {
            tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
            this.mnColInfo = nCol;
            return true;
        }
        if (column.equals("TeilBearbeiten") && !this.model.getGesperrt()) {
            tableConfig.addIconColumn("teil_bearbeiten.jpg", Resource.getInstance().getTeilBearbeiten());
            this.mnColEdit = nCol;
            return true;
        }
        if (column.equals("TeilLoeschen")) {
            tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
            this.mnColDel = nCol;
            return true;
        }
        if (column.equals("Position")) {
            tableConfig.addColumn(Resource.getInstance().getPos(), 0, false, "XXXXX");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getPosition());
            tableConfig.setHeaderButtonLeft(nCol, this.mbUpPos);
            tableConfig.setHeaderButtonRight(nCol, this.mbDownPos);
            this.mnColPos = nCol;
            return true;
        }
        if (column.equals("TeileNummer")) {
            tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXXX");
            tableConfig.setHeaderButtonLeft(nCol, this.mbUpTeilenummer);
            tableConfig.setHeaderButtonRight(nCol, this.mbDownTeilenummer);
            this.mnColTeilenummer = nCol;
            return true;
        }
        if (column.equals("TeileBenennung")) {
            tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            tableConfig.setHeaderButtonLeft(nCol, this.mbUpBenennung);
            tableConfig.setHeaderButtonRight(nCol, this.mbDownBenennung);
            this.mnColBenennung = nCol;
            return true;
        }
        if (column.equals("Zusatz")) {
            tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXX");
            return true;
        }
        if (column.equals("Menge")) {
            tableConfig.addColumn(Resource.getInstance().getMe(), 4, false, "X00000.00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getMenge());
            return true;
        }
        if (column.equals("Bestand")) {
            tableConfig.addColumn(Resource.getInstance().getBestand(), 4, false, "00000000.00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getLagerbestand());
            return true;
        }
        if (column.equals("Lagerort")) {
            tableConfig.addColumn(Resource.getInstance().getLagerort(), 2, true, "XXXXXXXXX");
            tableConfig.setHeaderButtonLeft(nCol, this.mbUpLagerort);
            tableConfig.setHeaderButtonRight(nCol, this.mbDownLagerort);
            this.mnColLagerort = nCol;
            return true;
        }
        if (column.equals("MinimalBestand")) {
            tableConfig.addColumn(Resource.getInstance().getNueMinBestand(), 4, false, "Min. BestandYY");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getMinimalbestand());
            return true;
        }
        if (column.equals("BedarfsHinweis")) {
            tableConfig.addColumn(Resource.getInstance().getNueBh(), 4, false, "00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getBedarfshinweis());
            return true;
        }
        if (column.equals("AusstehendeMenge")) {
            tableConfig.addColumn(Resource.getInstance().getNueAume(), 4, false, "0000000.00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getAusstehendeMenge());
            return true;
        }
        if (column.equals("Preis")) {
            tableConfig.addColumn(Resource.getInstance().getPreis(), 4, false, "0000000000.00");
            return true;
        }
        if (column.equals("Rabatt")) {
            tableConfig.addColumn(Resource.getInstance().getRabatt(), 4, false, "000.00");
            return true;
        }
        if (column.equals("Splittkennzeichen")) {
            tableConfig.addColumn(Resource.getInstance().getNueSplitt(), 4, false, Resource.getInstance().getNueSplitt());
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getSplittKennzeichen());
            return true;
        }
        if (column.equals("RechnungsTransparenz")) {
            tableConfig.addColumn(Resource.getInstance().getNueRetr(), 4, false, "0000");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getRechnungstransparenz());
            return true;
        }
        if (column.equals("DispoCode")) {
            tableConfig.addColumn(Resource.getInstance().getNueDc(), 0, false, Resource.getInstance().getNueDc());
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getDispocode());
            return true;
        }
        if (column.equals("Suffix")) {
            tableConfig.addColumn(Resource.getInstance().getNueSx(), 0, false, Resource.getInstance().getNueSx());
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getSuffix());
            return true;
        }
        if (column.equals("Netto")) {
            tableConfig.addColumn(Resource.getInstance().getNetto(), 4, false, "0000000000.00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getBetragNetto());
            return true;
        }
        if (column.equals("Brutto")) {
            tableConfig.addColumn(Resource.getInstance().getBrutto(), 4, false, "0000000000.00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getBetragBrutto());
            return true;
        }
        if (column.equals("Mwst")) {
            tableConfig.addColumn(Resource.getInstance().getNueMwst(), 4, false, "000000000.00");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getMehrwertsteuer());
            return true;
        }
        if (column.equals("Ruecksendepflicht")) {
            tableConfig.addColumn(Resource.getInstance().getR(), 0, false, "0");
            tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getRuecksendepflicht());
            return true;
        }
        if (column.equals("Bemerkung")) {
            tableConfig.addColumn(Resource.getInstance().getBemerkung(), 2, true, "XXXXXXXXXXXXXXXYYY");
            return true;
        }
        if (column.equals("Fahrzeug")) {
            int nAnzFzg = this.moController.ermittleAnzahlFahrzeuge();
            boolean bl = this.mbColFahrzeugDisplayed = nAnzFzg == 2 || nAnzFzg == 3;
            if (this.mbColFahrzeugDisplayed) {
                tableConfig.addColumn("F", 0, true, "X");
                tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getFahrzeug());
                this.mnColFIKuerzel = nCol;
                tableConfig.setHeaderButtonLeft(nCol, this.mbUpFIKuerzel);
                tableConfig.setHeaderButtonRight(nCol, this.mbDownFIKuerzel);
                return true;
            }
        }
        return false;
    }

    protected JComponent createScoreTabelle() {
        this.mtableScoreRahmen = new JPanel();
        this.updateScoreTabelle();
        JScrollPane sc = new JScrollPane(this.mtableScoreRahmen);
        sc.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 0), UIHelper.getStandardBorder()));
        Dimension dim = sc.getPreferredSize();
        dim.height = 300;
        sc.setPreferredSize(dim);
        return sc;
    }

    protected void updateScoreTabelle() {
        int anzZeilen = 0;
        Teileliste oTLDaten = this.model.getTLDaten();
        if (oTLDaten != null && oTLDaten instanceof Scoreliste) {
            Scoreliste scoreliste = (Scoreliste)oTLDaten;
            Collection<ScorelisteJob> cJobs = scoreliste.getJobs();
            for (ScorelisteJob job : cJobs) {
                ++anzZeilen;
                Collection<ScorelisteSrp> cSrps = job.getSrps();
                Iterator<ScorelisteSrp> iterSrps = cSrps.iterator();
                while (iterSrps.hasNext()) {
                    iterSrps.next();
                    ++anzZeilen;
                }
            }
        }
        int[] w_t = new int[]{20, 0};
        int[] h_t = new int[anzZeilen];
        for (int ii = 0; ii < anzZeilen; ++ii) {
            h_t[ii] = 0;
        }
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(2, 1);
        this.mtableScoreRahmen.setLayout(lo);
        this.mtableScoreRahmen.removeAll();
        this.mMapScoreJobToTable.clear();
        this.mMapScoreSrpToTable.clear();
        this.maScoreTeileTables.removeAllElements();
        if (oTLDaten != null && oTLDaten instanceof Scoreliste) {
            Scoreliste scoreliste = (Scoreliste)oTLDaten;
            Collection<ScorelisteJob> cJobs = scoreliste.getJobs();
            int nRow = 0;
            for (ScorelisteJob job : cJobs) {
                this.mtableScoreRahmen.add((Component)this.createScoreJobTable(job), c.rcwh(++nRow, 1, 2, 1));
                Collection<ScorelisteSrp> cSrps = job.getSrps();
                for (ScorelisteSrp srp : cSrps) {
                    this.mtableScoreRahmen.add((Component)this.createScoreSRPTable(job, srp), c.rc(++nRow, 2, "lr"));
                }
            }
        }
    }

    protected JPanel createScoreJobTable(ScorelisteJob job) {
        JPanel panel = new JPanel();
        int[] w_t = new int[]{10, 240, 10, 0};
        int[] h_t = new int[]{0};
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(4, 1);
        lo.setRowWeight(1, 1);
        panel.setLayout(lo);
        panel.setBackground(JOB_BACK_COLOR);
        JLabel id = new JLabel(job.getId());
        panel.add((Component)id, c.rc(1, 2, "lr"));
        panel.add((Component)new JLabel(job.getBezeichnung()), c.rc(1, 4));
        return panel;
    }

    protected JPanel createScoreSRPTable(ScorelisteJob job, ScorelisteSrp srp) {
        JPanel panel = new JPanel();
        int[] w_t = new int[]{20, 0};
        int[] h_t = new int[]{0, 0};
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(2, 1);
        lo.setRowWeight(2, 1);
        panel.setLayout(lo);
        panel.add((Component)this.createScoreSRPTableSRP(srp), c.rcwh(1, 1, 2, 1));
        JComponent scoreTabelleDetail = this.createScoreTabelleTeile(srp.getTeile(), job, srp);
        panel.add((Component)scoreTabelleDetail, c.rc(2, 2));
        return panel;
    }

    protected JPanel createScoreSRPTableSRP(ScorelisteSrp srp) {
        JPanel panel = new JPanel();
        int[] w_t = new int[]{240, 10, 0};
        int[] h_t = new int[]{0};
        HIGLayout lo = new HIGLayout(w_t, h_t);
        HIGConstraints c = new HIGConstraints();
        lo.setColumnWeight(3, 1);
        lo.setRowWeight(1, 1);
        panel.setLayout(lo);
        panel.setBackground(SRP_BACK_COLOR);
        JLabel id = new JLabel(srp.getId());
        id.setHorizontalAlignment(0);
        panel.add((Component)id, c.rc(1, 1, "lr"));
        panel.add((Component)new JLabel(srp.getBezeichnung()), c.rc(1, 3, "lr"));
        return panel;
    }

    protected JComponent createScoreTabelleTeile(Collection<Teil> aTeile, ScorelisteJob job, ScorelisteSrp srp) {
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        ++nCol;
        if (!this.model.getGesperrt()) {
            tableConfig.addIconColumn("teil_bearbeiten.jpg", Resource.getInstance().getTeilBearbeiten());
            ++nCol;
        }
        tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXX");
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getMe(), 4, false, "X00000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getMenge());
        if (this.model.istDMSAngeschlossen()) {
            tableConfig.addColumn(Resource.getInstance().getBestand(), 4, false, "00000000.00");
            tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getLagerbestand());
            ++nCol;
            tableConfig.addColumn(Resource.getInstance().getLagerort(), 2, false, "XXXXXXX");
        }
        ++nCol;
        tableConfig.addColumn(Resource.getInstance().getPreis(), 4, false, "0000000000.00");
        if (this.model.istDMSAngeschlossen()) {
            ++nCol;
            tableConfig.addColumn(Resource.getInstance().getRabatt(), 4, false, "000.00");
        }
        tableConfig.addColumn(Resource.getInstance().getNetto(), 4, false, "0000000000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getBetragNetto());
        tableConfig.addColumn(Resource.getInstance().getBrutto(), 4, false, "0000000000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getBetragBrutto());
        tableConfig.addColumn(Resource.getInstance().getNueMwst(), 4, false, "000000000.00");
        tableConfig.setHeaderTooltip(++nCol, Resource.getInstance().getMehrwertsteuer());
        tableConfig.setUsePrototypeIcons(false);
        GenericTableModel tabmodel = new GenericTableModel(tableConfig);
        this.mtable = new GenericTable(tabmodel);
        this.mtable.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.mtable.getTable().getColumnModel().getColumn(1).setWidth(20);
        if (!this.model.getGesperrt()) {
            this.mtable.getTable().getColumnModel().getColumn(2).setMinWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
            this.mtable.getTable().getColumnModel().getColumn(2).setWidth(20);
        }
        if (aTeile != null) {
            for (Teil oTeil : aTeile) {
                if (oTeil.getScoreAenderung() == 4) continue;
                boolean bJobOrSrpLock = job.isLock() || srp.isLock();
                this.addScoreTeil(tabmodel, oTeil, bJobOrSrpLock);
            }
        }
        this.mtable.addMouseListener(new TeilelisteScoreMouseListener());
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        this.maScoreTeileTables.add(this.mtable);
        this.mMapScoreJobToTable.put(this.mtable, job);
        this.mMapScoreSrpToTable.put(this.mtable, srp);
        return this.mtable.getScrollPane();
    }

    protected void addScoreTeil(GenericTableModel tabmodel, Teil oTeil, boolean bJobOrSrpLock) {
        IconAndTooltip teileinfo = new IconAndTooltip(ImageCache.getInstance().getIcon("info.gif"), Resource.getInstance().getTeileinfo());
        IconAndTooltip bearbeiten = null;
        IconAndTooltip loeschen = null;
        if (!bJobOrSrpLock && !oTeil.isScoreLock()) {
            bearbeiten = new IconAndTooltip(ImageCache.getInstance().getIcon("teil_bearbeiten.jpg"), Resource.getInstance().getTeilBearbeiten());
            loeschen = new IconAndTooltip(ImageCache.getInstance().getIcon("trashbin.gif"), Resource.getInstance().getLoeschen());
        }
        AbstractRow oRow = null;
        if (this.model.istDMSAngeschlossen()) {
            String sLagerbestand = "";
            if (oTeil.getLagerbestand() != null) {
                sLagerbestand = oTeil.getLagerbestand().toString();
            }
            oRow = !this.model.getGesperrt() ? new AbstractRow(new Object[]{teileinfo, bearbeiten, loeschen, oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), sLagerbestand, oTeil.getLagerort(), WebetkUtils.getPriceString(oTeil.getPreis()), oTeil.getRabattString(), WebetkUtils.getPriceString(oTeil.ermittleNetto()), WebetkUtils.getPriceString(oTeil.ermittleBrutto()), WebetkUtils.getPriceString(oTeil.ermittleMwSt())}) : new AbstractRow(new Object[]{teileinfo, loeschen, oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), sLagerbestand, oTeil.getLagerort(), WebetkUtils.getPriceString(oTeil.getPreis()), oTeil.getRabattString(), WebetkUtils.getPriceString(oTeil.ermittleNetto()), WebetkUtils.getPriceString(oTeil.ermittleBrutto()), WebetkUtils.getPriceString(oTeil.ermittleMwSt())});
        } else {
            oRow = !this.model.getGesperrt() ? new AbstractRow(new Object[]{teileinfo, bearbeiten, loeschen, oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), WebetkUtils.getPriceString(oTeil.getPreis()), WebetkUtils.getPriceString(oTeil.ermittleNetto()), WebetkUtils.getPriceString(oTeil.ermittleBrutto()), WebetkUtils.getPriceString(oTeil.ermittleMwSt())}) : new AbstractRow(new Object[]{teileinfo, loeschen, oTeil.getTeilenummerGespreizt(), oTeil.getBenennung(), oTeil.getZusatz(), oTeil.getMenge(), WebetkUtils.getPriceString(oTeil.getPreis()), WebetkUtils.getPriceString(oTeil.ermittleNetto()), WebetkUtils.getPriceString(oTeil.ermittleBrutto()), WebetkUtils.getPriceString(oTeil.ermittleMwSt())});
        }
        if (bJobOrSrpLock || oTeil.isScoreLock()) {
            oRow.setBackColor(LOCK_BACK_COLOR);
        }
        tabmodel.addRow(oRow);
    }

    private void handleClick(int comp, boolean bAsc) {
        this.mbSortierungAsc = bAsc;
        this.mnSortierung = comp;
        this.updateListe();
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuCollection.iterator();
    }

    protected JMenuItem createMenuItemMailDlg(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                    return;
                }
                MailAngaben dlg = new MailAngaben(DlgTeilelisteView.this.model.getTLDaten());
                dlg.show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createMenuItemFaxDlg(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                    return;
                }
                FaxAngaben dlg = new FaxAngaben(DlgTeilelisteView.this);
                dlg.show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    private JMenuItem createMenuItemExport(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                    return;
                }
                DlgTeilelisteView.this.moController.handleExport();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    private JMenuItem createMenuItemImport(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeilelisteView.this.moController.handleImport();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createMenuItemExportDatei(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                    return;
                }
                DlgTeilelisteView.this.moController.handleExportDateischnittstelle();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createBarverkaufMenuItem(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DlgTeilelisteView.this.model.getGesperrt()) {
                    String sNewID = null;
                    ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                    String sSelID = oSelItem.getID();
                    if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                        sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                    }
                    if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                        return;
                    }
                }
                DlgTeilelisteView.this.moController.handleBarverkauf();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createWerkstattauftragMenuItem(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DlgTeilelisteView.this.model.getGesperrt()) {
                    String sNewID = null;
                    ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                    String sSelID = oSelItem.getID();
                    if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                        sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                    }
                    if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                        return;
                    }
                }
                DlgTeilelisteView.this.moController.handleWerkstattauftrag();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createKostenvoranschlagMenuItem(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DlgTeilelisteView.this.model.getGesperrt()) {
                    String sNewID = null;
                    ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                    String sSelID = oSelItem.getID();
                    if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                        sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                    }
                    if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                        return;
                    }
                }
                DlgTeilelisteView.this.moController.handleKostenvoranschlag();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createMenuItemZurueckAnScore(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.getInstance().setVisible(false);
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createMenuItemPrint(String sMenuItem, final int nPrintArt) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                    return;
                }
                DlgTeilelisteView.this.mnPrintArt = nPrintArt;
                DlgTeilelisteView.this.mbPrintQuerformat = false;
                DlgTeilelisteView.this.mbPrintFISpalte = false;
                DlgTeilelisteView.this.mbPrintFIBloecke = false;
                DlgTeilelisteView.this.print();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    private JMenuItem createPrintBenDefMenuItem(String sMenuItem, final int nPrintArt) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNewID = null;
                ComboTeilelisteItem oSelItem = (ComboTeilelisteItem)DlgTeilelisteView.this.cbTeilelisten.getSelectedItem();
                String sSelID = oSelItem.getID();
                if (sSelID.equals(Resource.getInstance().getNeueListe())) {
                    sNewID = DlgTeilelisteView.this.tfTeilelisteNeu.getText();
                }
                if (!DlgTeilelisteView.this.moController.handleSaveTeileliste(sNewID, DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected())) {
                    return;
                }
                DlgTeilelisteView.this.mnPrintArt = nPrintArt;
                HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
                Druckausgabe dlg = new Druckausgabe(mapRetVal);
                dlg.show();
                Integer nRet = (Integer)mapRetVal.get("ret");
                if (nRet != 0) {
                    return;
                }
                DlgTeilelisteView.this.mbPrintQuerformat = (Boolean)mapRetVal.get("querformat");
                DlgTeilelisteView.this.mbPrintFISpalte = (Boolean)mapRetVal.get("fispalte");
                DlgTeilelisteView.this.mbPrintFIBloecke = !DlgTeilelisteView.this.mbPrintFISpalte;
                DlgTeilelisteView.this.print();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = new Paper();
        paper.setSize(pageFormat.getWidth(), pageFormat.getHeight());
        paper.setImageableArea(pageFormat.getImageableX() - 30.0, pageFormat.getImageableY() - 20.0, pageFormat.getImageableWidth() + 60.0, pageFormat.getImageableHeight() + 40.0);
        pageFormat.setPaper(paper);
        if (this.mbPrintQuerformat) {
            pageFormat.setOrientation(0);
        } else {
            pageFormat.setOrientation(1);
        }
        printJob.setPrintable(this, pageFormat);
        if (this.mnPrintArt == 0) {
            printJob.setJobName(Resource.getInstance().getTeilelisteRechnung());
        } else if (this.mnPrintArt == 1) {
            printJob.setJobName(Resource.getInstance().getTeilelisteKostenvoranschlag());
        } else if (this.mnPrintArt == 2) {
            printJob.setJobName(Resource.getInstance().getTeilelisteGreiferschein());
        }
        if (this.mnPrintArt == 0 || this.mnPrintArt == 1) {
            this.msPrintRechnungsnummer = this.moController.incrementRechungsnummer();
        }
        this.mnPrintOInd = 0;
        this.mnPrintRow = 0;
        this.mnPrintSummeGedruckt = 0;
        this.mPrintLastPageIndex = -1;
        if (printJob.printDialog()) {
            if (this.mbPrintQuerformat) {
                pageFormat.setOrientation(0);
            } else {
                pageFormat.setOrientation(1);
            }
            this.mbPrintReTrBloecke = this.model.istDMSAngeschlossen() && this.mnPrintArt == 1 && this.model.getTLDaten().hatMinEinTeilRetr();
            boolean save_mbSortierungAsc = this.mbSortierungAsc;
            int save_mnSortierung = this.mnSortierung;
            this.mbSortierungGeaendert = false;
            if (this.mbPrintReTrBloecke && !this.mbPrintFISpalte && !this.mbPrintFIBloecke) {
                this.mbSortierungAsc = true;
                this.mnSortierung = 80;
                this.updateListe();
                this.mbSortierungGeaendert = true;
            }
            if (this.mbPrintReTrBloecke && (this.mbPrintFISpalte || this.mbPrintFIBloecke)) {
                this.mbSortierungAsc = true;
                this.mnSortierung = 38;
                this.updateListe();
                this.mbSortierungGeaendert = true;
            }
            this.msLastFI = "";
            this.msLastRetr = "";
            this.msLastFIStringZwSum = "";
            this.msLastReTrStringZwSum = "";
            this.mbZwischenSumme = false;
            printJob.setPrintable(this, pageFormat);
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
            if (this.mbSortierungGeaendert) {
                this.mbSortierungAsc = save_mbSortierungAsc;
                this.mnSortierung = save_mnSortierung;
                this.updateListe();
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.mPrintLastPageIndex == pageIndex) {
            this.mnPrintRow = this.mnPrintOInd;
        } else {
            this.mPrintLastPageIndex = pageIndex;
            this.mnPrintOInd = this.mnPrintRow;
        }
        if (this.mnPrintRow >= this.mtabmodel.getRowCount() && (this.mnPrintSummeGedruckt > 1 || this.mnPrintArt == 2)) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int maxWidth = (int)pageFormat.getImageableWidth() - 1;
        int maxHeight = (int)pageFormat.getImageableHeight() - 2;
        Font headlinefont = UIHelper.getPrintTitleFont();
        Font textfont = UIHelper.getPrintFont();
        int xPosition = 0;
        int yPosition = 0;
        int secondColPosition = 315;
        int nMiddlePosition = (int)(pageFormat.getImageableWidth() / 2.0);
        g2d.setFont(headlinefont);
        int fontSize = headlinefont.getSize();
        if (pageIndex == 0) {
            String sUeberschrift;
            this.mbShowLegendeFH = false;
            yPosition = fontSize;
            if (this.mnPrintArt == 0) {
                sUeberschrift = Resource.getInstance().getTeilelisteRechnung();
                g2d.drawString(sUeberschrift, nMiddlePosition - sUeberschrift.length() * 3, yPosition);
            } else if (this.mnPrintArt == 1) {
                sUeberschrift = Resource.getInstance().getTeilelisteKostenvoranschlag();
                g2d.drawString(sUeberschrift, nMiddlePosition - sUeberschrift.length() * 3, yPosition);
            } else if (this.mnPrintArt == 2) {
                sUeberschrift = Resource.getInstance().getTeilelisteGreiferschein();
                g2d.drawString(sUeberschrift, nMiddlePosition - sUeberschrift.length() * 3, yPosition);
            }
        }
        yPosition += 20;
        g2d.setFont(textfont);
        fontSize = textfont.getSize();
        Konfiguration config = this.moController.getKonfiguration();
        Teileliste oTL = this.model.getTLDaten();
        g2d.drawString(config.getHaendleranschriftZeile1(), xPosition, yPosition += fontSize);
        g2d.drawString(Resource.getInstance().getSeite() + ": " + (pageIndex + 1), secondColPosition, yPosition);
        g2d.drawString(config.getHaendleranschriftZeile2(), xPosition, yPosition += fontSize);
        Date currentDate = new Date();
        g2d.drawString(Resource.getInstance().getDatumZeit() + ": " + DateFormat.getDateTimeInstance().format(currentDate), secondColPosition, yPosition);
        g2d.drawString(config.getHaendleranschriftZeile3(), xPosition, yPosition += fontSize);
        g2d.drawString(Resource.getInstance().getRechnungsnummer() + ": " + this.msPrintRechnungsnummer, secondColPosition, yPosition);
        g2d.drawString(config.getHaendleranschriftPLZ() + " " + config.getHaendleranschriftOrt(), xPosition, yPosition += fontSize);
        String sValue = this.tfAuftragsNr.getText();
        if (sValue == null) {
            sValue = this.txtAuftragsNrWert.getText();
        }
        if (sValue == null) {
            sValue = "";
        }
        g2d.drawString(Resource.getInstance().getAuftragsnummer() + ": " + sValue, secondColPosition, yPosition);
        g2d.drawString(config.getHaendleranschriftTelefon(), xPosition, yPosition += fontSize);
        sValue = this.tfKundenNr.getText();
        if (sValue == null) {
            sValue = this.txtKundenNrWert.getText();
        }
        if (sValue == null) {
            sValue = "";
        }
        g2d.drawString(Resource.getInstance().getKundennummer() + ": " + sValue, secondColPosition, yPosition);
        g2d.drawString(oTL.getID(), xPosition, yPosition += fontSize);
        sValue = Integer.toString(oTL.getTeile().size());
        g2d.drawString(Resource.getInstance().getAnzahlPositionen() + ": " + sValue, secondColPosition, yPosition);
        g2d.drawString(oTL.getBemerkung(), xPosition, yPosition += fontSize);
        boolean bFirstFI = true;
        int nAnzFzg = this.moController.ermittleAnzahlFahrzeuge();
        if (nAnzFzg != 0) {
            Vector<Teil> aTeile = oTL.getTeile();
            Iterator iter = null;
            if (aTeile != null) {
                iter = aTeile.iterator();
            }
            Iterator<String> iterKuerzel = null;
            iterKuerzel = oTL.ermittleFIKuerzel(true);
            String sLastFI = "";
            while (iter != null && iter.hasNext()) {
                String sFIKuerzel = "";
                if (iterKuerzel != null) {
                    sFIKuerzel = iterKuerzel.next();
                }
                Teil oTeil = (Teil)iter.next();
                String sFIString = "";
                if (oTeil != null) {
                    sFIString = oTeil.getFIString();
                }
                if (bFirstFI) {
                    yPosition += fontSize;
                    g2d.drawString(Resource.getInstance().getFahrzeug() + ": ", xPosition, yPosition += fontSize);
                }
                if (nAnzFzg == 1) {
                    this.mbPrintFISpalte = false;
                }
                if (("" + sFIKuerzel + sFIString).compareTo(sLastFI) <= 0) continue;
                if (this.mbPrintFISpalte) {
                    if (bFirstFI) {
                        bFirstFI = false;
                    } else {
                        yPosition += fontSize;
                    }
                    g2d.drawString(sFIKuerzel + "      " + sFIString, xPosition + 64, yPosition);
                } else {
                    if (bFirstFI) {
                        bFirstFI = false;
                        if (sFIString.equals("")) {
                            yPosition -= fontSize;
                        }
                    } else {
                        yPosition += fontSize;
                    }
                    if (!sFIString.equals("")) {
                        g2d.drawString(sFIString, xPosition + 64, yPosition);
                    }
                }
                sLastFI = "" + sFIKuerzel + sFIString;
            }
        } else {
            this.mbPrintFISpalte = false;
        }
        boolean left = false;
        boolean right = true;
        ArrayList<PrintColumn> printColumns = new ArrayList<PrintColumn>();
        PrintColumn pc = null;
        int start = 0;
        int width = 0;
        int ab = 10;
        int nEndeSumme = maxWidth;
        if (this.mbPrintFISpalte) {
            nEndeSumme = nEndeSumme - 6 - ab;
        }
        int totalWidth = 0;
        int xPosRetrBlockUeberschrift = 0;
        int xPosRetrBlockZwischenSummeText = 0;
        if (this.mnPrintArt == 2) {
            width = 18;
            pc = new PrintColumn(Resource.getInstance().getPos(), Resource.getInstance().getPos() + ".", start, width, 1);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 76;
            pc = new PrintColumn(Resource.getInstance().getTeilenummer(), Resource.getInstance().getTeilenummer(), start, width, 0);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            if (this.model.istDMSAngeschlossen()) {
                width = 30;
                pc = new PrintColumn(Resource.getInstance().getLagerort(), Resource.getInstance().getLagerort(), start, width, 0);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width + ab;
                width = 40;
                pc = new PrintColumn(Resource.getInstance().getBestand(), Resource.getInstance().getBestand(), start, width, 1);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width + ab;
                width = 30;
                pc = new PrintColumn(Resource.getInstance().getMe(), Resource.getInstance().getMenge(), start, width, 1);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width + ab;
                width = 120;
                pc = new PrintColumn(Resource.getInstance().getTeilebenennung(), Resource.getInstance().getBenennung(), start, width, 0);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width + ab;
            } else {
                width = 30;
                pc = new PrintColumn(Resource.getInstance().getMe(), Resource.getInstance().getMenge(), start, width, 1);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width + ab;
                width = 190;
                pc = new PrintColumn(Resource.getInstance().getTeilebenennung(), Resource.getInstance().getBenennung(), start, width, 0);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width + ab;
            }
            width = 65;
            pc = new PrintColumn(Resource.getInstance().getBemerkung(), Resource.getInstance().getBemerkung(), start, width, 0);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 6;
            pc = new PrintColumn(Resource.getInstance().getNueC(), Resource.getInstance().getNueC(), start, width, 0);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 6;
            pc = new PrintColumn(Resource.getInstance().getR(), Resource.getInstance().getR(), start, width, 0);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width;
            if (this.mbPrintFISpalte) {
                totalWidth += ab;
                width = 6;
                pc = new PrintColumn(Resource.getInstance().getNueF(), Resource.getInstance().getNueF(), start, width, 0);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width;
            }
            width = 40;
            pc = new PrintColumn(Resource.getInstance().getNueRetr(), Resource.getInstance().getNueRetr(), start, width, 0);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
        } else {
            width = 18;
            pc = new PrintColumn(Resource.getInstance().getPos(), Resource.getInstance().getPos() + ".", start, width, 1);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 76;
            pc = new PrintColumn(Resource.getInstance().getTeilenummer(), Resource.getInstance().getTeilenummer(), start, width, 0);
            printColumns.add(pc);
            xPosRetrBlockUeberschrift = start + width;
            start += width + ab;
            totalWidth += width + ab;
            width = 110;
            pc = new PrintColumn(Resource.getInstance().getTeilebenennung(), Resource.getInstance().getBenennung(), start, width, 0);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 30;
            pc = new PrintColumn(Resource.getInstance().getMe(), Resource.getInstance().getMenge(), start, width, 1);
            printColumns.add(pc);
            xPosRetrBlockZwischenSummeText = start - 10;
            start += width + ab;
            totalWidth += width + ab;
            width = 60;
            pc = new PrintColumn(Resource.getInstance().getPreis(), Resource.getInstance().getStueckpreis(), start, width, 1);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 30;
            pc = new PrintColumn(Resource.getInstance().getRabatt(), Resource.getInstance().getNueRab(), start, width, 1);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width + ab;
            width = 65;
            pc = new PrintColumn(Resource.getInstance().getNetto(), Resource.getInstance().getBetragNetto(), start, width, 1);
            printColumns.add(pc);
            start += width + ab;
            totalWidth += width;
            if (this.mbPrintFISpalte) {
                totalWidth += ab;
                width = 6;
                pc = new PrintColumn(Resource.getInstance().getNueF(), Resource.getInstance().getNueF(), start, width, 0);
                printColumns.add(pc);
                start += width + ab;
                totalWidth += width;
            }
        }
        if (totalWidth < maxWidth) {
            width = maxWidth - totalWidth;
            for (int ii = 0; ii < printColumns.size(); ++ii) {
                pc = (PrintColumn)printColumns.get(ii);
                if (!pc.printHeader.equals(Resource.getInstance().getBenennung())) continue;
                pc.columnWidth += width;
                for (int kk = ii + 1; kk < printColumns.size(); ++kk) {
                    pc = (PrintColumn)printColumns.get(kk);
                    pc.columnBegin += width;
                }
                break;
            }
        } else if (totalWidth > maxWidth) {
            log.warn((Object)"totalWidth > maxWidth!");
        }
        boolean bDetaileRowsPrinted = false;
        if (this.mnPrintRow < this.mtabmodel.getRowCount()) {
            this.msLastFI = "";
            this.msLastRetr = "";
            yPosition += 30;
            for (int i = 0; i < printColumns.size(); ++i) {
                pc = (PrintColumn)printColumns.get(i);
                String value = pc.printHeader;
                if (pc.columnFormat == 0) {
                    g2d.drawString(value, xPosition + pc.columnBegin, yPosition);
                    continue;
                }
                int end = pc.columnBegin + pc.columnWidth;
                g2d.drawString(value, xPosition + this.getPosition(value, end, g2d, textfont), yPosition);
            }
            yPosition += fontSize;
            if (this.mnPrintArt == 2) {
                Vector<Teil> cTeile = oTL.getTeile();
                for (Teil oTeil : cTeile) {
                    if (oTeil.getFertigungshinweis() == null || oTeil.getFertigungshinweis().length() <= 0) continue;
                    this.mbShowLegendeFH = true;
                    maxHeight -= fontSize * 2;
                    break;
                }
            }
            while (this.mnPrintRow < this.mtabmodel.getRowCount()) {
                yPosition += fontSize;
                int nOffset = 0;
                int iSizeMitZwSum = fontSize;
                if (this.mbPrintReTrBloecke) {
                    iSizeMitZwSum += fontSize * 3;
                }
                if (yPosition + iSizeMitZwSum > maxHeight) {
                    if (this.mbZwischenSumme) {
                        boolean bZwSumZeileNochDrucken = false;
                        this.printErmittleReTrString(oTL);
                        if (!this.msLastRetr.equals(this.msHelperReTrString)) {
                            bZwSumZeileNochDrucken = true;
                        } else if (this.mbPrintFIBloecke) {
                            this.printErmittleFIString(oTL);
                            if (!this.msLastFI.equals(this.msHelperFIString)) {
                                bZwSumZeileNochDrucken = true;
                            }
                        }
                        if (bZwSumZeileNochDrucken) {
                            String sZwischenSumme = this.mbPrintFISpalte || this.mbPrintFIBloecke ? WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuFzgUndRechnungsTransparenz(this.msLastFIStringZwSum, this.msLastReTrStringZwSum)) : WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuRechnungsTransparenz(this.msLastReTrStringZwSum));
                            g2d.drawString(Resource.getInstance().getZwischensumme(), xPosRetrBlockZwischenSummeText, yPosition);
                            g2d.drawString(sZwischenSumme, xPosition + this.getPosition(sZwischenSumme, nEndeSumme, g2d, textfont), yPosition);
                            yPosition += fontSize;
                            this.msLastFIStringZwSum = "";
                            this.msLastReTrStringZwSum = "";
                            this.mbZwischenSumme = false;
                        }
                    }
                    if (this.mbShowLegendeFH) {
                        g2d.drawString("*" + Resource.getInstance().getLegendeFertigungshinweis(), xPosition, yPosition += fontSize * 2);
                    }
                    return 0;
                }
                if (this.mbPrintFIBloecke) {
                    this.printErmittleFIString(oTL);
                    if (!this.msLastFI.equals(this.msHelperFIString)) {
                        if (this.mbZwischenSumme && bDetaileRowsPrinted) {
                            String sZwischenSumme = WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuFzgUndRechnungsTransparenz(this.msLastFIStringZwSum, this.msLastReTrStringZwSum));
                            g2d.drawString(Resource.getInstance().getZwischensumme(), xPosRetrBlockZwischenSummeText, yPosition);
                            g2d.drawString(sZwischenSumme, xPosition + this.getPosition(sZwischenSumme, nEndeSumme, g2d, textfont), yPosition);
                            yPosition += fontSize;
                            this.msLastRetr = "";
                            this.msLastFIStringZwSum = "";
                            this.msLastReTrStringZwSum = "";
                            this.mbZwischenSumme = false;
                        }
                        this.msLastFI = this.msHelperFIString;
                        this.msLastFIStringZwSum = this.msHelperLastFIStringZwSum;
                        if (this.msHelperFIString.length() > 0 && !this.msHelperFIString.equals("\u00ff") && this.mnPrintRow > 0) {
                            yPosition += fontSize;
                        }
                        if (yPosition + fontSize * 2 > maxHeight) {
                            if (this.mbShowLegendeFH) {
                                g2d.drawString("*" + Resource.getInstance().getLegendeFertigungshinweis(), xPosition, yPosition += fontSize * 2);
                            }
                            return 0;
                        }
                        if (!this.mbPrintReTrBloecke || !this.msHelperFIString.equals("\u00ff")) {
                            g2d.drawString(this.msHelperFIString, xPosition, yPosition);
                            yPosition += fontSize;
                        }
                    }
                }
                if (this.mbPrintReTrBloecke) {
                    this.printErmittleReTrString(oTL);
                    if (!this.msLastRetr.equals(this.msHelperReTrString)) {
                        if (this.mbZwischenSumme && bDetaileRowsPrinted) {
                            String sZwischenSumme = this.mbPrintFISpalte || this.mbPrintFIBloecke ? WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuFzgUndRechnungsTransparenz(this.msLastFIStringZwSum, this.msLastReTrStringZwSum)) : WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuRechnungsTransparenz(this.msLastReTrStringZwSum));
                            g2d.drawString(Resource.getInstance().getZwischensumme(), xPosRetrBlockZwischenSummeText, yPosition);
                            g2d.drawString(sZwischenSumme, xPosition + this.getPosition(sZwischenSumme, nEndeSumme, g2d, textfont), yPosition);
                            yPosition += fontSize;
                            this.msLastFIStringZwSum = "";
                            this.msLastReTrStringZwSum = "";
                            this.mbZwischenSumme = false;
                        }
                        if (yPosition + fontSize * 2 > maxHeight) {
                            if (this.mbShowLegendeFH) {
                                g2d.drawString("*" + Resource.getInstance().getLegendeFertigungshinweis(), xPosition, yPosition += fontSize * 2);
                            }
                            return 0;
                        }
                        this.msLastRetr = this.msHelperReTrString;
                        this.msLastFIStringZwSum = this.msHelperLastFIStringZwSum;
                        this.msLastReTrStringZwSum = this.msHelperLastReTrStringZwSum;
                        if (!this.mbPrintFISpalte && this.msLastRetr.equals("\u00ff\u00ff\u00ff\u00ff") || this.mbPrintFISpalte && this.msLastRetr.endsWith("\u00ff\u00ff\u00ff\u00ff")) {
                            if (!this.mbPrintFIBloecke && !this.mbPrintFISpalte) {
                                yPosition += fontSize;
                            }
                        } else {
                            g2d.drawString("RT = " + this.msHelperReTrStringForPrint, xPosition + xPosRetrBlockUeberschrift, yPosition);
                            yPosition += fontSize;
                        }
                        this.mbZwischenSumme = true;
                    }
                }
                bDetaileRowsPrinted = true;
                for (int j = 0; j < printColumns.size(); ++j) {
                    pc = (PrintColumn)printColumns.get(j);
                    boolean bSpalteFound = false;
                    for (int i = 0; i < this.mtabmodel.getColumnCount(); ++i) {
                        if (!this.mtabmodel.getConfiguration().getColumnName(i).equals(pc.tableHeader)) continue;
                        if (pc.tableHeader.equals(Resource.getInstance().getTeilenummer())) {
                            StringBuffer value = new StringBuffer(this.mtabmodel.getValueAt(this.mnPrintRow, i).toString());
                            g2d.drawString(value.toString(), xPosition + pc.columnBegin, yPosition);
                        } else if (pc.tableHeader.equals(Resource.getInstance().getTeilebenennung()) || pc.tableHeader.equals(Resource.getInstance().getBemerkung())) {
                            TextLayout layout;
                            int nOffsetSpalte = 0;
                            String value = this.mtabmodel.getValueAt(this.mnPrintRow, i).toString();
                            if (value == null || value.equals("")) {
                                value = " ";
                            }
                            AttributedString cellText = new AttributedString(value);
                            cellText.addAttribute(TextAttribute.FONT, textfont);
                            cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                            LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
                            boolean bFirstRow = true;
                            while ((layout = lineBreaker.nextLayout(pc.columnWidth)) != null) {
                                if (!bFirstRow) {
                                    nOffsetSpalte += fontSize;
                                }
                                bFirstRow = false;
                                layout.draw(g2d, xPosition + pc.columnBegin, yPosition + nOffsetSpalte);
                            }
                            if (nOffsetSpalte > nOffset) {
                                nOffset = nOffsetSpalte;
                            }
                        } else {
                            Object oValue = this.mtabmodel.getValueAt(this.mnPrintRow, i);
                            sValue = "";
                            if (oValue != null) {
                                sValue = oValue.toString();
                            }
                            if (pc.columnFormat == 0) {
                                g2d.drawString(sValue, xPosition + pc.columnBegin, yPosition);
                            } else {
                                g2d.drawString(sValue.replace(',', '.'), xPosition + this.getPosition(sValue, pc.columnBegin + pc.columnWidth, g2d, textfont), yPosition);
                            }
                        }
                        bSpalteFound = true;
                        break;
                    }
                    if (bSpalteFound || !Resource.getInstance().getNueC().equals(pc.tableHeader)) continue;
                    sValue = "";
                    Vector<Teil> cTeile = oTL.getTeile();
                    for (Teil oTeil : cTeile) {
                        if (oTeil.getPosInt() != this.mnPrintRow + 1) continue;
                        if (oTeil.getFertigungshinweis() == null || oTeil.getFertigungshinweis().length() <= 0) break;
                        sValue = "*";
                        break;
                    }
                    g2d.drawString(sValue, xPosition + pc.columnBegin, yPosition);
                }
                yPosition += nOffset;
                ++this.mnPrintRow;
            }
        }
        int iAnzZeilenSummen = this.mbPrintReTrBloecke && this.mbZwischenSumme ? (bDetaileRowsPrinted ? fontSize * 7 : fontSize * 8) : fontSize * 6;
        if (maxHeight - yPosition < iAnzZeilenSummen) {
            if (this.mbShowLegendeFH) {
                g2d.drawString("*" + Resource.getInstance().getLegendeFertigungshinweis(), xPosition, yPosition += fontSize * 2);
            }
            return 0;
        }
        if (this.mnPrintArt != 2) {
            if (this.mbPrintReTrBloecke && this.mbZwischenSumme) {
                String sZwischenSumme = this.mbPrintFISpalte || this.mbPrintFIBloecke ? WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuFzgUndRechnungsTransparenz(this.msLastFIStringZwSum, this.msLastReTrStringZwSum)) : WebetkUtils.getPriceString(oTL.ermittleSummeNettoZuRechnungsTransparenz(this.msLastReTrStringZwSum));
                yPosition = bDetaileRowsPrinted ? (yPosition += fontSize * 1) : (yPosition += fontSize * 2);
                g2d.drawString(Resource.getInstance().getZwischensumme(), xPosRetrBlockZwischenSummeText, yPosition);
                g2d.drawString(sZwischenSumme, xPosition + this.getPosition(sZwischenSumme, nEndeSumme, g2d, textfont), yPosition);
                if (this.mnPrintSummeGedruckt != 0) {
                    this.msLastFIStringZwSum = "";
                    this.msLastReTrStringZwSum = "";
                    this.mbZwischenSumme = false;
                }
            }
            String nettoSummeString = this.txtSummeNettoWert.getText();
            String mehrwertsteuerString = WebetkUtils.getPriceString(oTL.ermittleSummeMwSt());
            String atsteuerString = WebetkUtils.getPriceString(oTL.ermittleSummeAtSt());
            String gesamtsummeString = this.txtSummeBruttoWert.getText();
            g2d.drawString(Resource.getInstance().getGesamtsummeNetto(), xPosition, yPosition += fontSize * 2);
            g2d.drawString(nettoSummeString, xPosition + this.getPosition(nettoSummeString, nEndeSumme, g2d, textfont), yPosition);
            g2d.drawString(Resource.getInstance().getMehrwertsteuer(), xPosition, yPosition += fontSize);
            g2d.drawString(mehrwertsteuerString, xPosition + this.getPosition(mehrwertsteuerString, nEndeSumme, g2d, textfont), yPosition);
            g2d.drawString(Resource.getInstance().getAtSteuer(), xPosition, yPosition += fontSize);
            g2d.drawString(atsteuerString, xPosition + this.getPosition(atsteuerString, nEndeSumme, g2d, textfont), yPosition);
            yPosition += fontSize;
            AttributedString cellText = new AttributedString("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
            cellText.addAttribute(TextAttribute.FONT, textfont);
            cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
            TextLayout layout = lineBreaker.nextLayout(maxWidth + 1);
            layout.draw(g2d, xPosition, yPosition);
            g2d.drawString(Resource.getInstance().getGesamtsummeBrutto(), xPosition, yPosition += fontSize);
            g2d.drawString(gesamtsummeString, xPosition + this.getPosition(gesamtsummeString, nEndeSumme, g2d, textfont), yPosition);
            ++this.mnPrintSummeGedruckt;
        }
        if (this.mbShowLegendeFH) {
            g2d.drawString("*" + Resource.getInstance().getLegendeFertigungshinweis(), xPosition, yPosition += fontSize * 2);
        }
        return 0;
    }

    private void printErmittleFIString(Teileliste oTL) {
        this.msHelperFIString = "";
        this.msHelperLastFIStringZwSum = "";
        Vector<Teil> cTeile = oTL.getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
        Iterator iter = cTeile.iterator();
        int nCount = 0;
        while (iter.hasNext()) {
            Teil oTeil = (Teil)iter.next();
            if (++nCount != this.mnPrintRow + 1) continue;
            if (oTeil.getFIString() != null && oTeil.getFIString().trim().length() > 0) {
                this.msHelperFIString = oTeil.getFIString();
            } else if (this.mbPrintReTrBloecke) {
                this.msHelperFIString = "\u00ff";
            }
            if (oTeil.getFIString() == null || oTeil.getFIString().trim().length() <= 0) break;
            this.msHelperLastFIStringZwSum = oTeil.getFIString();
            break;
        }
    }

    private void printErmittleReTrString(Teileliste oTL) {
        this.msHelperReTrString = "";
        this.msHelperLastFIStringZwSum = "";
        this.msHelperLastReTrStringZwSum = "";
        this.msHelperReTrStringForPrint = "";
        Vector<Teil> cTeile = oTL.getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
        Iterator iter = cTeile.iterator();
        int nCount = 0;
        while (iter.hasNext()) {
            Teil oTeil = (Teil)iter.next();
            if (++nCount != this.mnPrintRow + 1) continue;
            if (oTeil.getTransparenz() != null && oTeil.getTransparenz().trim().length() > 0) {
                this.msHelperLastReTrStringZwSum = this.msHelperReTrString = oTeil.getTransparenz();
            } else {
                this.msHelperReTrString = "\u00ff\u00ff\u00ff\u00ff";
            }
            this.msHelperReTrStringForPrint = this.msHelperReTrString;
            if ((this.mbPrintFISpalte || this.mbPrintFIBloecke) && oTeil.getFIString() != null && oTeil.getFIString().trim().length() > 0) {
                this.msHelperLastFIStringZwSum = oTeil.getFIString();
            }
            if (!this.mbPrintFISpalte) break;
            if (oTeil.getFIKuerzel() != null && oTeil.getFIKuerzel().trim().length() > 0) {
                this.msHelperReTrString = oTeil.getFIKuerzel() + this.msHelperReTrString;
                break;
            }
            this.msHelperReTrString = "\u00ff" + this.msHelperReTrString;
            break;
        }
    }

    protected int getPosition(String value, int endPosition, Graphics2D g2d, Font textfont) {
        if (value == null || value.equals("")) {
            value = " ";
        }
        AttributedString cellText = new AttributedString(value);
        cellText.addAttribute(TextAttribute.FONT, textfont);
        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
        TextLayout layout = lineBreaker.nextLayout(1000.0f);
        float lText = layout.getAdvance();
        int pX = endPosition - (int)lText;
        return pX;
    }

    protected GenericTableModel getTableModel() {
        return this.mtabmodel;
    }

    protected String getListenID() {
        if (this.tfTeilelisteNeu.getText() != null && this.tfTeilelisteNeu.getText().length() > 0) {
            return this.tfTeilelisteNeu.getText();
        }
        return this.txtTeilelisteGewaehltWert.getText();
    }

    protected String getKundennummer() {
        if (this.tfKundenNr.getText() != null) {
            return this.tfKundenNr.getText();
        }
        return "";
    }

    protected String getKundenname() {
        if (this.tfKundenName.getText() != null) {
            return this.tfKundenName.getText();
        }
        return "";
    }

    protected String getAuftragsnummer() {
        if (this.tfAuftragsNr.getText() != null) {
            return this.tfAuftragsNr.getText();
        }
        return "";
    }

    protected String getBemerkung() {
        if (this.tfBemerkung.getText() != null) {
            return this.tfBemerkung.getText();
        }
        return "";
    }

    protected String getErstelltAm() {
        return this.txtErstelltAmWert.getText();
    }

    protected String getLetztmalsGeaendertAm() {
        return this.txtGeaendertAmWert.getText();
    }

    protected Vector<Teil> getSelTeileFromTab(GenericTable table) {
        Collection<Teil> aTeile = null;
        Teileliste oTl = this.model.getTLDaten();
        if (oTl instanceof Scoreliste) {
            Scoreliste oSl = (Scoreliste)oTl;
            ScorelisteJob job = this.mMapScoreJobToTable.get(table);
            ScorelisteSrp srp = this.mMapScoreSrpToTable.get(table);
            aTeile = oSl.getTeileOhneLoeschflag(job.getId(), srp.getId());
        } else {
            aTeile = this.mnSortierung == 0 && this.mbSortierungAsc ? this.model.getTLDaten().getTeile() : this.model.getTLDaten().getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
        }
        Vector<Teil> aSelTeile = new Vector<Teil>();
        int[] aRows = table.getSelectedRows();
        block0: for (int ii = 0; ii < aRows.length; ++ii) {
            Iterator<Teil> iter = aTeile.iterator();
            int nCount = -1;
            while (iter.hasNext()) {
                Teil oTeil = iter.next();
                if (++nCount != aRows[ii]) continue;
                aSelTeile.add(oTeil);
                continue block0;
            }
        }
        return aSelTeile;
    }

    private Teil getTeilAtRow(int nRow) {
        Vector<Teil> aTeile = null;
        aTeile = this.mnSortierung == 0 && this.mbSortierungAsc ? this.model.getTLDaten().getTeile() : this.model.getTLDaten().getTeileSortiert(this.mnSortierung, this.mbSortierungAsc);
        int[] aRows = this.mtable.getTable().getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            Iterator iter = aTeile.iterator();
            int nInd = -1;
            while (iter.hasNext()) {
                Teil oTeil = (Teil)iter.next();
                if (++nInd != nRow) continue;
                return oTeil;
            }
        }
        return null;
    }

    protected void requestFocusCbTeilelisten() {
        this.cbTeilelisten.requestFocus();
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        Vector<Teil> aSelTeile = this.getSelTeileFromTab(this.mtable);
        if (aSelTeile == null || aSelTeile.size() == 0) {
            return null;
        }
        Iterator<Teil> iter = aSelTeile.iterator();
        Teil oTeil = iter.next();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = oTeil.getSachnummer();
        String sTeilenummer = oTeil.getTeilenummerGespreizt();
        String sBenennungZusatz = oTeil.getBenennung();
        String sZusatz = oTeil.getZusatz();
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        Vector<String> aMarke = oTeil.getMarken();
        String sMarkeTeileliste = null;
        Teileliste oTeileliste = this.model.getTLDaten();
        if (oTeileliste != null) {
            sMarkeTeileliste = oTeileliste.getMarke();
        }
        String sMarke = null;
        sMarke = aMarke == null ? sMarkeTeileliste : GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeTeileliste);
        String sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    public DlgTeilelisteModel getModel() {
        return this.model;
    }

    public ArrayList<String> getColumnConfig() {
        return this.columnConfig;
    }

    public void updateTable(ArrayList<String> config) {
        this.columnConfig = config;
        this.createTabelle();
        this.update();
    }

    protected static class PrintColumn {
        public String tableHeader;
        public String printHeader;
        public int columnBegin;
        public int columnWidth;
        public int columnFormat;

        public PrintColumn(String tableHeader, String printHeader, int columnBegin, int columnWidth, int columnFormat) {
            this.tableHeader = tableHeader;
            this.printHeader = printHeader;
            this.columnBegin = columnBegin;
            this.columnWidth = columnWidth;
            this.columnFormat = columnFormat;
        }
    }

    protected class TeilelisteMouseListener
    extends GenericTableMouseEventAdapter {
        protected TeilelisteMouseListener() {
        }

        @Override
        public void popupOnCell(GenericTableMouseEvent evt) {
            Vector<Teil> aSelTeile = DlgTeilelisteView.this.getSelTeileFromTab(DlgTeilelisteView.this.mtable);
            if (aSelTeile.size() > 0) {
                DlgTeilelisteView.this.popupMenu.show(DlgTeilelisteView.this.mtable.getTable(), evt.getX(), evt.getY());
                if (aSelTeile.size() > 1) {
                    DlgTeilelisteView.this.popupActionCopySachnummer.setEnabled(false);
                    DlgTeilelisteView.this.popupActionTeileverwendungTeil.setEnabled(false);
                    DlgTeilelisteView.this.popupActionInterpretation.setEnabled(false);
                    DlgTeilelisteView.this.popupActionEinzelteile.setEnabled(false);
                    DlgTeilelisteView.this.popupActionTeileinfo.setEnabled(false);
                } else {
                    Teil oTeil = aSelTeile.get(0);
                    if (oTeil.getLokalteil()) {
                        DlgTeilelisteView.this.popupActionTeileverwendungTeil.setEnabled(false);
                        DlgTeilelisteView.this.popupActionEinzelteile.setEnabled(false);
                        DlgTeilelisteView.this.popupActionInterpretation.setEnabled(false);
                    } else {
                        DlgTeilelisteView.this.popupActionTeileverwendungTeil.setEnabled(true);
                        DlgTeilelisteView.this.popupActionEinzelteile.setEnabled(((MenuItemEinzelteile)DlgTeilelisteView.this.popupActionEinzelteile).hatEinzelteile());
                        DlgTeilelisteView.this.popupActionInterpretation.setEnabled(((MenuItemInterpretation)DlgTeilelisteView.this.popupActionInterpretation).hatInterpretation());
                    }
                    DlgTeilelisteView.this.popupActionCopySachnummer.setEnabled(true);
                    DlgTeilelisteView.this.popupActionTeileinfo.setEnabled(true);
                    DlgTeilelisteView.this.popupActionBearbeiten.setEnabled(true);
                    if (DlgTeilelisteView.this.model.istDMSAngeschlossen()) {
                        DlgTeilelisteView.this.popupActionStammsatz.setEnabled(true);
                    }
                }
            }
        }

        @Override
        public void clickedOnCell(GenericTableMouseEvent evt) {
            Teil oTeil = null;
            int nCol = evt.getColumn();
            oTeil = DlgTeilelisteView.this.getTeilAtRow(evt.getRow());
            Vector<Teil> cSelTeile = new Vector<Teil>();
            cSelTeile.add(oTeil);
            if (nCol == DlgTeilelisteView.this.mnColInfo) {
                DlgTeilelisteView.this.moController.handleTeileinfo(oTeil);
            } else if (nCol == DlgTeilelisteView.this.mnColEdit) {
                DlgTeilelisteView.this.moController.handleEditTeile(cSelTeile);
            } else if (nCol == DlgTeilelisteView.this.mnColDel) {
                JScrollPane sc = DlgTeilelisteView.this.mtable.getScrollPane();
                JScrollBar sb = sc.getVerticalScrollBar();
                final int nScrollVal = sb.getValue();
                DlgTeilelisteView.this.moController.handleDeleteTeile(cSelTeile);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JScrollPane sc = DlgTeilelisteView.this.mtable.getScrollPane();
                        JScrollBar sb = sc.getVerticalScrollBar();
                        sb.setValue(nScrollVal);
                    }
                });
            }
        }
    }

    protected class TeilelisteScoreMouseListener
    extends GenericTableMouseEventAdapter {
        protected TeilelisteScoreMouseListener() {
        }

        @Override
        public void popupOnCell(GenericTableMouseEvent evt) {
            GenericTable table = (GenericTable)evt.getSource();
            DlgTeilelisteView.this.mtable = table;
            Vector<Teil> aSelTeile = DlgTeilelisteView.this.getSelTeileFromTab(table);
            if (aSelTeile.size() > 0) {
                DlgTeilelisteView.this.popupMenu.show(table, evt.getX(), evt.getY());
                boolean bScoreLock = false;
                Teileliste oTl = DlgTeilelisteView.this.model.getTLDaten();
                if (oTl instanceof Scoreliste) {
                    ScorelisteJob job = (ScorelisteJob)DlgTeilelisteView.this.mMapScoreJobToTable.get(table);
                    ScorelisteSrp srp = (ScorelisteSrp)DlgTeilelisteView.this.mMapScoreSrpToTable.get(table);
                    boolean bl = bScoreLock = job.isLock() || srp.isLock();
                    if (!bScoreLock) {
                        for (Teil oTeil : aSelTeile) {
                            if (!oTeil.isScoreLock()) continue;
                            bScoreLock = true;
                        }
                    }
                }
                if (aSelTeile.size() > 1) {
                    DlgTeilelisteView.this.popupActionCopySachnummer.setEnabled(false);
                    DlgTeilelisteView.this.popupActionTeileverwendungTeil.setEnabled(false);
                    DlgTeilelisteView.this.popupActionInterpretation.setEnabled(false);
                    DlgTeilelisteView.this.popupActionEinzelteile.setEnabled(false);
                    DlgTeilelisteView.this.popupActionTeileinfo.setEnabled(false);
                } else {
                    DlgTeilelisteView.this.popupActionCopySachnummer.setEnabled(true);
                    DlgTeilelisteView.this.popupActionTeileverwendungTeil.setEnabled(true);
                    DlgTeilelisteView.this.popupActionEinzelteile.setEnabled(((MenuItemEinzelteile)DlgTeilelisteView.this.popupActionEinzelteile).hatEinzelteile());
                    DlgTeilelisteView.this.popupActionInterpretation.setEnabled(((MenuItemInterpretation)DlgTeilelisteView.this.popupActionInterpretation).hatInterpretation());
                    DlgTeilelisteView.this.popupActionTeileinfo.setEnabled(true);
                    DlgTeilelisteView.this.popupActionBearbeiten.setEnabled(true);
                    if (DlgTeilelisteView.this.model.istDMSAngeschlossen()) {
                        DlgTeilelisteView.this.popupActionStammsatz.setEnabled(true);
                    }
                }
                if (bScoreLock) {
                    DlgTeilelisteView.this.popupActionBearbeiten.setEnabled(false);
                    DlgTeilelisteView.this.popupActionLoeschen.setEnabled(false);
                }
            }
        }

        @Override
        public void clickedOnCell(GenericTableMouseEvent evt) {
            JScrollBar sb;
            JScrollPane sc;
            GenericTable table = (GenericTable)evt.getSource();
            Teil oTeil = null;
            int nCol = evt.getColumn();
            Vector aTeile = null;
            Teileliste oTl = DlgTeilelisteView.this.model.getTLDaten();
            boolean bScoreLock = false;
            if (oTl instanceof Scoreliste) {
                Scoreliste oSl = (Scoreliste)oTl;
                ScorelisteJob job = (ScorelisteJob)DlgTeilelisteView.this.mMapScoreJobToTable.get(table);
                ScorelisteSrp srp = (ScorelisteSrp)DlgTeilelisteView.this.mMapScoreSrpToTable.get(table);
                aTeile = (Vector)oSl.getTeileOhneLoeschflag(job.getId(), srp.getId());
                boolean bl = bScoreLock = job.isLock() || srp.isLock();
                if (!bScoreLock && (oTeil = (Teil)aTeile.get(evt.getRow())).isScoreLock()) {
                    bScoreLock = true;
                }
                for (GenericTable otherTable : DlgTeilelisteView.this.maScoreTeileTables) {
                    if (otherTable == table) continue;
                    otherTable.clearSelection();
                }
            } else {
                aTeile = oTl.getTeile();
            }
            oTeil = aTeile.get(evt.getRow());
            Vector<Teil> cSelTeile = null;
            if (bScoreLock) {
                switch (nCol) {
                    case 0: {
                        DlgTeilelisteView.this.moController.handleTeileinfo(oTeil);
                    }
                }
            } else if (!DlgTeilelisteView.this.model.getGesperrt()) {
                switch (nCol) {
                    case 0: {
                        DlgTeilelisteView.this.moController.handleTeileinfo(oTeil);
                        break;
                    }
                    case 1: {
                        cSelTeile = new Vector<Teil>();
                        cSelTeile.add(oTeil);
                        DlgTeilelisteView.this.moController.handleEditTeile(cSelTeile);
                        break;
                    }
                    case 2: {
                        cSelTeile = new Vector();
                        cSelTeile.add(oTeil);
                        sc = DlgTeilelisteView.this.mtable.getScrollPane();
                        sb = sc.getVerticalScrollBar();
                        final int nScrollVal = sb.getValue();
                        DlgTeilelisteView.this.moController.handleDeleteTeile(cSelTeile);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JScrollPane sc = DlgTeilelisteView.this.mtable.getScrollPane();
                                JScrollBar sb = sc.getVerticalScrollBar();
                                sb.setValue(nScrollVal);
                            }
                        });
                    }
                }
            } else {
                switch (nCol) {
                    case 0: {
                        DlgTeilelisteView.this.moController.handleTeileinfo(oTeil);
                        break;
                    }
                    case 1: {
                        cSelTeile = new Vector();
                        cSelTeile.add(oTeil);
                        sc = DlgTeilelisteView.this.mtable.getScrollPane();
                        sb = sc.getVerticalScrollBar();
                        final int nScrollVal = sb.getValue();
                        DlgTeilelisteView.this.moController.handleDeleteTeile(cSelTeile);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JScrollPane sc = DlgTeilelisteView.this.mtable.getScrollPane();
                                JScrollBar sb = sc.getVerticalScrollBar();
                                sb.setValue(nScrollVal);
                            }
                        });
                    }
                }
            }
        }
    }

    protected class ChkValueChangedListener
    implements ActionListener {
        protected ChkValueChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DlgTeilelisteView.this.model.checkKopfdatenGeaendert(DlgTeilelisteView.this.tfTeilelisteNeu.getText(), DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected());
        }
    }

    protected class ValueChangedListener
    extends KeyAdapter {
        protected ValueChangedListener() {
        }

        @Override
        public void keyReleased(KeyEvent ev) {
            DlgTeilelisteView.this.model.checkKopfdatenGeaendert(DlgTeilelisteView.this.tfTeilelisteNeu.getText(), DlgTeilelisteView.this.tfBemerkung.getText(), DlgTeilelisteView.this.txtAuftragsNrWert.getText(), DlgTeilelisteView.this.txtKundenNrWert.getText(), DlgTeilelisteView.this.chkPrivat.isSelected());
        }
    }
}

