/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class JobSrp
extends JDialog {
    private static final long serialVersionUID = 1L;
    private StringBuffer sbJobId;
    private StringBuffer sbSrpId;
    private Scoreliste oSL;
    private HeaderPanel headerPanel;
    private JLabel txtJob;
    private JComboBox cbJob;
    private JLabel txtSrp;
    private JComboBox cbSrp;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonAbbrechen;

    public JobSrp(Scoreliste oSL, StringBuffer sbJobId, StringBuffer sbSrpId) {
        super((Frame)MainView.getInstance(), true);
        this.oSL = oSL;
        sbJobId.delete(0, sbJobId.length());
        this.sbJobId = sbJobId;
        sbSrpId.delete(0, sbSrpId.length());
        this.sbSrpId = sbSrpId;
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilHinzufuegen(), null);
        this.setSize(550, 250);
        this.setLocation(50, 10);
        this.initComponents();
    }

    protected void initComponents() {
        this.txtJob = new JLabel(Resource.getInstance().getJob());
        this.cbJob = new JComboBox();
        this.cbJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobSrp.this.cbSrp.removeAllItems();
                ScorelisteJob job = (ScorelisteJob)JobSrp.this.cbJob.getSelectedItem();
                Collection<ScorelisteSrp> srps = job.getSrps();
                if (srps.size() != 1) {
                    ScorelisteSrp srpLeer = new ScorelisteSrp();
                    srpLeer.setId("");
                    srpLeer.setBezeichnung("");
                    JobSrp.this.cbSrp.addItem(srpLeer);
                }
                for (ScorelisteSrp srp : srps) {
                    JobSrp.this.cbSrp.addItem(srp);
                }
            }
        });
        this.txtSrp = new JLabel(Resource.getInstance().getSrp());
        this.cbSrp = new JComboBox();
        Collection<ScorelisteJob> jobs = this.oSL.getJobs();
        if (jobs.size() != 1) {
            ScorelisteJob jobLeer = new ScorelisteJob();
            jobLeer.setId("");
            jobLeer.setBezeichnung("");
            this.cbJob.addItem(jobLeer);
        }
        for (ScorelisteJob job : jobs) {
            this.cbJob.addItem(job);
        }
        if (this.cbJob.getItemCount() == 1 && this.cbSrp.getItemCount() == 1) {
            this.doOkButtonAction();
            return;
        }
        this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    protected void layoutAll() {
        Container contentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPane.setLayout(l);
        contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    protected JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 20, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] heights = new int[]{10, 0, 10, 0, 10};
        int[] widths = new int[]{1, 0, 10, 0, 1};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.txtJob, c.rc(2, 2, "l"));
        panel.add((Component)this.cbJob, c.rc(2, 4, "l"));
        panel.add((Component)this.txtSrp, c.rc(4, 2, "l"));
        panel.add((Component)this.cbSrp, c.rc(4, 4, "l"));
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.buttonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.buttonAbbrechen, c.rc(1, 4, "lrtb"));
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobSrp.this.doOkButtonAction();
            }
        });
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobSrp.this.dispose();
            }
        });
        return panel;
    }

    protected void doOkButtonAction() {
        ScorelisteJob job = (ScorelisteJob)this.cbJob.getSelectedItem();
        if (job.getId().length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoJob(), this.getTitle(), 0);
            return;
        }
        ScorelisteSrp srp = (ScorelisteSrp)this.cbSrp.getSelectedItem();
        if (srp.getId().length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoSrp(), this.getTitle(), 0);
            return;
        }
        ScorelisteJob seljob = (ScorelisteJob)this.cbJob.getSelectedItem();
        this.sbJobId.append(seljob.getId());
        ScorelisteSrp selsrp = (ScorelisteSrp)this.cbSrp.getSelectedItem();
        this.sbSrpId.append(selsrp.getId());
        this.dispose();
    }
}

