/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class MailAngaben {
    private JDialog mDlg;
    protected JPanel headerPanel;
    private Container contentPane;
    private static Logger log = Logger.getLogger(MailAngaben.class);
    private Teileliste moTL;
    private JLabel txtAn;
    private JLabel txtAnEMailAdresse;
    private JLabel txtVonEMailAdresse;
    private JLabel txtVon;
    private JLabel txtVonName;
    private JLabel txtBetreff;
    private JLabel txtFreitext;
    private JTextField tfAnEMailAdresse;
    private JTextField tfVon;
    private JTextField tfVonEMailAdresse;
    private JTextField tfBetreff;
    private JTextField tfFreitext;
    private JCheckBox chkAnEMailAdresse;
    private JCheckBox chkVonEMailAdresse;
    private JCheckBox chkPreise;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonAbbrechen;

    public MailAngaben(Teileliste oTL) {
        this.moTL = oTL;
        this.mDlg = new JDialog((Frame)MainView.getInstance(), false);
        this.mDlg.setModal(true);
        this.mDlg.setTitle(Resource.getInstance().getTeilelisteMailangabenHeader());
        this.mDlg.setSize(720, 420);
        this.mDlg.setLocation(50, 10);
        this.initComponents();
        this.ladeAdressen();
    }

    public void initComponents() {
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilelisteMailangabenHeader(), null);
        this.txtAn = new JLabel(Resource.getInstance().getAn());
        this.txtAnEMailAdresse = new JLabel(Resource.getInstance().getEMailAdresse());
        this.txtVonEMailAdresse = new JLabel(Resource.getInstance().getEMailAdresse());
        this.txtVonName = new JLabel(Resource.getInstance().getName());
        this.tfAnEMailAdresse = new JTextField(40);
        this.chkAnEMailAdresse = new JCheckBox(Resource.getInstance().getAbsenderSpeichern(), false);
        this.txtVon = new JLabel(Resource.getInstance().getVon());
        this.tfVon = new JTextField(40);
        this.tfVonEMailAdresse = new JTextField(40);
        this.chkVonEMailAdresse = new JCheckBox(Resource.getInstance().getEmpfaengerSpeichern(), false);
        this.txtBetreff = new JLabel(Resource.getInstance().getBetreff());
        this.tfBetreff = new JTextField(40);
        this.txtFreitext = new JLabel(Resource.getInstance().getFreitext());
        this.tfFreitext = new JTextField(40);
        this.chkPreise = new JCheckBox(Resource.getInstance().getMitNettopreisen());
        this.buttonUebernehmen = new JButtonEx("", ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    protected void layoutAll() {
        this.contentPane = this.mDlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.contentPane.setLayout(l);
        this.contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10, 0, 10};
        int[] heights = new int[]{5, 0, 0, 20, 0, 10, 0, 0, 20, 0, 10, 0, 10, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.txtAn, c.rc(2, 2, "lt"));
        panel.add((Component)this.txtAnEMailAdresse, c.rc(2, 4, "lt"));
        panel.add((Component)this.tfAnEMailAdresse, c.rc(2, 6, "lt"));
        panel.add((Component)this.chkAnEMailAdresse, c.rc(3, 6, "lt"));
        panel.add((Component)this.txtVon, c.rc(5, 2, "lt"));
        panel.add((Component)this.txtVonName, c.rc(5, 4, "lt"));
        panel.add((Component)this.tfVon, c.rc(5, 6, "lt"));
        panel.add((Component)this.txtVonEMailAdresse, c.rc(7, 4, "lt"));
        panel.add((Component)this.tfVonEMailAdresse, c.rc(7, 6, "lt"));
        panel.add((Component)this.chkVonEMailAdresse, c.rc(8, 6, "lt"));
        panel.add((Component)this.txtBetreff, c.rc(10, 2, "lt"));
        panel.add((Component)this.tfBetreff, c.rc(10, 6, "lt"));
        panel.add((Component)this.txtFreitext, c.rc(12, 2, "lt"));
        panel.add((Component)this.tfFreitext, c.rc(12, 6, "lt"));
        panel.add((Component)this.chkPreise, c.rc(14, 6, "lt"));
        return panel;
    }

    public JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(3, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.buttonUebernehmen, c.rc(2, 2, "lrtb"));
        panel.add((Component)this.buttonAbbrechen, c.rc(2, 4, "lrtb"));
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MailAngaben.this.tfAnEMailAdresse.getText().length() < 1 || MailAngaben.this.tfVonEMailAdresse.getText().length() < 1) {
                    String sMsg = Resource.getInstance().getTeilelisteNoMailAn();
                    Object[] aMsgZeilen = StringUtils.convMultilineToArray(sMsg);
                    JOptionPane.showMessageDialog(MainView.getInstance(), aMsgZeilen, MailAngaben.this.mDlg.getTitle(), 0);
                    return;
                }
                if (MailAngaben.this.chkAnEMailAdresse.isSelected()) {
                    MailAngaben.this.speichereEmpfaenger();
                }
                if (MailAngaben.this.chkVonEMailAdresse.isSelected()) {
                    MailAngaben.this.speichereAbsender();
                }
                MailAngaben.this.sendeMail();
                MailAngaben.this.mDlg.dispose();
            }
        });
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MailAngaben.this.mDlg.dispose();
            }
        });
        return panel;
    }

    public void show() {
        this.mDlg.setVisible(true);
    }

    protected void ladeAdressen() {
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        String sUserId = GlobalObjects.getInstance().getSessionInfo().getLogin();
        TrfHashMap trfMail = new TrfHashMap(null);
        trfMail.setValue("firmaid", sFirmaId);
        trfMail.setValue("user_id", sUserId);
        try {
            this.mDlg.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfMail, Command.LOAD_ABSENDER_UND_EMPFAENGER);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("Fehler beim Laden der E-Mail-Adressen: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (trfMail.getError() != null) {
            String sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfMail.getError().getMessage();
            log.error((Object)sMsg);
        }
        String sEmailEmpfaenger = (String)trfMail.getValue("eMailEmpfaenger");
        String sEmailAbsender = (String)trfMail.getValue("eMailAbsender");
        String sNameAbsender = (String)trfMail.getValue("nameAbsender");
        if (sEmailEmpfaenger != null) {
            this.tfAnEMailAdresse.setText(sEmailEmpfaenger);
        }
        if (sEmailAbsender != null) {
            this.tfVonEMailAdresse.setText(sEmailAbsender);
        }
        if (sNameAbsender != null) {
            this.tfVon.setText(sNameAbsender);
        }
    }

    protected void speichereAbsender() {
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        String sUserId = GlobalObjects.getInstance().getSessionInfo().getLogin();
        String sEmailAbsender = this.tfVonEMailAdresse.getText();
        String sNameAbsender = this.tfVon.getText();
        TrfHashMap trfMail = new TrfHashMap(null);
        trfMail.setValue("firmaid", sFirmaId);
        trfMail.setValue("user_id", sUserId);
        trfMail.setValue("eMailAbsender", sEmailAbsender);
        trfMail.setValue("nameAbsender", sNameAbsender);
        try {
            this.mDlg.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfMail, Command.SAVE_ABSENDER);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("Fehler beim Speichern des Absenders: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (trfMail.getError() != null) {
            String sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfMail.getError().getMessage();
            log.error((Object)sMsg);
        }
    }

    protected void speichereEmpfaenger() {
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        String sUserId = GlobalObjects.getInstance().getSessionInfo().getLogin();
        String sEmailEmpfaenger = this.tfAnEMailAdresse.getText();
        TrfHashMap trfMail = new TrfHashMap(null);
        trfMail.setValue("firmaid", sFirmaId);
        trfMail.setValue("user_id", sUserId);
        trfMail.setValue("eMailEmpfaenger", sEmailEmpfaenger);
        try {
            this.mDlg.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfMail, Command.SAVE_EMPFAENGER);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("Fehler beim Speichern des Empf\u00e4ngers: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (trfMail.getError() != null) {
            String sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfMail.getError().getMessage();
            log.error((Object)sMsg);
        }
    }

    protected void sendeMail() {
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teileliste", this.moTL);
        trfTL.setValue("anemail", this.tfAnEMailAdresse.getText());
        trfTL.setValue("vonname", this.tfVon.getText());
        trfTL.setValue("vonemail", this.tfVonEMailAdresse.getText());
        trfTL.setValue("betreff", this.tfBetreff.getText());
        trfTL.setValue("freitext", this.tfFreitext.getText());
        if (this.chkPreise.isSelected()) {
            trfTL.setValue("mit_preisen", "J");
        }
        try {
            this.mDlg.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SENDE_MAIL);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)(Resource.getInstance().getTeilelisteMailangabenHeader() + ": " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), this.mDlg.getTitle(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            String sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)sMsg);
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, this.mDlg.getTitle(), 0);
        } else {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSendenErfolgreich(), this.mDlg.getTitle(), 1);
        }
    }
}

