/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.DuplicateValueException;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class NewListe
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(NewListe.class);
    private HashMap<String, Object> mMapReturnValues;
    public static final String RET = "ret";
    public static final String ID = "id";
    public static final String TL = "tl";
    private String msMarke;
    private HeaderPanel mHeaderPanel;
    private JLabel mTxtListenID;
    private JTextField mTfListenID;
    private JLabel mTxtBemerkung;
    private JTextField mTfBemerkung;
    private JLabel mTxtAuftrag;
    private JTextField mTfAuftrag;
    private JLabel mTxtOder;
    private JLabel mTxtKunde;
    private JTextField mTfKunde;
    private JCheckBox mChkPrivat;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;
    private Konfiguration config;

    public NewListe(Frame oOwner, String sMarke, HashMap<String, Object> mapReturnValues) {
        super(oOwner, true);
        this.init(sMarke, mapReturnValues);
    }

    public NewListe(Frame oOwner, String sMarke, String sID, String sBemerkung, boolean bPrivat, HashMap<String, Object> mapReturnValues) {
        super(oOwner, true);
        this.init(sMarke, mapReturnValues);
        if (sID != null) {
            this.mTfListenID.setText(sID);
        }
        if (sBemerkung != null) {
            this.mTfBemerkung.setText(sBemerkung);
        }
        this.mChkPrivat.setSelected(bPrivat);
    }

    protected void init(String sMarke, HashMap<String, Object> mapReturnValues) {
        this.mMapReturnValues = mapReturnValues;
        this.msMarke = sMarke;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getNeueTeileliste(), null);
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            this.setSize(330, 340);
        } else {
            this.setSize(295, 255);
        }
        this.setLocation(50, 10);
        this.initComponents();
    }

    protected void initComponents() {
        this.setTitle(Resource.getInstance().getNeueTeileliste());
        this.mChkPrivat = new JCheckBox(Resource.getInstance().getPrivat());
        this.mChkPrivat.addKeyListener(new EnterKeyListener());
        this.mTxtListenID = new JLabel(Resource.getInstance().getTeileliste());
        this.mTfListenID = new LimitedTextField(20);
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            this.mTfListenID.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (NewListe.this.mTfListenID.getText() != null && NewListe.this.mTfListenID.getText().equals("0")) {
                        if (NewListe.this.config == null) {
                            NewListe.this.config = GlobalObjects.getInstance().getConfig();
                        }
                        String sID = DlgTeilelisteController.getNextTeilelistenId(NewListe.this.config, null);
                        NewListe.this.mTfListenID.setText(sID);
                    }
                    return true;
                }
            });
        }
        this.mTfListenID.addActionListener(new OkButtonActionListener());
        this.mTxtBemerkung = new JLabel(Resource.getInstance().getBemerkung());
        this.mTfBemerkung = new LimitedTextField(20);
        this.mTfBemerkung.addActionListener(new OkButtonActionListener());
        this.mTxtOder = new JLabel(Resource.getInstance().getOder());
        this.mTxtAuftrag = new JLabel(Resource.getInstance().getAuftragsnummer());
        this.mTfAuftrag = new LimitedTextField(10);
        this.mTfAuftrag.addActionListener(new OkButtonActionListener());
        this.mTxtKunde = new JLabel(Resource.getInstance().getKundennummer());
        this.mTfKunde = new LimitedNumberField(7, 10);
        this.mTfKunde.addActionListener(new OkButtonActionListener());
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            if (this.config == null) {
                this.config = GlobalObjects.getInstance().getConfig();
            }
            this.mTfAuftrag.setText(DlgTeilelisteController.getStandardAuftragsnummer(this.config));
            this.mTfKunde.setText(DlgTeilelisteController.getStandardKundennummer(this.config));
        }
        this.mButtonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonUebernehmen.addActionListener(new OkButtonActionListener());
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mButtonAbbrechen.setVerifyInputWhenFocusTarget(false);
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewListe.this.mMapReturnValues.put(NewListe.RET, 2);
                NewListe.this.dispose();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                NewListe.this.mTfListenID.requestFocus();
            }
        });
        this.layoutAll();
    }

    protected void layoutAll() {
        Container oContentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        oContentPane.setLayout(l);
        oContentPane.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        oContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    protected JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10};
        int[] heights = null;
        heights = GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden() ? new int[]{10, 0, 10, 0, 10, 0, 20, 0, 5, 0, 5, 0, 10} : new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mChkPrivat, c.rc(2, 2));
        panel.add((Component)this.mTxtListenID, c.rc(4, 2));
        panel.add((Component)this.mTfListenID, c.rc(4, 4));
        panel.add((Component)this.mTxtBemerkung, c.rc(6, 2));
        panel.add((Component)this.mTfBemerkung, c.rc(6, 4));
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            panel.add((Component)this.mTxtAuftrag, c.rc(8, 2));
            panel.add((Component)this.mTfAuftrag, c.rc(8, 4));
            panel.add((Component)this.mTxtOder, c.rc(10, 2));
            panel.add((Component)this.mTxtKunde, c.rc(12, 2));
            panel.add((Component)this.mTfKunde, c.rc(12, 4));
        }
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        return panel;
    }

    protected boolean saveTeileliste(String sNewID, boolean bPrivat, String sBemerkung, String sAuftragsnummer, String sKundennummer) {
        log.debug((Object)"Performing saveTeileliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelistenewid", sNewID);
        trfTL.setValue("marke", this.msMarke);
        trfTL.setValue("teilelistebemerkung", sBemerkung);
        trfTL.setValue("auftragsnr", sAuftragsnummer);
        trfTL.setValue("kundennr", sKundennummer);
        trfTL.setValue("privat", bPrivat);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAVE_TEILELISTE_KOPFDATEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("NewTeileliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), this.getTitle(), 0);
            return false;
        }
        if (trfTL.getError() != null) {
            Exception e = trfTL.getError();
            String sMsg = null;
            sMsg = trfTL.getError() instanceof DuplicateValueException ? Resource.getInstance().getTeilelisteDoppelteId() : Resource.getInstance().getSonstigerFehler() + ": " + e.getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, this.getTitle(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Teileliste oTL = (Teileliste)trfTL.getValue("teileliste");
        this.mMapReturnValues.put(TL, oTL);
        return true;
    }

    protected void doOkButtonAction() {
        String sListenID = this.mTfListenID.getText();
        if (sListenID.trim().equals("0")) {
            if (this.config == null) {
                this.config = GlobalObjects.getInstance().getConfig();
            }
            sListenID = DlgTeilelisteController.getNextTeilelistenId(this.config, sListenID);
        } else if (sListenID.length() < 1) {
            if (this.mTfAuftrag.getText().length() > 0) {
                sListenID = this.mTfAuftrag.getText();
            } else if (this.mTfKunde.getText().length() > 0) {
                sListenID = this.mTfKunde.getText();
            } else {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeilelisteNoBezeichner(), this.getTitle(), 0);
                return;
            }
            if (this.config == null) {
                this.config = GlobalObjects.getInstance().getConfig();
            }
            sListenID = DlgTeilelisteController.getNextTeilelistenId(this.config, sListenID);
        }
        if (!this.saveTeileliste(sListenID, this.mChkPrivat.isSelected(), this.mTfBemerkung.getText(), this.mTfAuftrag.getText(), this.mTfKunde.getText())) {
            return;
        }
        this.mMapReturnValues.put(ID, sListenID);
        this.mMapReturnValues.put(RET, 0);
        this.dispose();
    }

    protected class EnterKeyListener
    extends KeyAdapter {
        protected EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                NewListe.this.doOkButtonAction();
            }
        }
    }

    protected class OkButtonActionListener
    implements ActionListener {
        protected OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NewListe.this.doOkButtonAction();
        }
    }
}

