/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.BooleanWrapper;
import webetk.resources.Resource;

public class RrSapWaitDlg
extends JDialog {
    private Logger log = Logger.getLogger(RrSapWaitDlg.class);
    private static final long serialVersionUID = 1L;
    private WaitThread mWaitThread;
    private JLabel txtTextLabel;
    private JProgressBar progressBar;
    private JButtonEx buttonAbbrechen;
    private DlgSapRrListeController mController;
    private BooleanWrapper mbResult;

    public RrSapWaitDlg(DlgSapRrListeController controller, BooleanWrapper bResult) {
        super((Frame)MainView.getInstance(), true);
        this.mController = controller;
        this.mbResult = bResult;
        this.init();
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this.mWaitThread = new WaitThread();
            this.mWaitThread.start();
        } else if (this.mWaitThread != null) {
            this.mWaitThread.stopThread();
        }
        super.setVisible(bVisible);
    }

    public void init() {
        this.log.debug((Object)"init");
        this.setTitle(Resource.getInstance().getRrSap());
        this.txtTextLabel = new JLabel(Resource.getInstance().getMsgAnfrageWirdBearbeitet());
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechenUndSpaeterVersuchen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RrSapWaitDlg.this.log.debug((Object)"abgebrochen");
                if (RrSapWaitDlg.this.mWaitThread != null) {
                    RrSapWaitDlg.this.mWaitThread.stopThread();
                }
                RrSapWaitDlg.this.dispose();
            }
        });
        this.setFrameSize(400, 160);
        this.layoutAll();
    }

    private void setFrameSize(int px, int py) {
        this.setSize(new Dimension(px, py));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setSize(frameSize);
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void layoutAll() {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        int steps = GlobalObjects.getInstance().getEtkData().getRrSapWaitSteps();
        this.progressBar = new JProgressBar(0, steps);
        this.progressBar.setMaximum(steps);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setValue(0);
        layout.addLayoutComponent(this.txtTextLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.addLayoutComponent(this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.addLayoutComponent(this.buttonAbbrechen, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(this.txtTextLabel);
        this.getContentPane().add(this.progressBar);
        this.getContentPane().add(this.buttonAbbrechen);
    }

    private class WaitThread
    extends Thread {
        private boolean mbStop;

        private WaitThread() {
        }

        @Override
        public void run() {
            RrSapWaitDlg.this.log.info((Object)"Thread started!");
            this.waitForSap();
        }

        public void stopThread() {
            this.mbStop = true;
            RrSapWaitDlg.this.log.info((Object)"Thread stopped!");
        }

        private void waitForSap() {
            int nMaxSchritte = GlobalObjects.getInstance().getEtkData().getRrSapWaitSteps();
            for (int ii = 1; ii <= nMaxSchritte; ++ii) {
                boolean bErgebnis = RrSapWaitDlg.this.mController.holeAntwortVonSAP();
                RrSapWaitDlg.this.progressBar.setValue(ii);
                if (bErgebnis) {
                    RrSapWaitDlg.this.log.info((Object)"Antwort erhalten");
                    RrSapWaitDlg.this.mbResult.setValue(true);
                    RrSapWaitDlg.this.dispose();
                    return;
                }
                if (this.mbStop) {
                    RrSapWaitDlg.this.log.info((Object)"abgebrochen");
                    break;
                }
                try {
                    RrSapWaitDlg.this.log.debug((Object)"wait");
                    int nWaitTime = GlobalObjects.getInstance().getEtkData().getRrSapWaitTime();
                    WaitThread.sleep(nWaitTime);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            RrSapWaitDlg.this.mbResult.setValue(false);
            RrSapWaitDlg.this.log.info((Object)"Wartezeit abgelaufen");
            RrSapWaitDlg.this.dispose();
        }
    }
}

