/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.DuplicateValueException;
import webetk.EmptyListException;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.fix.Constants;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.dialog.extras.teileliste.EigentuemerAendern;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtModel;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Marken;
import webetk.resources.Resource;

public class TeilelistenUebersichtController
extends AbstractDialogViewController {
    private static Logger log = Logger.getLogger(TeilelistenUebersichtController.class);
    private TeilelistenUebersichtView view = new TeilelistenUebersichtView();
    private TeilelistenUebersichtModel model = new TeilelistenUebersichtModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    public TeilelistenUebersichtModel getModel() {
        return this.model;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.model.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        String sFilter = (String)oWFStateData.getWert("FILTER");
        if (sFilter == null) {
            sFilter = "nutzer";
        }
        this.model.setFilter(sFilter);
        this.loadTL();
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void loadTL() {
        boolean bMitBestelllisten = this.model.getFilter().equals("filiale");
        this.loadTL(bMitBestelllisten);
    }

    protected void loadTL(boolean bMitBestelllisten) {
        log.debug((Object)"Performing loadTL");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTeilelisten = new TrfTeileliste(null);
        String sUSDirect = GlobalObjects.getInstance().getEtkData().getUSDealerFilename();
        trfTeilelisten.setValue("us_filename", sUSDirect);
        trfTeilelisten.setValue("ohnebestelllisten", !bMitBestelllisten);
        trfTeilelisten.setValue("filter", this.model.getFilter());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeilelisten, Command.LOAD_TEILELISTEN_UEBERSICHT);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return;
        }
        if (trfTeilelisten.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + trfTeilelisten.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return;
        }
        ArrayList aTeilelisten = (ArrayList)trfTeilelisten.getValue("teilelisten");
        if (aTeilelisten != null) {
            for (Teileliste oTL : aTeilelisten) {
                if (!(oTL instanceof Bestellliste)) continue;
                Bestellliste oBL = (Bestellliste)oTL;
                if (oBL.getID().equals("EILAUFTRAGSLISTE")) {
                    oBL.setBezeichnung(Resource.getInstance().getEilauftragsliste());
                    continue;
                }
                if (!oBL.getID().equals("NORMALAUFTRAGSLISTE")) continue;
                oBL.setBezeichnung(Resource.getInstance().getNormalauftragsliste());
            }
            int nIndNeu = 0;
            for (int ii = 0; ii < aTeilelisten.size(); ++ii) {
                Teileliste oTL = (Teileliste)aTeilelisten.get(ii);
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                if (oTL.getNutzerID() == null || !oTL.getNutzerID().equals(oLoginInfo.getLogin())) continue;
                if (ii > nIndNeu) {
                    aTeilelisten.remove(ii);
                    aTeilelisten.add(nIndNeu, oTL);
                }
                ++nIndNeu;
            }
        }
        Vector<Teileliste> aTL = new Vector<Teileliste>();
        aTL.addAll(aTeilelisten);
        this.model.setTL(aTL);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void handleShowTL(int nRow) {
        Teileliste oTL = this.model.getTL(nRow);
        String sID = oTL.getID();
        String sEigentuemer = oTL.getNutzerID();
        String sFiliale = oTL.getFiliale();
        boolean bGesperrt = oTL.getGesperrt();
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (!(oTL instanceof Bestellliste || oTL.getNutzerID() != null && oTL.getNutzerID().equals(oLoginInfo.getLogin()) && (oTL.getAuftrag() == null || oTL.getFiliale().equals(oLoginInfo.getFilialeId())) || !oTL.getPrivat() && oTL.getAuftrag() == null)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgListShowNotIcon(), Resource.getInstance().getTeilelistenUebersicht(), 1);
            return;
        }
        WorkflowStateData oWsd = new WorkflowStateData();
        if (this.model.istDMSAngeschlossen()) {
            oWsd.setWert("DMS", "DMS");
        }
        oWsd.setWert("ID", sID);
        if (bGesperrt) {
            oWsd.setWert("GESPERRT", "J");
        }
        oWsd.setWert("EIGENTUEMER", sEigentuemer);
        oWsd.setWert("FILIALE", sFiliale);
        if (Constants.Bestellliste.isBestellliste(sID)) {
            MainView.getInstance().showDlg(DlgBestelllisteController.class, oWsd);
        } else if (oTL.isRrSapListe()) {
            MainView.getInstance().showDlg(DlgSapRrListeController.class, oWsd);
        } else {
            DlgTeilelisteController oCtrl = new DlgTeilelisteController();
            if (oCtrl.initBedingt(oWsd)) {
                DialogView view = oCtrl.getDialogView();
                MainView.getInstance().displayDialogView(view);
            }
        }
    }

    protected void handleSendeart(int nRow) {
        Teileliste oTL = this.model.getTL(nRow);
        String sID = oTL.getID();
        String sNutzerId = oTL.getNutzerID();
        String sFiliale = oTL.getFiliale();
        TrfTeileliste trf = new TrfTeileliste(null);
        trf.setValue("teilelisteid", sID);
        trf.setValue("eigentuemer", sNutzerId);
        trf.setValue("filialid", sFiliale);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_SENDEINFO);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return;
        }
        if (trf.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return;
        }
        String sSendeart = (String)trf.getValue("art");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sAnzSendeart = "";
        if (sSendeart.equals("Werkstattauftrag")) {
            sAnzSendeart = Resource.getInstance().getWerkstattauftrag();
        } else if (sSendeart.equals("Kostenvoranschlag")) {
            sAnzSendeart = Resource.getInstance().getKostenvoranschlag();
        } else if (sSendeart.equals("Barverkauf")) {
            sAnzSendeart = Resource.getInstance().getBarverkauf();
        }
        JOptionPane.showMessageDialog(MainView.getInstance(), sAnzSendeart, Resource.getInstance().getSendeartAnzeigen(), -1);
    }

    protected void handleSendTL(int nRow) {
        Teil[] aTeile;
        int[] aRetCodes;
        Teileliste oTL = this.model.getTL(nRow);
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (!(oTL.getGesperrt() && oTL.getNutzerID() != null && oTL.getNutzerID().equals(oLoginInfo.getLogin()) && oTL.getFiliale().equals(oLoginInfo.getFilialeId()) || oTL instanceof Bestellliste && oLoginInfo.hatRecht("R_WEBETK_BESTELLLISTEN"))) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeilelisteNichtGesperrt(), Resource.getInstance().getTeilelistenUebersicht(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        String sID = this.model.getTLID(nRow);
        trfTL.setValue("teilelisteid", sID);
        if (sID.equals("EILAUFTRAGSLISTE")) {
            trfTL.setValue("art", "Eilauftrag");
        } else if (sID.equals("NORMALAUFTRAGSLISTE")) {
            trfTL.setValue("art", "Normalauftrag");
        } else {
            trfTL.setValue("art", "resend");
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_SEND_LIST);
        }
        catch (CommunicationException e) {
            log.error((Object)("Teilelisten-\u00dcbersicht: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelistenUebersicht(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            String sMsg = null;
            sMsg = trfTL.getError() instanceof EmptyListException ? Resource.getInstance().getEmptyListNoSend() : Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelistenUebersicht(), 0);
            return;
        }
        String sMsgTxt = (String)trfTL.getValue("msgtxt");
        if (!DmsUtils.showMsgTxt(sMsgTxt, aRetCodes = (int[])trfTL.getValue("returncodes"), aTeile = this.getTeile(aRetCodes, oTL = (Teileliste)trfTL.getValue("teileliste")), this.getKonfiguration(), Resource.getInstance().getSendenErfolgreich())) {
            return;
        }
        if (!Constants.Bestellliste.isBestellliste(sID) && !Marken.getInstance().getEigenschaften("marke.usListenIds").contains(sID)) {
            this.deleteTeileliste(nRow);
            this.view.update();
        }
    }

    protected void deleteTeileliste(int nRow) {
        log.debug((Object)"Performing deleteTeileliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        String sID = this.model.getTLID(nRow);
        trfTL.setValue("teilelisteid", sID);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DELETE_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("TeilelistenUebersichtController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)"Fehler beim L\u00f6schen der Teileliste: ", (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelistenUebersicht(), 0);
            return;
        }
        this.model.removeTL(nRow);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected Teil[] getTeile(int[] aRetCodes, Teileliste oTL) {
        Teil[] aTeile = new Teil[aRetCodes.length];
        for (int ii = 0; ii < aRetCodes.length; ++ii) {
            Teil oTeil;
            aTeile[ii] = oTeil = DlgTeilelisteModel.getTeil(oTL, ii + 1);
        }
        return aTeile;
    }

    protected Konfiguration getKonfiguration() {
        if (this.model.getKonfiguration() != null) {
            return this.model.getKonfiguration();
        }
        this.model.setKonfiguration(GlobalObjects.getInstance().getConfig());
        return this.model.getKonfiguration();
    }

    protected void handleEigentuemerAendern(Collection<Teileliste> aTL) {
        String sNewNutzerID = null;
        String sNewNutzerName = null;
        boolean bNotAllChanged = false;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        boolean bSuperuser = oLoginInfo.hatRecht("R_WEBETK_SUPERUSER_AUFTRAEGE");
        String sFilialId = null;
        Iterator<Teileliste> iTLChange = aTL.iterator();
        while (iTLChange.hasNext()) {
            Teileliste oTL = iTLChange.next();
            if (oTL.getNutzerID() == null || !bSuperuser && !oTL.getNutzerID().equals(oLoginInfo.getLogin()) || oTL.getAuftragsNr() == null || oTL.isRrSapListe()) {
                if (aTL.size() == 1) {
                    String sMsg = null;
                    sMsg = bSuperuser ? Resource.getInstance().getMsgListEigentuemerIcon() : Resource.getInstance().getMsgListEigentuemerIconOhneFremde();
                    JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelistenUebersicht(), 1);
                    return;
                }
                iTLChange.remove();
                bNotAllChanged = true;
                continue;
            }
            sFilialId = oTL.getFiliale();
        }
        HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
        EigentuemerAendern dlg = new EigentuemerAendern(sFilialId, mapRetVal);
        dlg.setVisible(true);
        Integer nRet = (Integer)mapRetVal.get("ret");
        if (nRet == null || nRet != 0) {
            return;
        }
        sNewNutzerID = (String)mapRetVal.get("idNewUser");
        sNewNutzerName = (String)mapRetVal.get("nameNewUser");
        iTLChange = aTL.iterator();
        while (iTLChange.hasNext()) {
            Teileliste oTL = iTLChange.next();
            if (!sNewNutzerID.equals(oTL.getNutzerID())) continue;
            iTLChange.remove();
        }
        if (aTL.size() < 1) {
            return;
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisten", aTL);
        trfTL.setValue("eigentuemer", sNewNutzerID);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.EIGENTUEMER_AENDERN);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        Collection aTLNotChanged = (Collection)trfTL.getValue("teilelisten");
        if (trfTL.getError() != null) {
            String sMsg = null;
            if (trfTL.getError() instanceof DuplicateValueException) {
                StringBuffer sIDs = new StringBuffer();
                for (Teileliste oTL : aTLNotChanged) {
                    sIDs.append(oTL.getID());
                }
                Object[] arguments = new Object[]{sIDs};
                sMsg = MessageFormat.format(Resource.getInstance().getMsgListEigentuemerId(), arguments);
            } else {
                log.error((Object)(Resource.getInstance().getSonstigerFehler() + ": "), (Throwable)trfTL.getError());
                sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelistenUebersicht(), 0);
        }
        for (Teileliste oTL : aTL) {
            if (Teileliste.contains(aTLNotChanged, oTL)) continue;
            String sFilter = this.model.getFilter();
            if (sFilter.equals("nutzer")) {
                if (!sNewNutzerID.equals(oLoginInfo.getLogin())) {
                    this.model.removeTL(oTL);
                    continue;
                }
                this.model.setEigentuemer(oTL, sNewNutzerID, sNewNutzerName);
                continue;
            }
            if (sNewNutzerID.equals(oLoginInfo.getLogin())) {
                this.model.removeTL(oTL);
                continue;
            }
            this.model.setEigentuemer(oTL, sNewNutzerID, sNewNutzerName);
        }
        this.view.update();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (bNotAllChanged) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgListEigentuemerPopup(), Resource.getInstance().getTeilelistenUebersicht(), 1);
        }
    }

    protected void handleLoeschen(Collection<Teileliste> aTL) {
        boolean bNotAllDel = false;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        boolean bDarfLoeschen = oLoginInfo.hatRecht("R_WEBETK_SUPERUSER_AUFTRAEGE");
        String sAktNutzer = oLoginInfo.getLogin();
        Iterator<Teileliste> iTLDel = aTL.iterator();
        while (iTLDel.hasNext()) {
            Teileliste oTL = iTLDel.next();
            if (oTL.getNutzerID() != null && (bDarfLoeschen || oTL.getNutzerID().equals(sAktNutzer)) && !oTL.getGesperrt() && !oTL.isRrSapListe()) continue;
            if (aTL.size() == 1) {
                String sMsg = null;
                sMsg = bDarfLoeschen ? Resource.getInstance().getMsgListDelNotIconMitFremden() : Resource.getInstance().getMsgListDelNotIcon();
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelistenUebersicht(), 1);
                return;
            }
            iTLDel.remove();
            bNotAllDel = true;
        }
        String sMsg = null;
        sMsg = aTL.size() > 1 ? Resource.getInstance().getAskTeilelistenLoeschen() : Resource.getInstance().getAskTeilelisteLoeschen();
        int nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelistenUebersicht(), 0);
        if (nRet != 0) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisten", aTL);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DELETE_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeileliste() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelistenUebersicht(), 0);
        }
        Collection aTLNotDel = (Collection)trfTL.getValue("teilelisten");
        for (Teileliste oTL : aTL) {
            if (!Teileliste.contains(aTLNotDel, oTL)) {
                this.model.removeTL(oTL);
                continue;
            }
            bNotAllDel = true;
        }
        this.view.update();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (bNotAllDel) {
            sMsg = bDarfLoeschen ? Resource.getInstance().getMsgListDelPopupMitFremden() : Resource.getInstance().getMsgListDelPopup();
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelistenUebersicht(), 1);
        }
    }
}

