/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.Teileliste;
import webetk.javaclient.dialog.ChoicePanel;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtController;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.HeaderRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class TeilelistenUebersichtKleinDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private TeilelistenUebersichtModel model;
    private GenericTableModel tabmodel;
    private GenericTable table;
    private JPanel headerPanel;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;
    private int mnColAuftragsnummer = -1;
    private int mnColKundennummer = -1;
    private int mnColErstelltAm = -1;
    private int mnColTeileliste = -1;
    private int mnColBemerkung = -1;
    private int mnColEigentuemer = -1;
    private int mnColFiliale = -1;
    private JButtonEx mbUpAuftragsnummer;
    private JButtonEx mbDownAuftragsnummer;
    private JButtonEx mbUpKundennummer;
    private JButtonEx mbDownKundennummer;
    private JButtonEx mbUpErstelltAm;
    private JButtonEx mbDownErstelltAm;
    private JButtonEx mbUpTeileliste;
    private JButtonEx mbDownTeileliste;
    private JButtonEx mbUpBemerkung;
    private JButtonEx mbDownBemerkung;
    private JButtonEx mbUpEigentuemer;
    private JButtonEx mbDownEigentuemer;
    private JButtonEx mbUpFiliale;
    private JButtonEx mbDownFiliale;
    private HashMap<String, Object> mMapReturnValues;
    public static final String RET = "ret";
    public static final String LISTE = "liste";

    public TeilelistenUebersichtKleinDlg(HashMap<String, Object> mapReturnValues) {
        super((Frame)MainView.getInstance(), true);
        this.mMapReturnValues = mapReturnValues;
        this.setSize(970, 640);
        this.setLocation(20, 10);
        TeilelistenUebersichtController oController = new TeilelistenUebersichtController();
        this.model = oController.getModel();
        this.model.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        this.model.setFilter("filiale");
        oController.loadTL(false);
        this.initComponents(oController);
        this.update();
    }

    private void initComponents(TeilelistenUebersichtController oController) {
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilelistenUebersicht(), ImageCache.getInstance().getHeaderIcon("tllist"));
        this.setTitle(Resource.getInstance().getTeilelistenUebersicht());
        this.createLayout(oController);
        this.mButtonUebernehmen.setEnabled(false);
    }

    private void createLayout(TeilelistenUebersichtController oController) {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent(oController));
        contentPane.add((Component)content, "Center");
    }

    private JPanel createFilterPanel(final TeilelistenUebersichtController oController) {
        JRadioButton rbNutzer = new JRadioButton(Resource.getInstance().getEigene());
        JRadioButton rbFiliale = new JRadioButton(Resource.getInstance().getFiliale());
        JRadioButton rbFirma = new JRadioButton(Resource.getInstance().getFirma());
        rbNutzer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TeilelistenUebersichtKleinDlg.this.model.setFilter("nutzer");
                oController.loadTL(false);
                TeilelistenUebersichtKleinDlg.this.update();
            }
        });
        rbFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TeilelistenUebersichtKleinDlg.this.model.setFilter("filiale");
                oController.loadTL(false);
                TeilelistenUebersichtKleinDlg.this.update();
            }
        });
        rbFirma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TeilelistenUebersichtKleinDlg.this.model.setFilter("firma");
                oController.loadTL(false);
                TeilelistenUebersichtKleinDlg.this.update();
            }
        });
        return new ChoicePanel(Resource.getInstance().getTeilelistenUbersichtFuer(), new AbstractButton[]{rbNutzer, rbFiliale, rbFirma}, 1, 1);
    }

    private void update() {
        this.tabmodel.removeAllRows();
        Collection<Teileliste> cTL = this.model.getTL();
        if (cTL != null) {
            Iterator<Teileliste> iter = cTL.iterator();
            int nCount = 0;
            while (iter.hasNext()) {
                ++nCount;
                AbstractRow oRow = null;
                Teileliste oTL = iter.next();
                if (oTL instanceof Bestellliste) {
                    Bestellliste oBL = (Bestellliste)oTL;
                    oRow = new AbstractRow(new Object[]{"", "", "", oBL.getBezeichnung(), "", "", oTL.getFiliale()});
                } else if (oTL.isRrSapListe()) {
                    String sStatus = oTL.getSapStatus();
                    if (sStatus != null && (sStatus.equals("B") || sStatus.equals("E"))) continue;
                    String listname = null;
                    listname = "_RRSAPLIST".equals(oTL.getID()) ? Resource.getInstance().getRrSap() : oTL.getID();
                    oRow = new AbstractRow(new Object[]{oTL.getAuftragsNr(), oTL.getKundenNr(), oTL.getDatErstellungString(), listname, oTL.getBemerkung(), oTL.getNutzerName(), oTL.getFiliale()});
                } else {
                    oRow = new AbstractRow(new Object[]{oTL.getAuftragsNr(), oTL.getKundenNr(), oTL.getDatErstellungString(), oTL.getID(), oTL.getBemerkung(), oTL.getNutzerName(), oTL.getFiliale()});
                    if (oTL.getGesperrt()) {
                        oRow.setForeColor(new Color(225, 0, 0));
                    }
                }
                oRow.setTooltip(this.mnColFiliale, oTL.getFilialeBen());
                this.tabmodel.addRow(oRow);
            }
        }
    }

    private JPanel createContent(TeilelistenUebersichtController oController) {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        hl.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createFilterPanel(oController), c.rc(2, 2, "tlrb"));
        contentPanel.add((Component)this.createTabelle(oController), c.rc(4, 2, "tlrb"));
        contentPanel.add((Component)this.createButtonPanel(), c.rc(6, 2, "tlrb"));
        return contentPanel;
    }

    private JComponent createTabelle(TeilelistenUebersichtController oController) {
        this.createTabelleSortierButtons();
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        tableConfig.addColumn(Resource.getInstance().getAuftragsnummer(), 2, false, "AuftragsnummerXXX");
        this.mnColAuftragsnummer = nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpAuftragsnummer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownAuftragsnummer);
        tableConfig.addColumn(Resource.getInstance().getKundennummer(), 2, false, "KundennummerXXX");
        this.mnColKundennummer = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpKundennummer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownKundennummer);
        tableConfig.addColumn(Resource.getInstance().getErstelltAm(), 0, true, "00XXXXX0000");
        this.mnColErstelltAm = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpErstelltAm);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownErstelltAm);
        tableConfig.addColumn(Resource.getInstance().getTeileliste(), 2, true, "XXXXXXXXXXXXXXXXXXXXY");
        this.mnColTeileliste = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpTeileliste);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownTeileliste);
        tableConfig.addColumn(Resource.getInstance().getBemerkung(), 2, true, "XXXXXXXXXXXXXXXYYY");
        this.mnColBemerkung = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpBemerkung);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownBemerkung);
        tableConfig.addColumn(Resource.getInstance().getEigentuemer(), 2, true, "XXXXXXXXXXXXXXXYYY");
        this.mnColEigentuemer = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpEigentuemer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownEigentuemer);
        tableConfig.addColumn(Resource.getInstance().getFiliale(), 2, true, "XXXX");
        this.mnColFiliale = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpFiliale);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownFiliale);
        ++nCol;
        tableConfig.setUsePrototypeIcons(true);
        this.tabmodel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tabmodel);
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        this.table.getTable().setSelectionMode(0);
        this.table.getTable().getSelectionModel().addListSelectionListener(new TableListSelectionListener());
        this.table.getTable().addKeyListener(new EnterKeyListener());
        InputMap im = this.table.getTable().getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "none");
        JTableHeader th = this.table.getTableHeader();
        th.addMouseListener(new ClickTableHeaderListener(th));
        return this.table.getScrollPane();
    }

    private void createTabelleSortierButtons() {
        this.mbUpAuftragsnummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpAuftragsnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(1, true);
            }
        });
        this.mbDownAuftragsnummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownAuftragsnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(1, false);
            }
        });
        this.mbUpKundennummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpKundennummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(2, true);
            }
        });
        this.mbDownKundennummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownKundennummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(2, false);
            }
        });
        this.mbUpErstelltAm = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpErstelltAm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(3, true);
            }
        });
        this.mbDownErstelltAm = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownErstelltAm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(3, false);
            }
        });
        this.mbUpTeileliste = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpTeileliste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(4, true);
            }
        });
        this.mbDownTeileliste = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownTeileliste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(4, false);
            }
        });
        this.mbUpBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(5, true);
            }
        });
        this.mbDownBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(5, false);
            }
        });
        this.mbUpEigentuemer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpEigentuemer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(6, true);
            }
        });
        this.mbDownEigentuemer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownEigentuemer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(6, false);
            }
        });
        this.mbUpFiliale = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(7, true);
            }
        });
        this.mbDownFiliale = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.handleClick(7, false);
            }
        });
    }

    public JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        this.mButtonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.doUebernehmenButtonAction();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtKleinDlg.this.mMapReturnValues.put(TeilelistenUebersichtKleinDlg.RET, 2);
                TeilelistenUebersichtKleinDlg.this.dispose();
            }
        });
        return panel;
    }

    private void doUebernehmenButtonAction() {
        int nRow = this.table.getTable().getSelectedRow();
        this.mMapReturnValues.put(LISTE, this.model.getTL(nRow));
        this.mMapReturnValues.put(RET, 0);
        this.dispose();
    }

    private void handleClick(int comp, boolean bAsc) {
        this.model.setSortierungAsc(bAsc);
        this.model.setSortierung(comp);
        this.update();
    }

    private class ClickTableHeaderListener
    extends MouseAdapter {
        private JTableHeader th;

        public ClickTableHeaderListener(JTableHeader th) {
            this.th = th;
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            int col = this.th.columnAtPoint(ev.getPoint());
            TableColumn column = TeilelistenUebersichtKleinDlg.this.table.getColumnModel().getColumn(col);
            HeaderRenderer renderer = (HeaderRenderer)column.getHeaderRenderer();
            if (renderer.handleClick(TeilelistenUebersichtKleinDlg.this.table, ev)) {
                return;
            }
            if (col == TeilelistenUebersichtKleinDlg.this.mnColAuftragsnummer) {
                this.handleClick(1);
            } else if (col == TeilelistenUebersichtKleinDlg.this.mnColKundennummer) {
                this.handleClick(2);
            } else if (col == TeilelistenUebersichtKleinDlg.this.mnColErstelltAm) {
                this.handleClick(3);
            } else if (col == TeilelistenUebersichtKleinDlg.this.mnColTeileliste) {
                this.handleClick(4);
            } else if (col == TeilelistenUebersichtKleinDlg.this.mnColBemerkung) {
                this.handleClick(5);
            } else if (col == TeilelistenUebersichtKleinDlg.this.mnColEigentuemer) {
                this.handleClick(6);
            } else if (col == TeilelistenUebersichtKleinDlg.this.mnColFiliale) {
                this.handleClick(7);
            }
        }

        private void handleClick(int comp) {
            if (TeilelistenUebersichtKleinDlg.this.model.getSortierung() == comp) {
                TeilelistenUebersichtKleinDlg.this.model.setSortierungAsc(!TeilelistenUebersichtKleinDlg.this.model.isSortierungAsc());
            } else {
                TeilelistenUebersichtKleinDlg.this.model.setSortierungAsc(true);
            }
            TeilelistenUebersichtKleinDlg.this.model.setSortierung(comp);
            TeilelistenUebersichtKleinDlg.this.update();
        }
    }

    private class TableListSelectionListener
    implements ListSelectionListener {
        private TableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            TeilelistenUebersichtKleinDlg.this.mButtonUebernehmen.setEnabled(TeilelistenUebersichtKleinDlg.this.table.getTable().getSelectedRow() > -1);
        }
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10 && TeilelistenUebersichtKleinDlg.this.mButtonUebernehmen.isEnabled()) {
                TeilelistenUebersichtKleinDlg.this.doUebernehmenButtonAction();
            }
        }
    }
}

