/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import de.esg.commonclient.dialog.AbstractDialogModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileliste.Teileliste;
import webetk.javaclient.dialog.extras.teileliste.UebersichtComparator;

public class TeilelistenUebersichtModel
extends AbstractDialogModel {
    private boolean mbDMSVerwenden = false;
    private Vector<Teileliste> maTL = null;
    private Konfiguration moKonfiguration = null;
    private String msFilter = null;
    private int mnSortierung = 0;
    private boolean mbSortierungAsc = true;

    public void setTL(Vector<Teileliste> aTL) {
        this.maTL = aTL;
    }

    public Collection<Teileliste> getTL() {
        if (this.getSortierung() == 0 && this.isSortierungAsc()) {
            return this.maTL;
        }
        return this.getTLSortiert();
    }

    public String getTLID(int nInd) {
        Teileliste oTL = this.getTL(nInd);
        if (oTL != null) {
            return oTL.getID();
        }
        return "";
    }

    public Teileliste getTL(int nInd) {
        Collection<Teileliste> cTL = null;
        cTL = this.getSortierung() == 0 && this.isSortierungAsc() ? this.getTL() : this.getTLSortiert();
        Iterator<Teileliste> iter = cTL.iterator();
        int ii = -1;
        while (iter.hasNext()) {
            Teileliste oTL = iter.next();
            if (++ii != nInd) continue;
            return oTL;
        }
        return null;
    }

    private Collection<Teileliste> getTLSortiert() {
        Vector<Teileliste> cTLUnsortiert = this.maTL;
        Teileliste[] aTL = new Teileliste[cTLUnsortiert.size()];
        Iterator iter = cTLUnsortiert.iterator();
        int ii = 0;
        while (iter.hasNext()) {
            Teileliste oTL;
            aTL[ii] = oTL = (Teileliste)iter.next();
            ++ii;
        }
        UebersichtComparator comp = new UebersichtComparator(this.mnSortierung, this.mbSortierungAsc);
        Arrays.sort(aTL, comp);
        ArrayList<Teileliste> cTLSortiert = new ArrayList<Teileliste>();
        for (ii = 0; ii < aTL.length; ++ii) {
            cTLSortiert.add(aTL[ii]);
        }
        return cTLSortiert;
    }

    public void removeTL(int nInd) {
        this.maTL.remove(nInd);
    }

    public void removeTL(Teileliste oTL) {
        this.maTL.remove(oTL);
    }

    public void setEigentuemer(Teileliste oTL, String sEigentuemerId, String sEigentuemerName) {
        int nInd = this.maTL.indexOf(oTL);
        oTL = this.maTL.get(nInd);
        oTL.setNutzerID(sEigentuemerId);
        oTL.setNutzerName(sEigentuemerName);
    }

    public boolean istDMSAngeschlossen() {
        return this.mbDMSVerwenden;
    }

    public void setDMSVerwenden(boolean bDMSVerwenden) {
        this.mbDMSVerwenden = bDMSVerwenden;
    }

    public Konfiguration getKonfiguration() {
        return this.moKonfiguration;
    }

    public void setKonfiguration(Konfiguration oKonfiguration) {
        this.moKonfiguration = oKonfiguration;
    }

    public String getFilter() {
        return this.msFilter;
    }

    public void setFilter(String sFilter) {
        this.msFilter = sFilter;
    }

    public boolean isSortierungAsc() {
        return this.mbSortierungAsc;
    }

    public void setSortierungAsc(boolean bSortierungAsc) {
        this.mbSortierungAsc = bSortierungAsc;
    }

    public int getSortierung() {
        return this.mnSortierung;
    }

    public void setSortierung(int nSortierung) {
        this.mnSortierung = nSortierung;
    }
}

