/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.Teileliste;
import webetk.communication.LoginInfo;
import webetk.javaclient.dialog.ChoicePanel;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtController;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.HeaderRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class TeilelistenUebersichtView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TeilelistenUebersichtView.class);
    private TeilelistenUebersichtModel model;
    private TeilelistenUebersichtController controller;
    private GenericTable table;
    private GenericTableModel tabmodel;
    private JPopupMenu popupMenu;
    private JMenuItem popupActionAnzeigen;
    private JMenuItem popupActionSendeart;
    private JMenuItem popupActionSenden;
    private JMenuItem popupActionEigentuemerAendern;
    private JMenuItem popupActionLoeschen;
    private JPanel headerPanel;
    private final int POPUP_IND_SHOW = 0;
    private final int POPUP_IND_SENDEART = 2;
    private final int POPUP_IND_SEND = 3;
    private final int POPUP_IND_EIGENTUEMER = 5;
    private final int POPUP_IND_LOESCHEN = 7;
    private final int POPUP_IND_NO_DMS_EIGENTUEMER = 2;
    private final int POPUP_IND_NO_DMS_LOESCHEN = 4;
    private JRadioButton rbNutzer;
    private JRadioButton rbFiliale;
    private JRadioButton rbFirma;
    private int mnColIconShow = -1;
    private int mnColIconSend = -1;
    private int mnColIconEigentuemer = -1;
    private int mnColIconLoeschen = -1;
    private int mnColAuftragsnummer = -1;
    private int mnColKundennummer = -1;
    private int mnColErstelltAm = -1;
    private int mnColTeileliste = -1;
    private int mnColBemerkung = -1;
    private int mnColEigentuemer = -1;
    private int mnColFiliale = -1;
    private JButtonEx mbUpAuftragsnummer;
    private JButtonEx mbDownAuftragsnummer;
    private JButtonEx mbUpKundennummer;
    private JButtonEx mbDownKundennummer;
    private JButtonEx mbUpErstelltAm;
    private JButtonEx mbDownErstelltAm;
    private JButtonEx mbUpTeileliste;
    private JButtonEx mbDownTeileliste;
    private JButtonEx mbUpBemerkung;
    private JButtonEx mbDownBemerkung;
    private JButtonEx mbUpEigentuemer;
    private JButtonEx mbDownEigentuemer;
    private JButtonEx mbUpFiliale;
    private JButtonEx mbDownFiliale;

    private void initComponents() {
        this.initMenus();
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilelistenUebersicht(), ImageCache.getInstance().getHeaderIcon("tllist"));
        this.createLayout();
    }

    @Override
    public void initMenus() {
        this.popupMenu = new JPopupMenu();
        this.popupActionAnzeigen = new JMenuItem(Resource.getInstance().getAnzeigen());
        this.popupMenu.add(this.popupActionAnzeigen);
        if (this.model.istDMSAngeschlossen()) {
            this.popupMenu.addSeparator();
            this.popupActionSendeart = new JMenuItem(Resource.getInstance().getSendeartAnzeigen() + "...");
            this.popupMenu.add(this.popupActionSendeart);
            this.popupActionSenden = new JMenuItem(Resource.getInstance().getSenden());
            this.popupMenu.add(this.popupActionSenden);
        }
        this.popupMenu.addSeparator();
        this.popupActionEigentuemerAendern = new JMenuItem(Resource.getInstance().getEigentuemerAendern() + "...");
        this.popupMenu.add(this.popupActionEigentuemerAendern);
        this.popupMenu.addSeparator();
        this.popupActionLoeschen = new JMenuItem(Resource.getInstance().getLoeschen());
        this.popupMenu.add(this.popupActionLoeschen);
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    private JPanel createFilterPanel() {
        this.rbNutzer = new JRadioButton(Resource.getInstance().getEigene());
        this.rbFiliale = new JRadioButton(Resource.getInstance().getFiliale());
        this.rbFirma = new JRadioButton(Resource.getInstance().getFirma());
        this.rbNutzer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TeilelistenUebersichtView.this.model.setFilter("nutzer");
                TeilelistenUebersichtView.this.controller.loadTL();
                TeilelistenUebersichtView.this.update();
            }
        });
        this.rbFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TeilelistenUebersichtView.this.model.setFilter("filiale");
                TeilelistenUebersichtView.this.controller.loadTL();
                TeilelistenUebersichtView.this.update();
            }
        });
        this.rbFirma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TeilelistenUebersichtView.this.model.setFilter("firma");
                TeilelistenUebersichtView.this.controller.loadTL();
                TeilelistenUebersichtView.this.update();
            }
        });
        return new ChoicePanel(Resource.getInstance().getTeilelistenUbersichtFuer(), new AbstractButton[]{this.rbNutzer, this.rbFiliale, this.rbFirma}, 0, 1);
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"init");
        this.model = (TeilelistenUebersichtModel)oDlgModel;
        this.controller = (TeilelistenUebersichtController)oController;
        this.initComponents();
        this.update();
    }

    @Override
    public void update() {
        this.tabmodel.removeAllRows();
        Collection<Teileliste> cTL = this.model.getTL();
        if (cTL != null) {
            Iterator<Teileliste> iter = cTL.iterator();
            int nCount = 0;
            while (iter.hasNext()) {
                ++nCount;
                Teileliste oTL = iter.next();
                AbstractRow oRow = null;
                if (oTL instanceof Bestellliste) {
                    Bestellliste oBL = (Bestellliste)oTL;
                    oRow = this.model.istDMSAngeschlossen() ? new AbstractRow(new Object[]{null, null, null, null, "", "", "", oBL.getBezeichnung(), "", "", oTL.getFiliale()}) : new AbstractRow(new Object[]{null, null, null, "", "", "", oBL.getBezeichnung(), "", "", oTL.getFiliale()});
                } else if (oTL.isRrSapListe()) {
                    String listname = null;
                    listname = "_RRSAPLIST".equals(oTL.getID()) ? Resource.getInstance().getRrSap() : oTL.getID();
                    oRow = this.model.istDMSAngeschlossen() ? new AbstractRow(new Object[]{null, null, null, null, oTL.getAuftragsNr(), oTL.getKundenNr(), oTL.getDatErstellungString(), listname, oTL.getBemerkung(), oTL.getNutzerName(), oTL.getFiliale()}) : new AbstractRow(new Object[]{null, null, null, oTL.getAuftragsNr(), oTL.getKundenNr(), oTL.getDatErstellungString(), listname, oTL.getBemerkung(), oTL.getNutzerName(), oTL.getFiliale()});
                } else {
                    oRow = this.model.istDMSAngeschlossen() ? new AbstractRow(new Object[]{null, null, null, null, oTL.getAuftragsNr(), oTL.getKundenNr(), oTL.getDatErstellungString(), oTL.getID(), oTL.getBemerkung(), oTL.getNutzerName(), oTL.getFiliale()}) : new AbstractRow(new Object[]{null, null, null, oTL.getAuftragsNr(), oTL.getKundenNr(), oTL.getDatErstellungString(), oTL.getID(), oTL.getBemerkung(), oTL.getNutzerName(), oTL.getFiliale()});
                    if (oTL.getGesperrt()) {
                        oRow.setForeColor(new Color(225, 0, 0));
                    }
                }
                oRow.setTooltip(this.mnColFiliale, oTL.getFilialeBen());
                this.tabmodel.addRow(oRow);
            }
        }
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        hl.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createFilterPanel(), c.rc(2, 2, "tlrb"));
        contentPanel.add((Component)this.createTabelle(), c.rc(4, 2, "tlrb"));
        return contentPanel;
    }

    private JComponent createTabelle() {
        this.createTabelleSortierButtons();
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        tableConfig.addIconColumn("tl_anzeigen.jpg", Resource.getInstance().getAnzeigen());
        this.mnColIconShow = nCol++;
        if (this.model.istDMSAngeschlossen()) {
            tableConfig.addIconColumn("tl_senden.jpg", Resource.getInstance().getSenden());
            this.mnColIconSend = nCol++;
        }
        tableConfig.addIconColumn("weitergeben.png", Resource.getInstance().getEigentuemerAendern());
        this.mnColIconEigentuemer = nCol++;
        tableConfig.addIconColumn("trashbin.gif", Resource.getInstance().getLoeschen());
        this.mnColIconLoeschen = nCol++;
        tableConfig.addColumn(Resource.getInstance().getAuftragsnummer(), 2, false, "AuftragsnummerXXX");
        this.mnColAuftragsnummer = nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpAuftragsnummer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownAuftragsnummer);
        tableConfig.addColumn(Resource.getInstance().getKundennummer(), 2, false, "KundennummerXXX");
        this.mnColKundennummer = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpKundennummer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownKundennummer);
        tableConfig.addColumn(Resource.getInstance().getErstelltAm(), 0, true, "00XXXXX0000");
        this.mnColErstelltAm = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpErstelltAm);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownErstelltAm);
        tableConfig.addColumn(Resource.getInstance().getTeileliste(), 2, true, "XXXXXXXXXXXXXXXXXXXXY");
        this.mnColTeileliste = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpTeileliste);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownTeileliste);
        tableConfig.addColumn(Resource.getInstance().getBemerkung(), 2, true, "XXXXXXXXXXXXXXXYYY");
        this.mnColBemerkung = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpBemerkung);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownBemerkung);
        tableConfig.addColumn(Resource.getInstance().getEigentuemer(), 2, true, "XXXXXXXXXXXXXXXYYY");
        this.mnColEigentuemer = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpEigentuemer);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownEigentuemer);
        tableConfig.addColumn(Resource.getInstance().getFiliale(), 2, true, "XXXX");
        this.mnColFiliale = ++nCol;
        tableConfig.setHeaderButtonLeft(nCol, this.mbUpFiliale);
        tableConfig.setHeaderButtonRight(nCol, this.mbDownFiliale);
        ++nCol;
        tableConfig.setUsePrototypeIcons(true);
        this.tabmodel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tabmodel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setWidth(20);
        if (this.model.istDMSAngeschlossen()) {
            this.table.getTable().getColumnModel().getColumn(3).setMinWidth(20);
            this.table.getTable().getColumnModel().getColumn(3).setMaxWidth(20);
            this.table.getTable().getColumnModel().getColumn(3).setWidth(20);
        }
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                Teileliste oTL;
                int ii;
                if (TeilelistenUebersichtView.this.table.getTable().getSelectedRowCount() < 1) {
                    return;
                }
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                if (TeilelistenUebersichtView.this.table.getTable().getSelectedRowCount() == 1) {
                    int nRow = TeilelistenUebersichtView.this.table.getTable().getSelectedRow();
                    Teileliste oTL2 = TeilelistenUebersichtView.this.model.getTL(nRow);
                    if (oTL2 instanceof Bestellliste || oTL2.getNutzerID() != null && oTL2.getNutzerID().equals(oLoginInfo.getLogin()) && (oTL2.getAuftrag() == null || oTL2.getFiliale().equals(oLoginInfo.getFilialeId())) || !oTL2.getPrivat() && oTL2.getAuftrag() == null) {
                        TeilelistenUebersichtView.this.popupMenu.getComponent(0).setEnabled(true);
                    } else {
                        TeilelistenUebersichtView.this.popupMenu.getComponent(0).setEnabled(false);
                    }
                    if (TeilelistenUebersichtView.this.model.istDMSAngeschlossen()) {
                        if (oTL2.getGesperrt()) {
                            TeilelistenUebersichtView.this.popupMenu.getComponent(2).setEnabled(true);
                        } else {
                            TeilelistenUebersichtView.this.popupMenu.getComponent(2).setEnabled(false);
                        }
                        if (oTL2.getGesperrt() && oTL2.getNutzerID() != null && oTL2.getNutzerID().equals(oLoginInfo.getLogin()) && oTL2.getFiliale().equals(oLoginInfo.getFilialeId()) || oTL2 instanceof Bestellliste && oLoginInfo.hatRecht("R_WEBETK_BESTELLLISTEN")) {
                            TeilelistenUebersichtView.this.popupMenu.getComponent(3).setEnabled(true);
                        } else {
                            TeilelistenUebersichtView.this.popupMenu.getComponent(3).setEnabled(false);
                        }
                    }
                } else {
                    TeilelistenUebersichtView.this.popupMenu.getComponent(0).setEnabled(false);
                    TeilelistenUebersichtView.this.popupMenu.getComponent(2).setEnabled(false);
                    TeilelistenUebersichtView.this.popupMenu.getComponent(3).setEnabled(false);
                }
                int[] aSelRows = TeilelistenUebersichtView.this.table.getTable().getSelectedRows();
                boolean bSuperuser = oLoginInfo.hatRecht("R_WEBETK_SUPERUSER_AUFTRAEGE");
                boolean bEnable = false;
                String sLastFiliale = null;
                for (ii = 0; ii < aSelRows.length; ++ii) {
                    oTL = TeilelistenUebersichtView.this.model.getTL(aSelRows[ii]);
                    if (oTL.getAuftrag() == null || (oTL.getNutzerID() == null || !oTL.getNutzerID().equals(oLoginInfo.getLogin())) && !bSuperuser) continue;
                    if (sLastFiliale != null && !sLastFiliale.equals(oTL.getFiliale())) {
                        bEnable = false;
                        break;
                    }
                    bEnable = true;
                    sLastFiliale = oTL.getFiliale();
                }
                if (TeilelistenUebersichtView.this.model.istDMSAngeschlossen()) {
                    TeilelistenUebersichtView.this.popupMenu.getComponent(5).setEnabled(bEnable);
                } else {
                    TeilelistenUebersichtView.this.popupMenu.getComponent(2).setEnabled(bEnable);
                }
                bEnable = false;
                for (ii = 0; ii < aSelRows.length; ++ii) {
                    oTL = TeilelistenUebersichtView.this.model.getTL(aSelRows[ii]);
                    if (oTL instanceof Bestellliste || oTL.isRrSapListe() || !bSuperuser && (oTL.getNutzerID() == null || !oTL.getNutzerID().equals(oLoginInfo.getLogin())) || oTL.getGesperrt()) continue;
                    bEnable = true;
                    break;
                }
                if (TeilelistenUebersichtView.this.model.istDMSAngeschlossen()) {
                    TeilelistenUebersichtView.this.popupMenu.getComponent(7).setEnabled(bEnable);
                } else {
                    TeilelistenUebersichtView.this.popupMenu.getComponent(4).setEnabled(bEnable);
                }
                TeilelistenUebersichtView.this.popupMenu.show(TeilelistenUebersichtView.this.table.getTable(), evt.getX(), evt.getY());
            }

            @Override
            public void clickedOnCell(GenericTableMouseEvent evt) {
                int nCol = evt.getColumn();
                int nRow = evt.getRow();
                Teileliste oTL = TeilelistenUebersichtView.this.model.getTL(nRow);
                ArrayList<Teileliste> aTL = new ArrayList<Teileliste>();
                aTL.add(oTL);
                if (nCol == TeilelistenUebersichtView.this.mnColIconShow) {
                    TeilelistenUebersichtView.this.controller.handleShowTL(nRow);
                } else if (nCol == TeilelistenUebersichtView.this.mnColIconSend) {
                    TeilelistenUebersichtView.this.controller.handleSendTL(nRow);
                } else if (nCol == TeilelistenUebersichtView.this.mnColIconEigentuemer) {
                    TeilelistenUebersichtView.this.controller.handleEigentuemerAendern(aTL);
                } else if (nCol == TeilelistenUebersichtView.this.mnColIconLoeschen) {
                    TeilelistenUebersichtView.this.controller.handleLoeschen(aTL);
                }
            }
        });
        final JTableHeader th = this.table.getTableHeader();
        th.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                int col = th.columnAtPoint(ev.getPoint());
                TableColumn column = TeilelistenUebersichtView.this.table.getColumnModel().getColumn(col);
                HeaderRenderer renderer = (HeaderRenderer)column.getHeaderRenderer();
                if (renderer.handleClick(TeilelistenUebersichtView.this.table, ev)) {
                    return;
                }
                if (col == TeilelistenUebersichtView.this.mnColAuftragsnummer) {
                    this.handleClick(1);
                } else if (col == TeilelistenUebersichtView.this.mnColKundennummer) {
                    this.handleClick(2);
                } else if (col == TeilelistenUebersichtView.this.mnColErstelltAm) {
                    this.handleClick(3);
                } else if (col == TeilelistenUebersichtView.this.mnColTeileliste) {
                    this.handleClick(4);
                } else if (col == TeilelistenUebersichtView.this.mnColBemerkung) {
                    this.handleClick(5);
                } else if (col == TeilelistenUebersichtView.this.mnColEigentuemer) {
                    this.handleClick(6);
                } else if (col == TeilelistenUebersichtView.this.mnColFiliale) {
                    this.handleClick(7);
                }
            }

            private void handleClick(int comp) {
                if (TeilelistenUebersichtView.this.model.getSortierung() == comp) {
                    TeilelistenUebersichtView.this.model.setSortierungAsc(!TeilelistenUebersichtView.this.model.isSortierungAsc());
                } else {
                    TeilelistenUebersichtView.this.model.setSortierungAsc(true);
                }
                TeilelistenUebersichtView.this.model.setSortierung(comp);
                TeilelistenUebersichtView.this.update();
            }
        });
        this.popupActionAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nRow = TeilelistenUebersichtView.this.table.getTable().getSelectedRow();
                TeilelistenUebersichtView.this.controller.handleShowTL(nRow);
            }
        });
        if (this.model.istDMSAngeschlossen()) {
            this.popupActionSendeart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nRow = TeilelistenUebersichtView.this.table.getTable().getSelectedRow();
                    TeilelistenUebersichtView.this.controller.handleSendeart(nRow);
                }
            });
            this.popupActionSenden.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nRow = TeilelistenUebersichtView.this.table.getTable().getSelectedRow();
                    TeilelistenUebersichtView.this.controller.handleSendTL(nRow);
                }
            });
        }
        this.popupActionEigentuemerAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.controller.handleEigentuemerAendern(TeilelistenUebersichtView.this.getSelTeilelistenFromTab());
            }
        });
        this.popupActionLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.controller.handleLoeschen(TeilelistenUebersichtView.this.getSelTeilelistenFromTab());
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        return this.table.getScrollPane();
    }

    private void createTabelleSortierButtons() {
        this.mbUpAuftragsnummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpAuftragsnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(1, true);
            }
        });
        this.mbDownAuftragsnummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownAuftragsnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(1, false);
            }
        });
        this.mbUpKundennummer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpKundennummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(2, true);
            }
        });
        this.mbDownKundennummer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownKundennummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(2, false);
            }
        });
        this.mbUpErstelltAm = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpErstelltAm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(3, true);
            }
        });
        this.mbDownErstelltAm = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownErstelltAm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(3, false);
            }
        });
        this.mbUpTeileliste = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpTeileliste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(4, true);
            }
        });
        this.mbDownTeileliste = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownTeileliste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(4, false);
            }
        });
        this.mbUpBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(5, true);
            }
        });
        this.mbDownBemerkung = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(5, false);
            }
        });
        this.mbUpEigentuemer = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpEigentuemer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(6, true);
            }
        });
        this.mbDownEigentuemer = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownEigentuemer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(6, false);
            }
        });
        this.mbUpFiliale = new JButtonEx(ImageCache.getInstance().getIcon("up.gif"), 4, 4);
        this.mbUpFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(7, true);
            }
        });
        this.mbDownFiliale = new JButtonEx(ImageCache.getInstance().getIcon("down.gif"), 4, 4);
        this.mbDownFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeilelistenUebersichtView.this.handleClick(7, false);
            }
        });
    }

    private Collection<Teileliste> getSelTeilelistenFromTab() {
        ArrayList<Teileliste> aSelTL = new ArrayList<Teileliste>();
        int[] aRows = this.table.getTable().getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            Teileliste oTL = this.model.getTL(aRows[ii]);
            aSelTL.add(oTL);
        }
        return aSelTL;
    }

    private void handleClick(int comp, boolean bAsc) {
        this.model.setSortierungAsc(bAsc);
        this.model.setSortierung(comp);
        this.update();
    }

    public TeilelistenUebersichtController getController() {
        return this.controller;
    }
}

