/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.utils.DmsUtils;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class Werkstattauftrag {
    private HashMap<String, Object> mMapReturnValues;
    private static Logger log = Logger.getLogger(Werkstattauftrag.class);
    private JDialog mDlg;
    private DlgTeilelisteModel mModel;
    private DlgTeilelisteController mController;
    private HeaderPanel mHeaderPanel;
    private Container mContentPane;
    private JLabel mTxtAuftragsnummer;
    private JTextField mTfAuftragsnummer;
    private JLabel mTxtAuftragsnummerWert;
    private JLabel mTxtBearbeiter;
    private JTextField mTfBearbeiter;
    private JLabel mTxtFreitext;
    private JTextArea mTaFreitext;
    private JCheckBox mChkGreiferschein;
    private JCheckBox mChkWiederverwenden;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;

    public Werkstattauftrag(HashMap<String, Object> mapReturnValues) {
        this.mMapReturnValues = mapReturnValues;
        this.mDlg = new JDialog((Frame)MainView.getInstance(), false);
        this.mDlg.setModal(true);
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getWerkstattauftrag(), null);
        this.mDlg.setSize(480, 360);
        this.mDlg.setLocation(50, 10);
    }

    public void setController(DlgTeilelisteController oController) {
        this.mController = oController;
        if (oController != null) {
            this.mModel = oController.getModel();
        }
    }

    public void initComponents() {
        this.mDlg.setTitle(Resource.getInstance().getWerkstattauftrag());
        this.mTxtAuftragsnummer = new JLabel(Resource.getInstance().getAuftragsnummer());
        this.mTfAuftragsnummer = new LimitedTextField(10);
        this.mTxtAuftragsnummerWert = new JLabel();
        if (this.mModel.getTLDaten().getAuftragsNr() != null) {
            this.mTfAuftragsnummer.setText(this.mModel.getTLDaten().getAuftragsNr());
            this.mTxtAuftragsnummerWert.setText(this.mModel.getTLDaten().getAuftragsNr());
        } else if (this.mModel.getTLDaten().getAuftragsNrLokal() != null) {
            this.mTfAuftragsnummer.setText(this.mModel.getTLDaten().getAuftragsNrLokal());
            this.mTxtAuftragsnummerWert.setText(this.mModel.getTLDaten().getAuftragsNrLokal());
        }
        this.mTxtBearbeiter = new JLabel(Resource.getInstance().getBearbeiter());
        this.mTfBearbeiter = new LimitedNumberField(3);
        this.mTxtFreitext = new JLabel(Resource.getInstance().getFreitext());
        this.mChkGreiferschein = new JCheckBox(Resource.getInstance().getGreiferschein(), false);
        if (this.mModel.getGreiferschein()) {
            this.mChkGreiferschein.setSelected(true);
        }
        this.mTaFreitext = new JTextArea("");
        this.mTaFreitext.setAutoscrolls(false);
        this.mTaFreitext.setEditable(true);
        this.mTaFreitext.setEnabled(true);
        this.mTaFreitext.setLineWrap(true);
        this.mTaFreitext.setWrapStyleWord(true);
        this.mTaFreitext.setForeground(Color.black);
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(150, 0);
        this.mTaFreitext.setDocument(ehDoc);
        if (this.mModel.getGesperrt()) {
            this.mTfAuftragsnummer.setText(this.mModel.getAuftragsNr());
            this.mTfBearbeiter.setText(this.mModel.getMitarbeiterNr());
            this.mTaFreitext.setText(this.mModel.getFreitext());
        } else {
            this.mTfBearbeiter.setText(DlgTeilelisteController.loadBearbeiterNr());
        }
        this.mChkWiederverwenden = new JCheckBox(Resource.getInstance().getListeWiederVerwenden(), false);
        this.mButtonUebernehmen = new JButtonEx("", ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    protected void layoutAll() {
        this.mContentPane = this.mDlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mContentPane.setLayout(l);
        this.mContentPane.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.mContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 120, 0, 10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10, 0, 5, 0, 5, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mTxtAuftragsnummer, c.rc(2, 2));
        if (this.mModel.getTLDaten().getAuftragsNr() != null) {
            panel.add((Component)this.mTxtAuftragsnummerWert, c.rc(2, 4));
        } else {
            panel.add((Component)this.mTfAuftragsnummer, c.rc(2, 4));
        }
        panel.add((Component)this.mTxtBearbeiter, c.rc(2, 6, "l"));
        panel.add((Component)this.mTfBearbeiter, c.rc(2, 8, "l"));
        panel.add((Component)this.mChkGreiferschein, c.rc(4, 2, "l"));
        panel.add((Component)this.mTxtFreitext, c.rcwh(6, 2, 7, 1, "l"));
        panel.add((Component)this.createFreitextComponent(), c.rcwh(8, 2, 7, 1, "lr"));
        if (this.mModel.getTLDaten().getAuftrag() == null && !this.mModel.getGesperrt()) {
            panel.add((Component)this.mChkWiederverwenden, c.rcwh(10, 2, 7, 1, "lr"));
        }
        return panel;
    }

    public JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nRet = Werkstattauftrag.this.sendeWerkstattauftrag();
                if (nRet == 1) {
                    return;
                }
                Werkstattauftrag.this.mMapReturnValues.put("ret", nRet);
                boolean bWiederVerwenden = Werkstattauftrag.this.mChkWiederverwenden.isSelected();
                Werkstattauftrag.this.mMapReturnValues.put("wieder_verwenden", bWiederVerwenden);
                Werkstattauftrag.this.mDlg.dispose();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Werkstattauftrag.this.mMapReturnValues.put("ret", 1);
                Werkstattauftrag.this.mDlg.dispose();
            }
        });
        return panel;
    }

    protected JComponent createFreitextComponent() {
        JScrollPane sc = new JScrollPane(this.mTaFreitext);
        sc.setPreferredSize(new Dimension(460, 80));
        this.mTaFreitext.setCaretPosition(0);
        sc.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), UIHelper.getStandardBorder()));
        return sc;
    }

    protected int sendeWerkstattauftrag() {
        if (this.mTfAuftragsnummer.getText().length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoAuftragsnummer(), this.mDlg.getTitle(), 0);
            return 1;
        }
        if (!StringUtils.isNMToken(this.mTfAuftragsnummer.getText())) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getAuftragsnummer() + ": \n" + Resource.getInstance().getWrongFormatNmtoken(), this.mDlg.getTitle(), 1);
            return 1;
        }
        if (this.mTfBearbeiter.getText().length() < 1 || Integer.parseInt(this.mTfBearbeiter.getText()) < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoMitarbeiternummer(), this.mDlg.getTitle(), 0);
            return 1;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        Teileliste oTL = this.mModel.getTLDaten();
        if (this.mChkWiederverwenden.isSelected() && !this.mModel.getGesperrt()) {
            String sOldID = oTL.getID();
            String sNutzerID = oTL.getNutzerID();
            String sFiliale = oTL.getFiliale();
            String sNewID = DlgTeilelisteController.copyTeileliste(sOldID, sNutzerID, sFiliale);
            oTL.setID(sNewID);
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            oTL.setNutzerID(oLoginInfo.getLogin());
            oTL.setFiliale(oLoginInfo.getFilialeId());
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teileliste", oTL);
        trfTL.setValue("art", "Werkstattauftrag");
        trfTL.setValue("auftragsnr", this.mTfAuftragsnummer.getText());
        if (this.mChkGreiferschein.isSelected()) {
            trfTL.setValue("greiferschein", "J");
        }
        trfTL.setValue("bearbeiter", this.mTfBearbeiter.getText());
        trfTL.setValue("freitext", this.mTaFreitext.getText());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_SEND_LIST);
        }
        catch (CommunicationException e) {
            log.error((Object)("Werkstattauftrag: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), this.mDlg.getTitle(), 0);
            return 1;
        }
        if (trfTL.getError() != null) {
            String sMsg = null;
            if (trfTL.getError() instanceof NoDataFoundException) {
                String sTNr = trfTL.getError().getMessage();
                Object[] arguments = new Object[]{sTNr};
                sMsg = MessageFormat.format(Resource.getInstance().getFehlerRabattschluesselTeilInListe(), arguments);
            } else {
                sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            }
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, this.mDlg.getTitle(), 0);
            return 1;
        }
        oTL = (Teileliste)trfTL.getValue("teileliste");
        this.mModel.setTLDaten(oTL);
        String sMsgTxt = (String)trfTL.getValue("msgtxt");
        int[] aRetCodes = (int[])trfTL.getValue("returncodes");
        Teil[] aTeile = this.mController.getTeile(aRetCodes);
        if (!DmsUtils.showMsgTxt(sMsgTxt, aRetCodes, aTeile, this.mController.getKonfiguration(), Resource.getInstance().getSendenErfolgreich())) {
            return 2;
        }
        return 0;
    }

    public void show() {
        this.mDlg.setVisible(true);
    }
}

