/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.fzgid;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.GrafikDisplay;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.fzgid.DlgFzgIdAusstattungPanel;
import webetk.resources.Resource;

public class DlgFzgIdPanel
extends TitledPanel {
    private static final long serialVersionUID = 1L;
    protected Logger log = Logger.getLogger(DlgFzgIdPanel.class);
    protected GrafikDisplay dispFIGrafik;
    protected JLabel labFgstnr = null;
    protected JComboBox cbFgstnr = null;
    private static final int LENGTH_VIN = 17;
    protected DlgFzgIdAusstattungPanel panAusstattung = null;
    protected static JButtonEx buttonSuchenFgstnr = null;
    protected JLabel jlDatenVom = null;
    private static int blinkInterval = 1000;
    private static boolean blinkState = false;

    public DlgFzgIdPanel() {
        super(Resource.getInstance().getFahrzeugidentifikationUeberFahrgestellnummer());
        GridBagLayout gbl_panFgstnr = new GridBagLayout();
        gbl_panFgstnr.columnWidths = new int[]{270, 137, 161, 0, 88, 10, 10};
        gbl_panFgstnr.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_panFgstnr.rowHeights = new int[]{133, 0, 0};
        gbl_panFgstnr.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gbl_panFgstnr);
        this.dispFIGrafik = new GrafikDisplay(1);
        this.dispFIGrafik.setShowMouseOver(false);
        GridBagConstraints gbc_dispFIGrafik = new GridBagConstraints();
        gbc_dispFIGrafik.gridheight = 2;
        gbc_dispFIGrafik.insets = new Insets(0, 0, 0, 5);
        gbc_dispFIGrafik.gridx = 0;
        gbc_dispFIGrafik.gridy = 0;
        this.add((Component)this.dispFIGrafik, gbc_dispFIGrafik);
        this.labFgstnr = new JLabel();
        this.labFgstnr.setText(Resource.getInstance().getFahrgestellnummer() + ":");
        GridBagConstraints gbc_labFgstnr = new GridBagConstraints();
        gbc_labFgstnr.insets = new Insets(0, 0, 5, 5);
        gbc_labFgstnr.gridx = 1;
        gbc_labFgstnr.gridy = 0;
        this.add((Component)this.labFgstnr, gbc_labFgstnr);
        this.cbFgstnr = new JComboBox();
        this.cbFgstnr.setEditable(true);
        ComboBoxEditor editor = this.cbFgstnr.getEditor();
        JTextField comp = (JTextField)editor.getEditorComponent();
        comp.setDocument(new EnhancedTextDocument(17, 0));
        this.cbFgstnr.setRenderer(new LimitedComboBoxRenderer(32));
        this.cbFgstnr.setPreferredSize(new Dimension(220, 25));
        Iterator<String> vins = GlobalObjects.getInstance().getEtkData().getVins();
        while (vins != null && vins.hasNext()) {
            String item = vins.next();
            int firstSpace = item.indexOf(" ") >= 0 ? item.indexOf(" ") : item.length() - 1;
            item = item.substring(0, firstSpace);
            this.addFgstnrToCb(item);
        }
        this.cbFgstnr.setSelectedItem("");
        GridBagConstraints gbc_cbFgstnr = new GridBagConstraints();
        gbc_cbFgstnr.insets = new Insets(0, 0, 5, 5);
        gbc_cbFgstnr.gridx = 2;
        gbc_cbFgstnr.gridy = 0;
        this.add((Component)this.cbFgstnr, gbc_cbFgstnr);
        this.panAusstattung = new DlgFzgIdAusstattungPanel();
        GridBagConstraints gbc_panAusstattung = new GridBagConstraints();
        gbc_panAusstattung.insets = new Insets(0, 0, 5, 5);
        gbc_panAusstattung.gridx = 3;
        gbc_panAusstattung.gridy = 0;
        this.add((Component)this.panAusstattung, gbc_panAusstattung);
        buttonSuchenFgstnr = new JButtonEx(null, ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        buttonSuchenFgstnr.addMouseListener(new MyMouseAdapter());
        GridBagConstraints gbc_buttonSuchenFgstnr = new GridBagConstraints();
        gbc_buttonSuchenFgstnr.insets = new Insets(0, 0, 5, 5);
        gbc_buttonSuchenFgstnr.gridx = 4;
        gbc_buttonSuchenFgstnr.gridy = 0;
        this.add((Component)buttonSuchenFgstnr, gbc_buttonSuchenFgstnr);
        this.jlDatenVom = new JLabel(Resource.getInstance().getDatenVom() + " " + "MM/YYYY");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.gridwidth = 3;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_1.anchor = 14;
        gbc_lblNewLabel_1.gridx = 3;
        gbc_lblNewLabel_1.gridy = 1;
        this.add((Component)this.jlDatenVom, gbc_lblNewLabel_1);
    }

    protected void addFgstnrToCb(String fgstnr) {
        if (fgstnr != null) {
            boolean bFound = false;
            if (fgstnr.length() >= 17) {
                for (int ii = 0; ii < this.cbFgstnr.getItemCount(); ++ii) {
                    String fgstnr17Zeichen;
                    String entry17Zeichen;
                    String entry = (String)this.cbFgstnr.getItemAt(ii);
                    if (entry.length() < 17 || fgstnr.length() < 17 || !(entry17Zeichen = entry.substring(0, 17)).equalsIgnoreCase(fgstnr17Zeichen = fgstnr.substring(0, 17))) continue;
                    bFound = true;
                    break;
                }
            } else {
                for (int ii = 0; ii < this.cbFgstnr.getItemCount(); ++ii) {
                    String fgstnr7Zeichen;
                    String entry7Zeichen;
                    String entry = (String)this.cbFgstnr.getItemAt(ii);
                    if (entry.length() < 7 || fgstnr.length() < 7 || !(entry7Zeichen = entry.substring(0, 7)).equalsIgnoreCase(fgstnr7Zeichen = fgstnr.substring(0, 7))) continue;
                    bFound = true;
                    break;
                }
            }
            if (!bFound) {
                this.cbFgstnr.insertItemAt(fgstnr, 0);
            }
            this.cbFgstnr.setSelectedItem(fgstnr);
        }
    }

    protected void createBlinkTimer() {
        Timer makeItBlink = new Timer(blinkInterval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                blinkState = !blinkState;
                if (blinkState) {
                    DlgFzgIdPanel.this.setBlinkTextColor();
                } else {
                    DlgFzgIdPanel.this.setNormalTextColor();
                }
            }
        });
        makeItBlink.start();
    }

    private void setBlinkTextColor() {
        this.jlDatenVom.setForeground(Color.RED);
    }

    private void setNormalTextColor() {
        this.jlDatenVom.setForeground(Color.BLACK);
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isControlDown() && e.isShiftDown() && SwingUtilities.isRightMouseButton(e)) {
                try {
                    DlgFzgIdPanel.this.addFgstnrToCb("KT87550");
                    DlgFzgIdPanel.this.dispFIGrafik.removeAllGraphics();
                    DlgFzgIdPanel.this.dispFIGrafik.addGrafik(ImageCache.getInstance().getImage("inDBverwaltet/fi_group_all.jpg"), null, null);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

