/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.fzgumfang;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.fzgumfang.FzgUmfang;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.fzgumfang.DlgFzgUmfangModel;
import webetk.javaclient.dialog.fzgumfang.DlgFzgUmfangView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgFzgUmfangController
extends AbstractDialogViewController {
    protected Logger log = Logger.getLogger(DlgFzgUmfangController.class);
    DlgFzgUmfangView view = new DlgFzgUmfangView();
    DlgFzgUmfangModel model = new DlgFzgUmfangModel();

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("modellspaltenids", this.model.getModellspaltenIDsString());
        exitData.setWert("marke", this.model.getMarke());
        exitData.setWert("produktart", this.model.getProduktart());
        exitData.setWert("katalogumfang", this.model.getKatalogumfang());
        exitData.setWert("lenkung", this.model.getLenkung());
        exitData.setWert("baureihen", this.model.getBaureihenString());
        exitData.setWert("hgvon", this.model.getHgVon());
        exitData.setWert("hgbis", this.model.getHgBis());
        exitData.setWert("fzgumfang", this.model.getFzgUmfang());
        if (this.model.getDialogModus().equals("Teileersetzung") || this.model.getDialogModus().equals("TeileverwendungFahrzeug")) {
            exitData.setWert("tag", this.model.getDatumAbTag());
            exitData.setWert("monat", this.model.getDatumAbMonat());
            exitData.setWert("jahr", this.model.getDatumAbJahr());
            if (this.model.getDialogModus().equals("TeileverwendungFahrzeug")) {
                exitData.setWert("nurinselfzg", this.model.getNurInSelFzg());
            }
        }
        return exitData;
    }

    int loadRegionen() {
        this.log.debug((Object)"Performing Load Regionen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfRegionen = new TrfHashMap(null);
        trfRegionen.setValue("marke", this.model.getMarke());
        trfRegionen.setValue("produktart", this.model.getProduktart());
        trfRegionen.setValue("katalogumfang", this.model.getKatalogumfang());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfRegionen, Command.LOAD_FZGUMFANG_REGIONEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trfRegionen.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfRegionen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfRegionen.getError().getMessage(), this.model.getDialogTitel(), 0);
            return -1;
        }
        this.model.storeRegionen(trfRegionen);
        this.model.storeFzgUmfang((FzgUmfang)trfRegionen.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trfRegionen.getValue("count");
        return Integer.parseInt(sCount);
    }

    int loadLenkungen() {
        this.log.debug((Object)"Performing Load Lenkungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfLenkungen = new TrfHashMap(null);
        trfLenkungen.setValue("fzgumfang", this.model.getFzgUmfang());
        trfLenkungen.setValue("marke", this.model.getMarke());
        trfLenkungen.setValue("produktart", this.model.getProduktart());
        trfLenkungen.setValue("katalogumfang", this.model.getKatalogumfang());
        trfLenkungen.setValue("regionen", this.model.getSelRegionen());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfLenkungen, Command.LOAD_FZGUMFANG_LENKUNGEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trfLenkungen.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfLenkungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfLenkungen.getError().getMessage(), this.model.getDialogTitel(), 0);
            return -1;
        }
        this.model.storeLenkungen(trfLenkungen);
        this.model.storeFzgUmfang((FzgUmfang)trfLenkungen.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trfLenkungen.getValue("count");
        return Integer.parseInt(sCount);
    }

    int loadBauarten() {
        this.log.debug((Object)"Performing Load Bauarten");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBauarten = new TrfHashMap(null);
        trfBauarten.setValue("fzgumfang", this.model.getFzgUmfang());
        trfBauarten.setValue("marke", this.model.getMarke());
        trfBauarten.setValue("produktart", this.model.getProduktart());
        trfBauarten.setValue("katalogumfang", this.model.getKatalogumfang());
        trfBauarten.setValue("regionen", this.model.getSelRegionen());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBauarten, Command.LOAD_FZGUMFANG_BAUARTEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trfBauarten.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBauarten.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBauarten.getError().getMessage(), this.model.getDialogTitel(), 0);
            return -1;
        }
        this.model.storeBauarten(trfBauarten);
        this.model.storeFzgUmfang((FzgUmfang)trfBauarten.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trfBauarten.getValue("count");
        return Integer.parseInt(sCount);
    }

    int loadBaureihen() {
        this.log.debug((Object)"Performing Load Baureihen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBaureihen = new TrfHashMap(null);
        trfBaureihen.setValue("fzgumfang", this.model.getFzgUmfang());
        trfBaureihen.setValue("marke", this.model.getMarke());
        trfBaureihen.setValue("produktart", this.model.getProduktart());
        trfBaureihen.setValue("katalogumfang", this.model.getKatalogumfang());
        trfBaureihen.setValue("regionen", this.model.getSelRegionen());
        trfBaureihen.setValue("lenkungen", this.model.getSelLenkungen());
        trfBaureihen.setValue("bauarten", this.model.getSelBauarten());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBaureihen, Command.LOAD_FZGUMFANG_BAUREIHEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trfBaureihen.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBaureihen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBaureihen.getError().getMessage(), this.model.getDialogTitel(), 0);
            return -1;
        }
        this.model.storeBaureihen(trfBaureihen);
        this.model.storeFzgUmfang((FzgUmfang)trfBaureihen.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trfBaureihen.getValue("count");
        return Integer.parseInt(sCount);
    }

    int loadKarosserien() {
        this.log.debug((Object)"Performing Load Karosserien");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfKarosserien = new TrfHashMap(null);
        trfKarosserien.setValue("fzgumfang", this.model.getFzgUmfang());
        trfKarosserien.setValue("marke", this.model.getMarke());
        trfKarosserien.setValue("produktart", this.model.getProduktart());
        trfKarosserien.setValue("katalogumfang", this.model.getKatalogumfang());
        trfKarosserien.setValue("regionen", this.model.getSelRegionen());
        trfKarosserien.setValue("lenkungen", this.model.getSelLenkungen());
        trfKarosserien.setValue("baureihen", this.model.getSelBaureihen());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfKarosserien, Command.LOAD_FZGUMFANG_KAROSSERIEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trfKarosserien.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfKarosserien.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfKarosserien.getError().getMessage(), this.model.getDialogTitel(), 0);
            return -1;
        }
        this.model.storeKarosserien(trfKarosserien);
        this.model.storeFzgUmfang((FzgUmfang)trfKarosserien.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trfKarosserien.getValue("count");
        return Integer.parseInt(sCount);
    }

    int loadModelle() {
        this.log.debug((Object)"Performing Load Modelle");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfModelle = new TrfHashMap(null);
        trfModelle.setValue("fzgumfang", this.model.getFzgUmfang());
        trfModelle.setValue("marke", this.model.getMarke());
        trfModelle.setValue("produktart", this.model.getProduktart());
        trfModelle.setValue("katalogumfang", this.model.getKatalogumfang());
        trfModelle.setValue("regionen", this.model.getSelRegionen());
        trfModelle.setValue("lenkungen", this.model.getSelLenkungen());
        trfModelle.setValue("bauarten", this.model.getSelBauarten());
        trfModelle.setValue("baureihen", this.model.getSelBaureihen());
        trfModelle.setValue("karosserien", this.model.getSelKarosserien());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfModelle, Command.LOAD_FZGUMFANG_MODELLE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return -1;
        }
        if (trfModelle.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfModelle.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfModelle.getError().getMessage(), this.model.getDialogTitel(), 0);
            return -1;
        }
        this.model.storeModelle(trfModelle);
        this.model.storeFzgUmfang((FzgUmfang)trfModelle.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sCount = (String)trfModelle.getValue("count");
        return Integer.parseInt(sCount);
    }

    void loadModellspaltenIDs() {
        this.log.debug((Object)"Performing Load Modellspalten");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfModellspalten = new TrfHashMap(null);
        trfModellspalten.setValue("fzgumfang", this.model.getFzgUmfang());
        trfModellspalten.setValue("marke", this.model.getMarke());
        trfModellspalten.setValue("produktart", this.model.getProduktart());
        trfModellspalten.setValue("katalogumfang", this.model.getKatalogumfang());
        trfModellspalten.setValue("regionen", this.model.getSelRegionen());
        trfModellspalten.setValue("lenkungen", this.model.getSelLenkungen());
        trfModellspalten.setValue("bauarten", this.model.getSelBauarten());
        trfModellspalten.setValue("baureihen", this.model.getSelBaureihen());
        trfModellspalten.setValue("karosserien", this.model.getSelKarosserien());
        trfModellspalten.setValue("modelle", this.model.getSelModelle());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfModellspalten, Command.LOAD_FZGUMFANG_MODELLSPALTEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfModellspalten.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfModellspalten.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfModellspalten.getError().getMessage(), this.model.getDialogTitel(), 0);
            return;
        }
        this.model.storeModellspaltenIDs((String)trfModellspalten.getValue("modellspaltenids"));
        this.model.storeFzgUmfang((FzgUmfang)trfModellspalten.getValue("fzgumfang"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        this.notifyAllExitListeners();
    }
}

