/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import rasterviewer.imageloaders.ImageLoader;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfMisc;
import webetk.javaclient.dialog.GrafikDisplay;
import webetk.javaclient.dialog.GrafikDisplayEvent;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheBTController;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheBTModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class GrafischeSucheBTView
extends AbstractDialogView {
    private static final long serialVersionUID = -2814491170216863779L;
    private static Logger log = Logger.getLogger(GrafischeSucheBTView.class);
    private GrafischeSucheBTModel model;
    private GrafischeSucheBTController controller;
    private JButtonEx buttonFiltern = null;
    private JComboBox comboMarktPrio;
    private JLabel fuerMarktPrio;
    private boolean mbSuppressComboMarktPrioActionListener = false;
    private JList listMarktWeitere;
    private JScrollPane spMarktWeitere;
    private boolean mbSuppressListWeitereMaerkteSelectionListener = false;
    private boolean marktWeitereExpanded = false;
    private JPanel panAnzeigeGrafiken = null;
    private GrafikDisplay dispGrafik = null;
    private JScrollPane scrollpanDispGrafik = null;
    private static final int IMG_WIDTH = 232;
    private static final int IMG_HEIGHT = 162;
    private JPanel buttonPanel;
    private JLayeredPane content;
    private Thread backgroundLoader = null;
    private JPanel pHinweisZuBTE = null;
    private JTextArea taHinweisZuBTE = null;
    private boolean isHinweistextOn = false;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createHeaderPanel(), "North");
        this.add((Component)this.createContentPanel(), "Center");
        boolean lbIsHinweistextOn = false;
        lbIsHinweistextOn = this.model.habenBildtafelnNachruestungsRelevanteBedingungen();
        this.setHinweistextOn(lbIsHinweistextOn);
        if (this.isHinweistextOn()) {
            String lsHinweistext = null;
            if (this.model.isBedFilter() && this.model.isAbBandVerbaut()) {
                lsHinweistext = Resource.getInstance().getHinweisAbBand();
                this.buttonFiltern.setVisible(true);
            } else if (!this.model.isBedFilter() && this.model.isAbBandVerbaut()) {
                lsHinweistext = Resource.getInstance().getHinweisNachruestung();
                this.buttonFiltern.setVisible(true);
            } else {
                this.buttonFiltern.setVisible(false);
            }
            this.pHinweisZuBTE = new JPanel();
            int[] w = new int[]{20, 900, 20};
            int[] h = new int[]{5, 0, 5};
            HIGLayout layout = new HIGLayout(w, h);
            HIGConstraints c = new HIGConstraints();
            this.pHinweisZuBTE.setLayout(layout);
            this.taHinweisZuBTE = new JTextArea(lsHinweistext);
            this.taHinweisZuBTE.setFont(UIHelper.getNormalFont());
            this.taHinweisZuBTE.setForeground(Color.red);
            this.taHinweisZuBTE.setBackground(UIHelper.getBackground());
            this.taHinweisZuBTE.setLineWrap(true);
            this.taHinweisZuBTE.setWrapStyleWord(true);
            this.pHinweisZuBTE.add((Component)this.taHinweisZuBTE, c.rc(2, 2, "tlbr"));
            this.pHinweisZuBTE.setMaximumSize(new Dimension(900, 50));
            if (this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                this.add((Component)this.pHinweisZuBTE, "South");
                this.taHinweisZuBTE.setVisible(true);
            } else {
                this.add((Component)this.pHinweisZuBTE, "South");
                this.taHinweisZuBTE.setVisible(false);
            }
        }
    }

    private JPanel createHeaderPanel() {
        HeaderPanel panHeader = null;
        JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        String sSuchkriterien = this.model.getSuchkriterienString(oSucheInfo, false);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
            String sFzgIdString = oFzgSucheInfo == null ? "" : oFzgSucheInfo.getFzgIdString();
            panHeader = new HeaderPanel(this.model.getDialogTitel(), sFzgIdString + "   " + sSuchkriterien, ImageCache.getInstance().getHeaderIcon("tsgfzgbt"));
        } else {
            panHeader = new HeaderPanel(this.model.getDialogTitel(), sSuchkriterien, ImageCache.getInstance().getHeaderIcon("tsgaccbt"));
        }
        return panHeader;
    }

    private JComponent createContentPanel() {
        this.content = new JLayeredPane();
        this.content.setLayout(null);
        this.listMarktWeitere = new JList();
        this.spMarktWeitere = new JScrollPane(this.listMarktWeitere);
        this.spMarktWeitere.setVisible(false);
        this.content.add((Component)this.spMarktWeitere, JLayeredPane.PALETTE_LAYER);
        this.buttonPanel = this.createButtonPanel();
        this.content.add((Component)this.buttonPanel, JLayeredPane.DEFAULT_LAYER);
        JComponent grafikenPanel = this.createGrafikenPanel();
        if (this.buttonFiltern != null && this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
            grafikenPanel.setBounds(10, 40, 1006, 540);
            this.buttonFiltern.setVisible(true);
            this.buttonFiltern.setEnabled(true);
        } else {
            grafikenPanel.setBounds(10, 40, 1006, 575);
            this.buttonFiltern.setVisible(false);
            this.buttonFiltern.setEnabled(false);
        }
        this.content.add((Component)grafikenPanel, JLayeredPane.DEFAULT_LAYER);
        return this.content;
    }

    private JPanel createButtonPanel() {
        JButtonEx buttonHGPrev = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        buttonHGPrev.setEnabled(this.model.getIndexHGPrev() != -1);
        buttonHGPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrafischeSucheBTView.this.suchenHGPrev();
            }
        });
        JButtonEx buttonHGNext = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollend.gif"));
        buttonHGNext.setHorizontalTextPosition(2);
        buttonHGNext.setEnabled(this.model.getIndexHGNext() != -1);
        buttonHGNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrafischeSucheBTView.this.suchenHGNext();
            }
        });
        JButtonEx buttonFGPrev = new JButtonEx(Resource.getInstance().getFg(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        buttonFGPrev.setEnabled(this.model.getIndexFGPrev() != -1);
        buttonFGPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrafischeSucheBTView.this.suchenFGPrev();
            }
        });
        JButtonEx buttonFGNext = new JButtonEx(Resource.getInstance().getFg(), ImageCache.getInstance().getIcon("scrollend.gif"));
        buttonFGNext.setHorizontalTextPosition(2);
        buttonFGNext.setEnabled(this.model.getIndexFGNext() != -1);
        buttonFGNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrafischeSucheBTView.this.suchenFGNext();
            }
        });
        this.buttonFiltern = new JButtonEx(ImageCache.getInstance().getIcon("filtern_BteBed_dis.gif"));
        this.buttonFiltern.setText(Resource.getInstance().getFiltern());
        this.buttonFiltern.setHorizontalTextPosition(4);
        this.setButtonFilternStatus();
        this.buttonFiltern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrafischeSucheBTView.this.filternHG();
            }
        });
        boolean bShowHgButtons = this.model.getIndexHGNext() != -1 || this.model.getIndexHGPrev() != -1;
        boolean bShowFgButtons = this.model.getIndexFGNext() != -1 || this.model.getIndexFGPrev() != -1;
        JPanel panelButtons = new JPanel();
        int[] w = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0};
        int[] h = new int[]{0};
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        panelButtons.setLayout(layout);
        if (!bShowHgButtons && !bShowFgButtons) {
            layout.setColumnWidth(7, 750);
        } else if (bShowHgButtons && !bShowFgButtons) {
            layout.setColumnWidth(7, 600);
        } else if (bShowHgButtons && bShowFgButtons) {
            layout.setColumnWidth(11, 465);
        } else if (bShowFgButtons) {
            layout.setColumnWidth(7, 600);
        }
        int col = 1;
        if (bShowHgButtons && !bShowFgButtons) {
            panelButtons.add((Component)buttonHGPrev, c.rc(1, 1, "l"));
            panelButtons.add((Component)buttonHGNext, c.rc(1, 3, "l"));
            col = 3;
        } else if (bShowHgButtons && bShowFgButtons) {
            panelButtons.add((Component)buttonHGPrev, c.rc(1, 1, "l"));
            panelButtons.add((Component)buttonHGNext, c.rc(1, 3, "l"));
            panelButtons.add((Component)buttonFGPrev, c.rc(1, 5, "l"));
            panelButtons.add((Component)buttonFGNext, c.rc(1, 7, "l"));
            col = 7;
        } else if (bShowFgButtons) {
            panelButtons.add((Component)buttonFGPrev, c.rc(1, 1, "l"));
            panelButtons.add((Component)buttonFGNext, c.rc(1, 3, "l"));
            col = 5;
        }
        panelButtons.add((Component)this.buttonFiltern, c.rc(1, col += 2, "l"));
        col += 2;
        if (this.model.habenBildtafelnLokaleMaerkte()) {
            panelButtons.add((Component)this.createMarktAuswahl(), c.rc(1, col, "lt"));
        }
        panelButtons.setBounds(10, 8, 985, 32);
        return panelButtons;
    }

    private JPanel createMarktAuswahl() {
        this.fuerMarktPrio = new JLabel(Resource.getInstance().getFuerMarktPrio());
        this.comboMarktPrio = new JComboBox();
        this.comboMarktPrio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GrafischeSucheBTView.this.mbSuppressComboMarktPrioActionListener) {
                    return;
                }
                if (GrafischeSucheBTView.this.backgroundLoader != null) {
                    GrafischeSucheBTView.this.backgroundLoader.interrupt();
                }
                GrafischeSucheBTView.this.dispGrafik.removeAllGraphics();
                GrafischeSucheBTView.this.panAnzeigeGrafiken.remove(GrafischeSucheBTView.this.dispGrafik);
                GrafischeSucheBTView.this.panAnzeigeGrafiken.add(GrafischeSucheBTView.this.createDispGrafik());
                Markt newPrioMarkt = (Markt)GrafischeSucheBTView.this.comboMarktPrio.getSelectedItem();
                GrafischeSucheBTView.this.model.getMarktDaten().changePrioMarkt(newPrioMarkt);
                GrafischeSucheBTView.this.setButtonFilternLayout();
                Collection<SearchBTETeile.PartOrBTE> cCache = GrafischeSucheBTView.this.model.getBildtafelCache();
                if (cCache != null && cCache.size() > 0) {
                    GrafischeSucheBTView.this.model.setBildtafeln(cCache);
                }
                GrafischeSucheBTView.this.update();
            }
        });
        JLabel weitereMaerkte = new JLabel(Resource.getInstance().getWeitereMaerkte());
        JLabel marktWeiterePfeilAuf = new JLabel(ImageCache.getInstance().getIcon("aufklappen.gif"));
        marktWeiterePfeilAuf.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                GrafischeSucheBTView.this.showListMarktWeitere(true);
            }
        });
        JLabel marktWeiterePfeilZu = new JLabel(ImageCache.getInstance().getIcon("zuklappen.gif"));
        marktWeiterePfeilZu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                GrafischeSucheBTView.this.showListMarktWeitere(false);
            }
        });
        this.listMarktWeitere.setSelectionMode(2);
        this.listMarktWeitere.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (GrafischeSucheBTView.this.mbSuppressListWeitereMaerkteSelectionListener) {
                    return;
                }
                if (GrafischeSucheBTView.this.backgroundLoader != null) {
                    GrafischeSucheBTView.this.backgroundLoader.interrupt();
                }
                GrafischeSucheBTView.this.dispGrafik.removeAllGraphics();
                GrafischeSucheBTView.this.panAnzeigeGrafiken.remove(GrafischeSucheBTView.this.dispGrafik);
                GrafischeSucheBTView.this.panAnzeigeGrafiken.add(GrafischeSucheBTView.this.createDispGrafik());
                int[] newSelInd = GrafischeSucheBTView.this.listMarktWeitere.getSelectedIndices();
                GrafischeSucheBTView.this.model.getMarktDaten().setSelSonstigeMaerkte(newSelInd);
                GrafischeSucheBTView.this.updateGrafiken();
            }
        });
        JPanel panel = new JPanel();
        int[] w = new int[]{0, 5, 0, 52, 0, 5, 0};
        int[] h = new int[]{0, 0};
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        layout.setColumnWeight(7, 1);
        panel.setLayout(layout);
        panel.add((Component)this.fuerMarktPrio, c.rc(1, 1, "l"));
        panel.add((Component)this.comboMarktPrio, c.rc(1, 3, "l"));
        panel.add((Component)weitereMaerkte, c.rc(1, 5, "l"));
        if (this.marktWeitereExpanded) {
            this.spMarktWeitere.setVisible(true);
            this.listMarktWeitere.setVisible(true);
            panel.add((Component)marktWeiterePfeilZu, c.rc(1, 7, "l"));
        } else {
            this.spMarktWeitere.setVisible(false);
            this.listMarktWeitere.setVisible(false);
            panel.add((Component)marktWeiterePfeilAuf, c.rc(1, 7, "l"));
        }
        boolean isUSETK = this.controller.isUSETK();
        if (isUSETK) {
            panel.setVisible(false);
        }
        return panel;
    }

    private void showListMarktWeitere(boolean show) {
        this.marktWeitereExpanded = show;
        Collection<SearchBTETeile.PartOrBTE> cBildtafeln = this.model.getBildtafelCache();
        this.model.setBildtafeln(cBildtafeln);
        this.content.remove(this.buttonPanel);
        this.buttonPanel = this.createButtonPanel();
        this.content.add((Component)this.buttonPanel, JLayeredPane.DEFAULT_LAYER);
        this.update();
    }

    private JComponent createGrafikenPanel() {
        this.panAnzeigeGrafiken = new TitledPanel(Resource.getInstance().getErgebnisBildtafeln() + " ");
        this.panAnzeigeGrafiken.add(this.createDispGrafik());
        this.scrollpanDispGrafik = new JScrollPane(this.panAnzeigeGrafiken);
        int unitIncr = 65;
        this.scrollpanDispGrafik.getVerticalScrollBar().setUnitIncrement(65);
        this.scrollpanDispGrafik.setBorder(null);
        if (this.model.getAnzBildtafeln() > 0) {
            return this.scrollpanDispGrafik;
        }
        return new JLabel(Resource.getInstance().getKeineDatenGefunden());
    }

    private GrafikDisplay createDispGrafik() {
        this.dispGrafik = new GrafikDisplay(3);
        this.dispGrafik.setShowMouseOver(true);
        this.dispGrafik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt instanceof GrafikDisplayEvent) {
                    GrafikDisplayEvent e = (GrafikDisplayEvent)evt;
                    if (GrafischeSucheBTView.this.backgroundLoader != null) {
                        if (GrafischeSucheBTView.this.backgroundLoader.isAlive()) {
                            try {
                                GrafischeSucheBTView.this.backgroundLoader.join();
                            }
                            catch (InterruptedException exc) {
                                // empty catch block
                            }
                        }
                        GrafischeSucheBTView.this.backgroundLoader.interrupt();
                    }
                    int nGrafikIndex = e.getClickedIndex();
                    GrafikDisplay oGrfDsp = (GrafikDisplay)e.getSource();
                    String sBtNummer = oGrfDsp.getTooltip(nGrafikIndex);
                    sBtNummer = sBtNummer.substring(0, sBtNummer.indexOf(" "));
                    GrafischeSucheBTView.this.model.setExitAction("weiterbildtafeln");
                    GrafischeSucheBTView.this.model.setSelBtNummer(sBtNummer);
                    GrafischeSucheBTView.this.controller.notifyAllExitListeners();
                }
            }
        });
        return this.dispGrafik;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.model = (GrafischeSucheBTModel)oDlgModel;
        this.controller = (GrafischeSucheBTController)oDlgController;
        this.initComponents();
        this.update();
    }

    @Override
    public void update() {
        this.updateMaerkte();
        this.updateGrafiken();
    }

    private void updateMaerkte() {
        if (this.comboMarktPrio != null) {
            this.mbSuppressComboMarktPrioActionListener = true;
            this.comboMarktPrio.removeAllItems();
            for (Markt markt : this.model.getMarktDaten().getAuswahlPrimaerMarkt()) {
                this.comboMarktPrio.addItem(markt);
            }
            Markt selPrioMarkt = this.model.getMarktDaten().getSelPrimaerMarkt();
            if (selPrioMarkt != null) {
                this.comboMarktPrio.setSelectedItem(selPrioMarkt);
            } else {
                this.comboMarktPrio.setSelectedIndex(0);
            }
            this.mbSuppressComboMarktPrioActionListener = false;
        }
        if (this.listMarktWeitere != null) {
            this.mbSuppressListWeitereMaerkteSelectionListener = true;
            this.listMarktWeitere.setListData(this.model.getMarktDaten().getAuswahlSonstigeMaerkte());
            int[] aSelIndizes = this.model.getMarktDaten().getIndicesSelSonstigeMaerkte();
            if (aSelIndizes != null) {
                this.listMarktWeitere.setSelectedIndices(aSelIndizes);
            }
            this.mbSuppressListWeitereMaerkteSelectionListener = false;
        }
        if (this.comboMarktPrio != null && this.spMarktWeitere != null) {
            Dimension dimMarktPrio = this.comboMarktPrio.getPreferredSize();
            Dimension dimLabel = this.fuerMarktPrio.getPreferredSize();
            int xMarktWeitere = 214 + dimLabel.width + dimMarktPrio.width;
            this.spMarktWeitere.setBounds(xMarktWeitere, 29, dimMarktPrio.width, 160);
        }
    }

    private void updateGrafiken() {
        boolean bIsCacheToFill;
        if (this.backgroundLoader != null) {
            this.backgroundLoader.interrupt();
        }
        log.debug((Object)"updateGrafiken start");
        this.dispGrafik.removeAllGraphics();
        this.panAnzeigeGrafiken.remove(this.dispGrafik);
        this.panAnzeigeGrafiken.add(this.createDispGrafik());
        Vector<SearchBTETeile.PartOrBTE> cBildtafeln = this.model.getBildtafelnSortiertNachMarkt();
        final Iterator iterator = cBildtafeln.iterator();
        boolean bl = bIsCacheToFill = this.model.getBildtafelCache() == null;
        if (bIsCacheToFill) {
            this.model.setBildtafelCache(this.model.getBildtafeln());
        }
        if (cBildtafeln == null || cBildtafeln.isEmpty()) {
            this.panAnzeigeGrafiken.setVisible(false);
            return;
        }
        this.panAnzeigeGrafiken.setVisible(true);
        Dimension dim = this.panAnzeigeGrafiken.getSize();
        this.panAnzeigeGrafiken.setSize(new Dimension(1, 1));
        this.panAnzeigeGrafiken.setSize(dim);
        Image imgArrowHourglass = ImageCache.getInstance().getImage("cur_arrow_hourglass.gif");
        Toolkit tk = Toolkit.getDefaultToolkit();
        Cursor curArrowHourglass = tk.createCustomCursor(imgArrowHourglass, new Point(1, 1), "ArrowHourglass");
        MainView.getInstance().setCursor(curArrowHourglass);
        this.backgroundLoader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    log.debug((Object)"backgroundLoader start");
                    boolean bIsBedFilter = GrafischeSucheBTView.this.model.isBedFilter();
                    boolean bIsAbBandVerbaut = GrafischeSucheBTView.this.model.isAbBandVerbaut();
                    boolean bIsIGDOM = GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden();
                    boolean isContinue = false;
                    Vector<SearchBTETeile.PartOrBTE> oBildtafeln = new Vector<SearchBTETeile.PartOrBTE>();
                    Vector<SearchBTETeile.PartOrBTE> lBildtafelnBlaettern = new Vector<SearchBTETeile.PartOrBTE>();
                    ImageLoader loader = new ImageLoader();
                    int nIndex = 0;
                    while (iterator.hasNext()) {
                        byte[] aBild;
                        SearchBTETeile.PartOrBTE oBte = (SearchBTETeile.PartOrBTE)iterator.next();
                        String sBtNummer = oBte.getIdNummer();
                        String sBenennung = oBte.getBenennung();
                        String sMarkt = oBte.getMarktIso();
                        if (sMarkt == null) {
                            sMarkt = "";
                        }
                        boolean bIsBteRelevant = oBte.getBteBedingungRelevant();
                        boolean bIsBteRelevant3 = oBte.isBteBedingungRelevant3();
                        boolean bHatBteNachruestungsRelevant3 = oBte.hatNachruestenRelevantBTEBedingung3();
                        if (Thread.currentThread().isInterrupted()) {
                            log.debug((Object)"backgroundLoader aborted");
                            return;
                        }
                        log.debug((Object)("*** model.isBedFilter()\t: " + GrafischeSucheBTView.this.model.isBedFilter()));
                        log.debug((Object)("*** Filter anwenden    \t: " + Boolean.toString(bIsBedFilter)));
                        log.debug((Object)("*** IGD-DOM aktiv      \t: " + Boolean.toString(bIsIGDOM)));
                        log.debug((Object)("*** BTE-Nr.: " + sBtNummer + " oBte.getBteBedingungRelevant(): " + Boolean.toString(bIsBteRelevant) + " oBte.getBteBedingungRelevant3(): " + Boolean.toString(bIsBteRelevant3)));
                        log.debug((Object)("*** BTE-Nr.: " + sBtNummer + " oBte.hatNachruestenRelevantBedingung3(): " + oBte.hatNachruestenRelevantBTEBedingung3()));
                        if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                            log.debug((Object)("*** BTE Bedingung: " + (oBte.getBteBedingung() != null ? oBte.getBteBedingung().toString() : "null")));
                            log.debug((Object)("*** Ergebnis: " + (oBte.getErgebnis() != null ? oBte.getErgebnis().toString() : "null")));
                            log.debug((Object)("*** BTE Bedingung3: " + (oBte.getBedingungen3() != null ? oBte.getBedingungen3().toString() : "null")));
                            log.debug((Object)("*** BTE \u00dcberBedingung3: " + (oBte.getUeberBedingungen3() != null ? oBte.getUeberBedingungen3().toString() : "null")));
                            log.debug((Object)("*** Ergebnis3: " + (oBte.getErgebnis3() != null ? oBte.getErgebnis3().toString() : "null")));
                        }
                        if (bIsBedFilter && !bIsBteRelevant3 && bHatBteNachruestungsRelevant3) {
                            log.debug((Object)("===>>> BTE-Nr.: " + sBtNummer + "<<<=== oBte.getBteBedingungRelevant3(): " + Boolean.toString(bIsBteRelevant3) + " oBte.hatNachruestenRelevantBedingung3(): " + Boolean.toString(bHatBteNachruestungsRelevant3)));
                        }
                        if (bIsBedFilter && (!bIsBedFilter || !bIsBteRelevant3) && (!bIsBedFilter || bIsBteRelevant3 || !bHatBteNachruestungsRelevant3) || (aBild = oBte.getGrafik()) == null) continue;
                        if (Thread.currentThread().isInterrupted()) {
                            log.debug((Object)"backgroundLoader aborted");
                            return;
                        }
                        Image origImg = loader.loadImage(aBild, 2, 0);
                        if (Thread.currentThread().isInterrupted()) {
                            log.debug((Object)"backgroundLoader aborted");
                            return;
                        }
                        Image smallImg = origImg.getScaledInstance(232, 162, 4);
                        boolean bRotMarkieren = false;
                        if (GrafischeSucheBTView.this.buttonFiltern != null) {
                            boolean bl = bRotMarkieren = !oBte.isBteBedingungRelevant3() && oBte.hatNachruestenRelevantBTEBedingung3();
                            if (GrafischeSucheBTView.this.taHinweisZuBTE != null && bRotMarkieren) {
                                GrafischeSucheBTView.this.taHinweisZuBTE.setVisible(true);
                            }
                        }
                        oBte.setIsRotMarkiert(bRotMarkieren);
                        if (bIsIGDOM && bIsAbBandVerbaut && !bIsBedFilter && !bIsBteRelevant3 && !bHatBteNachruestungsRelevant3) continue;
                        if (bIsAbBandVerbaut && bRotMarkieren && bIsBedFilter) {
                            GrafischeSucheBTView.this.taHinweisZuBTE.setText(Resource.getInstance().getHinweisAbBand());
                            GrafischeSucheBTView.this.taHinweisZuBTE.setForeground(Color.red);
                            GrafischeSucheBTView.this.taHinweisZuBTE.setVisible(true);
                            isContinue = true;
                            continue;
                        }
                        if (!isContinue && GrafischeSucheBTView.this.taHinweisZuBTE != null) {
                            GrafischeSucheBTView.this.taHinweisZuBTE.setText(Resource.getInstance().getHinweisNachruestung());
                            GrafischeSucheBTView.this.taHinweisZuBTE.setForeground(Color.red);
                            GrafischeSucheBTView.this.taHinweisZuBTE.setVisible(true);
                        }
                        lBildtafelnBlaettern.add(oBte);
                        GrafischeSucheBTView.this.dispGrafik.addGrafik(smallImg, sBtNummer + " " + sBenennung, sBtNummer + " " + sBenennung, sMarkt, bRotMarkieren);
                        oBildtafeln.add(oBte);
                        if (sBtNummer.equals(GrafischeSucheBTView.this.model.getSelBtNummerInit())) {
                            this.highlightGrafik(nIndex);
                        }
                        try {
                            Thread.sleep(60L);
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"backgroundLoader aborted");
                        }
                        ++nIndex;
                    }
                    GrafischeSucheBTView.this.model.setBildtafeln(oBildtafeln);
                    GrafischeSucheBTView.this.model.setBildTafelnBlaettern(lBildtafelnBlaettern);
                    log.debug((Object)"backgroundLoader finished");
                }
                finally {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            private void highlightGrafik(int nIndex) {
                GrafischeSucheBTView.this.dispGrafik.setIndexHighlightInit(nIndex);
                if (!GrafischeSucheBTView.this.dispGrafik.hasAllreadyHighlightedByMouseMove() && nIndex > 9) {
                    Rectangle rect = GrafischeSucheBTView.this.dispGrafik.getRect(nIndex - 6);
                    rect.setLocation(0, (int)rect.getY() - 20);
                    GrafischeSucheBTView.this.scrollpanDispGrafik.getViewport().setViewPosition(rect.getLocation());
                }
            }
        };
        this.backgroundLoader.setPriority(4);
        this.backgroundLoader.start();
    }

    public void suchenHGPrev() {
        this.model.setExitAction("search_hg_at_index");
        this.model.setIndexHGtoSearch(this.model.getIndexHGPrev());
        boolean isBedFilter = this.model.isBedFilter();
        boolean isAbBandVerbaut = this.model.isAbBandVerbaut();
        if (isAbBandVerbaut && !isBedFilter) {
            this.model.setBedFilter(true);
        }
        this.controller.notifyAllExitListeners();
    }

    public void suchenHGNext() {
        this.model.setExitAction("search_hg_at_index");
        this.model.setIndexHGtoSearch(this.model.getIndexHGNext());
        boolean isBedFilter = this.model.isBedFilter();
        boolean isAbBandVerbaut = this.model.isAbBandVerbaut();
        if (isAbBandVerbaut && !isBedFilter) {
            this.model.setBedFilter(true);
        }
        this.controller.notifyAllExitListeners();
    }

    public void suchenFGPrev() {
        this.model.setExitAction("search_fg_at_index");
        this.model.setIndexFGtoSearch(this.model.getIndexFGPrev());
        this.controller.notifyAllExitListeners();
    }

    public void suchenFGNext() {
        this.model.setExitAction("search_fg_at_index");
        this.model.setIndexFGtoSearch(this.model.getIndexFGNext());
        this.controller.notifyAllExitListeners();
    }

    public void filternHG() {
        this.model.setBedFilter(!this.model.isBedFilter());
        Collection<SearchBTETeile.PartOrBTE> cache = this.model.getBildtafelCache();
        Vector<SearchBTETeile.PartOrBTE> bildtafeln = new Vector<SearchBTETeile.PartOrBTE>();
        for (SearchBTETeile.PartOrBTE bte : cache) {
            bildtafeln.add(bte);
        }
        this.model.setBildtafeln(bildtafeln);
        this.setButtonFilternLayout();
        this.update();
    }

    public void setButtonFilternLayout() {
        if (this.model.isBedFilter()) {
            this.buttonFiltern.setIcon(ImageCache.getInstance().getIcon("filtern_BteBed_dis.gif"));
            this.buttonFiltern.updateUI();
        } else {
            this.buttonFiltern.setIcon(ImageCache.getInstance().getIcon("filtern_BteBed_en.gif"));
            this.buttonFiltern.updateUI();
        }
    }

    private void setButtonFilternStatus() {
        if (GlobalObjects.getInstance().isIGDOMAktiv() && GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden() && GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle().equals("igdom") && GlobalObjects.getInstance().getFzgIdInfo() != null && GlobalObjects.getInstance().getFzgIdInfo().getFahrgestellNr() != null && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getBedingungsMenge().hatSchnittstellenBedingungen()) {
            if (this.model.getDialogModus().equals("Fahrzeugteile")) {
                if (this.getAusweisungenElementeErmitteln()) {
                    this.model.setBedFilter(this.model.isBedFilter());
                    if (this.model.isAbBandVerbaut() && this.model.isBedFilter() && this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                        this.buttonFiltern.setEnabled(true);
                        this.buttonFiltern.setVisible(true);
                    } else if (this.model.isAbBandVerbaut() && this.model.isBedFilter() && !this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                        this.buttonFiltern.setEnabled(true);
                        this.buttonFiltern.setVisible(false);
                    } else if (this.model.isAbBandVerbaut() && !this.model.isBedFilter() && this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                        this.buttonFiltern.setEnabled(true);
                        this.buttonFiltern.setVisible(true);
                    } else {
                        this.buttonFiltern.setEnabled(false);
                        this.buttonFiltern.setVisible(false);
                    }
                } else {
                    this.model.setBedFilter(false);
                    this.buttonFiltern.setEnabled(false);
                    this.buttonFiltern.setVisible(false);
                }
            } else {
                this.model.setBedFilter(false);
                this.buttonFiltern.setEnabled(false);
                this.buttonFiltern.setVisible(false);
            }
        } else {
            this.model.setBedFilter(false);
            this.buttonFiltern.setEnabled(false);
            this.buttonFiltern.setVisible(false);
        }
        this.setButtonFilternLayout();
    }

    private boolean getAusweisungenElementeErmitteln() {
        TrfMisc misc = new TrfMisc(null);
        boolean bAusweisungenElemente = false;
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.HOLEN_FLAG_AUSWEISUNG_ELEMENTE);
            String sAusweisungenElemente = (String)misc.getValue("flagAusweisungElementeErmitteln");
            bAusweisungenElemente = sAusweisungenElemente.equals("true");
        }
        catch (CommunicationException e) {
            log.error((Object)"Kommunikationsfehler beim HOLEN_FLAG_AUSWEISUNG_ELEMENTE am Server!", (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage());
        }
        if (misc.getError() != null) {
            log.error((Object)"Sonstiger Fehler beim HOLEN_FLAG_AUSWEISUNG_ELEMENTE Server!", (Throwable)misc.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), misc.getError().getMessage());
        }
        return bAusweisungenElemente;
    }

    public void setHinweistextOn(boolean isHinweistextOn) {
        this.isHinweistextOn = isHinweistextOn;
    }

    public boolean isHinweistextOn() {
        return this.isHinweistextOn;
    }
}

