/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.FGs;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheFGModel;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheFGView;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class GrafischeSucheFGController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(GrafischeSucheHGController.class);
    GrafischeSucheFGView view = new GrafischeSucheFGView();
    GrafischeSucheFGModel model = new GrafischeSucheFGModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", "anzbildtafeln_graf");
        exitData.setWert("marke", this.model.getMarke());
        exitData.setWert("produktart", this.model.getProduktart());
        exitData.setWert("katalogumfang", this.model.getKatalogumfang());
        exitData.setWert("hg", this.model.getHg());
        exitData.setWert("hgfg", this.model.getHGs());
        exitData.setWert("fg", this.model.getFg());
        exitData.setWert("fgsuche", "true");
        exitData.setWert("fgs", this.model.getFGs());
        exitData.setWert("FG_OBJECT", this.model.getFGsObject());
        exitData.setWert("HGFG_BENENNUNG", this.model.getHgfgList());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void ladeFunktionsgruppenGrafiken() {
        this.log.debug((Object)"Performing Teilesuche Acc Grafisch: Hauptgruppen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFgGrafiken = new TrfHashMap(null);
        String sIsFahrzeug = this.model.getDialogModus().equals("Fahrzeugteile") ? "true" : "false";
        trfFgGrafiken.setValue("isfzg", sIsFahrzeug);
        trfFgGrafiken.setValue("marke", this.model.getMarke());
        trfFgGrafiken.setValue("produktart", this.model.getProduktart());
        trfFgGrafiken.setValue("katalogumfang", this.model.getKatalogumfang());
        trfFgGrafiken.setValue("hg", this.model.getHg());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFgGrafiken, Command.LOAD_TEILESUCHE_GRAF_FG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("GrafischeSucheHGController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFgGrafiken.getError() != null) {
            if (trfFgGrafiken.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Funktionsgruppen gefunden!", (Throwable)trfFgGrafiken.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), this.model.getDialogTitel(), 0);
                this.model.storeAnzeigedaten(null);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFgGrafiken.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFgGrafiken.getError().getMessage(), this.model.getDialogTitel(), 0);
            this.model.storeAnzeigedaten(null);
            return;
        }
        FGs fGs = (FGs)trfFgGrafiken.getValue("FGOBJECT");
        if (fGs != null) {
            this.model.setFGsObject(fGs);
            for (int i = 0; i < fGs.getFGs().size(); ++i) {
                trfFgGrafiken.setValue(i + "fg", fGs.getFGs().get(i));
                trfFgGrafiken.setValue(i + "benennung", fGs.getFGBen().get(i));
                trfFgGrafiken.setValue(i + "bild", fGs.getFGGraf().get(i));
            }
        }
        this.model.storeAnzeigedaten(trfFgGrafiken);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean checkSucheResult() {
        this.log.debug((Object)"Performing Check Suche");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSuche = new TrfHashMap(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
            trfSuche.setValue("isfzg", "false");
        }
        Vector<String> aHgFg = new Vector<String>();
        aHgFg.add(this.model.getHg());
        trfSuche.setValue("hgfg", aHgFg);
        trfSuche.setValue("hg", this.model.getHg());
        trfSuche.setValue("fgsuche", "true");
        Vector aFgs = new Vector();
        trfSuche.setValue("fgs", aFgs);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.CHECK_TEILESUCHE_GRAF_BT);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"Suchergebnisse gefunen", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }
}

