/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import rasterviewer.imageloaders.ImageLoader;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfMisc;
import webetk.javaclient.dialog.GrafikDisplay;
import webetk.javaclient.dialog.GrafikDisplayEvent;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLAuswahl;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheFGController;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheFGModel;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGView;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class GrafischeSucheFGView
extends AbstractDialogView {
    private static final long serialVersionUID = 3595063769479183906L;
    Logger log = Logger.getLogger(GrafischeSucheHGView.class);
    GrafischeSucheFGModel model;
    GrafischeSucheFGController controller;
    protected JPanel panHeader = null;
    protected MarkeProduktKatalogUmfangVLAuswahl mpkAuswahl = null;
    protected JPanel panAuswahl = null;
    private JPanel panSucheGrafiken = null;
    private GrafikDisplay dispGrafik = null;
    private ImageLoader loader = new ImageLoader();

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        String sSuchkriterien = this.model.getSuchkriterienString(oSucheInfo, false);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            String sFzgIdString = "";
            JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
            if (oFzgSucheInfo != null) {
                sFzgIdString = oFzgSucheInfo.getFzgIdString();
            }
            this.panHeader = new HeaderPanel(this.model.getDialogTitel(), sFzgIdString + "   " + sSuchkriterien, ImageCache.getInstance().getHeaderIcon("tsgfzgbt"));
        } else {
            this.panHeader = new HeaderPanel(this.model.getDialogTitel(), sSuchkriterien, ImageCache.getInstance().getHeaderIcon("tsgaccbt"));
        }
        JScrollPane sc = new JScrollPane(this.createContent());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)sc, "Center");
    }

    private JPanel createContent() {
        JPanel content = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        content.setLayout(hl);
        this.panSucheGrafiken = new TitledPanel(Resource.getInstance().getSucheUeberFunktionsgruppe());
        this.dispGrafik = new GrafikDisplay(6);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            hl.setRowHeight(2, 0);
        } else {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            boolean bShowAuswahl = false;
            if (bShowAuswahl) {
                this.mpkAuswahl = new MarkeProduktKatalogUmfangVLAuswahl(Resource.getInstance().getSucheungebGUeberschrift1(), true, this.model.getMarke(), this.model.getProduktart(), this.model.getKatalogumfang(), true, false);
                this.panAuswahl = this.mpkAuswahl.getMpkPanelSet();
                this.mpkAuswahl.addPropertyChangeListener("Marke", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GrafischeSucheFGView.this.model.setMarke((String)evt.getNewValue());
                        GrafischeSucheFGView.this.ladeFunktionsgruppenGrafiken();
                        GrafischeSucheFGView.this.update();
                    }
                });
                this.mpkAuswahl.addPropertyChangeListener("Produktart", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GrafischeSucheFGView.this.model.setProduktart((String)evt.getNewValue());
                        GrafischeSucheFGView.this.ladeFunktionsgruppenGrafiken();
                        GrafischeSucheFGView.this.update();
                    }
                });
                this.mpkAuswahl.addPropertyChangeListener("KATUMFANG", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GrafischeSucheFGView.this.model.setKatalogumfang((String)evt.getNewValue());
                        GrafischeSucheFGView.this.log.debug((Object)"*** ladeHauptgruppenGrafiken");
                        GrafischeSucheFGView.this.ladeFunktionsgruppenGrafiken();
                        GrafischeSucheFGView.this.update();
                    }
                });
                content.add((Component)this.panAuswahl, c.rc(1, 1, "ltrb"));
            } else {
                hl.setRowHeight(2, 0);
            }
        }
        this.dispGrafik.setShowMouseOver(true);
        this.dispGrafik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt instanceof GrafikDisplayEvent) {
                    GrafikDisplayEvent e = (GrafikDisplayEvent)evt;
                    TrfHashMap oGrafiken = GrafischeSucheFGView.this.model.getAnzeigedaten();
                    int nGrafikIndex = e.getClickedIndex();
                    String sFg = (String)oGrafiken.getValue(nGrafikIndex + "fg");
                    GrafischeSucheFGView.this.model.setFg(sFg);
                    if (!GrafischeSucheFGView.this.controller.checkSucheResult()) {
                        return;
                    }
                    GrafischeSucheFGView.this.controller.notifyAllExitListeners();
                }
            }
        });
        this.panSucheGrafiken.add(this.dispGrafik);
        content.add((Component)this.panSucheGrafiken, c.rc(3, 1));
        return content;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.model = (GrafischeSucheFGModel)oDlgModel;
        this.controller = (GrafischeSucheFGController)oDlgController;
        this.initComponents();
        this.ladeFunktionsgruppenGrafiken();
        this.update();
    }

    @Override
    public void update() {
        this.log.debug((Object)"**** update");
        this.dispGrafik.removeAllGraphics();
        this.panSucheGrafiken.setVisible(this.model.getAnzeigedaten() != null);
        TrfHashMap oGrafiken = this.model.getAnzeigedaten();
        if (oGrafiken == null) {
            return;
        }
        int i = 0;
        while (true) {
            String sFg = (String)oGrafiken.getValue(i + "fg");
            String sBenennung = (String)oGrafiken.getValue(i + "benennung");
            if (sBenennung == null) break;
            if (oGrafiken.getValue(i + "bild") != null) {
                this.dispGrafik.addGrafik(this.loader.loadImage((byte[])oGrafiken.getValue(i + "bild"), 2, 0), sFg + " " + sBenennung, null);
                this.revalidate();
                this.repaint();
            } else if (this.model.getMarke().equals("BMW") && this.model.getProduktart().equals("M") && this.model.getHg().equals("72") || this.model.getHg().equals("76")) {
                URL url = ImageCache.class.getResource("/webetk/imgs/leer2.png");
                BufferedImage img1 = new BufferedImage(112, 79, 11);
                try {
                    img1 = ImageIO.read(url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.dispGrafik.addGrafik(img1, sFg + " " + sBenennung, null);
                this.revalidate();
                this.repaint();
            }
            ++i;
        }
        this.log.debug((Object)"**** update beendet");
    }

    public void ladeFunktionsgruppenGrafiken() {
        this.update();
        this.controller.ladeFunktionsgruppenGrafiken();
    }

    ByteArrayInputStream getAsStream(byte[] data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    public void setAusweisungenElementeErmitteln(boolean pbAusweisungenElementeErmitteln) {
        if (GlobalObjects.getInstance().isIGDOMAktiv() && GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden() && GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle().equals("igdom") && GlobalObjects.getInstance().getFzgIdInfo() != null && GlobalObjects.getInstance().getFzgIdInfo().getFahrgestellNr() != null) {
            this.model.setAusweisungenElementeErmitteln(true);
        } else {
            this.model.setAusweisungenElementeErmitteln(false);
        }
        TrfMisc misc = new TrfMisc(null);
        misc.setValue("flagAusweisungElementeErmitteln", this.model.isAusweisungenElementeErmitteln() ? "true" : "false");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.SETZE_FLAG_AUSWEISUNG_ELEMENTE);
        }
        catch (CommunicationException e) {
            this.log.error((Object)"Kommunikationsfehler beim SETZE_FLAG_AUSWEISUNG_ELEMENTE am Server!", (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage());
        }
        if (misc.getError() != null) {
            this.log.error((Object)"Sonstiger Fehler beim SETZE_FLAG_AUSWEISUNG_ELEMENTE Server!", (Throwable)misc.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), misc.getError().getMessage());
        }
    }
}

