/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import rasterviewer.imageloaders.ImageLoader;
import webetk.app.HauptgruppeTO;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfMisc;
import webetk.javaclient.dialog.GrafikDisplay;
import webetk.javaclient.dialog.GrafikDisplayEvent;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLAuswahl;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGController;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGModel;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class GrafischeSucheHGView
extends AbstractDialogView {
    private static final long serialVersionUID = -3034155485865305083L;
    Logger log = Logger.getLogger(GrafischeSucheHGView.class);
    GrafischeSucheHGModel model;
    GrafischeSucheHGController controller;
    protected JPanel panHeader = null;
    protected MarkeProduktKatalogUmfangVLAuswahl mpkAuswahl = null;
    protected JPanel panAuswahl = null;
    private JPanel panSucheGrafiken = null;
    private GrafikDisplay dispGrafik = null;
    private ImageLoader loader = new ImageLoader();

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            String sFzgIdString = "";
            JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
            if (oFzgSucheInfo != null) {
                sFzgIdString = oFzgSucheInfo.getFzgIdString();
            }
            this.panHeader = new HeaderPanel(this.model.getDialogTitel(), sFzgIdString, ImageCache.getInstance().getHeaderIcon("tsgfzghg"));
        } else {
            this.panHeader = new HeaderPanel(this.model.getDialogTitel(), ImageCache.getInstance().getHeaderIcon("tsgacchg"));
        }
        JScrollPane sc = new JScrollPane(this.createContent());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)sc, "Center");
    }

    private JPanel createContent() {
        JPanel content = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        content.setLayout(hl);
        this.panSucheGrafiken = new TitledPanel(Resource.getInstance().getSucheUeberHauptgruppe());
        this.dispGrafik = new GrafikDisplay(6);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            hl.setRowHeight(2, 0);
        } else {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            boolean bShowAuswahl = oLoginInfo.displayMarkeProduktKatalogumfang();
            if (bShowAuswahl) {
                this.mpkAuswahl = new MarkeProduktKatalogUmfangVLAuswahl(Resource.getInstance().getSucheungebGUeberschrift1(), true, this.model.getMarke(), this.model.getProduktart(), this.model.getKatalogumfang(), true, false);
                this.panAuswahl = this.mpkAuswahl.getMpkPanelSet();
                this.mpkAuswahl.addPropertyChangeListener("Marke", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GrafischeSucheHGView.this.model.setMarke((String)evt.getNewValue());
                        GrafischeSucheHGView.this.ladeHauptgruppenGrafiken();
                        GrafischeSucheHGView.this.update();
                    }
                });
                this.mpkAuswahl.addPropertyChangeListener("Produktart", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GrafischeSucheHGView.this.model.setProduktart((String)evt.getNewValue());
                        GrafischeSucheHGView.this.ladeHauptgruppenGrafiken();
                        GrafischeSucheHGView.this.update();
                    }
                });
                this.mpkAuswahl.addPropertyChangeListener("KATUMFANG", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GrafischeSucheHGView.this.model.setKatalogumfang((String)evt.getNewValue());
                        GrafischeSucheHGView.this.log.debug((Object)"*** ladeHauptgruppenGrafiken");
                        GrafischeSucheHGView.this.ladeHauptgruppenGrafiken();
                        GrafischeSucheHGView.this.update();
                    }
                });
                content.add((Component)this.panAuswahl, c.rc(1, 1, "ltrb"));
            } else {
                hl.setRowHeight(2, 0);
            }
        }
        this.dispGrafik.setShowMouseOver(true);
        this.dispGrafik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt instanceof GrafikDisplayEvent) {
                    GrafikDisplayEvent e = (GrafikDisplayEvent)evt;
                    List<HauptgruppeTO> oGrafiken = GrafischeSucheHGView.this.model.getAnzeigedaten();
                    GrafischeSucheHGView.this.model.setHg(oGrafiken.get(e.getClickedIndex()).getHG());
                    if (!GrafischeSucheHGView.this.controller.checkSucheResult()) {
                        return;
                    }
                    GrafischeSucheHGView.this.controller.notifyAllExitListeners();
                }
            }
        });
        this.panSucheGrafiken.add(this.dispGrafik);
        content.add((Component)this.panSucheGrafiken, c.rc(3, 1));
        return content;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.model = (GrafischeSucheHGModel)oDlgModel;
        this.controller = (GrafischeSucheHGController)oDlgController;
        this.initComponents();
        this.ladeHauptgruppenGrafiken();
        this.update();
    }

    @Override
    public void update() {
        this.log.debug((Object)"**** update");
        this.dispGrafik.removeAllGraphics();
        this.panSucheGrafiken.setVisible(this.model.getAnzeigedaten() != null);
        List<HauptgruppeTO> oGrafiken = this.model.getAnzeigedaten();
        if (oGrafiken == null || oGrafiken.isEmpty()) {
            return;
        }
        for (HauptgruppeTO hauptgruppe : oGrafiken) {
            if (hauptgruppe.getBild() == null) continue;
            this.dispGrafik.addGrafik(this.loader.loadImage(hauptgruppe.getBild(), 2, 0), hauptgruppe.getHG() + " " + hauptgruppe.getBenennung(), null);
            this.revalidate();
            this.repaint();
        }
        this.log.debug((Object)"**** update beendet");
    }

    public void ladeHauptgruppenGrafiken() {
        this.setAusweisungenElementeErmitteln();
        this.update();
        this.controller.ladeHauptgruppenGrafiken();
    }

    ByteArrayInputStream getAsStream(byte[] data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    public void setAusweisungenElementeErmitteln() {
        if (GlobalObjects.getInstance().isIGDOMAktiv() && GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden() && GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle().equals("igdom") && GlobalObjects.getInstance().getFzgIdInfo() != null && GlobalObjects.getInstance().getFzgIdInfo().getFahrgestellNr() != null) {
            this.model.setAusweisungenElementeErmitteln(true);
        } else {
            this.model.setAusweisungenElementeErmitteln(false);
        }
        TrfMisc misc = new TrfMisc(null);
        misc.setValue("flagAusweisungElementeErmitteln", this.model.isAusweisungenElementeErmitteln() ? "true" : "false");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.SETZE_FLAG_AUSWEISUNG_ELEMENTE);
        }
        catch (CommunicationException e) {
            this.log.error((Object)"Kommunikationsfehler beim SETZE_FLAG_AUSWEISUNG_ELEMENTE am Server!", (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage());
        }
        if (misc.getError() != null) {
            this.log.error((Object)"Sonstiger Fehler beim SETZE_FLAG_AUSWEISUNG_ELEMENTE Server!", (Throwable)misc.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), misc.getError().getMessage());
        }
    }
}

