/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.hilfe.abkuerzungen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.hilfe.Abkuerzung;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class Abkuerzungen {
    private static Logger log = Logger.getLogger(Abkuerzungen.class);
    private static Abkuerzungen instance;
    private JDialog dlg = new JDialog((Frame)MainView.getInstance(), false);
    private GenericTableModel tableModel;
    private GenericTable table;
    protected JPanel panHeader;
    protected JPanel panAbkuerzungen;
    private Container paneContent;
    List<Abkuerzung> mAbkuerzungen = null;

    private Abkuerzungen() {
        this.dlg.setTitle(Resource.getInstance().getAbkuerzungen());
        this.dlg.setSize(900, 700);
        this.dlg.setLocation(50, 10);
        this.initComponents();
        this.loadAbkuerzungen();
        this.update();
    }

    public void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getAbkuerzungen(), null);
        this.panAbkuerzungen = new TitledPanel(Resource.getInstance().getAbkuerzungen());
        TableConfiguration config = new TableConfiguration();
        config.addColumn(Resource.getInstance().getAbkuerzung(), 2, false, "XXXXXXXX");
        config.addColumn(Resource.getInstance().getBedeutung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        config.addColumn(Resource.getInstance().getUebersetzung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tableModel = new GenericTableModel(config);
        this.table = new GenericTable(this.tableModel);
        this.layoutAll();
    }

    protected void layoutAll() {
        this.paneContent = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.paneContent.setLayout(l);
        this.paneContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.paneContent.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        p.setLayout(l);
        p.add((Component)this.createAbkuerzungenPanel(), c.rc(2, 1));
        return p;
    }

    public JPanel createAbkuerzungenPanel() {
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        this.panAbkuerzungen.setLayout(l);
        this.panAbkuerzungen.add((Component)this.table.getScrollPane(), c.rc(2, 2));
        return this.panAbkuerzungen;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static Abkuerzungen getInstance() {
        if (instance == null) {
            instance = new Abkuerzungen();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    private void update() {
        if (this.mAbkuerzungen == null) {
            return;
        }
        for (Abkuerzung abkuerzung : this.mAbkuerzungen) {
            this.tableModel.addRow(new AbstractRow(new Object[]{abkuerzung.getAbkuerzung(), abkuerzung.getBedeutung(), abkuerzung.getUebersetzung()}));
        }
    }

    private void loadAbkuerzungen() {
        log.debug((Object)"Performing Load Abkuerzungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfAbkuerzungen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfAbkuerzungen, Command.LOAD_ABKUERZUNGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Version: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfAbkuerzungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfAbkuerzungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfAbkuerzungen.getError().getMessage(), Resource.getInstance().getAbkuerzungen(), 0);
            return;
        }
        this.mAbkuerzungen = (List)trfAbkuerzungen.getValue("abkuerzung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

