/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.hilfe.sonderausstattung;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.hilfe.Salapa;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class Sonderausstattungen {
    private static Logger log = Logger.getLogger(Sonderausstattungen.class);
    private static Sonderausstattungen instance;
    private JDialog dlg = new JDialog((Frame)MainView.getInstance(), false);
    private GenericTableModel tableModelAuto;
    private GenericTable tableAuto;
    private GenericTableModel tableModelKrad;
    private GenericTable tableKrad;
    protected JPanel panHeader;
    private JPanel panSalapaAuto;
    private JPanel panSalapaKrad;
    private Container paneContent;
    private List<Salapa> mSalapasPkw;
    private List<Salapa> mSalapasMotorrad;

    private Sonderausstattungen() {
        this.dlg.setTitle(Resource.getInstance().getSonderausstattungen());
        this.dlg.setSize(550, 700);
        this.dlg.setLocation(100, 10);
        this.initComponents();
        this.loadSonderausstattungen();
        this.update();
    }

    public void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getSonderausstattungen(), null);
        this.panSalapaAuto = new TitledPanel(Resource.getInstance().getSonderausstattungenPkw());
        TableConfiguration configAuto = new TableConfiguration();
        configAuto.addColumn(Resource.getInstance().getCode(), 2, false, "XXXXXYY");
        configAuto.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        this.tableModelAuto = new GenericTableModel(configAuto);
        this.tableAuto = new GenericTable(this.tableModelAuto);
        this.panSalapaKrad = new TitledPanel(Resource.getInstance().getSonderausstattungenMotorrad());
        TableConfiguration configKrad = new TableConfiguration();
        configKrad.addColumn(Resource.getInstance().getCode(), 2, false, "XXXXXYY");
        configKrad.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        this.tableModelKrad = new GenericTableModel(configKrad);
        this.tableKrad = new GenericTable(this.tableModelKrad);
        this.layoutAll();
    }

    protected void layoutAll() {
        this.paneContent = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.paneContent.setLayout(l);
        this.paneContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.paneContent.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 10, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        l.setRowWeight(4, 1);
        p.setLayout(l);
        p.add((Component)this.createpanSalapaAuto(), c.rc(2, 1));
        p.add((Component)this.createKradPanel(), c.rc(4, 1));
        return p;
    }

    public JPanel createpanSalapaAuto() {
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        this.panSalapaAuto.setLayout(l);
        this.panSalapaAuto.add((Component)this.tableAuto.getScrollPane(), c.rc(2, 2));
        return this.panSalapaAuto;
    }

    public JPanel createKradPanel() {
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        this.panSalapaKrad.setLayout(l);
        this.panSalapaKrad.add((Component)this.tableKrad.getScrollPane(), c.rc(2, 2));
        return this.panSalapaKrad;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static Sonderausstattungen getInstance() {
        if (instance == null) {
            instance = new Sonderausstattungen();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    private void update() {
        if (this.mSalapasPkw != null && !this.mSalapasPkw.isEmpty()) {
            this.tableModelAuto.removeAllRows();
            for (Salapa salapa : this.mSalapasPkw) {
                this.tableModelAuto.addRow(new AbstractRow(new Object[]{salapa.getCode(), salapa.getBenennung()}));
            }
        }
        if (this.mSalapasPkw != null && !this.mSalapasPkw.isEmpty()) {
            this.tableModelKrad.removeAllRows();
            for (Salapa salapa : this.mSalapasMotorrad) {
                this.tableModelKrad.addRow(new AbstractRow(new Object[]{salapa.getCode(), salapa.getBenennung()}));
            }
        }
    }

    private void loadSonderausstattungen() {
        log.debug((Object)"Performing Load Sonderausstattungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSonderausstattungen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSonderausstattungen, Command.LOAD_SONDERAUSSTATTUNGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Version: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfSonderausstattungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSonderausstattungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSonderausstattungen.getError().getMessage(), Resource.getInstance().getSonderausstattung(), 0);
            return;
        }
        this.mSalapasPkw = (List)trfSonderausstattungen.getValue("pkw_salapas");
        this.mSalapasMotorrad = (List)trfSonderausstattungen.getValue("motorrad_salapas");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

