/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.login;

import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import webetk.communication.transferables.AsapInfo;
import webetk.javaclient.communication.login.AsapLogin;
import webetk.javaclient.communication.login.CommonLogin;
import webetk.javaclient.communication.login.DcsLogin;
import webetk.javaclient.communication.login.SGateLogin;
import webetk.javaclient.dialog.login.model.Context;
import webetk.javaclient.dialog.login.model.ContextDcs;
import webetk.javaclient.dialog.login.model.ContextDealer;
import webetk.javaclient.dialog.login.model.ContextInternet;
import webetk.javaclient.dialog.login.model.ContextRrDealer;
import webetk.javaclient.dialog.login.model.ContextSGate;
import webetk.javaclient.dialog.login.model.LoginModel;
import webetk.javaclient.dialog.login.view.LoginPanelDealer;
import webetk.javaclient.dialog.login.view.LoginPanelUser;
import webetk.javaclient.dialog.login.view.LoginView;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class LoginController {
    private static Logger log = Logger.getLogger(LoginController.class);
    private JFrame mainView;
    private LoginModel model;
    private LoginView view;

    public LoginController(JFrame mainView, LoginModel model, LoginView view) {
        this.mainView = mainView;
        this.model = model;
        this.view = view;
        view.addContextChangeListener(new ContextChangeListener());
        view.addLoginButtonListener(new LoginButtonListener());
        view.addCancelButtonListener(new CancelButtonListener());
        this.addChangeListenerForActiveLoginPanel();
    }

    public static AsapInfo getAsapInfo(boolean pbIGDOM) {
        MainView mainView = MainView.getInstance();
        if (GlobalObjects.getInstance().getEtkData().isAsapSessionIdRequired(pbIGDOM)) {
            if (GlobalObjects.getInstance().getEtkData().getAsapSessionId() == null) {
                log.debug((Object)"ASAP Session Id and User Id is required -> login zur BMW AG");
                LoginController.initiateAndShow(mainView);
            }
            String asapSessionId = GlobalObjects.getInstance().getEtkData().getAsapSessionIdWithoutIndex();
            String asapUserId = GlobalObjects.getInstance().getEtkData().getAsapUserId();
            log.debug((Object)("===>>> ASAP User Id and Session Id  (via Login to BMW AG) : " + asapUserId + ":" + asapSessionId));
            if (asapSessionId == null) {
                log.warn((Object)"ASAP Session Id and User Id are required -> login to BMW AG - but could not retrieve ASAP Session Id or User Id!");
                JOptionPane.showMessageDialog(mainView, Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                mainView.setCursor(Cursor.getPredefinedCursor(0));
            }
            return new AsapInfo(asapSessionId, asapUserId);
        }
        return null;
    }

    public static AsapInfo getAsapInfo() {
        MainView mainView = MainView.getInstance();
        if (GlobalObjects.getInstance().getEtkData().getAsapSessionId() == null) {
            log.debug((Object)"FORCE ASAP Session Id and User Id is required -> login zur BMW AG");
            LoginController.initiateAndShow(mainView);
        }
        String asapSessionId = GlobalObjects.getInstance().getEtkData().getAsapSessionIdWithoutIndex();
        String asapUserId = GlobalObjects.getInstance().getEtkData().getAsapUserId();
        log.debug((Object)("===>>> FORCE ASAP User Id and Session Id  (via Login to BMW AG) : " + asapUserId + ":" + asapSessionId));
        if (asapSessionId == null) {
            log.warn((Object)"FORCE ASAP Session Id and User Id are required -> login to BMW AG - but could not retrieve ASAP Session Id or User Id!");
            JOptionPane.showMessageDialog(mainView, Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            mainView.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        return new AsapInfo(asapSessionId, asapUserId);
    }

    public static void initiateAndShow(JFrame mainView) {
        LoginModel model = new LoginModel();
        LoginView view = new LoginView(mainView, model, Resource.getInstance().getLoginZurBMWaG());
        view.setLblContext(Resource.getInstance().getKontext());
        view.setLblBtnCancel(Resource.getInstance().getAbbrechen());
        view.setLblBtnLogin(Resource.getInstance().getAnmelden());
        new LoginController(mainView, model, view);
        view.preSelectContext();
        view.show();
    }

    private void addChangeListenerForActiveLoginPanel() {
        if (this.view.getActiveComponent() != null) {
            if (this.view.getActiveComponent() instanceof LoginPanelUser) {
                LoginPanelUser loginPnlUsr = (LoginPanelUser)this.view.getActiveComponent();
                loginPnlUsr.addChangeListenerTextField(new ChangeListenerTextField());
                loginPnlUsr.addChangeListenerPasswordField(new ChangeListenerPasswordField());
            }
            if (this.view.getActiveComponent() instanceof LoginPanelDealer) {
                LoginPanelDealer loginPnlDlr = (LoginPanelDealer)this.view.getActiveComponent();
                loginPnlDlr.addChangeListenerTextField(new ChangeListenerTextField());
                loginPnlDlr.addChangeListenerTextField_1(new ChangeListenerTextField_1());
                loginPnlDlr.addChangeListenerPasswordField(new ChangeListenerPasswordField());
            }
        }
    }

    private boolean isOkInputFromActiveComponent() {
        if (this.view.getActiveComponent() != null) {
            if (this.view.getActiveComponent() instanceof LoginPanelUser && this.model.getUser().length() > 0 && this.model.getPassword().length() > 0) {
                return true;
            }
            if (this.view.getActiveComponent() instanceof LoginPanelDealer && this.model.getDealerNumber().length() > 0 && this.model.getDealerUserNumber().length() > 0 && this.model.getPassword().length() > 0) {
                return true;
            }
        }
        return false;
    }

    private void deleteInputFromActiveComponent() {
        if (this.view.getActiveComponent() != null) {
            if (this.view.getActiveComponent() instanceof LoginPanelUser) {
                this.model.setUser(null);
                this.model.setPassword(null);
            }
            if (this.view.getActiveComponent() instanceof LoginPanelDealer) {
                this.model.setDealerNumber(null);
                this.model.setDealerUserNumber(null);
                this.model.setPassword(null);
            }
        }
    }

    private void performLogin(Context context) {
        log.debug((Object)"start of this method ...");
        if (context instanceof ContextSGate || context instanceof ContextRrDealer) {
            SGateLogin sl = new SGateLogin();
            this.fillLoginInformation(context, sl);
            this.loginAndCheckStatus(context, sl);
        } else if (context instanceof ContextDealer || context instanceof ContextInternet) {
            AsapLogin al = new AsapLogin();
            this.fillLoginInformation(context, al);
            if (context instanceof ContextDealer) {
                al.setDealerNo(this.model.getDealerNumber());
                al.setUserNo(this.model.getDealerUserNumber());
            }
            this.loginAndCheckStatus(context, al);
        } else if (context instanceof ContextDcs) {
            DcsLogin dl = new DcsLogin();
            this.fillLoginInformation(context, dl);
            this.loginAndCheckStatus(context, dl);
        } else {
            this.view.setCursorToDefault();
            JOptionPane.showMessageDialog(this.mainView, "Unknown login contxt ...", Resource.getInstance().getSonstigerFehler(), 0);
        }
        log.debug((Object)"end of this method ...");
    }

    private void fillLoginInformation(Context context, CommonLogin login) {
        log.debug((Object)"start of this method ...");
        login.setNetzUrl(context.getContextUrl());
        if (GlobalObjects.getInstance().getAppProperties().getProperty("swscris.proxyset", "false").equals("true")) {
            login.setProxyAdress(GlobalObjects.getInstance().getAppProperties().getProperty("swscris.proxyhost"));
            login.setProxyPort(Integer.parseInt(GlobalObjects.getInstance().getAppProperties().getProperty("swscris.proxyport")));
            if (GlobalObjects.getInstance().getAppProperties().getProperty("swscris.proxyauth", "false").equals("true")) {
                login.setProxyUser(GlobalObjects.getInstance().getAppProperties().getProperty("swscris.proxyuser"));
                login.setProxyPassword(GlobalObjects.getInstance().getAppProperties().getProperty("swscris.proxypassword"));
            }
        }
        this.logProxyInfo(login);
        login.setUserID(this.model.getUser());
        login.setPassword(this.model.getPassword());
        log.debug((Object)"end of this method ...");
    }

    private void logProxyInfo(CommonLogin login) {
        log.debug((Object)("proxy host : " + login.getProxyAdress()));
        log.debug((Object)("proxy port : " + login.getProxyPort()));
        log.debug((Object)("proxy user : " + login.getProxyUser()));
        log.debug((Object)("proxy pw   : " + login.getProxyPassword()));
    }

    private void loginAndCheckStatus(Context context, CommonLogin login) {
        GlobalObjects.getInstance().getEtkData().setAsapSessionId(null);
        GlobalObjects.getInstance().getEtkData().setAsapUserId(null);
        try {
            int iLoginAttempt = 0;
            boolean bProceedLogin = true;
            while (bProceedLogin && iLoginAttempt <= 2) {
                ++iLoginAttempt;
                login.login();
                log.debug((Object)" nach login ...");
                this.view.setCursorToDefault();
                if (login.getStatusCode() != 0) {
                    if (login.getStatusCode() == 10 || iLoginAttempt >= 2) {
                        bProceedLogin = false;
                    } else {
                        bProceedLogin = true;
                        this.fillProxyInformationWithServerSettings(context, login);
                    }
                    if (bProceedLogin) continue;
                    log.error((Object)("status code : \n" + login.getStatusCode() + "\n" + "status message : \n" + login.getStatusMsg()));
                    JOptionPane.showMessageDialog(this.mainView, login.getStatusMsg(), Resource.getInstance().getSonstigerFehler(), 0);
                    continue;
                }
                bProceedLogin = false;
                GlobalObjects.getInstance().getEtkData().setAsapSessionId(login.getAsapSessionId());
                GlobalObjects.getInstance().getEtkData().setAsapUserId(login.getAsapUserId());
                this.view.disposeMe();
            }
        }
        catch (Exception Exc) {
            this.view.setCursorToDefault();
            JOptionPane.showMessageDialog(this.mainView, Exc.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    private void fillProxyInformationWithServerSettings(Context context, CommonLogin login) {
        if (context.getBmwNetzInfos().getProxy_name() != null) {
            login.setProxyAdress(context.getBmwNetzInfos().getProxy_name());
            login.setProxyPort(context.getBmwNetzInfos().getProxy_port());
            if (context.getBmwNetzInfos().getProxy_user() != null) {
                login.setProxyUser(context.getBmwNetzInfos().getProxy_user());
                login.setProxyPassword(context.getBmwNetzInfos().getProxy_pw());
            }
        }
        this.logProxyInfo(login);
    }

    class ChangeListenerPasswordField
    implements DocumentListener {
        ChangeListenerPasswordField() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            if (LoginController.this.isOkInputFromActiveComponent()) {
                LoginController.this.view.enableBtnLogin();
            } else {
                LoginController.this.view.disableBtnLogin();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            if (LoginController.this.isOkInputFromActiveComponent()) {
                LoginController.this.view.enableBtnLogin();
            } else {
                LoginController.this.view.disableBtnLogin();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }
    }

    class ChangeListenerTextField_1
    implements DocumentListener {
        ChangeListenerTextField_1() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            if (LoginController.this.isOkInputFromActiveComponent()) {
                LoginController.this.view.enableBtnLogin();
            } else {
                LoginController.this.view.disableBtnLogin();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            if (LoginController.this.isOkInputFromActiveComponent()) {
                LoginController.this.view.enableBtnLogin();
            } else {
                LoginController.this.view.disableBtnLogin();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }
    }

    class ChangeListenerTextField
    implements DocumentListener {
        ChangeListenerTextField() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            if (LoginController.this.isOkInputFromActiveComponent()) {
                LoginController.this.view.enableBtnLogin();
            } else {
                LoginController.this.view.disableBtnLogin();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            if (LoginController.this.isOkInputFromActiveComponent()) {
                LoginController.this.view.enableBtnLogin();
            } else {
                LoginController.this.view.disableBtnLogin();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }
    }

    class LoginButtonListener
    implements ActionListener {
        LoginButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Context context = (Context)LoginController.this.view.getComboBox().getSelectedItem();
            if (context != null) {
                LoginController.this.view.setCursorToWait();
                log.debug((Object)"Button clicked");
                log.debug((Object)("Context URL: " + LoginController.this.model.getContext().getContextUrl()));
                log.debug((Object)("User: " + LoginController.this.model.getUser()));
                log.debug((Object)("Password: " + LoginController.this.model.getPassword()));
                log.debug((Object)("DealerNumber: " + LoginController.this.model.getDealerNumber()));
                log.debug((Object)("DealerUserNumber: " + LoginController.this.model.getDealerUserNumber()));
                LoginController.this.performLogin(context);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LoginController.this.view.disposeMe();
        }
    }

    class ContextChangeListener
    implements ActionListener {
        ContextChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Context context = (Context)LoginController.this.view.getComboBox().getSelectedItem();
            if (context != null) {
                LoginController.this.model.setContext(context);
                if (LoginController.this.view.getActiveComponent() != null) {
                    LoginController.this.deleteInputFromActiveComponent();
                    LoginController.this.view.getPanel_loginData().remove((Component)((Object)LoginController.this.view.getActiveComponent()));
                }
                LoginController.this.view.setActiveComponent(context.getPanel());
                LoginController.this.addChangeListenerForActiveLoginPanel();
                if (LoginController.this.isOkInputFromActiveComponent()) {
                    LoginController.this.view.enableBtnLogin();
                } else {
                    LoginController.this.view.disableBtnLogin();
                }
                LoginController.this.view.validateMe();
            }
        }
    }
}

