/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.cache.CBTEBedingungsmenge;
import webetk.communication.JavaFzgSucheInfo;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.bte.bedingungen.BTEBedingungenTabelleModel;
import webetk.javaclient.dialog.bte.bedingungen.BTETableCellRadiobuttonEditor;
import webetk.javaclient.dialog.bte.bedingungen.BTETableCellRadiobuttonRenderer;
import webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung.BedingungsauswertungController;
import webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung.BedingungsauswertungModel;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class BedingungsauswertungView
extends AbstractDialogView {
    private static final long serialVersionUID = -2379094214891223184L;
    Logger log = Logger.getLogger(BedingungsauswertungView.class);
    BedingungsauswertungModel model;
    BedingungsauswertungController controller;
    private JPanel panHeader;
    private GenericTable table = null;
    private BTEBedingungenTabelleModel tableModel = null;
    private JButtonEx buttonWeiter = null;
    private JButtonEx buttonReset = null;
    private boolean mbSuppressBedListener = true;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        String sFzgIdString = oFzgSucheInfo.getFzgIdString();
        this.panHeader = new HeaderPanel(Resource.getInstance().getBedingungsauswertung(), sFzgIdString, ImageCache.getInstance().getHeaderIcon("bed"));
        this.buttonWeiter = new JButtonEx("", ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.buttonWeiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BedingungsauswertungView.this.model.setExitAction("anzeigen_bt");
                BedingungsauswertungView.this.controller.notifyAllExitListeners();
            }
        });
        this.buttonReset = new JButtonEx(Resource.getInstance().getZuruecksetzen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BedingungsauswertungView.this.controller.resetBedingungen();
                BedingungsauswertungView.this.update();
            }
        });
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 2, false, "XXXXXXXXYY");
        tableConfig.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getJa(), 0, Object.class, false, 1);
        tableConfig.setHeaderTooltip(2, Resource.getInstance().getJaVorhanden());
        tableConfig.addColumn(Resource.getInstance().getNein(), 0, Object.class, false, 1);
        tableConfig.setHeaderTooltip(3, Resource.getInstance().getNeinNichtVorhanden());
        tableConfig.addColumn(Resource.getInstance().getFrage(), 0, Object.class, false, 1);
        tableConfig.setHeaderTooltip(4, Resource.getInstance().getNichtBekanntVorhanden());
        this.tableModel = new BTEBedingungenTabelleModel(false){
            private static final long serialVersionUID = -8984677281432211352L;

            @Override
            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return mColIndex >= 2;
            }
        };
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (BedingungsauswertungView.this.mbSuppressBedListener) {
                    return;
                }
                BedingungsauswertungView.this.changeBedingung(e.getFirstRow());
            }
        });
        BTETableCellRadiobuttonEditor radioEditor = new BTETableCellRadiobuttonEditor();
        tableConfig.setEditor(Resource.getInstance().getJa(), (TableCellEditor)radioEditor);
        tableConfig.setEditor(Resource.getInstance().getNein(), (TableCellEditor)radioEditor);
        tableConfig.setEditor(Resource.getInstance().getFrage(), (TableCellEditor)radioEditor);
        BTETableCellRadiobuttonRenderer radioRenderer = new BTETableCellRadiobuttonRenderer();
        tableConfig.setRenderer(Resource.getInstance().getJa(), (TableCellRenderer)radioRenderer);
        tableConfig.setRenderer(Resource.getInstance().getNein(), (TableCellRenderer)radioRenderer);
        tableConfig.setRenderer(Resource.getInstance().getFrage(), (TableCellRenderer)radioRenderer);
        this.table = new GenericTable((TableModel)this.tableModel, tableConfig);
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        this.table.getTable().setSelectionMode(0);
        HIGConstraints c = new HIGConstraints();
        JPanel panButton = new JPanel();
        int[] w_buttonPanel = new int[]{100, -4, 0, -2};
        int[] h_buttonPanel = new int[]{0};
        HIGLayout buttonPanelLayout = new HIGLayout(w_buttonPanel, h_buttonPanel);
        buttonPanelLayout.setColumnWeight(3, 1);
        panButton.setLayout(buttonPanelLayout);
        panButton.add((Component)this.buttonReset, c.rc(1, 2, "l"));
        panButton.add((Component)this.buttonWeiter, c.rc(1, 4, "r"));
        TitledPanel panBedingungen = new TitledPanel(Resource.getInstance().getBedingungsauswertung());
        int[] w_bedingungsPanel = new int[]{10, 0, 10};
        int[] h_bedingungsPanel = new int[]{5, 0, 5, 0, 5};
        HIGLayout bedingungsPanelLayout = new HIGLayout(w_bedingungsPanel, h_bedingungsPanel);
        bedingungsPanelLayout.setRowWeight(4, 1);
        bedingungsPanelLayout.setColumnWeight(2, 1);
        panBedingungen.setLayout(bedingungsPanelLayout);
        panBedingungen.add((Component)panButton, c.rc(2, 2, "lr"));
        panBedingungen.add((Component)this.table.getScrollPane(), c.rc(4, 2, "tblr"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane sc = new JScrollPane(panBedingungen);
        this.add((Component)sc, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.model = (BedingungsauswertungModel)oDlgModel;
        this.controller = (BedingungsauswertungController)oDlgController;
        this.initComponents();
        this.update();
    }

    @Override
    public void update() {
        this.mbSuppressBedListener = true;
        this.tableModel.removeAllRows();
        BTEBedingungsmenge oBedingungen = this.model.getCurrentBedingungen();
        try {
            Long lBedId;
            oBedingungen.goFirst();
            while ((lBedId = oBedingungen.getCurrentId()) != null) {
                CBTEBedingungsmenge oBTECache;
                String sCode = oBedingungen.getCurrentCode();
                String sBenennung = oBedingungen.getCurrentBenennung();
                String sWert = oBedingungen.getCurrentWert();
                Boolean bNachruestungenAufNein = oBedingungen.getCurrentNachruestungAufNein();
                int nStatus = 3;
                if (sWert.equals("1")) {
                    nStatus = 1;
                } else if (sWert.equals("2")) {
                    nStatus = 2;
                }
                Color bedColor = null;
                if (oBedingungen.isBteBedingung(oBedingungen.getCurrentId())) {
                    bedColor = Color.blue;
                    if (bNachruestungenAufNein.booleanValue()) {
                        bedColor = new Color(171, 3, 3);
                    }
                }
                if (oBedingungen.showCurrentBed("bedauswertung")) {
                    this.tableModel.addBedingung(lBedId, sCode, sBenennung, nStatus, bedColor);
                }
                if (!(oBTECache = CBTEBedingungsmenge.getObject()).exists(oBedingungen)) {
                    oBTECache.add(oBedingungen);
                }
                if (oBedingungen.hasNext()) {
                    oBedingungen.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mbSuppressBedListener = false;
    }

    private void changeBedingung(int nRow) {
        String sBedWertOld;
        BTEBedingungenTabelleModel.BedingungRow oZeile = this.tableModel.getRow(nRow);
        Long lBedId = oZeile.getBedId();
        String sBedWertNew = null;
        if (oZeile.isJa()) {
            sBedWertNew = "1";
        }
        if (oZeile.isNein()) {
            sBedWertNew = "2";
        }
        if (oZeile.isUnbekannt()) {
            sBedWertNew = "0";
        }
        if ((sBedWertOld = this.model.getCurrentBedingungen().getBedWert(lBedId)) == null) {
            sBedWertOld = this.model.getCurrentBedingungen().getBedingungsmenge().getBedWert(lBedId);
        }
        if (sBedWertOld.equals(sBedWertNew)) {
            return;
        }
        Bedingungswert oBedWertNew = null;
        try {
            oBedWertNew = new Bedingungswert(sBedWertNew);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.controller.changeBedingung(lBedId, oBedWertNew);
        this.update();
    }
}

