/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.federtabelle;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import webetk.javaclient.dialog.bte.BTETableCellIconRenderer;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedernTabelleModell;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedertabelleDlgView;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.SelectionModel;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.TestTableCellRenderer;

public class FedernTabelle {
    private JTable table = new JTable();
    private SelectionModel selectionModel;

    public FedernTabelle(FedernTabelleModell model) {
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(model);
        this.selectionModel = new SelectionModel(this.table, model);
        TestTableCellRenderer defaultRenderer = new TestTableCellRenderer(this.selectionModel);
        defaultRenderer.setHorizontalAlignment(0);
        BTETableCellIconRenderer iconRenderer = new BTETableCellIconRenderer();
        iconRenderer.setHorizontalAlignment(0);
        for (int k = 0; k < model.getColumnCount(); ++k) {
            DefaultTableCellRenderer renderer;
            boolean normaleLogik = true;
            if (model.nLayout == FedertabelleDlgView.VIER_FEDERN) {
                if (k == 1 || k == 4 || k == 7 || k == 10) {
                    normaleLogik = false;
                }
            } else if (model.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN || model.nLayout == FedertabelleDlgView.DREI_FEDERN_HA_2FEDERN) {
                if (k == 1 || k == 4 || k == 7) {
                    normaleLogik = false;
                }
            } else if (model.nLayout == FedertabelleDlgView.ZWEI_FEDERN && (k == 1 || k == 4)) {
                normaleLogik = false;
            }
            Dimension prefSize = null;
            if (!normaleLogik) {
                prefSize = new Dimension(20, 1);
                renderer = iconRenderer;
            } else {
                Component c;
                if (model.getPrototype(k) instanceof Icon) {
                    renderer = iconRenderer;
                } else {
                    TestTableCellRenderer dr = defaultRenderer;
                    renderer = dr;
                }
                if (model.getPrototype(k) instanceof Icon) {
                    c = renderer.getTableCellRendererComponent(this.table, model.getPrototype(k), false, false, 1, k);
                    prefSize = c.getPreferredSize();
                } else {
                    c = this.table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.table, model.getPrototype(k), false, false, 1, k);
                    prefSize = c.getPreferredSize();
                }
            }
            TableColumn column = new TableColumn(k, prefSize.width + 2, renderer, null);
            column.setMinWidth(prefSize.width);
            if (!model.isColumnResizable(k)) {
                column.setMaxWidth(prefSize.width);
            }
            column.setResizable(model.isColumnResizable(k));
            this.table.addColumn(column);
        }
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.selectionModel.installMouseHandler();
    }

    public JTable getTable() {
        return this.table;
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }
}

